/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.mq;

import java.util.HashMap;
import java.util.List;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.data.idi.util.IDIJSONUtils;

public class IDIMqMessagePublisher {
    @Deprecated
    public static void sendSaveInvoiceAction(String billType, String billId, String dataText, boolean needDelete) {
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("billType", billType);
        paramMap.put("billId", billId);
        paramMap.put("dataStr", dataText);
        paramMap.put("needDelete", String.valueOf(needDelete));
        paramMap.put("type", "single");
        IDIMqMessagePublisher.publishMessage("kd.data.idi.mq.invoice_queue", paramMap);
    }

    public static void sendSaveInvoiceAction(String billType, String billId, String dataText, String clientId, String secret, boolean needDelete) {
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("billType", billType);
        paramMap.put("billId", billId);
        paramMap.put("dataStr", dataText);
        paramMap.put("needDelete", String.valueOf(needDelete));
        paramMap.put("type", "single");
        paramMap.put("clientId", clientId);
        paramMap.put("secret", secret);
        IDIMqMessagePublisher.publishMessage("kd.data.idi.mq.invoice_queue", paramMap);
    }

    public static void sendBatSaveInvoiceAction(List<BatchInvoiceParam> dataList) {
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("dataStr", IDIJSONUtils.toJsonString(dataList));
        paramMap.put("type", "batch");
        paramMap.put("needDelete", Boolean.TRUE.toString());
        IDIMqMessagePublisher.publishMessage("kd.data.idi.mq.invoice_queue", paramMap);
    }

    public static void publishMessage(String queueName, Object messageBody) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("data", queueName);){
            pub.publish(messageBody);
        }
    }

    public static BatchInvoiceParam createOf(String billId, String billType, String clientId, String secret, List<String> invoiceDataStrList) {
        return new BatchInvoiceParam(billId, billType, clientId, secret, invoiceDataStrList);
    }

    public static class BatchInvoiceParam {
        private String billId;
        private String billType;
        private String clientId;
        private String secret;
        private List<String> invoiceDataStrList;

        public BatchInvoiceParam(String billId, String billType, String clientId, String secret, List<String> invoiceDataStrList) {
            this.billId = billId;
            this.billType = billType;
            this.clientId = clientId;
            this.secret = secret;
            this.invoiceDataStrList = invoiceDataStrList;
        }

        public String getBillId() {
            return this.billId;
        }

        public void setBillId(String billId) {
            this.billId = billId;
        }

        public String getBillType() {
            return this.billType;
        }

        public void setBillType(String billType) {
            this.billType = billType;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public List<String> getInvoiceDataStrList() {
            return this.invoiceDataStrList;
        }

        public void setInvoiceDataStrList(List<String> invoiceDataStrList) {
            this.invoiceDataStrList = invoiceDataStrList;
        }
    }
}

