/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndConfigField;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.attachment.AttachmentConfig;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.data.attachment.ExceptionTip;
import kd.data.idi.data.attachment.ExceptionTipEnum;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.AttachmentServiceFactory;
import kd.data.idi.engine.attachment.IAttachmentService;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class IDIAttachmentFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(IDIAttachmentFormPlugin.class);
    private static final String Key_STARTCCONDITION_FIELD = "startcondition";
    private static final String Key_STARTCCONDITION_JSON = "startcondition_json";
    private static final String Key_CHECKTYPE = "checktype";
    private static final String Key_CHECKMETHOD = "checkmethod";
    private static final String Key_TEMPLATEPANEL = "templatepanel";
    private static final String Key_VALIDTEMPLATE = "validtemplate";
    private static final String Key_CUSTOMTEMPLATE = "customtemplate";
    private static final String Key_RECOGNIZER = "recognizer";
    private static final String Key_LCTEMPLATE = "lctemplate";
    private static final String Key_WORDSCONFIG = "wordsconfig";
    private static final String Key_EXISTWORDS = "existwords";
    private static final String Key_NOTEXISTWORDS = "notexistwords";
    private static final String Key_RULEPANEL = "rulepanel";
    private static final String Key_RULE_LIST = "rulelist";
    private static final String Key_TITLE = "title";
    private static final String Key_ISPASS = "ispass";
    private static final String Key_RULE_JSON = "rulejson";
    private static final String Key_RULE = "rule";
    private static final String Key_PERCENT = "percent";
    private static final String Key_STATUS = "status";
    private static final String Key_SHOWALLCHECKTRUE = "showallchecktrue";
    private static final String KEY_TIPPANEL = "tippanel";
    private static final String Key_SETENTRY = "setentry";
    private static final String Key_DEDUCTITEM = "deductitem";
    private static final String Key_ERRORTIPS = "errortips";
    private static final String KEY_ISSHOWERRORTIPS = "isshowerrortips";
    private static final String Key_DEDUCTPERCENT = "deductpercent";
    private static final String Key_BAR_FRONTEND = "bar_frontend";
    private static final String Key_BTN_NEW = "btn_new";
    private static final String Key_SHOW_LIST = "show_list";
    private static final String KEY_SOURCEBILL = "srcbill";
    private static final String KEY_ATTACHMENTFIELD = "attachmentField";
    private static final String Key_BILLTYPE = "billtype";
    private static final String Key_PROPNAME = "propname";
    private static final String Key_DISPLAYNAME = "displayname";
    private static final String Key_PROPDISPLAYNAME = "propdisplayname";
    private static final String Key_BTN_OK = "btnok";
    private static final String CustomParam_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_ANALYSIS_MODE = "analysis_mode";
    private static final String CustomParam_CURRENTSELECTFIELDS = "currentSelectField";
    private static final String CustomParam_LIMITFIELDS = "limitfields";
    private static final String CustomParam_FORMULA = "formula";
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String CustomParam_TREENODES = "treenodes";
    private static final String CustomParam_SOURCEENTITYNUMBER = "sourceentitynumber";
    private static final String CustomParam_ATTACHMENTFIELD = "attachmentField";
    private static final String CustomParam_ONLY_ATTACHMENTFILENAME = "onlyAttachmentFileName";
    private static final String FormId_IDI_CONDITION_EDIT = "idi_condition_edit";
    private static final String ActionId_SET_START_CONDITION = "setStartCondition";
    private static final String ActionId_SET_BILLFIELD = "setBillField";
    private static final String KEY_SHOWALLENTRYCHECKTRUE = "showallentrychecktrue";
    private static final String PAGECACHE_INTERRUPT = "interrupt";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_BTN_OK, Key_BTN_NEW, Key_RULE, Key_STARTCCONDITION_FIELD, Key_PROPDISPLAYNAME, Key_RECOGNIZER, Key_LCTEMPLATE});
        this.addItemClickListeners(new String[]{Key_BAR_FRONTEND});
        IFormView view = this.getView();
        BasedataEdit validTemplate = (BasedataEdit)view.getControl(Key_VALIDTEMPLATE);
        BasedataEdit customTemplate = (BasedataEdit)view.getControl(Key_CUSTOMTEMPLATE);
        BasedataEdit recognizer = (BasedataEdit)view.getControl(Key_RECOGNIZER);
        BasedataEdit lcTemplate = (BasedataEdit)view.getControl(Key_LCTEMPLATE);
        validTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        customTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        recognizer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        lcTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter fsp = view.getFormShowParameter();
        String analysisMode = (String)fsp.getCustomParam(CustomParam_ANALYSIS_MODE);
        boolean scoreMode = AnalysisMode.SCORE.getType().equals(analysisMode);
        String detailConfig = (String)fsp.getCustomParam(CustomParam_DETAIL_CONFIG);
        AttachmentConfig attachmentConfig = (AttachmentConfig)IDIJSONUtils.cast((String)detailConfig, AttachmentConfig.class);
        if (attachmentConfig != null) {
            this.setStartCondition(attachmentConfig.getStartCondition());
            this.setVisibleAndClearValueByCheckType(attachmentConfig.getCheckType(), true);
            this.setCheckTypeAndTemplate(attachmentConfig);
            if (StringUtils.isNotEmpty((String)attachmentConfig.getExistWords())) {
                model.setValue(Key_EXISTWORDS, (Object)attachmentConfig.getExistWords());
            }
            if (StringUtils.isNotEmpty((String)attachmentConfig.getNotExistWords())) {
                model.setValue(Key_NOTEXISTWORDS, (Object)attachmentConfig.getNotExistWords());
            }
            this.setRule(attachmentConfig.getRuleList(), scoreMode);
            this.setErrorTipsPanel(attachmentConfig.getCheckType(), attachmentConfig.getExceptionTipList(), scoreMode);
            this.setFrontConfig(attachmentConfig);
        } else {
            this.setVisibleAndClearValueByCheckType(CheckAttachmentTypeEnum.CHECKBILLCONTENT, false);
            this.setRule(null, scoreMode);
            this.setErrorTipsPanel(CheckAttachmentTypeEnum.CHECKBILLCONTENT, null, scoreMode);
        }
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnok": {
                if (!this.preVerity()) break;
                IFormView view = this.getView();
                view.returnDataToParent((Object)IDIJSONUtils.toJsonString((Object)this.buildAttachmentConfig()));
                view.close();
                break;
            }
            case "startcondition": {
                this.showStartConditionForm();
                break;
            }
            case "rule": {
                this.showRuleForm();
                break;
            }
            case "propdisplayname": {
                this.showBillFieldForm();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (Key_BTN_NEW.equals(key)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            int count = model.getEntryRowCount(Key_SHOW_LIST);
            if (count >= 5) {
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u60ac\u505c\u4fe1\u606f\u914d\u7f6e\u201d\u5206\u5f55\u884c\u6570\u5e94\u22645\u884c\u3002", (String)"IDIDecisionFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            model.createNewEntryRow(Key_SHOW_LIST);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "rule": {
                this.receiveCondition((String)result);
                break;
            }
            case "setStartCondition": {
                this.receiveStartCondition((String)result);
                break;
            }
            case "setBillField": {
                this.receiveBillField(result);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isInterruptPropertyChange()) {
            this.clearInterruptPropertyChange();
            return;
        }
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (property) {
            case "startcondition": {
                if (!StringUtils.isEmpty((String)String.valueOf(newValue))) break;
                model.setValue(Key_STARTCCONDITION_JSON, null);
                break;
            }
            case "checktype": {
                CheckAttachmentTypeEnum checkAttachmentTypeEnum = CheckAttachmentTypeEnum.convertFromMatchType((String)String.valueOf(newValue));
                this.setVisibleAndClearValueByCheckType(checkAttachmentTypeEnum, false);
                String analysisMode = (String)view.getFormShowParameter().getCustomParam(CustomParam_ANALYSIS_MODE);
                boolean scoreMode = AnalysisMode.SCORE.getType().equals(analysisMode);
                this.setErrorTipsPanel(checkAttachmentTypeEnum, null, scoreMode);
                break;
            }
            case "checkmethod": {
                model.deleteEntryData(Key_RULE_LIST);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
                model.deleteEntryData(Key_SHOW_LIST);
                this.setTemplateWhenCheckMethodChanged();
                this.updateBillTypeCombo(null, CheckMethodEnum.convertFromMatchType((String)String.valueOf(newValue)));
                break;
            }
            case "rule": {
                if (StringUtils.isEmpty((String)String.valueOf(newValue))) {
                    int currentIndex = model.getEntryCurrentRowIndex(Key_RULE_LIST);
                    model.setValue(Key_RULE_JSON, (Object)"", currentIndex);
                }
                this.deleteEntryAndTableField();
                break;
            }
            case "validtemplate": 
            case "customtemplate": 
            case "recognizer": 
            case "lctemplate": {
                model.deleteEntryData(Key_RULE_LIST);
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
                model.deleteEntryData(Key_SHOW_LIST);
                this.updateBillTypeCombo(newValue, null);
                break;
            }
            case "propdisplayname": {
                if (!StringUtils.isEmpty((String)String.valueOf(newValue))) break;
                int currentIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
                model.setValue(Key_PROPNAME, null, currentIndex);
                model.setValue(Key_DISPLAYNAME, null, currentIndex);
                model.setValue(Key_PROPDISPLAYNAME, null, currentIndex);
                break;
            }
            case "billtype": {
                int currentIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
                CheckAttachmentTypeEnum checkAttachmentTypeEnum = CheckAttachmentTypeEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKTYPE)));
                if (CheckAttachmentTypeEnum.CHECKFILENAME == checkAttachmentTypeEnum && "attachmentField".equals(String.valueOf(newValue))) {
                    model.setValue(Key_PROPNAME, (Object)"filename", currentIndex);
                    model.setValue(Key_PROPDISPLAYNAME, (Object)ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), currentIndex);
                    break;
                }
                model.setValue(Key_PROPNAME, null, currentIndex);
                model.setValue(Key_DISPLAYNAME, null, currentIndex);
                model.setValue(Key_PROPDISPLAYNAME, null, currentIndex);
                break;
            }
            case "showallchecktrue": {
                this.changeShowAll((Boolean)newValue, KEY_SHOWALLENTRYCHECKTRUE);
                break;
            }
            case "showallentrychecktrue": {
                this.changeShowAll((Boolean)newValue, Key_SHOWALLCHECKTRUE);
                break;
            }
        }
    }

    private void deleteEntryAndTableField() {
        AIParam fieldQueryParam = this.buildParam();
        if (fieldQueryParam == null) {
            return;
        }
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)this.getModel().getValue(Key_CHECKMETHOD)));
        if (checkMethodEnum == null) {
            return;
        }
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        fieldQueryParam.setEntityNumber(sourceBill);
        IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
        List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
        Map<Long, List<AttachmentField>> fieldClassifyMap = this.attachmentFieldFilter(fieldList, sourceBill);
        Set<String> entrySet = this.billFieldFilter(sourceBill);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        Map entityMap = mainType.getAllEntities();
        int rowCount = this.getModel().getEntryRowCount(Key_SHOW_LIST);
        ArrayList<String> deleteRowIndexList = new ArrayList<String>(5);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                String fieldNumber = (String)this.getModel().getValue(Key_BILLTYPE, i);
                String propName = (String)this.getModel().getValue(Key_PROPNAME, i);
                if (propName == null || propName.isEmpty()) continue;
                int splitIndex = propName.indexOf(",");
                String templateIdStr = "";
                String fullPropName = "";
                String entryKey = "";
                if (splitIndex > -1) {
                    templateIdStr = propName.substring(0, splitIndex);
                    fullPropName = propName.substring(splitIndex + 1);
                } else if (!KEY_SOURCEBILL.equals(fieldNumber)) {
                    switch (fieldQueryParam.getCheckMethod()) {
                        case PRESET: {
                            templateIdStr = String.valueOf(fieldQueryParam.getValidTemplateId());
                            break;
                        }
                        case CUSTOM: {
                            templateIdStr = String.valueOf(fieldQueryParam.getCustomTemplateId());
                            break;
                        }
                        case LC: {
                            templateIdStr = String.valueOf(fieldQueryParam.getLcTemplateId());
                        }
                    }
                    fullPropName = propName;
                } else {
                    int index = propName.indexOf(".");
                    if (index > -1) {
                        entryKey = propName.substring(0, index);
                    }
                }
                if (StringUtils.isNotEmpty((String)templateIdStr) && !"attachmentField".equals(templateIdStr) && StringUtils.isNotEmpty((String)fullPropName)) {
                    List<AttachmentField> templateFieldList = fieldClassifyMap.get(Long.valueOf(templateIdStr));
                    String finalFullPropName = fullPropName;
                    Optional<AttachmentField> field = templateFieldList.stream().filter(fieldObj -> fieldObj.getFullName().equals(finalFullPropName)).findFirst();
                    if (!field.isPresent()) {
                        deleteRowIndexList.add(String.valueOf(i));
                    }
                }
                if (!StringUtils.isNotEmpty((String)entryKey) || !entityMap.containsKey(entryKey) || entrySet.contains(entryKey)) continue;
                deleteRowIndexList.add(String.valueOf(i));
            }
        }
        if (!deleteRowIndexList.isEmpty()) {
            int[] deleteIndexs = new int[deleteRowIndexList.size()];
            for (int i = 0; i < deleteIndexs.length; ++i) {
                deleteIndexs[i] = Integer.parseInt((String)deleteRowIndexList.get(i));
            }
            this.getModel().deleteEntryRows(Key_SHOW_LIST, deleteIndexs);
        }
    }

    private void clearInterruptPropertyChange() {
        this.getPageCache().remove(PAGECACHE_INTERRUPT);
    }

    private boolean isInterruptPropertyChange() {
        return Boolean.parseBoolean(this.getPageCache().get(PAGECACHE_INTERRUPT));
    }

    private void interruptPropertyChange() {
        this.getPageCache().put(PAGECACHE_INTERRUPT, "true");
    }

    private void changeShowAll(Boolean currentValue, String targetField) {
        int rowCount;
        if (currentValue.booleanValue() && (rowCount = this.getModel().getEntryRowCount(Key_RULE_LIST)) > 0) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                boolean targetValue = (Boolean)this.getModel().getValue(targetField, rowIndex);
                if (targetValue) {
                    this.interruptPropertyChange();
                }
                this.getModel().setValue(targetField, (Object)false, rowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"checkCVPLicense", (Object[])new Object[0]);
            if (result == null || result instanceof Boolean && !((Boolean)result).booleanValue()) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5982\u9700\u4f7f\u7528\u9884\u7f6e\u6a21\u677f\uff0c\u8bf7\u5148\u8ba2\u9605AI\u670d\u52a1\u4e91-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u3002", (String)"IDIAttachmentFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        catch (Exception ex) {
            logger.error("check ai license error", (Throwable)ex);
        }
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilter = formShowParameter.getListFilterParameter();
        QFilter filter = null;
        switch (fieldKey) {
            case "validtemplate": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u677f\u5217\u8868", (String)"IDIAttachmentFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
                filter = new QFilter("isvalid", "in", Arrays.asList("1", "2")).and(Key_STATUS, "=", (Object)"B").and("bindingdata", "=", (Object)"1");
                break;
            }
            case "customtemplate": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6a21\u677f\u5217\u8868", (String)"IDIAttachmentFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]));
                filter = new QFilter("isvalid", "=", (Object)"0").and(Key_STATUS, "=", (Object)"B").and("bindingdata", "=", (Object)"1");
                break;
            }
            case "lctemplate": {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4ee4\u624d\u79d1\u6280\u6a21\u677f\u5217\u8868", (String)"IDIAttachmentFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
                List qFilters = formShowParameter.getTreeFilterParameter().getQFilters();
                qFilters.add(new QFilter("id", "in", Arrays.asList(1736359277184102400L, 1736359278090195968L)));
                break;
            }
        }
        if (filter != null) {
            listFilter.setFilter(filter);
        }
    }

    private void showRuleForm() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String sourceBill = (String)view.getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        int row = model.getEntryCurrentRowIndex(Key_RULE_LIST);
        String conditionJson = (String)model.getValue(Key_RULE_JSON, row);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormId_IDI_CONDITION_EDIT);
        showParameter.getCustomParams().put(CustomParam_FORMULA, conditionJson);
        showParameter.getCustomParams().put(CustomParam_ENTITY_NUMBER, sourceBill);
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61", (String)"IDIDecisionFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
        if (checkMethodEnum != null) {
            IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
            AIParam fieldQueryParam = this.buildParam();
            if (fieldQueryParam == null) {
                return;
            }
            fieldQueryParam.setEntityNumber(sourceBill);
            List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
            if (fieldList != null) {
                Map<AITemplate, List<AttachmentField>> fieldClassifyMap = fieldList.stream().collect(Collectors.groupingBy(AttachmentField::getTemplate));
                this.addAttachField(fieldClassifyMap, root);
                showParameter.getCustomParams().put("attachmentField", JSON.toJSONString(fieldClassifyMap));
            }
        } else {
            showParameter.getCustomParams().put(CustomParam_ONLY_ATTACHMENTFILENAME, Boolean.TRUE);
        }
        if (StringUtils.isNotEmpty((String)sourceBill)) {
            MainEntityType sourceBillEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
            TreeNode sourceBillTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceBillEntityType, (PropTreeBuildOption)new PropTreeBuildOption());
            this.updateTreeNode(sourceBillTreeNode, sourceBillEntityType.getName());
            root.addChild(sourceBillTreeNode);
            sourceBillTreeNode.setIsOpened(false);
        }
        String nodesJson = SerializationUtils.toJsonString((Object)root);
        showParameter.getCustomParams().put(CustomParam_TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_RULE));
        showParameter.getCustomParams().put(CustomParam_SOURCEENTITYNUMBER, sourceBill);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private AIParam buildParam() {
        AIParam fieldQueryParam = new AIParam();
        IDataModel model = this.getModel();
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
        if (checkMethodEnum == null) {
            return fieldQueryParam;
        }
        IFormView view = this.getView();
        switch (checkMethodEnum) {
            case PRESET: {
                Long validTemplateId = (Long)model.getValue("validtemplate_id");
                if (validTemplateId == null || validTemplateId == 0L) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7f6e\u6a21\u677f\u3002", (String)"IDIAttachmentFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return null;
                }
                fieldQueryParam.setValidTemplateId(validTemplateId);
                break;
            }
            case CUSTOM: {
                Long customTemplateId = (Long)model.getValue("customtemplate_id");
                if (customTemplateId == null || customTemplateId == 0L) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81ea\u5b9a\u4e49\u6a21\u677f\u3002", (String)"IDIAttachmentFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return null;
                }
                fieldQueryParam.setCustomTemplateId(customTemplateId);
                break;
            }
            case RECOGNIZER: {
                Long recognizeId = (Long)model.getValue("recognizer_id");
                if (recognizeId == null || recognizeId == 0L) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u5408\u8bc6\u522b\u5668\u3002", (String)"IDIAttachmentFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return null;
                }
                fieldQueryParam.setRecognizerId(recognizeId);
                break;
            }
            case LC: {
                Long lcTemplateId = (Long)model.getValue("lctemplate_id");
                if (lcTemplateId == null || lcTemplateId == 0L) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ee4\u624d\u79d1\u6280\u6a21\u677f\u3002", (String)"IDIAttachmentFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return null;
                }
                fieldQueryParam.setLcTemplateId(lcTemplateId);
                break;
            }
        }
        fieldQueryParam.setCheckMethod(checkMethodEnum);
        return fieldQueryParam;
    }

    private void addAttachField(Map<AITemplate, List<AttachmentField>> fieldClassifyMap, TreeNode root) {
        fieldClassifyMap.forEach((templateData, fields) -> {
            String templatePrefix = IDIStringUtils.templatePrefix((Long)templateData.getId());
            TreeNode templateNode = new TreeNode(root.getId(), templatePrefix.substring(0, templatePrefix.length() - 1), templateData.getName());
            root.addChild(templateNode);
            HashMap<AttachmentField, TreeNode> tableNodeMap = new HashMap<AttachmentField, TreeNode>(fields.size());
            for (AttachmentField attachmentField : fields) {
                AttachmentField attachmentFieldParent;
                TreeNode currentNode = (TreeNode)tableNodeMap.get(attachmentField);
                if (currentNode == null) {
                    currentNode = new TreeNode(templateNode.getId(), templatePrefix + attachmentField.getFullName(), attachmentField.getFullDisplayName());
                    if (attachmentField.isTable()) {
                        tableNodeMap.put(attachmentField, currentNode);
                    }
                }
                if ((attachmentFieldParent = attachmentField.getParent()) != null) {
                    TreeNode parentNode = (TreeNode)tableNodeMap.get(attachmentFieldParent);
                    if (parentNode == null) {
                        parentNode = new TreeNode(templateNode.getId(), templatePrefix + attachmentFieldParent.getFullName(), attachmentFieldParent.getFullDisplayName());
                        tableNodeMap.put(attachmentFieldParent, parentNode);
                    }
                    currentNode.setParentid(parentNode.getId());
                    parentNode.addChild(currentNode);
                    continue;
                }
                templateNode.addChild(currentNode);
            }
        });
    }

    private void updateTreeNode(TreeNode treeNode, String billNumber) {
        String newRootId = billNumber + "_billObj";
        treeNode.setId(newRootId);
        treeNode.setParentid("root");
        if (treeNode.getChildren() == null) {
            return;
        }
        Set mulBaseDataEntitySet = ExecutorHelper.getMulBaseDataEntity((String)billNumber);
        for (TreeNode node : treeNode.getChildren()) {
            node.setParentid(treeNode.getId());
            node.setId(treeNode.getId() + "." + node.getId());
            if (node.getChildren() == null) continue;
            this.updateTreeNodeChild(node, mulBaseDataEntitySet);
        }
    }

    private void updateTreeNodeChild(TreeNode parentNode, Set<String> mulBaseDataEntitySet) {
        boolean isHeadField = parentNode.getId().endsWith("billhead");
        for (TreeNode node : parentNode.getChildren()) {
            node.setParentid(parentNode.getId());
            String newNodeId = isHeadField ? parentNode.getId().replace("billhead", node.getId()) : (node.getId().indexOf(46) > -1 ? parentNode.getId() + node.getId().substring(node.getId().lastIndexOf(46)) : parentNode.getId() + "." + node.getId());
            if (!mulBaseDataEntitySet.isEmpty()) {
                for (String mulEntityNumber : mulBaseDataEntitySet) {
                    if (!newNodeId.contains(mulEntityNumber) || newNodeId.contains(mulEntityNumber + ".fbasedataid")) continue;
                    newNodeId = newNodeId.replace(mulEntityNumber, mulEntityNumber + ".fbasedataid");
                }
            }
            node.setId(newNodeId);
            if (node.getChildren() == null) continue;
            this.updateTreeNodeChild(node, mulBaseDataEntitySet);
        }
    }

    private void receiveCondition(String ruleJson) {
        IDICondition condition;
        if (StringUtils.isNotEmpty((String)ruleJson) && (condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class)) != null) {
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex(Key_RULE_LIST);
            model.setValue(Key_RULE_JSON, (Object)ruleJson, row);
            model.setValue(Key_RULE, (Object)this.getExprDesc(condition), row);
            this.setShowAllEntryCheckTrue();
        }
    }

    private void setShowAllEntryCheckTrue() {
        int rowIndex;
        int rowCount = this.getModel().getEntryRowCount(Key_RULE_LIST);
        StringBuilder scriptBuild = new StringBuilder();
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String ruleJson = (String)this.getModel().getValue(Key_RULE_JSON, rowIndex);
            if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
            scriptBuild.append(condition.getScript()).append(" || ");
        }
        if (scriptBuild.length() <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.getModel().setValue(KEY_SHOWALLENTRYCHECKTRUE, (Object)false, rowIndex);
            }
            return;
        }
        String script = scriptBuild.substring(0, scriptBuild.length() - 3);
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        String[] billTypes = new String[]{sourceBill};
        Set propSet = ScriptUtils.getEntries((MainEntityType)EntityMetadataCache.getDataEntityType((String)sourceBill), (String)script, (String[])billTypes);
        if (propSet.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
            for (int rowIndex2 = 0; rowIndex2 < rowCount; ++rowIndex2) {
                this.getModel().setValue(KEY_SHOWALLENTRYCHECKTRUE, (Object)false, rowIndex2);
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SHOWALLENTRYCHECKTRUE});
        }
    }

    private void receiveStartCondition(String startConditionJson) {
        IDICondition condition;
        if (StringUtils.isNotEmpty((String)startConditionJson) && (condition = (IDICondition)IDIJSONUtils.cast((String)startConditionJson, IDICondition.class)) != null) {
            String exprTran = this.getExprDesc(condition);
            IDataModel model = this.getModel();
            model.setValue(Key_STARTCCONDITION_FIELD, (Object)exprTran);
            model.setValue(Key_STARTCCONDITION_JSON, (Object)startConditionJson);
        }
    }

    private void showStartConditionForm() {
        IFormView view = this.getView();
        String sourceBill = (String)view.getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
        if (StringUtils.isNotEmpty((String)sourceBill)) {
            String conditionJson = (String)this.getModel().getValue(Key_STARTCCONDITION_JSON);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FormId_IDI_CONDITION_EDIT);
            showParameter.getCustomParams().put(CustomParam_FORMULA, conditionJson);
            showParameter.getCustomParams().put(CustomParam_ENTITY_NUMBER, sourceBill);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_START_CONDITION));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(showParameter);
        }
    }

    private boolean preVerity() {
        DynamicObjectCollection collection;
        int size;
        int errorTipsCount;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
        if (checkMethodEnum != null) {
            switch (checkMethodEnum) {
                case PRESET: {
                    Long validTemplateId = (Long)model.getValue("validtemplate_id");
                    if (validTemplateId != null && validTemplateId != 0L) break;
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7f6e\u6a21\u677f\u3002", (String)"IDIAttachmentFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
                case CUSTOM: {
                    Long customTemplateId = (Long)model.getValue("customtemplate_id");
                    if (customTemplateId != null && customTemplateId != 0L) break;
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81ea\u5b9a\u4e49\u6a21\u677f\u3002", (String)"IDIAttachmentFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
                case RECOGNIZER: {
                    Long recognizeId = (Long)model.getValue("recognizer_id");
                    if (recognizeId != null && recognizeId != 0L) break;
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u5408\u8bc6\u522b\u5668\u3002", (String)"IDIAttachmentFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
                case LC: {
                    Long lcTemplateId = (Long)model.getValue("lctemplate_id");
                    if (lcTemplateId != null && lcTemplateId != 0L) break;
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ee4\u624d\u79d1\u6280\u6a21\u677f\u3002", (String)"IDIAttachmentFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        String checkType = (String)model.getValue(Key_CHECKTYPE);
        if (CheckAttachmentTypeEnum.CHECKBILLCONTENT.getType().equals(checkType) && (errorTipsCount = model.getEntryRowCount(Key_SETENTRY)) > 0) {
            for (int i = 0; i < errorTipsCount; ++i) {
                String errorTips = (String)model.getValue(Key_ERRORTIPS, i);
                if (!StringUtils.isEmpty((String)errorTips)) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7279\u522b\u60c5\u51b5\u63d0\u793a\u201d\u7b2c%d\u884c\u7684\u63d0\u793a\u8bed\u3002", (String)"IDIAttachmentFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
        }
        if ((size = (collection = model.getEntryEntity(Key_SHOW_LIST)).size()) > 5) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u60ac\u505c\u4fe1\u606f\u914d\u7f6e\u201d\u5206\u5f55\u884c\u6570\u5e94\u22645\u884c\u3002", (String)"IDIDecisionFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> hoverContents = new ArrayList<String>(1);
        ArrayList<Integer> removeList = new ArrayList<Integer>(1);
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            String billType = dynamicObject.getString(Key_BILLTYPE);
            String fieldNumber = dynamicObject.getString(Key_PROPNAME);
            if (StringUtils.isEmpty((String)billType) && StringUtils.isEmpty((String)fieldNumber)) {
                removeList.add(i);
                continue;
            }
            if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)fieldNumber)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u60ac\u505c\u5c55\u793a\u5b57\u6bb5\u5f55\u5165\u5b8c\u6574\u3002", (String)"IDIDecisionFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            String key = billType + "_" + fieldNumber;
            if (hoverContents.contains(key)) continue;
            hoverContents.add(key);
        }
        int[] delArray = new int[removeList.size()];
        for (int i = 0; i < removeList.size(); ++i) {
            delArray[i] = (Integer)removeList.get(i);
        }
        model.deleteEntryRows(Key_SHOW_LIST, delArray);
        if (size - removeList.size() != hoverContents.size()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60ac\u505c\u5c55\u793a\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"IDIDecisionFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setStartCondition(IDICondition startCondition) {
        if (startCondition != null) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            model.beginInit();
            model.setValue(Key_STARTCCONDITION_FIELD, (Object)startCondition.getExprTran());
            model.setValue(Key_STARTCCONDITION_JSON, (Object)IDIJSONUtils.toJsonString((Object)startCondition));
            model.endInit();
            view.updateView(Key_STARTCCONDITION_FIELD);
            view.updateView(Key_STARTCCONDITION_JSON);
        }
    }

    private void setVisibleAndClearValueByCheckType(CheckAttachmentTypeEnum checkAttachmentTypeEnum, boolean needSetValue) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (needSetValue) {
            model.beginInit();
            model.setValue(Key_CHECKTYPE, (Object)checkAttachmentTypeEnum.getType());
            model.endInit();
            view.updateView(Key_CHECKTYPE);
        }
        if (CheckAttachmentTypeEnum.CHECKEXISTS == checkAttachmentTypeEnum) {
            view.setVisible(Boolean.TRUE, new String[]{Key_CHECKMETHOD, Key_VALIDTEMPLATE, Key_WORDSCONFIG});
            view.setVisible(Boolean.FALSE, new String[]{Key_RULEPANEL, KEY_SHOWALLENTRYCHECKTRUE});
            model.deleteEntryData(Key_RULE_LIST);
            String checkMethod = (String)model.getValue(Key_CHECKMETHOD);
            if (checkMethod == null || checkMethod.isEmpty()) {
                model.setValue(Key_CHECKMETHOD, (Object)CheckMethodEnum.PRESET.getType());
            }
        } else if (CheckAttachmentTypeEnum.CHECKBILLCONTENT == checkAttachmentTypeEnum) {
            view.setVisible(Boolean.TRUE, new String[]{Key_CHECKMETHOD, Key_VALIDTEMPLATE, Key_RULEPANEL, KEY_TIPPANEL});
            view.setVisible(Boolean.FALSE, new String[]{Key_WORDSCONFIG});
            model.setValue(Key_EXISTWORDS, null);
            model.setValue(Key_NOTEXISTWORDS, null);
            String checkMethod = (String)model.getValue(Key_CHECKMETHOD);
            if (checkMethod == null || checkMethod.isEmpty()) {
                model.setValue(Key_CHECKMETHOD, (Object)CheckMethodEnum.PRESET.getType());
            }
        } else if (CheckAttachmentTypeEnum.CHECKFILENAME == checkAttachmentTypeEnum) {
            view.setVisible(Boolean.TRUE, new String[]{Key_RULEPANEL, KEY_TIPPANEL});
            view.setVisible(Boolean.FALSE, new String[]{Key_CHECKMETHOD, Key_VALIDTEMPLATE, Key_CUSTOMTEMPLATE, Key_RECOGNIZER, Key_LCTEMPLATE, Key_WORDSCONFIG});
            model.setValue(Key_CHECKMETHOD, null);
            model.setValue(Key_VALIDTEMPLATE, null);
            model.setValue(Key_CUSTOMTEMPLATE, null);
            model.setValue(Key_RECOGNIZER, null);
            model.setValue(Key_LCTEMPLATE, null);
            model.setValue(Key_EXISTWORDS, null);
            model.setValue(Key_NOTEXISTWORDS, null);
            model.deleteEntryData(Key_RULE_LIST);
            model.deleteEntryData(Key_SHOW_LIST);
        }
    }

    private void setRule(List<DecisionRule> ruleList, boolean scoreMode) {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(scoreMode), new String[]{Key_PERCENT});
        if (ruleList != null && !ruleList.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(Key_RULE_LIST);
            model.batchCreateNewEntryRow(Key_RULE_LIST, ruleList.size());
            for (int row = 0; row < ruleList.size(); ++row) {
                DecisionRule rule = ruleList.get(row);
                model.setValue(Key_TITLE, (Object)rule.getName(), row);
                model.setValue(Key_ISPASS, (Object)rule.isPass(), row);
                if (scoreMode) {
                    model.setValue(Key_PERCENT, (Object)rule.getDeductionGradePercent(), row);
                }
                model.setValue(Key_STATUS, (Object)rule.getDecisionStatus(), row);
                model.setValue(Key_RULE, (Object)this.getExprDesc(rule.getRule()), row);
                model.setValue(Key_RULE_JSON, (Object)(rule.getRule() == null ? "" : IDIJSONUtils.toJsonString((Object)rule.getRule())), row);
                model.setValue(Key_SHOWALLCHECKTRUE, (Object)rule.isShowAllCheckTrue(), row);
                model.setValue(KEY_SHOWALLENTRYCHECKTRUE, (Object)rule.isShowAllEntryCheckTrue(), row);
            }
            model.endInit();
            view.updateView(Key_RULE_LIST);
            this.setShowAllEntryCheckTrue();
        }
    }

    private void setErrorTipsPanel(CheckAttachmentTypeEnum checkAttachmentTypeEnum, List<ExceptionTip> tipList, boolean scoreMode) {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(scoreMode), new String[]{Key_DEDUCTPERCENT});
        IDataModel model = this.getModel();
        model.deleteEntryData(Key_SETENTRY);
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(Key_DEDUCTITEM, new Object[0]);
        tvs.addField(Key_ERRORTIPS, new Object[0]);
        tvs.addField(KEY_ISSHOWERRORTIPS, new Object[0]);
        tvs.addField(Key_DEDUCTPERCENT, new Object[0]);
        if (tipList != null && !tipList.isEmpty()) {
            for (ExceptionTip tip : tipList) {
                tvs.addRow(new Object[]{tip.getExceptionTipItem().getType(), tip.getTipWords(), tip.getShowErrorTips(), scoreMode ? tip.getPercent() : 0});
            }
        } else {
            if (CheckAttachmentTypeEnum.CHECKEXISTS != checkAttachmentTypeEnum) {
                tvs.addRow(new Object[]{ExceptionTipEnum.NOEXISTS.getType(), ExceptionTipEnum.NOEXISTS.convertDescription(), false, 0});
            }
            tvs.addRow(new Object[]{ExceptionTipEnum.NO_MATCH_START.getType(), ExceptionTipEnum.NO_MATCH_START.convertDescription(), true, 0});
            if (CheckAttachmentTypeEnum.CHECKEXISTS != checkAttachmentTypeEnum) {
                tvs.addRow(new Object[]{ExceptionTipEnum.NO_MATCH_RULE.getType(), ExceptionTipEnum.NO_MATCH_RULE.convertDescription(), true, 0});
            }
        }
        abstractModel.beginInit();
        abstractModel.batchCreateNewEntryRow(Key_SETENTRY, tvs);
        abstractModel.endInit();
        view.updateView(Key_SETENTRY);
    }

    private List<DecisionRule> getFormulaData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_RULE_LIST);
        ArrayList<DecisionRule> ruleList = new ArrayList<DecisionRule>();
        for (DynamicObject obj : entryEntity) {
            String name = obj.getString(Key_TITLE);
            boolean isPass = obj.getBoolean(Key_ISPASS);
            String ruleJson = obj.getString(Key_RULE_JSON);
            int percent = obj.getInt(Key_PERCENT);
            String status = obj.getString(Key_STATUS);
            boolean showAllCheckTrue = obj.getBoolean(Key_SHOWALLCHECKTRUE);
            boolean showAllEntryCheckTrue = obj.getBoolean(KEY_SHOWALLENTRYCHECKTRUE);
            DecisionRule rule = new DecisionRule();
            rule.setName(name);
            rule.setRule((IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class));
            rule.setDeductionGradePercent(percent);
            rule.setDecisionStatus(status);
            rule.setPass(isPass);
            rule.setShowAllCheckTrue(showAllCheckTrue);
            rule.setShowAllEntryCheckTrue(showAllEntryCheckTrue);
            ruleList.add(rule);
        }
        return ruleList;
    }

    private DecisionFrontEndConfig getFrontEndConfig() {
        DecisionFrontEndConfig config = new DecisionFrontEndConfig();
        int rowCount = this.getModel().getEntryRowCount(Key_SHOW_LIST);
        if (rowCount > 0) {
            ArrayList<DecisionFrontEndConfigField> hoverContents = new ArrayList<DecisionFrontEndConfigField>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                int splitIndex;
                String fieldNumber = (String)this.getModel().getValue(Key_BILLTYPE, i);
                String propDisplayName = (String)this.getModel().getValue(Key_PROPDISPLAYNAME, i);
                String propName = (String)this.getModel().getValue(Key_PROPNAME, i);
                String displayName = (String)this.getModel().getValue(Key_DISPLAYNAME, i);
                DecisionFrontEndConfigField configField = new DecisionFrontEndConfigField();
                configField.setBillType(fieldNumber);
                configField.setDisplayName(displayName);
                configField.setPropDisplayName(propDisplayName);
                configField.setPropName(propName);
                if (propName != null && !propName.isEmpty() && (splitIndex = propName.indexOf(",")) > -1) {
                    configField.setBillType(propName.substring(0, splitIndex));
                    configField.setPropName(propName.substring(splitIndex + 1));
                }
                hoverContents.add(configField);
            }
            config.setHoverFieldContents(hoverContents);
        }
        return config;
    }

    private String getExprDesc(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        String handDesc = condition.getDescription().toString();
        if (StringUtils.isNotEmpty((String)handDesc)) {
            return handDesc;
        }
        return StringUtils.isNotEmpty((String)condition.getExprTran()) ? condition.getExprTran() : condition.getExpression();
    }

    private void showBillFieldForm() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
        if (currentRowIndex > -1) {
            String billType = (String)model.getValue(Key_BILLTYPE, currentRowIndex);
            if (StringUtils.isEmpty((String)billType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u5b57\u6bb5\u6765\u6e90\u201d\u3002", (String)"IDIDecisionFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("idi_fieldlist");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            String sourceBill = (String)view.getFormShowParameter().getCustomParam(CustomParam_ENTITY_NUMBER);
            if (!KEY_SOURCEBILL.equals(billType)) {
                AIParam fieldQueryParam = this.buildParam();
                if (fieldQueryParam == null) {
                    return;
                }
                fieldQueryParam.setEntityNumber(sourceBill);
                CheckMethodEnum checkMethodEnum = CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
                if (checkMethodEnum != null) {
                    IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance((CheckMethodEnum)checkMethodEnum);
                    List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
                    if (fieldList != null && !fieldList.isEmpty()) {
                        Map<Long, List<AttachmentField>> fieldClassifyMap = this.attachmentFieldFilter(fieldList, sourceBill);
                        fsp.getCustomParams().put("attachmentField", JSON.toJSONString(fieldClassifyMap));
                    } else {
                        fsp.getCustomParams().put("attachmentField", "");
                    }
                } else {
                    fsp.getCustomParams().put(CustomParam_ONLY_ATTACHMENTFILENAME, Boolean.TRUE);
                }
            }
            fsp.setCustomParam(CustomParam_ENTITY_NUMBER, (Object)sourceBill);
            fsp.setCustomParam(CustomParam_CURRENTSELECTFIELDS, model.getValue(Key_PROPNAME, currentRowIndex));
            String checkType = (String)model.getValue(Key_CHECKTYPE);
            if (CheckAttachmentTypeEnum.CHECKBILLCONTENT.getType().equals(checkType)) {
                Set<String> fieldLimitSet = this.billFieldFilter(sourceBill);
                fsp.setCustomParam(CustomParam_LIMITFIELDS, fieldLimitSet);
            }
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_BILLFIELD));
            view.showForm(fsp);
        }
    }

    private Set<String> billFieldFilter(String sourceBill) {
        int ruleCount = this.getModel().getEntryRowCount(Key_RULE_LIST);
        String mainVarName = sourceBill + "_billObj.";
        HashSet<String> fieldLimitSet = new HashSet<String>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        Map entityMap = mainType.getAllEntities();
        for (int i = 0; i < ruleCount; ++i) {
            String ruleJson = (String)this.getModel().getValue(Key_RULE_JSON, i);
            if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
            String script = condition.getScript();
            Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{sourceBill});
            for (String field : vars) {
                if (!field.startsWith(mainVarName)) continue;
                String fullField = field.substring(mainVarName.length());
                for (String entryKey : entityMap.keySet()) {
                    if (entryKey.equals(sourceBill) || !fullField.contains(entryKey)) continue;
                    fieldLimitSet.add(entryKey);
                }
            }
        }
        return fieldLimitSet;
    }

    private Map<Long, List<AttachmentField>> attachmentFieldFilter(List<AttachmentField> fieldList, String sourceBill) {
        HashMap<Long, List<AttachmentField>> fieldClassifyMap = new HashMap<Long, List<AttachmentField>>(1);
        for (AttachmentField attachmentField : fieldList) {
            AITemplate template = attachmentField.getTemplate();
            if (template == null) continue;
            Long templateId = template.getId();
            List attachmentFields = fieldClassifyMap.computeIfAbsent(templateId, k -> new ArrayList(1));
            attachmentFields.add(attachmentField);
        }
        ArrayList<Long> templateIdList = new ArrayList<Long>(fieldClassifyMap.keySet());
        Map<Long, String> templateTableMap = this.getTemplateTable(templateIdList, sourceBill);
        for (Map.Entry entry : fieldClassifyMap.entrySet()) {
            Long templateId = (Long)entry.getKey();
            List attachmentFieldList = (List)entry.getValue();
            ListIterator attachmentFieldListIterator = attachmentFieldList.listIterator();
            while (attachmentFieldListIterator.hasNext()) {
                AttachmentField attachmentField = (AttachmentField)attachmentFieldListIterator.next();
                if (attachmentField == null) {
                    attachmentFieldListIterator.remove();
                    continue;
                }
                boolean reserve = false;
                String tableKey = templateTableMap.get(templateId);
                if (StringUtils.isNotEmpty((String)tableKey)) {
                    reserve = attachmentField.getParent() == null && !attachmentField.isTable() ? true : attachmentField.getParent() != null && tableKey.equals(attachmentField.getParent().getName());
                } else if (attachmentField.getParent() == null && !attachmentField.isTable()) {
                    reserve = true;
                }
                if (reserve) continue;
                attachmentFieldListIterator.remove();
            }
        }
        return fieldClassifyMap;
    }

    private Map<Long, String> getTemplateTable(List<Long> templateIdList, String sourceBill) {
        IDataModel model = this.getModel();
        int ruleCount = model.getEntryRowCount(Key_RULE_LIST);
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (int i = 0; i < ruleCount; ++i) {
            String ruleJson = (String)model.getValue(Key_RULE_JSON, i);
            if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
            IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)ruleJson, IDICondition.class);
            String script = condition.getScript();
            Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{sourceBill});
            for (Long aLong : templateIdList) {
                String prefix = IDIStringUtils.templatePrefix((Long)aLong);
                for (String var : vars) {
                    String previousTable;
                    String[] properties = var.split("\\.");
                    if (properties.length <= 2 || !var.startsWith(prefix) || (previousTable = (String)map.get(aLong)) != null && !previousTable.equals(properties[1])) continue;
                    map.put(aLong, properties[1]);
                }
            }
        }
        return map;
    }

    private void receiveBillField(Object result) {
        IDataModel model = this.getModel();
        if (result != null) {
            String[][] fields = (String[][])result;
            int currentIndex = model.getEntryCurrentRowIndex(Key_SHOW_LIST);
            for (int i = 0; i < fields.length; ++i) {
                String[] field = fields[i];
                if (field == null || i != 0) continue;
                model.setValue(Key_PROPNAME, (Object)field[0], currentIndex);
                model.setValue(Key_PROPDISPLAYNAME, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"IDIDecisionFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]), field[1]), currentIndex);
                break;
            }
        }
    }

    private void setFrontConfig(AttachmentConfig attachmentConfig) {
        List contents;
        Long templateId = null;
        CheckMethodEnum checkMethod = attachmentConfig.getCheckMethod();
        if (checkMethod != null) {
            switch (checkMethod) {
                case PRESET: {
                    templateId = attachmentConfig.getValidTemplateId();
                    break;
                }
                case CUSTOM: {
                    templateId = attachmentConfig.getCustomTemplateId();
                    break;
                }
                case RECOGNIZER: {
                    templateId = attachmentConfig.getRecognizerId();
                    break;
                }
                case LC: {
                    templateId = attachmentConfig.getLcTemplateId();
                    break;
                }
            }
        }
        this.updateBillTypeCombo(templateId, checkMethod);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DecisionFrontEndConfig decisionFrontEndConfig = attachmentConfig.getFrontEndConfig();
        if (decisionFrontEndConfig != null && (contents = decisionFrontEndConfig.getHoverFieldContents()) != null) {
            model.beginInit();
            for (DecisionFrontEndConfigField configField : contents) {
                String billType = configField.getBillType();
                int row = model.createNewEntryRow(Key_SHOW_LIST);
                model.setValue(Key_BILLTYPE, (Object)(KEY_SOURCEBILL.equals(billType) ? billType : "attachmentField"), row);
                model.setValue(Key_PROPDISPLAYNAME, (Object)configField.getPropDisplayName(), row);
                model.setValue(Key_PROPNAME, (Object)(KEY_SOURCEBILL.equals(billType) ? configField.getPropName() : billType + "," + configField.getPropName()), row);
                model.setValue(Key_DISPLAYNAME, (Object)configField.getDisplayName(), row);
            }
            model.endInit();
            view.updateView(Key_SHOW_LIST);
        }
    }

    private void setTemplateWhenCheckMethodChanged() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(Key_VALIDTEMPLATE, null);
        model.setValue(Key_CUSTOMTEMPLATE, null);
        model.setValue(Key_RECOGNIZER, null);
        model.setValue(Key_LCTEMPLATE, null);
        model.endInit();
        view.updateView(Key_TEMPLATEPANEL);
    }

    private void updateBillTypeCombo(Object newTemplateValue, CheckMethodEnum checkMethodEnumParam) {
        CheckMethodEnum checkMethodEnum;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String templateDataIdStr = null;
        CheckMethodEnum checkMethodEnum2 = checkMethodEnum = checkMethodEnumParam != null ? checkMethodEnumParam : CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD)));
        if (checkMethodEnum != null) {
            if (newTemplateValue != null) {
                templateDataIdStr = newTemplateValue instanceof DynamicObject ? String.valueOf(((DynamicObject)newTemplateValue).getPkValue()) : String.valueOf(newTemplateValue);
            }
            switch (checkMethodEnum) {
                case PRESET: {
                    view.setVisible(Boolean.TRUE, new String[]{Key_VALIDTEMPLATE});
                    break;
                }
                case CUSTOM: {
                    view.setVisible(Boolean.TRUE, new String[]{Key_CUSTOMTEMPLATE});
                    break;
                }
                case RECOGNIZER: {
                    view.setVisible(Boolean.TRUE, new String[]{Key_RECOGNIZER});
                    break;
                }
                case LC: {
                    view.setVisible(Boolean.TRUE, new String[]{Key_LCTEMPLATE});
                    break;
                }
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(Key_BILLTYPE);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(2);
        ComboItem srcBillComboItem = new ComboItem();
        srcBillComboItem.setCaption(ResManager.getLocaleString((String)"\u6e90\u5355\u5b57\u6bb5", (String)"IDIDecisionFormPlugin_8", (String)"data-idi-formplugin"));
        srcBillComboItem.setValue(KEY_SOURCEBILL);
        comboItemList.add(srcBillComboItem);
        if (templateDataIdStr != null || checkMethodEnum == null) {
            ComboItem templateComboItem = new ComboItem();
            templateComboItem.setCaption(ResManager.getLocaleString((String)"\u9644\u4ef6\u5b57\u6bb5", (String)"IDIDecisionFormPlugin_14", (String)"data-idi-formplugin"));
            templateComboItem.setValue("attachmentField");
            comboItemList.add(templateComboItem);
        }
        comboEdit.setComboItems(comboItemList);
    }

    private void setCheckTypeAndTemplate(AttachmentConfig attachmentConfig) {
        CheckMethodEnum checkMethod = attachmentConfig.getCheckMethod();
        if (checkMethod != null) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue(Key_CHECKMETHOD, (Object)checkMethod.getType());
            switch (checkMethod) {
                case PRESET: {
                    model.setValue(Key_VALIDTEMPLATE, (Object)attachmentConfig.getValidTemplateId());
                    break;
                }
                case CUSTOM: {
                    model.setValue(Key_CUSTOMTEMPLATE, (Object)attachmentConfig.getCustomTemplateId());
                    break;
                }
                case RECOGNIZER: {
                    model.setValue(Key_RECOGNIZER, (Object)attachmentConfig.getRecognizerId());
                    break;
                }
                case LC: {
                    model.setValue(Key_LCTEMPLATE, (Object)attachmentConfig.getLcTemplateId());
                }
            }
            model.endInit();
            view.updateView(Key_CHECKMETHOD);
            view.updateView(Key_TEMPLATEPANEL);
        }
    }

    private List<ExceptionTip> getExceptionTips() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(Key_SETENTRY);
        ArrayList<ExceptionTip> exceptionTipList = new ArrayList<ExceptionTip>(rowCount);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                ExceptionTip exceptionTip = new ExceptionTip();
                exceptionTip.setSeq(i);
                ExceptionTipEnum exceptionTipEnum = ExceptionTipEnum.convertFromMatchType((String)((String)model.getValue(Key_DEDUCTITEM, i)));
                exceptionTip.setExceptionTipItem(exceptionTipEnum);
                String tips = (String)model.getValue(Key_ERRORTIPS, i);
                exceptionTip.setTipWords(StringUtils.isNotEmpty((String)tips) ? tips : exceptionTipEnum.convertDescription());
                exceptionTip.setShowErrorTips((Boolean)model.getValue(KEY_ISSHOWERRORTIPS, i));
                exceptionTip.setPercent(((Integer)model.getValue(Key_DEDUCTPERCENT, i)).intValue());
                exceptionTipList.add(exceptionTip);
            }
        }
        return exceptionTipList;
    }

    private AttachmentConfig buildAttachmentConfig() {
        AttachmentConfig config = new AttachmentConfig();
        IDataModel model = this.getModel();
        config.setStartCondition((IDICondition)IDIJSONUtils.cast((String)((String)model.getValue(Key_STARTCCONDITION_JSON)), IDICondition.class));
        CheckAttachmentTypeEnum checkAttachmentTypeEnum = CheckAttachmentTypeEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKTYPE)));
        config.setCheckType(checkAttachmentTypeEnum);
        config.setCheckMethod(CheckMethodEnum.convertFromMatchType((String)((String)model.getValue(Key_CHECKMETHOD))));
        config.setValidTemplateId((Long)model.getValue("validtemplate_id"));
        config.setCustomTemplateId((Long)model.getValue("customtemplate_id"));
        DynamicObject recognizerObj = (DynamicObject)model.getValue(Key_RECOGNIZER);
        if (recognizerObj != null) {
            config.setRecognizerName(((OrmLocaleValue)recognizerObj.get("name")).get((Object)Lang.get().toString()));
            config.setRecognizerId(Long.valueOf(recognizerObj.getLong("id")));
        }
        config.setLcTemplateId((Long)model.getValue("lctemplate_id"));
        if (CheckAttachmentTypeEnum.CHECKEXISTS == checkAttachmentTypeEnum) {
            String existWord = (String)model.getValue(Key_EXISTWORDS);
            String notExistWord = (String)model.getValue(Key_NOTEXISTWORDS);
            config.setExistWords(StringUtils.isEmpty((String)existWord) ? ResManager.loadKDString((String)"\u9644\u4ef6\u5b58\u5728", (String)"IDIAttachmentFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]) : existWord);
            config.setNotExistWords(StringUtils.isEmpty((String)notExistWord) ? ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728", (String)"IDIAttachmentFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]) : notExistWord);
        }
        config.setRuleList(this.getFormulaData());
        config.setExceptionTipList(this.getExceptionTips());
        config.setFrontEndConfig(this.getFrontEndConfig());
        return config;
    }
}

