/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillFlowConfig;
import kd.data.idi.data.BillFlowConfigDetail;
import kd.data.idi.util.IDIJSONUtils;

public class IDIBillFlowFormPlugin
extends AbstractFormPlugin {
    private static final String CONFIRM = "buttonconfirm";
    private static final String TOOLBAR = "advcontoolbarap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BILL_TYPE_NUMBER = "billtypenumber";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_ENTITY_NAME = "billName";
    private static final String IS_BILL_FLOW = "isbillflow";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String DATE_FIELD_NAME = "propdisplayname";
    private static final String DATE_FIELD_PEOPERTY = "propname";
    private static final String SHOW_TOTAL_COLUMN = "showtotalcolumn";
    private static final String PROPERTY_NAME = "propertyname";
    private static final String BILL_TYPE_NUMBER_OF_DEADLINE = "billtypenumberofdeadline";
    private static final String DATE_FIELD_OF_DEADLINE = "datefieldofdeadline";
    private static final String IDI_FIELDLIST = "idi_fieldlist";
    private static final String CLOSE_DATE_FIELD = "close_date_field";
    private static final String BILL_FLOW_FIELDLIST = "idi_flow_fieldlist";
    private static final String CLOSE_EXTERNAL_COLUMN_FIELD = "close_external_column_field";
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String SELECT_FIELDS = "selectfields";
    private static final String LIMIT_FIELDS = "limitfields";
    private static final String CUSTOM_ONLYHEADFIELD = "onlyheadfield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM, BILL_TYPE_NUMBER, DATE_FIELD_NAME, SHOW_TOTAL_COLUMN});
        this.addItemClickListeners(new String[]{TOOLBAR});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "propdisplayname": {
                this.showBillFieldForm();
                break;
            }
            case "showtotalcolumn": {
                this.showExternalBillColumnField();
                break;
            }
            case "buttonconfirm": {
                if (!this.isDataCorrect()) break;
                String returnData = this.getReturnData();
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.refreshBillTypeOption();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "close_date_field": {
                this.reciveBillField(result);
                break;
            }
            case "close_external_column_field": {
                this.reciveBillFlowField(result);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        switch (e.getProperty().getName()) {
            case "billtypenumber": {
                this.checkBillTypeRepeat();
                this.clearExternalColumn(currentRow);
                this.getModel().setValue(SHOW_TOTAL_COLUMN, (Object)"", currentRow);
                this.clearCurrentRowDateField(currentRow);
                this.refreshBillTypeOption();
                break;
            }
            case "propdisplayname": {
                String dateFieldName = (String)this.getModel().getValue(DATE_FIELD_NAME, currentRow);
                if (StringUtils.isEmpty((String)dateFieldName)) {
                    this.getModel().setValue(DATE_FIELD_PEOPERTY, (Object)"", currentRow);
                }
                this.clearExternalColumn(currentRow);
                this.getModel().setValue(SHOW_TOTAL_COLUMN, (Object)"", currentRow);
                break;
            }
            case "showtotalcolumn": {
                String totalColumn = (String)this.getModel().getValue(SHOW_TOTAL_COLUMN, currentRow);
                if (!StringUtils.isEmpty((String)totalColumn)) break;
                this.clearExternalColumn(currentRow);
                break;
            }
            case "billtypenumberofdeadline": {
                this.refreshDateFieldOfDeadline();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String detailConfig = (String)formShowParameter.getCustomParam(CustomParam_DETAIL_CONFIG);
        if (StringUtils.isNotEmpty((String)detailConfig)) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            BillFlowConfig billFlowConfig = (BillFlowConfig)IDIJSONUtils.cast((String)detailConfig, BillFlowConfig.class);
            List billFlowConfigDetailList = billFlowConfig.getDetailList();
            if (!billFlowConfigDetailList.isEmpty()) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
                tableValueSetter.addField(BILL_TYPE_NUMBER, new Object[0]);
                tableValueSetter.addField(DATE_FIELD_NAME, new Object[0]);
                tableValueSetter.addField(DATE_FIELD_PEOPERTY, new Object[0]);
                tableValueSetter.addField(SHOW_TOTAL_COLUMN, new Object[0]);
                for (int i = 1; i < 5; ++i) {
                    tableValueSetter.addField(PROPERTY_NAME + i, new Object[0]);
                }
                List<ComboItem> endBillTypeList = this.initEndBillTypeList(billFlowConfigDetailList, tableValueSetter);
                ComboEdit endBillTypeComboEdit = (ComboEdit)this.getControl(BILL_TYPE_NUMBER_OF_DEADLINE);
                endBillTypeComboEdit.setComboItems(endBillTypeList);
                model.batchCreateNewEntryRow(ENTRY_ENTITY, tableValueSetter);
                model.endInit();
                this.getView().updateView(ENTRY_ENTITY);
            }
            List<ComboItem> endDateList = this.initEndDateList(billFlowConfig.getBillTypeNumberOfDeadline());
            ComboEdit endDateComboEdit = (ComboEdit)this.getControl(DATE_FIELD_OF_DEADLINE);
            endDateComboEdit.setComboItems(endDateList);
            this.getModel().setValue(BILL_TYPE_NUMBER_OF_DEADLINE, (Object)billFlowConfig.getBillTypeNumberOfDeadline());
            this.getModel().setValue(DATE_FIELD_OF_DEADLINE, (Object)billFlowConfig.getDateFieldOfDeadline());
        }
    }

    private List<ComboItem> initEndBillTypeList(List<BillFlowConfigDetail> billFlowConfigDetailList, TableValueSetter tableValueSetter) {
        ArrayList<ComboItem> endBillTypeList = new ArrayList<ComboItem>();
        for (BillFlowConfigDetail detail : billFlowConfigDetailList) {
            tableValueSetter = this.setCurrentRowData(detail, tableValueSetter);
            String billNumber = detail.getBillTypeNumber();
            String billName = detail.getBillTypeNumberEntityName();
            if (!StringUtils.isNotEmpty((String)billNumber) || !StringUtils.isNotEmpty((String)billName)) continue;
            ComboItem comboItem = new ComboItem();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(billName);
            comboItem.setCaption(localeString);
            comboItem.setValue(billNumber);
            endBillTypeList.add(comboItem);
        }
        return endBillTypeList;
    }

    private List<ComboItem> initEndDateList(String billTypeNumber) {
        ArrayList<ComboItem> endDateList = new ArrayList<ComboItem>();
        if (StringUtils.isNotEmpty((String)billTypeNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billTypeNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            for (Map map : cols) {
                String entryEntity = (String)map.get("entryEntity");
                String fieldName = (String)map.get("fieldName");
                String fieldCaption = (String)map.get("fieldCaption");
                String columnType = (String)map.get("type");
                if (!"date".equalsIgnoreCase(columnType) && !"datetime".equalsIgnoreCase(columnType)) continue;
                String value = fieldName;
                if (StringUtils.isNotEmpty((String)entryEntity) && !billTypeNumber.equals(entryEntity)) {
                    value = entryEntity + "." + fieldName;
                }
                ComboItem endDateComboItem = new ComboItem();
                LocaleString endDateLocaleString = new LocaleString();
                endDateLocaleString.setLocaleValue(fieldCaption);
                endDateComboItem.setCaption(endDateLocaleString);
                endDateComboItem.setValue(value);
                endDateList.add(endDateComboItem);
            }
        }
        return endDateList;
    }

    private void clearExternalColumn(int currentRow) {
        for (int k = 1; k < 5; ++k) {
            this.getModel().setValue(PROPERTY_NAME + k, (Object)"", currentRow);
        }
    }

    public String getReturnData() {
        int totalRowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        BillFlowConfig billFlowConfig = new BillFlowConfig();
        billFlowConfig.setBillTypeNumberOfDeadline((String)this.getModel().getValue(BILL_TYPE_NUMBER_OF_DEADLINE));
        billFlowConfig.setDateFieldOfDeadline((String)this.getModel().getValue(DATE_FIELD_OF_DEADLINE));
        ArrayList<BillFlowConfigDetail> detailList = new ArrayList<BillFlowConfigDetail>();
        for (int i = 0; i < totalRowCount; ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BILL_TYPE_NUMBER, i);
            if (dynamicObject == null) continue;
            String billTypeNumber = (String)dynamicObject.get(NUMBER);
            String dateFieldName = (String)this.getModel().getValue(DATE_FIELD_PEOPERTY, i);
            if (!StringUtils.isNotEmpty((String)billTypeNumber) || !StringUtils.isNotEmpty((String)dateFieldName)) continue;
            BillFlowConfigDetail billFlowConfigDetail = new BillFlowConfigDetail();
            billFlowConfigDetail.setBillTypeNumber(billTypeNumber);
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dynamicObject.get(NAME);
            String billEntityName = ormLocaleValue.getLocaleValue_zh_CN();
            billFlowConfigDetail.setBillTypeNumberEntityName(billEntityName);
            billFlowConfigDetail.setDateFieldName(dateFieldName);
            billFlowConfigDetail.setDateFieldEntityName((String)this.getModel().getValue(DATE_FIELD_NAME, i));
            String showTotalColumnName = (String)this.getModel().getValue(SHOW_TOTAL_COLUMN, i);
            List<String> totalColumnNameList = StringUtils.isNotEmpty((String)showTotalColumnName) ? Arrays.asList(showTotalColumnName.split("\u3001")) : null;
            billFlowConfigDetail.setDisplayFieldNameList(totalColumnNameList);
            billFlowConfigDetail.setCalculateDistanceDays(true);
            ArrayList<String> externalColumnList = new ArrayList<String>();
            for (int k = 1; k < 5; ++k) {
                String externalProperty = (String)this.getModel().getValue(PROPERTY_NAME + k, i);
                if (!StringUtils.isNotEmpty((String)externalProperty)) continue;
                externalColumnList.add(externalProperty);
            }
            billFlowConfigDetail.setDisplayFieldList(externalColumnList);
            detailList.add(billFlowConfigDetail);
        }
        billFlowConfig.setDetailList(detailList);
        return IDIJSONUtils.toJsonString((Object)billFlowConfig);
    }

    private void showBillFieldForm() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (currentRowIndex > -1) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BILL_TYPE_NUMBER, currentRowIndex);
            if (dynamicObject == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"IDIBillFlowFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            String billType = (String)dynamicObject.get(NUMBER);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(IDI_FIELDLIST);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam(ENTITY_NUMBER, (Object)billType);
            ArrayList<String> fields = new ArrayList<String>();
            fields.add((String)this.getModel().getValue(DATE_FIELD_PEOPERTY, currentRowIndex));
            fsp.setCustomParam(SELECT_FIELDS, (Object)IDIJSONUtils.toJsonString(fields));
            fsp.setCustomParam(IS_BILL_FLOW, (Object)Boolean.TRUE);
            fsp.setCustomParam(CUSTOM_ONLYHEADFIELD, (Object)"true");
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_DATE_FIELD));
            this.getView().showForm(fsp);
        }
    }

    private void showExternalBillColumnField() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (currentRowIndex > -1) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BILL_TYPE_NUMBER, currentRowIndex);
            if (dynamicObject == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"IDIBillFlowFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            String dateFieldPropertyName = (String)this.getModel().getValue(DATE_FIELD_PEOPERTY, currentRowIndex);
            if (StringUtils.isEmpty((String)dateFieldPropertyName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u5b57\u6bb5\u3002", (String)"IDIBillFlowFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            String showTotalColumn = (String)this.getModel().getValue(SHOW_TOTAL_COLUMN, currentRowIndex);
            String billType = (String)dynamicObject.get(NUMBER);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(BILL_FLOW_FIELDLIST);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam(BILL_TYPE_NUMBER, (Object)billType);
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 1; i <= 4; ++i) {
                String propertyValue = (String)this.getModel().getValue(PROPERTY_NAME + i, currentRowIndex);
                if (!StringUtils.isNotEmpty((String)propertyValue)) continue;
                fields.add(propertyValue);
            }
            fsp.setCustomParam(SELECT_FIELDS, (Object)IDIJSONUtils.toJsonString(fields));
            fsp.setCustomParam(LIMIT_FIELDS, (Object)dateFieldPropertyName);
            fsp.setCustomParam(CUSTOM_ONLYHEADFIELD, (Object)Boolean.TRUE);
            fsp.setCustomParam(SHOW_TOTAL_COLUMN, (Object)showTotalColumn);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_EXTERNAL_COLUMN_FIELD));
            this.getView().showForm(fsp);
        }
    }

    private void reciveBillField(Object result) {
        if (result != null) {
            String[][] fields = (String[][])result;
            int currrentIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            for (int i = 0; i < fields.length; ++i) {
                String[] field = fields[i];
                if (field == null) continue;
                this.getModel().setValue(DATE_FIELD_PEOPERTY, (Object)field[0], currrentIndex);
                this.getModel().setValue(DATE_FIELD_NAME, (Object)field[1], currrentIndex);
            }
        }
    }

    private void reciveBillFlowField(Object result) {
        if (result != null) {
            String[][] fields = (String[][])result;
            int currentIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            StringBuilder showTotalColumnName = new StringBuilder();
            for (int i = 0; i < fields.length; ++i) {
                String[] field = fields[i];
                if (field == null || field.length < 1) continue;
                String proDispalyName = field[0];
                String propertyName = field.length >= 2 ? field[1] : "";
                String proDisplayRename = field.length >= 3 ? field[2] : "";
                String indexNumber = String.valueOf(i + 1);
                this.getModel().setValue(PROPERTY_NAME + indexNumber, (Object)propertyName, currentIndex);
                if (showTotalColumnName.length() < 1) {
                    showTotalColumnName.append(StringUtils.isNotEmpty((String)proDisplayRename) ? proDisplayRename : proDispalyName);
                    continue;
                }
                showTotalColumnName.append('\u3001').append(StringUtils.isNotEmpty((String)proDisplayRename) ? proDisplayRename : proDispalyName);
            }
            this.getModel().setValue(SHOW_TOTAL_COLUMN, (Object)showTotalColumnName.toString(), currentIndex);
            for (int k = 4; k > fields.length; --k) {
                this.getModel().setValue(PROPERTY_NAME + k, (Object)"", currentIndex);
            }
        }
    }

    private boolean isDataCorrect() {
        int totalRowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        ArrayList billTypeList = new ArrayList();
        boolean atLeastOneMatch = false;
        String sourceBillNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        for (int i = 0; i < totalRowCount; ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BILL_TYPE_NUMBER, i);
            if (dynamicObject == null) continue;
            String billType = (String)dynamicObject.get(NUMBER);
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dynamicObject.get(NAME);
            String billName = ormLocaleValue.toString();
            if (StringUtils.isNotEmpty((String)billType)) {
                String dateFieldProperty = (String)this.getModel().getValue(DATE_FIELD_PEOPERTY, i);
                if (StringUtils.isEmpty((String)dateFieldProperty)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u5b57\u6bb5\u3002", (String)"IDIBillFlowFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!billTypeList.isEmpty() && billTypeList.contains(billType)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5355\u636e\u7c7b\u578b\u91cd\u590d\u3002", (String)"IDIBillFlowFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), billName));
                    return false;
                }
                if (!billType.equals(sourceBillNumber)) continue;
                atLeastOneMatch = true;
                continue;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"IDIBillFlowFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!atLeastOneMatch) {
            String sourceBillEntityName = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ENTITY_NAME);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e2d\u9700\u8981\u6709\u4e00\u884c\u5355\u636e\u662f\u201c%s\u201d\u3002", (String)"IDIBillFlowFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]), sourceBillEntityName));
            return false;
        }
        return true;
    }

    private void checkBillTypeRepeat() {
        String currentBillNumber;
        DynamicObject currentDynamicObject;
        int totalRowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (currentRow > -1 && (currentDynamicObject = (DynamicObject)this.getModel().getValue(BILL_TYPE_NUMBER, currentRow)) != null && StringUtils.isNotEmpty((String)(currentBillNumber = (String)currentDynamicObject.get(NUMBER)))) {
            for (int i = 0; i < totalRowCount; ++i) {
                DynamicObject dynamicObject;
                if (i == currentRow || (dynamicObject = (DynamicObject)this.getModel().getValue(BILL_TYPE_NUMBER, i)) == null) continue;
                String billNumber = (String)dynamicObject.get(NUMBER);
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dynamicObject.get(NAME);
                String billName = ormLocaleValue.toString();
                if (!currentBillNumber.equals(billNumber)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5355\u636e\u7c7b\u578b\u91cd\u590d\u3002", (String)"IDIBillFlowFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]), billName));
            }
        }
    }

    private void clearCurrentRowDateField(int currentRow) {
        if (currentRow > -1) {
            this.getModel().setValue(DATE_FIELD_NAME, (Object)"", currentRow);
            this.getModel().setValue(DATE_FIELD_PEOPERTY, (Object)"", currentRow);
        }
    }

    private TableValueSetter setCurrentRowData(BillFlowConfigDetail detail, TableValueSetter tableValueSetter) {
        List externalColumnList;
        List totalColumnNameList = detail.getDisplayFieldNameList();
        StringBuilder totalColumnName = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)totalColumnNameList)) {
            for (String fieldName : totalColumnNameList) {
                if (totalColumnName.length() > 0) {
                    totalColumnName.append('\u3001').append(fieldName);
                    continue;
                }
                totalColumnName.append(fieldName);
            }
        }
        String firstProperty = (externalColumnList = detail.getDisplayFieldList()).size() > 0 ? (String)externalColumnList.get(0) : "";
        String secondProperty = externalColumnList.size() > 1 ? (String)externalColumnList.get(1) : "";
        String thirdProperty = externalColumnList.size() > 2 ? (String)externalColumnList.get(2) : "";
        String fourthProperty = externalColumnList.size() > 3 ? (String)externalColumnList.get(3) : "";
        tableValueSetter.addRow(new Object[]{detail.getBillTypeNumber(), detail.getDateFieldEntityName(), detail.getDateFieldName(), totalColumnName.toString(), firstProperty, secondProperty, thirdProperty, fourthProperty});
        return tableValueSetter;
    }

    private void refreshBillTypeOption() {
        String endBillTypeOfChecked = (String)this.getModel().getValue(BILL_TYPE_NUMBER_OF_DEADLINE);
        boolean containEndBillType = false;
        int totalRowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        ArrayList<ComboItem> endBillTypeList = new ArrayList<ComboItem>();
        for (int i = 0; i < totalRowCount; ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BILL_TYPE_NUMBER, i);
            if (dynamicObject == null) continue;
            String billNumber = (String)dynamicObject.get(NUMBER);
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dynamicObject.get(NAME);
            String billName = ormLocaleValue.toString();
            if (!StringUtils.isNotEmpty((String)billNumber) || !StringUtils.isNotEmpty((String)billName)) continue;
            if (billNumber.equalsIgnoreCase(endBillTypeOfChecked)) {
                containEndBillType = true;
            }
            ComboItem comboItem = new ComboItem();
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(billName);
            comboItem.setCaption(localeString);
            comboItem.setValue(billNumber);
            endBillTypeList.add(comboItem);
        }
        ComboEdit endBillTypeComboEdit = (ComboEdit)this.getControl(BILL_TYPE_NUMBER_OF_DEADLINE);
        endBillTypeComboEdit.setComboItems(endBillTypeList);
        if (!containEndBillType) {
            this.getModel().setValue(DATE_FIELD_OF_DEADLINE, (Object)"");
            this.getModel().setValue(BILL_TYPE_NUMBER_OF_DEADLINE, (Object)"");
        }
    }

    private void refreshDateFieldOfDeadline() {
        String billTypeNumber = (String)this.getModel().getValue(BILL_TYPE_NUMBER_OF_DEADLINE);
        List<ComboItem> endDateList = this.initEndDateList(billTypeNumber);
        ComboEdit endDateComboEdit = (ComboEdit)this.getControl(DATE_FIELD_OF_DEADLINE);
        endDateComboEdit.setComboItems(endDateList);
    }
}

