/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.data.idi.data.IDICondition;
import kd.data.idi.engine.ScriptBuilder;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.util.CompareColumnHelper;
import kd.data.idi.util.FilterGridHelper;
import kd.data.idi.util.IDIStringUtils;

public class IDIConditionEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String CustParamKey_EntityNumber = "entitynumber";
    private static final String CustParamKey_Formula = "formula";
    private static final String CustParamKey_OnlyHeadField = "onlyheadfield";
    private static final String CustParamKey_TreeNodes = "treenodes";
    private static final String CustParamKey_SourceEntityNumber = "sourceentitynumber";
    private static final String CustParamKey_AttachmentField = "attachmentField";
    private static final String CustParamKey_SUPPORTTARGETSELF = "targetSelf";
    private static final String CustParamKey_SUPPORTSUBENTRY = "supportSubEntry";
    private static final String CustomParam_ONLY_ATTACHMENTFILENAME = "onlyAttachmentFileName";
    private static final String Key_FDescription = "fdescription";
    private static final String Key_FExpression = "fexpression";
    private static final String Key_FFilterGrid = "ffiltergrid";
    private static final String Key_FTranExpr = "ftranexpr";
    private static final String Key_TreeView = "tv_fields";
    private static final String Key_btnBackSpace = "backspace";
    private static final String Key_btnCancel = "btncancel";
    private static final String Key_btnClr = "clr";
    private static final String Key_btnFunction = "btnfunction";
    private static final String Key_btnOK = "btnok";
    private static final String IDI_CONDITION_CONFIG = "idi_condition_config";
    private final Map<Integer, Set<String>> acceptCompareType = new HashMap<Integer, Set<String>>();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        this.addClickListeners(new String[]{Key_btnFunction, Key_btnClr, Key_btnBackSpace});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright", "addcondition"});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        HashSet<String> set = new HashSet<String>(18);
        this.acceptCompareType.put(-1, set);
        set.add(CompareTypeEnum.EQUAL.getId());
        set.add(CompareTypeEnum.NOTEQUAL.getId());
        set.add(CompareTypeEnum.ISNULL.getId());
        set.add(CompareTypeEnum.ISNOTNULL.getId());
        set.add(CompareTypeEnum.GREATEROREQUAL.getId());
        set.add(CompareTypeEnum.LESSOREQUAL.getId());
        set.add(CompareTypeEnum.GREATER.getId());
        set.add(CompareTypeEnum.LESS.getId());
        set.add(CompareTypeEnum.LESSTHANOREQUALTODAY.getId());
        set.add(CompareTypeEnum.MORETHANOREQUALTODAY.getId());
        set.add(CompareTypeEnum.ITEMCLASSEQUALS.getId());
        set.add(CompareTypeEnum.ITEMCLASSNOTEQUALS.getId());
        set.add(CompareTypeEnum.ITEMCLASSLIKE.getId());
        set.add(CompareTypeEnum.ITEMCLASSNOTLIKE.getId());
        set.add(CompareTypeEnum.ITEMCLASSIN.getId());
        set.add(CompareTypeEnum.ITEMCLASSNOTIN.getId());
        set.add(CompareTypeEnum.ITEMCLASSISNULL.getId());
        set.add(CompareTypeEnum.ITEMCLASSISNOTNULL.getId());
        set.add(CompareTypeEnum.CHECKBOXEQUAL.getId());
        set.add(CompareTypeEnum.CHECKBOXNOTEQUAL.getId());
        set.add(CompareTypeEnum.LIKE.getId());
        set.add(CompareTypeEnum.NOTLIKE.getId());
        set.add(CompareTypeEnum.IN.getId());
        set.add(CompareTypeEnum.NOTIN.getId());
        set = new HashSet(9);
        this.acceptCompareType.put(5, set);
        set.add(CompareTypeEnum.TODAY.getId());
        set.add(CompareTypeEnum.YESTERDAY.getId());
        set.add(CompareTypeEnum.THISWEEK.getId());
        set.add(CompareTypeEnum.LASTWEEK.getId());
        set.add(CompareTypeEnum.THISMONTH.getId());
        set.add(CompareTypeEnum.LASTMONTH.getId());
        set.add(CompareTypeEnum.TOMORROW.getId());
        set.add(CompareTypeEnum.NEXTWEEK.getId());
        set.add(CompareTypeEnum.NEXTMONTH.getId());
        set = new HashSet(4);
        this.acceptCompareType.put(7, set);
        set.add(CompareTypeEnum.ORGEQUAL.getId());
        set.add("114");
        set.add(CompareTypeEnum.ORGIN.getId());
        set.add("115");
    }

    private void checkFilterColumns(List<Map<String, Object>> cols, String fieldDisplayPrefix) {
        Iterator<Map<String, Object>> colsIterator = cols.iterator();
        while (colsIterator.hasNext()) {
            Map<String, Object> item = colsIterator.next();
            String fieldDisplayName = (String)item.get("fieldCaption");
            fieldDisplayName = fieldDisplayPrefix + fieldDisplayName;
            item.put("fieldCaption", fieldDisplayName);
            Object compareTypes = item.get("compareTypes");
            if (compareTypes instanceof List) {
                List compareTypeList = (List)compareTypes;
                Iterator compareTypesIterator = compareTypeList.iterator();
                while (compareTypesIterator.hasNext()) {
                    Object obj = compareTypesIterator.next();
                    if (obj instanceof CompareTypeDto) {
                        CompareTypeDto compareType = (CompareTypeDto)obj;
                        Set<String> set = this.acceptCompareType.get(compareType.getGroupId());
                        if (set == null) {
                            set = this.acceptCompareType.get(-1);
                        }
                        if (set == null || set.contains(compareType.getId())) continue;
                        compareTypesIterator.remove();
                        continue;
                    }
                    compareTypesIterator.remove();
                }
                if (!compareTypeList.isEmpty()) continue;
                colsIterator.remove();
                continue;
            }
            colsIterator.remove();
        }
    }

    private String getCustParamEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
    }

    private String getCustParamSourceEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_SourceEntityNumber);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        String conditionJson = (String)fsp.getCustomParam(CustParamKey_Formula);
        IDICondition formulaObj = this.deserialize(conditionJson);
        this.setFormulaObj(formulaObj);
        Tab tab = (Tab)this.getControl("tabap_condition");
        String attachmentJson = (String)fsp.getCustomParam(CustParamKey_AttachmentField);
        Object onlyAttachmentFileName = fsp.getCustomParam(CustomParam_ONLY_ATTACHMENTFILENAME);
        if (onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{"tabpageap_condition", "tabpageap_expression"});
            tab.activeTab("attachment_condition");
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(1);
            ComboItem fileNameItem = new ComboItem();
            fileNameItem.setCaption(ResManager.getLocaleString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin"));
            fileNameItem.setValue("filename");
            comboItemList.add(fileNameItem);
            ComboEdit comboEdit = (ComboEdit)this.getControl("fieldname");
            comboEdit.setComboItems(comboItemList);
        } else if (StringUtils.isNotBlank((CharSequence)attachmentJson)) {
            view.setVisible(Boolean.FALSE, new String[]{"tabpageap_condition"});
            tab.activeTab("attachment_condition");
            Map fieldClassifyMap = (Map)JSON.parseObject((String)attachmentJson, (TypeReference)new TypeReference<Map<AITemplate, List<AttachmentField>>>(){}, (Feature[])new Feature[0]);
            if (fieldClassifyMap != null && !fieldClassifyMap.isEmpty()) {
                ArrayList comboItemList = new ArrayList(fieldClassifyMap.size());
                fieldClassifyMap.forEach((templateData, fields) -> {
                    String templatePrefix = IDIStringUtils.templatePrefix((Long)templateData.getId());
                    for (AttachmentField attachmentField : fields) {
                        ComboItem comboItem = new ComboItem();
                        comboItem.setCaption(new LocaleString(attachmentField.getFullDisplayName()));
                        comboItem.setValue(templatePrefix + attachmentField.getFullName());
                        comboItemList.add(comboItem);
                    }
                });
                ComboEdit comboEdit = (ComboEdit)this.getControl("fieldname");
                comboEdit.setComboItems(comboItemList);
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"attachment_condition"});
            tab.activeTab("tabpageap_condition");
            String entityNumber = this.getCustParamEntityNumber();
            String onlyHeadField = (String)fsp.getCustomParam(CustParamKey_OnlyHeadField);
            if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                List cols = this.isSupportSubEntry() ? FilterGridHelper.getAllFilterColumns((MainEntityType)entityType) : FilterGridHelper.getFilterColumns((MainEntityType)entityType, (!StringUtils.isBlank((CharSequence)onlyHeadField) && Boolean.parseBoolean(onlyHeadField) ? 1 : 0) != 0);
                List seqCols = CompareColumnHelper.createEntrySeq((MainEntityType)entityType);
                cols.addAll(seqCols);
                CompareColumnHelper.processPropertyName((String)entityNumber, (List)seqCols);
                String targetSelfStr = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_SUPPORTTARGETSELF);
                boolean targetSelf = Boolean.parseBoolean(targetSelfStr);
                String fieldDisplayPrefix = "";
                if (targetSelf) {
                    String targetMesg = ResManager.loadKDString((String)"\u76ee\u6807\u5355", (String)"IDIDecisionFormPlugin_20", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    fieldDisplayPrefix = targetMesg + "_" + entityType.getDisplayName() + ".";
                }
                this.checkFilterColumns(cols, fieldDisplayPrefix);
                FilterGrid filterGrid = (FilterGrid)this.getControl(Key_FFilterGrid);
                filterGrid.setFilterColumns(cols);
                filterGrid.setEntityNumber(entityNumber);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)fsp.getCustomParam(IDI_CONDITION_CONFIG)))) {
            this.getView().getPageCache().put(IDI_CONDITION_CONFIG, "true");
        }
    }

    public void afterBindData(EventObject e) {
        IDICondition conditionObj;
        FilterCondition filterCondition;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String json = (String)view.getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tabpageap_expression"});
        }
        String conditionJson = (String)view.getFormShowParameter().getCustomParam(CustParamKey_Formula);
        if (StringUtils.isNotEmpty((CharSequence)conditionJson) && (filterCondition = (conditionObj = this.deserialize(conditionJson)).getFilterCondition()) != null) {
            String attachmentJson = (String)view.getFormShowParameter().getCustomParam(CustParamKey_AttachmentField);
            Object onlyAttachmentFileName = view.getFormShowParameter().getCustomParam(CustomParam_ONLY_ATTACHMENTFILENAME);
            if (StringUtils.isNotEmpty((CharSequence)attachmentJson) || onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
                List filterRowList = filterCondition.getFilterRow();
                if (filterRowList != null && !filterRowList.isEmpty()) {
                    model.beginInit();
                    model.batchCreateNewEntryRow("entryentity", filterRowList.size());
                    for (int i = 0; i < filterRowList.size(); ++i) {
                        SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterRowList.get(i);
                        model.setValue("leftbracket", (Object)simpleFilterRow.getLeftBracket(), i);
                        model.setValue("fieldname", (Object)simpleFilterRow.getFieldName(), i);
                        String compareType = simpleFilterRow.getCompareType();
                        model.setValue("comparetype", (Object)compareType, i);
                        if (CompareTypeEnum.ISNULL.getId().equals(compareType) || CompareTypeEnum.ISNOTNULL.getId().equals(compareType)) {
                            view.setEnable(Boolean.FALSE, i, new String[]{"value"});
                        } else {
                            List valueList = simpleFilterRow.getValue();
                            if (valueList != null && !valueList.isEmpty()) {
                                model.setValue("value", ((FilterValue)valueList.get(0)).getValue(), i);
                            }
                        }
                        model.setValue("rightbracket", (Object)simpleFilterRow.getRightBracket(), i);
                        model.setValue("logic", (Object)simpleFilterRow.getLogic(), i);
                    }
                    model.endInit();
                    view.updateView("entryentity");
                }
            } else {
                FilterGrid filterGrid = (FilterGrid)this.getControl(Key_FFilterGrid);
                filterGrid.SetValue(filterCondition);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (Key_btnOK.equalsIgnoreCase(key)) {
            String conditionJson = (String)view.getFormShowParameter().getCustomParam(CustParamKey_Formula);
            IDICondition formulaObj = this.deserialize(conditionJson);
            this.getFormulaObj(formulaObj);
            try {
                this.tranFormula(formulaObj);
            }
            catch (FormulaException exp) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"IDIConditionEdit_0", (String)"data-idi-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
                return;
            }
            catch (Throwable exp) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"IDIConditionEdit_0", (String)"data-idi-formplugin", (Object[])new Object[0]), exp.getMessage()));
                return;
            }
            if ("true".equals(view.getPageCache().get(IDI_CONDITION_CONFIG)) && !ScriptUtils.checkEntryCountByRule((String)this.getCustParamSourceEntityNumber(), (String)this.getCustParamEntityNumber(), (String)formulaObj.getScript())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55/\u5b50\u5206\u5f55\u5b57\u6bb5\u8d85\u8fc7\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u68c0\u67e5\u89c4\u5219\u3002", (String)"IDIDecisionFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            view.returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            view.close();
        } else if (Key_btnCancel.equalsIgnoreCase(key)) {
            view.close();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)Key_btnClr)) {
            model.setValue(Key_FExpression, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)view, (String)Key_FExpression, (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)Key_btnBackSpace)) {
            FormulaEditHelper.backSpaceExpression((IFormView)view, (String)Key_btnBackSpace, (String)Key_FExpression);
        } else if ("addcondition".equals(key)) {
            int newRowIndex = model.createNewEntryRow("entryentity");
            Object onlyAttachmentFileName = view.getFormShowParameter().getCustomParam(CustomParam_ONLY_ATTACHMENTFILENAME);
            if (onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
                model.setValue("fieldname", (Object)"filename", newRowIndex);
                model.setValue("comparetype", (Object)"59", newRowIndex);
            }
        } else {
            this.clickCompareButton(key);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)Key_TreeView, (String)Key_FExpression, (String)e.getNodeId().toString());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String key = e.getProperty().getName();
        if (key.equalsIgnoreCase(Key_FExpression)) {
            String tranExpr;
            String expression = (String)model.getValue(Key_FExpression);
            FormulaEditHelper.setCursorIndex((IFormView)view, (String)Key_FExpression, (int)(StringUtils.isBlank((CharSequence)expression) ? 0 : expression.length()));
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            catch (Throwable exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25", (String)"IDIConditionEdit_1", (String)"data-idi-formplugin", (Object[])new Object[0]);
            }
            model.setValue(Key_FTranExpr, (Object)tranExpr);
        } else if (key.equalsIgnoreCase("comparetype")) {
            boolean notAllowEdit;
            int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
            String newCompareType = String.valueOf(e.getChangeSet()[0].getNewValue());
            boolean bl = notAllowEdit = CompareTypeEnum.ISNULL.getId().equals(newCompareType) || CompareTypeEnum.ISNOTNULL.getId().equals(newCompareType);
            if (notAllowEdit) {
                model.setValue("value", null, currentRowIndex);
            }
            view.setEnable(Boolean.valueOf(!notAllowEdit), currentRowIndex, new String[]{"value"});
        }
    }

    private IDICondition deserialize(String json) {
        IDICondition conditionObj = StringUtils.isEmpty((CharSequence)json) ? new IDICondition() : (IDICondition)SerializationUtils.fromJsonString((String)json, IDICondition.class);
        return conditionObj;
    }

    private void setFormulaObj(IDICondition formulaObj) {
        if (formulaObj == null) {
            return;
        }
        this.getModel().setValue(Key_FExpression, (Object)formulaObj.getExpression());
        this.getModel().setValue(Key_FDescription, (Object)formulaObj.getDescription().toString());
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
    }

    private void getFormulaObj(IDICondition formulaObj) {
        IDataModel model = this.getModel();
        String expression = (String)model.getValue(Key_FExpression);
        formulaObj.setExpression(expression);
        String desc = (String)model.getValue(Key_FDescription);
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
        String attachmentJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_AttachmentField);
        Object onlyAttachmentFileName = this.getView().getFormShowParameter().getCustomParam(CustomParam_ONLY_ATTACHMENTFILENAME);
        if (StringUtils.isNotEmpty((CharSequence)attachmentJson) || onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
            int attachmentFilterCount = model.getEntryRowCount("entryentity");
            ArrayList<SimpleFilterRow> filterRowList = new ArrayList<SimpleFilterRow>(attachmentFilterCount);
            for (int i = 0; i < attachmentFilterCount; ++i) {
                String fieldName = (String)model.getValue("fieldname", i);
                String leftBracket = (String)model.getValue("leftbracket", i);
                String compareType = (String)model.getValue("comparetype", i);
                String value = (String)model.getValue("value", i);
                String rightBracket = (String)model.getValue("rightbracket", i);
                String logic = (String)model.getValue("logic", i);
                ArrayList<FilterValue> valueList = new ArrayList<FilterValue>(1);
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)value);
                valueList.add(filterValue);
                SimpleFilterRow currentFilter = new SimpleFilterRow(leftBracket, compareType, fieldName, rightBracket, logic, valueList);
                filterRowList.add(currentFilter);
            }
            FilterCondition filterCondition = new FilterCondition();
            filterCondition.setFilterRow(filterRowList);
            filterCondition.setForList(false);
            formulaObj.setFilterCondition(filterCondition);
        } else {
            FilterGrid filterGrid = (FilterGrid)this.getControl(Key_FFilterGrid);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            formulaObj.setFilterCondition(filterGridState.getFilterCondition());
        }
    }

    private void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(node);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "==";
                break;
            }
            case "btnnotequal": {
                compareValue = "!=";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "&&";
                break;
            }
            case "btnor": {
                compareValue = "||";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)Key_FExpression, (String)compareValue);
        }
    }

    private void tranFormula(IDICondition formulaObj) {
        FilterCondition filterCondition;
        StringBuilder script = new StringBuilder();
        StringBuilder scriptDesc = new StringBuilder();
        boolean hasExpression = StringUtils.isNotEmpty((CharSequence)formulaObj.getExpression());
        boolean hasFilterCondition = false;
        String entityNumber = this.getCustParamEntityNumber();
        if (StringUtils.isNotEmpty((CharSequence)entityNumber) && (filterCondition = formulaObj.getFilterCondition()) != null && filterCondition.getFilterRow().size() > 0) {
            ScriptBuilder.ValueAndDesc buildScripts;
            String attachmentJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_AttachmentField);
            Object onlyAttachmentFileName = this.getView().getFormShowParameter().getCustomParam(CustomParam_ONLY_ATTACHMENTFILENAME);
            if (StringUtils.isNotEmpty((CharSequence)attachmentJson) || onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
                buildScripts = this.getAttachmentScripts(filterCondition.getFilterRow(), attachmentJson);
            } else {
                String targetSelfStr = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_SUPPORTTARGETSELF);
                boolean targetSelf = Boolean.parseBoolean(targetSelfStr);
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                ScriptBuilder scriptBuilder = new ScriptBuilder(mainType, filterCondition);
                if (targetSelf) {
                    scriptBuilder.setBillPrefix("targetisself_");
                }
                buildScripts = scriptBuilder.buildScript();
            }
            if (StringUtils.isNotEmpty((CharSequence)buildScripts.getValue())) {
                hasFilterCondition = true;
                if (hasExpression) {
                    script.append('(');
                }
                script.append(buildScripts.getValue());
                if (hasExpression) {
                    script.append(')');
                }
                scriptDesc.append(buildScripts.getDesc());
            }
        }
        if (hasExpression) {
            if (hasFilterCondition) {
                script.append(" && (");
                scriptDesc.append(ResManager.loadKDString((String)" \u4e14 ", (String)"IDIConditionEdit_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            script.append(formulaObj.getExpression());
            String tranExpr = this.tranExpression(formulaObj.getExpression());
            scriptDesc.append(tranExpr);
            if (hasFilterCondition) {
                script.append(')');
            }
        }
        formulaObj.setScript(script.toString());
        formulaObj.setExprTran(scriptDesc.toString());
    }

    private String tranExpression(String expression) {
        String[] stringArray;
        String sourceNumber;
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String targetNumber = this.getCustParamEntityNumber();
        if (targetNumber.equals(sourceNumber = this.getCustParamSourceEntityNumber())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = targetNumber;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = targetNumber;
            stringArray = stringArray3;
            stringArray3[1] = sourceNumber;
        }
        Set vars = ScriptFormIdHandler.extractVariables((String)expression, (String[])stringArray);
        if (vars.isEmpty()) {
            return expressionDesc;
        }
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList orderVars = new ArrayList(vars);
        orderVars.sort((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o2.compareTo((String)o1);
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(orderVars.size());
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%d###", i);
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    private ScriptBuilder.ValueAndDesc getAttachmentScripts(List<SimpleFilterRow> filterRow, String attachmentJson) {
        HashMap<String, String> attachmentCompareType = new HashMap<String, String>(6);
        attachmentCompareType.put(CompareTypeEnum.EQUAL.getId(), ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"IDIConditionEdit_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.NOTEQUAL.getId(), ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"IDIConditionEdit_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.LIKE.getId(), ResManager.loadKDString((String)"\u5305\u542b", (String)"IDIConditionEdit_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.NOTLIKE.getId(), ResManager.loadKDString((String)"\u4e0d\u5305\u542b", (String)"IDIConditionEdit_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.ISNULL.getId(), ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"IDIConditionEdit_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.ISNOTNULL.getId(), ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"IDIConditionEdit_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
        HashMap<String, Tuple> attachmentLogic = new HashMap<String, Tuple>(2);
        attachmentLogic.put("0", Tuple.create((Object)"&&", (Object)ResManager.loadKDString((String)"\u4e14", (String)"IDIConditionEdit_9", (String)"data-idi-formplugin", (Object[])new Object[0])));
        attachmentLogic.put("1", Tuple.create((Object)"||", (Object)ResManager.loadKDString((String)"\u6216", (String)"IDIConditionEdit_10", (String)"data-idi-formplugin", (Object[])new Object[0])));
        HashMap<String, String> attachmentFieldAndName = new HashMap<String, String>(16);
        if (attachmentJson != null && !attachmentJson.isEmpty()) {
            Map fieldClassifyMap = (Map)JSON.parseObject((String)attachmentJson, (TypeReference)new TypeReference<Map<AITemplate, List<AttachmentField>>>(){}, (Feature[])new Feature[0]);
            if (fieldClassifyMap != null && !fieldClassifyMap.isEmpty()) {
                fieldClassifyMap.forEach((templateData, fields) -> {
                    String templatePrefix = IDIStringUtils.templatePrefix((Long)templateData.getId());
                    for (AttachmentField attachmentField : fields) {
                        attachmentFieldAndName.put(templatePrefix + attachmentField.getFullName(), new LocaleString(attachmentField.getFullDisplayName()).toString());
                    }
                });
            }
        } else {
            attachmentFieldAndName.put("filename", ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
        StringBuilder leftBracketCount = new StringBuilder();
        StringBuilder rightBracketCount = new StringBuilder();
        StringBuilder valueBuilder = new StringBuilder();
        StringBuilder descBuilder = new StringBuilder();
        for (int i = 0; i < filterRow.size(); ++i) {
            String inputValue;
            SimpleFilterRow simpleFilterRow = filterRow.get(i);
            String fieldName = simpleFilterRow.getFieldName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u7840\u6761\u4ef6\u7b2c%d\u884c\u5b57\u6bb5\u3002", (String)"IDIConditionEdit_11", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
            }
            String compareType = simpleFilterRow.getCompareType();
            List valueList = simpleFilterRow.getValue();
            String string = inputValue = valueList == null || valueList.isEmpty() ? "" : ((FilterValue)valueList.get(0)).getValue().toString();
            if (!CompareTypeEnum.ISNULL.getId().equals(compareType) && !CompareTypeEnum.ISNOTNULL.getId().equals(compareType) && StringUtils.isEmpty((CharSequence)inputValue)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u7840\u6761\u4ef6\u7b2c%d\u884c\u503c\u3002", (String)"IDIConditionEdit_12", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
            }
            String leftBracket = StringUtils.isEmpty((CharSequence)simpleFilterRow.getLeftBracket()) ? "" : simpleFilterRow.getLeftBracket();
            String rightBracket = StringUtils.isEmpty((CharSequence)simpleFilterRow.getRightBracket()) ? "" : simpleFilterRow.getRightBracket();
            String logic = simpleFilterRow.getLogic();
            valueBuilder.append(leftBracket);
            leftBracketCount.append(leftBracket);
            descBuilder.append(leftBracket);
            CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)compareType);
            String fieldNameDesc = (String)attachmentFieldAndName.get(fieldName);
            String compareDesc = (String)attachmentCompareType.get(compareType);
            switch (compareTypeEnum) {
                case LIKE: {
                    valueBuilder.append(fieldName).append(".contains(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case NOTLIKE: {
                    valueBuilder.append("!").append(fieldName).append(".contains(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case EQUAL: {
                    valueBuilder.append(fieldName).append(".equals(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case NOTEQUAL: {
                    valueBuilder.append("!").append(fieldName).append(".equals(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case ISNULL: {
                    valueBuilder.append(String.format("isNull(%s)", fieldName));
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc);
                    break;
                }
                case ISNOTNULL: {
                    valueBuilder.append(String.format("!isNull(%s)", fieldName));
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc);
                }
            }
            valueBuilder.append(rightBracket).append(" ");
            descBuilder.append(rightBracket).append(" ");
            rightBracketCount.append(rightBracket);
            Tuple logicTuple = (Tuple)attachmentLogic.get(logic);
            if (logicTuple == null || i >= filterRow.size() - 1) continue;
            valueBuilder.append((String)logicTuple.item1).append(" ");
            descBuilder.append((String)logicTuple.item2).append(" ");
        }
        if (leftBracketCount.length() != rightBracketCount.length()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ScriptBuilder_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        ScriptBuilder.ValueAndDesc resultScript = new ScriptBuilder.ValueAndDesc();
        resultScript.setValue(valueBuilder.toString());
        resultScript.setDesc(descBuilder.toString());
        return resultScript;
    }

    private boolean isSupportSubEntry() {
        return Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_SUPPORTSUBENTRY));
    }

    protected static void openCondition(String conditionJson, String entityNumber, String actionId, AbstractFormPlugin plugin) {
        Objects.requireNonNull(entityNumber);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("idi_condition_edit");
        showParameter.getCustomParams().put(CustParamKey_Formula, conditionJson);
        showParameter.getCustomParams().put(CustParamKey_EntityNumber, entityNumber);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(showParameter);
    }
}

