/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.GeneralLedger;
import kd.data.idi.data.IDICondition;
import kd.data.idi.util.IDIJSONUtils;

public class IDIGeneralLegalPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String Btn_OK = "btn_ok";
    private static final String CustParamKey_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    private static final String Key_BILL_ACCOUNT = "account";
    private static final String Key_BILL_ACCOUNTVIEW = "accountview";
    private static final String Key_BILL_ASSTACTTYPE = "asstacttype";
    private static final String Key_BILL_BOOKTYPE = "booktype";
    private static final String Key_BILL_ORG = "org";
    private static final String Key_BILL_SRCFIELD = "srcfield";
    private static final String Key_START_CONDITION = "startcondition";
    private static final String Key_START_CONDITION_JSON = "startcondition_json";
    private static final String CustParamKey_FORMULA = "formula";
    private static final String ActionId_SET_START_CONDITION = "setStartCondition";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Btn_OK, Key_START_CONDITION});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountView = (BasedataEdit)this.getControl(Key_BILL_ACCOUNTVIEW);
        if (accountView != null) {
            accountView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String ctlKey;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (ctlKey = ctl.getKey()) {
            case "btn_ok": {
                DynamicObjectCollection accountView = (DynamicObjectCollection)this.getModel().getValue(Key_BILL_ACCOUNTVIEW);
                if (accountView.size() > 10) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u79d1\u76ee\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u3002", (String)"IDIGeneralLegalPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                    return;
                }
                String returnData = this.getReturnData();
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
                break;
            }
            case "startcondition": {
                this.showStartConditionForm();
                break;
            }
        }
    }

    private String getReturnData() {
        GeneralLedger generalLedger = new GeneralLedger();
        DynamicObject bookType = (DynamicObject)this.getModel().getValue(Key_BILL_BOOKTYPE);
        generalLedger.setBookTypeId((Long)bookType.getPkValue());
        DynamicObject account = (DynamicObject)this.getModel().getValue(Key_BILL_ACCOUNT);
        if (account != null) {
            generalLedger.setAccountId((Long)account.getPkValue());
        }
        DynamicObjectCollection accountViews = (DynamicObjectCollection)this.getModel().getValue(Key_BILL_ACCOUNTVIEW);
        generalLedger.setAccountViewIds(accountViews.stream().map(dy -> dy.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        generalLedger.setCurrencyId(Long.valueOf(0L));
        String orgField = (String)this.getModel().getValue(Key_BILL_ORG);
        generalLedger.setOrgField(orgField);
        String srcField = (String)this.getModel().getValue(Key_BILL_SRCFIELD);
        generalLedger.setFieldNumber(srcField);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(Key_BILL_ASSTACTTYPE);
        Long pkValue = (Long)dynamicObject.getPkValue();
        String flexfield = dynamicObject.getString("flexfield");
        generalLedger.setAsstactTypeId(pkValue);
        generalLedger.setAsstactTypeFlexField(flexfield);
        String startConditionJson = (String)this.getModel().getValue(Key_START_CONDITION_JSON);
        if (startConditionJson != null && !startConditionJson.isEmpty()) {
            generalLedger.setStartCondition((IDICondition)IDIJSONUtils.cast((String)startConditionJson, IDICondition.class));
        }
        return IDIJSONUtils.toJsonString((Object)generalLedger);
    }

    public void afterCreateNewData(EventObject e) {
        this.initSrcField();
        this.fillField();
    }

    private void fillField() {
        String detailConfig = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_DETAIL_CONFIG);
        if (StringUtils.isNotEmpty((String)detailConfig)) {
            GeneralLedger generalLedger = (GeneralLedger)IDIJSONUtils.cast((String)detailConfig, GeneralLedger.class);
            this.getModel().setValue(Key_BILL_ORG, (Object)generalLedger.getOrgField());
            this.getModel().setValue(Key_BILL_BOOKTYPE, (Object)generalLedger.getBookTypeId());
            this.getModel().setValue(Key_BILL_ACCOUNT, (Object)generalLedger.getAccountId());
            this.getModel().setValue(Key_BILL_SRCFIELD, (Object)generalLedger.getFieldNumber());
            this.getModel().setValue(Key_BILL_ASSTACTTYPE, (Object)generalLedger.getAsstactTypeId());
            List accountViewIds = generalLedger.getAccountViewIds();
            Object[] ids = !CollectionUtils.isEmpty((Collection)accountViewIds) ? accountViewIds.toArray() : new Object[]{generalLedger.getAccountId()};
            this.getModel().setValue(Key_BILL_ACCOUNTVIEW, (Object)BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bd_accountview"));
            IDICondition startCondition = generalLedger.getStartCondition();
            if (startCondition != null) {
                String exprTran = this.getExprDesc(startCondition);
                this.getModel().setValue(Key_START_CONDITION, (Object)exprTran);
                this.getModel().setValue(Key_START_CONDITION_JSON, (Object)IDIJSONUtils.toJsonString((Object)startCondition));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (Key_BILL_ACCOUNTVIEW.equals(key)) {
            model.setValue(Key_BILL_ACCOUNT, null);
        } else if (Key_BILL_ASSTACTTYPE.equals(key)) {
            model.setValue(Key_BILL_ACCOUNTVIEW, null);
        } else if (Key_START_CONDITION.equals(key) && StringUtils.isEmpty((String)((String)newValue))) {
            model.setValue(Key_START_CONDITION_JSON, null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        if (Key_BILL_ACCOUNTVIEW.equals(fieldKey)) {
            DynamicObject asstactType = (DynamicObject)this.getModel().getValue(Key_BILL_ASSTACTTYPE);
            if (asstactType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"IDIGeneralLegalPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("checkitementry.asstactitem.flexfield", "=", (Object)asstactType.getString("flexfield"));
            listFilterParameter.setFilter(qFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        if (ActionId_SET_START_CONDITION.equals(actionId)) {
            this.receiveStartCondition((String)result);
        }
    }

    private void initSrcField() {
        List<ComboItem> srcFieldItems = this.getSrcFieldItems();
        for (String key : new String[]{Key_BILL_SRCFIELD, Key_BILL_ORG}) {
            ComboEdit combo = (ComboEdit)this.getControl(key);
            combo.setComboItems(srcFieldItems);
        }
    }

    private List<ComboItem> getSrcFieldItems() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        List<ComboItem> currColl = new ArrayList<ComboItem>();
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            for (IDataEntityProperty property : entityType.getAllFields().values()) {
                if (!(property instanceof BasedataProp) || !property.getParent().getName().equals(entityNumber)) continue;
                HashMap<String, String> col = new HashMap<String, String>(10);
                ArrayList<String> parentEntry = new ArrayList<String>(10);
                ArrayList<String> parentCaption = new ArrayList<String>(10);
                parentCaption.add(property.getDisplayName().toString());
                IDataEntityType parent = property.getParent();
                while (!entityNumber.equals(parent.getName())) {
                    parentEntry.add(0, parent.getName());
                    parentCaption.add(0, parent.getDisplayName().toString());
                    if ((parent = parent.getParent()) != null) continue;
                }
                if (CollectionUtils.isEmpty(parentEntry) && parent != null) {
                    parentEntry.add(parent.getName());
                }
                col.put("entryEntity", String.join((CharSequence)".", parentEntry));
                col.put("fieldName", property.getName());
                col.put("fieldCaption", String.join((CharSequence)".", parentCaption));
                cols.add(col);
            }
            currColl = this.createComboItem(entityNumber, cols);
        }
        return currColl;
    }

    private List<ComboItem> createComboItem(String entityNumber, List<Map<String, Object>> listNodes) {
        if (listNodes == null) {
            return null;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(listNodes.size());
        for (Map<String, Object> map : listNodes) {
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(fieldCaption);
            String value = fieldName;
            if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                value = entryEntity + "." + fieldName;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(localeString);
            comboItem.setValue(value);
            list.add(comboItem);
        }
        return list;
    }

    private void showStartConditionForm() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        String conditionJson = (String)this.getModel().getValue(Key_START_CONDITION_JSON);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("idi_condition_edit");
        showParameter.getCustomParams().put(CustParamKey_FORMULA, conditionJson);
        showParameter.getCustomParams().put(CustParamKey_ENTITY_NUMBER, sourceBill);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SET_START_CONDITION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveStartCondition(String result) {
        IDICondition condition;
        if (!StringUtils.isEmpty((String)result) && (condition = (IDICondition)IDIJSONUtils.cast((String)result, IDICondition.class)) != null) {
            String exprTran = this.getExprDesc(condition);
            this.getModel().setValue(Key_START_CONDITION, (Object)exprTran);
            this.getModel().setValue(Key_START_CONDITION_JSON, (Object)result);
        }
    }

    private String getExprDesc(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        String handDesc = condition.getDescription().toString();
        if (StringUtils.isNotEmpty((String)handDesc)) {
            return handDesc;
        }
        return StringUtils.isNotEmpty((String)condition.getExprTran()) ? condition.getExprTran() : condition.getExpression();
    }
}

