/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.Plugin;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.idi.engine.courier.service.CourierParam;
import kd.data.idi.util.IDIJSONUtils;

public class IDILogisticsExampleFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(IDILogisticsExampleFormPlugin.class);
    private static final String KEY_FIELD_BILLTYPE = "billtype";
    private static final String KEY_FIELD_BILLNO = "billno";
    private static final String KEY_FIELD_BILLID = "billid";
    private static final String KEY_FIELD_SCHEMA = "idischema";
    private static final String KEY_FIELD_ENTRY = "entryentity";
    private static final String KEY_FIELD_ORDER = "order";
    private static final String KEY_FIELD_COMPANY = "companynum";
    private static final String KEY_FIELD_COMPANYNAME = "companyname";
    private static final String KEY_FIELD_MOBILE = "mobile";
    private static final String KEY_CONTROL_EXECUTE = "excute";
    private static final String KEY_CONTROL_EXEKEYWORD = "exekeyword";
    private static final String KEY_CONTROL_EXEINVOICE = "exeinvoice";
    private static final String KEY_CONTROL_JF = "jf";
    private static final String CallBackActionId_ObjectId = "objectid";
    private static final String KEY_VERSION = "version";
    private static final String KEY_REFRESHRESULT = "refreshResult";
    private static final String KEY_CREATEINVOICE = "createinvoice";
    private static final String[] keys = new String[]{"unitPrice", "num", "preferentialPolicy", "zeroTaxRateFlag", "taxRate", "unit", "versionNo", "specModel", "detailAmount", "discountType", "goodsCode", "taxAmount", "goodsName", "printingSequenceNo", "trainNum", "invoiceDate"};
    private static final String[] values = new String[]{"299.00", "1.00", "0", "3", "0", " ", " ", " ", " ", " ", " ", " ", " ", "100", "K10", "2021-03-"};
    private static final String KEY_CONTROL_EXESCHEMAPARALLEL = "exeparallelschema";
    private static final String KEY_CONTROL_ORIGINRESULT = "originresult";
    private static final String KEY_CONTROL_PCCONVERT = "pcconvert";
    private static final String KEY_CONTROL_JSCONVERT = "jsconvert";
    private static final String KEY_FIELD_SCHEMARESULTTXT = "schemaresulttxt";
    private static final String KEY_FIELD_SCHEMARESULTTXT_TAG = "schemaresulttxt_tag";
    private static final String KEY_FIELD_PCCONVERTRESULT = "pcconvertresult";
    private static final String KEY_FIELD_PCCONVERTRESULT_TAG = "pcconvertresult_tag";
    private static final String KEY_FIELD_JFHT = "jfht";
    private static final String KEY_FIELD_JFHT_TAG = "jfht";
    private static final String KEY_CONTROL_REGISTPLUGIN = "registplugin";
    private static final String KEY_CONTROL_SSCIDI = "sccidi";
    private static final String KEY_CONTROL_FOREXE = "forexe";
    private static final String KEY_CONTROL_EXEFOR = "exefor";
    private static final String KEY_CONTROL_EXEFOROOM = "exeforoom";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_FIELD_BILLNO, KEY_CONTROL_EXECUTE, KEY_CREATEINVOICE, KEY_CONTROL_EXEKEYWORD, KEY_CONTROL_EXEINVOICE, KEY_CONTROL_EXESCHEMAPARALLEL, KEY_CONTROL_JF, KEY_CONTROL_ORIGINRESULT, KEY_CONTROL_PCCONVERT, KEY_CONTROL_JSCONVERT, KEY_CONTROL_FOREXE, KEY_CONTROL_EXEFOR, KEY_CONTROL_EXEFOROOM, KEY_CONTROL_SSCIDI, KEY_CONTROL_REGISTPLUGIN});
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "billno": {
                this.showBillForm();
                break;
            }
            case "excute": {
                this.executeSchema();
                break;
            }
            case "createinvoice": {
                this.createInvoiceData();
                break;
            }
            case "exekeyword": {
                this.executeKeyWordUpgrade();
                break;
            }
            case "exeinvoice": {
                this.executeInvoiceUpgrade();
                break;
            }
            case "exeparallelschema": {
                this.exeParallelSchema();
                break;
            }
            case "jf": {
                this.exeSchemaResultQuery();
                break;
            }
            case "originresult": {
                this.originalExecuteSchema();
                break;
            }
            case "pcconvert": {
                this.pcDataConvert();
                break;
            }
            case "jsconvert": {
                this.jfDataConvert();
                break;
            }
            case "registplugin": {
                this.registPlugin();
                break;
            }
            case "sccidi": {
                this.sscExecuteSchema();
            }
        }
    }

    private void jfDataConvert() {
        Map jfResult;
        String schemaResult = (String)this.getModel().getValue(KEY_FIELD_SCHEMARESULTTXT_TAG);
        if (StringUtils.isNotEmpty((CharSequence)schemaResult) && (jfResult = (Map)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaResultConvertService", (String)"jfhtDataConvert", (Object[])new Object[]{schemaResult})) != null) {
            this.getModel().setValue("jfht", (Object)"have data");
            this.getModel().setValue("jfht", (Object)IDIJSONUtils.toJsonString((Object)jfResult));
        }
    }

    private void pcDataConvert() {
        String htmlResult;
        String schemaResult = (String)this.getModel().getValue(KEY_FIELD_SCHEMARESULTTXT_TAG);
        if (StringUtils.isNotEmpty((CharSequence)schemaResult) && StringUtils.isNotEmpty((CharSequence)(htmlResult = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaResultConvertService", (String)"pcDataConvert", (Object[])new Object[]{schemaResult})))) {
            this.getModel().setValue(KEY_FIELD_PCCONVERTRESULT, (Object)"have data");
            this.getModel().setValue(KEY_FIELD_PCCONVERTRESULT_TAG, (Object)htmlResult);
        }
    }

    private void sscExecuteSchema() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_FIELD_BILLTYPE);
        Object billId = this.getModel().getValue(KEY_FIELD_BILLID);
        if (objectType == null || billId == null || StringUtils.isEmpty((CharSequence)String.valueOf(billId)) || StringUtils.isEmpty((CharSequence)objectType.getString("number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"IDILogisticsExampleFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)objectType.getString("number"));
        if (billObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"IDILogisticsExampleFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject schemaObj = (DynamicObject)this.getModel().getValue(KEY_FIELD_SCHEMA);
        if (schemaObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"IDILogisticsExampleFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = schemaObj.getString("number");
        ArrayList<String> numberList = new ArrayList<String>(2);
        numberList.add(number);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"executeSchemaNativeByList", (Object[])new Object[]{billObj, numberList});
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.getModel().setValue(KEY_FIELD_SCHEMARESULTTXT, (Object)"have data");
            this.getModel().setValue(KEY_FIELD_SCHEMARESULTTXT_TAG, (Object)result);
        }
    }

    private void originalExecuteSchema() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_FIELD_BILLTYPE);
        Object billId = this.getModel().getValue(KEY_FIELD_BILLID);
        if (objectType == null || billId == null || StringUtils.isEmpty((CharSequence)String.valueOf(billId)) || StringUtils.isEmpty((CharSequence)objectType.getString("number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"IDILogisticsExampleFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)objectType.getString("number"));
        if (billObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"IDILogisticsExampleFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject schemaObj = (DynamicObject)this.getModel().getValue(KEY_FIELD_SCHEMA);
        if (schemaObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"IDILogisticsExampleFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = schemaObj.getString("number");
        String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"originalExecuteSchema", (Object[])new Object[]{billObj, number});
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.getModel().setValue(KEY_FIELD_SCHEMARESULTTXT, (Object)"have data");
            this.getModel().setValue(KEY_FIELD_SCHEMARESULTTXT_TAG, (Object)result);
        }
    }

    private void exeSchemaResultQuery() {
        String billId = (String)this.getModel().getValue(KEY_FIELD_BILLID);
        if (StringUtils.isEmpty((CharSequence)billId)) {
            this.getView().showTipNotification("billid must input");
            return;
        }
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_FIELD_BILLTYPE);
        String entityNumber = null;
        if (objectType != null) {
            entityNumber = objectType.getString("number");
        }
        List result = (List)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaResultQueryService", (String)"querySchemaResultByBill", (Object[])new Object[]{billId, entityNumber});
        this.getView().showMessage(JSONObject.toJSONString((Object)result));
    }

    private void exeParallelSchema() {
        long start = System.currentTimeMillis();
        UpgradeResult result = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaUpgradeParallelService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{"", "", "", ""});
        this.getView().showMessage("cost" + (System.currentTimeMillis() - start) + "ms", result.getLog(), MessageTypes.Default);
    }

    private void executeKeyWordUpgrade() {
        long start = System.currentTimeMillis();
        UpgradeResult result = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaKeyWordUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{"", "", "", ""});
        this.getView().showMessage("cost" + (System.currentTimeMillis() - start) + "ms", result.getLog(), MessageTypes.Default);
    }

    private void executeInvoiceUpgrade() {
        long start = System.currentTimeMillis();
        UpgradeResult result = (UpgradeResult)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaUpgradeInvoiceService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{"", "", "", ""});
        this.getView().showMessage("cost" + (System.currentTimeMillis() - start) + "ms", result.getLog(), MessageTypes.Default);
    }

    private void createInvoiceData() {
        int count = 160000;
        DynamicObject[] datas = new DynamicObject[1000];
        for (int i = 0; i < count; ++i) {
            int subIndex = i % 1000;
            datas[subIndex] = this.createData(i);
            if (i <= 0 || subIndex != datas.length - 1) continue;
            SaveServiceHelper.save((DynamicObject[])datas);
            datas = new DynamicObject[1000];
        }
        DynamicObject repeatData = this.createData(1);
        repeatData.set(KEY_FIELD_BILLID, (Object)"1378852535456047104");
        datas = new DynamicObject[]{repeatData};
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    private DynamicObject createData(int index) {
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"idi_invoice");
        data.set(KEY_FIELD_BILLID, (Object)index);
        data.set("invoicedate", (Object)"2021-03-11");
        data.set("imagenumber", (Object)("FYBX-2021-03-11-" + index));
        data.set("invoicetype", (Object)"9");
        data.set("imagepage", (Object)"0");
        DynamicObjectCollection dataEntry = data.getDynamicObjectCollection("entrykeyvalue");
        for (int k = 0; k < keys.length; ++k) {
            DynamicObject entry = dataEntry.addNew();
            String value = values[k];
            value = "invoiceDate".equals(keys[k]) || "trainNum".equals(keys[k]) ? value + index % 31 : value + index;
            entry.set("invoicekey", (Object)keys[k]);
            entry.set("invoicevalue", (Object)value);
        }
        data.set("entrykeyvalue", (Object)dataEntry);
        return data;
    }

    private void executeSchema() {
        DynamicObject schemaObj;
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_FIELD_BILLTYPE);
        Object billId = this.getModel().getValue(KEY_FIELD_BILLID);
        if (objectType == null || billId == null || StringUtils.isEmpty((CharSequence)String.valueOf(billId)) || StringUtils.isEmpty((CharSequence)objectType.getString("number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"IDILogisticsExampleFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)objectType.getString("number"));
        if (billObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"IDILogisticsExampleFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, CourierParam> courierParam = new HashMap<String, CourierParam>();
        int rowCount = this.getModel().getEntryRowCount(KEY_FIELD_ENTRY);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                String key;
                String order = (String)this.getModel().getValue(KEY_FIELD_ORDER, i);
                String companyNum = (String)this.getModel().getValue(KEY_FIELD_COMPANY, i);
                if (StringUtils.isBlank((CharSequence)order) || StringUtils.isBlank((CharSequence)companyNum) || courierParam.containsKey(key = order + '_' + companyNum)) continue;
                String companyName = (String)this.getModel().getValue(KEY_FIELD_COMPANYNAME, i);
                String mobile = (String)this.getModel().getValue(KEY_FIELD_MOBILE, i);
                CourierParam param = new CourierParam(order, companyNum, companyName, mobile);
                courierParam.put(key, param);
            }
        }
        if ((schemaObj = (DynamicObject)this.getModel().getValue(KEY_FIELD_SCHEMA)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"IDILogisticsExampleFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        if (courierParam.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6d41\u4fe1\u606f\u3002", (String)"IDILogisticsExampleFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = schemaObj.getString("number");
        String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"executeSchemaCourier", (Object[])new Object[]{billObj, number, courierParam});
        CustomControl control = (CustomControl)this.getView().getControl("customcontrolap");
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            try {
                Map map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                if ("success".equalsIgnoreCase((String)map.get("status"))) {
                    map.put(KEY_VERSION, System.nanoTime());
                    control.setData((Object)map);
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
    }

    private void showBillForm() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_FIELD_BILLTYPE);
        if (objectType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"IDILogisticsExampleFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityNumber = (String)objectType.getPkValue();
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CallBackActionId_ObjectId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        if (StringUtils.equalsIgnoreCase((CharSequence)CallBackActionId_ObjectId, (CharSequence)closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            this.getModel().setValue(KEY_FIELD_BILLID, rows.get(0).getPrimaryKeyValue());
            this.getModel().setValue(KEY_FIELD_BILLNO, (Object)rows.get(0).getBillNo());
        }
    }

    public void customEvent(CustomEventArgs e) {
        if (KEY_REFRESHRESULT.equalsIgnoreCase(e.getEventName())) {
            this.executeSchema();
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    private void registPlugin() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("idi_highlighting");
        FormConfig fc = fsp.getFormConfig();
        if (fc == null) {
            fc = new FormConfig();
            fc.setAppId("idi");
            fsp.setFormConfig(fc);
        }
        Plugin plugin = new Plugin();
        plugin.setClassName("kd.bos.ext.data.idi.formplugin.SmartPanelPlugin");
        plugin.setType(0);
        fc.setPlugin(plugin);
        OpenStyle os = fsp.getOpenStyle();
        os.setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }
}

