/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.StatisticsConfig;
import kd.data.idi.util.IDIJSONUtils;

public class IDIStatisticsFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_TARGET_BILL_TYPE = "targetbilltype";
    private static final String KEY_CONDITION = "condition";
    private static final String KEY_CONDITION_JSON = "condition_json";
    private static final String KEY_DIM_FLEX = "dimflex";
    private static final String KEY_DIM_FIELD_TYPE = "dimfieldtype";
    private static final String KEY_PROCESS_CONFIG_FLEX = "processconfigflex";
    private static final String KEY_DIM_PROP_NAME_FLEX = "dimpropnameflex";
    private static final String KEY_DIM_PROP_NAME = "dimpropname";
    private static final String KEY_SHOW_FIELD_FLEX = "showfieldflex";
    private static final String KEY_SHOW_FIELD = "showfield";
    private static final String KEY_RENAME_SHOW_FIELD = "renameshowfield";
    private static final String KEY_DIM_ENTRY_ENTITY_FLEX = "dimentryentityflex";
    private static final String KEY_DIM_ENTRY_ENTITY = "dimentryentity";
    private static final String KEY_METHOD = "method";
    private static final String KEY_PROP_NAME_DIM = "propnamedim";
    private static final String KEY_DISPLAY_NAME_DIM = "displaynamedim";
    private static final String KEY_LAST_TIME_PROP_NAME = "lasttimepropname";
    private static final String KEY_NO_DIM_ENTRY_ENTITY_FLEX = "nodimentryentityflex";
    private static final String KEY_NO_DIM_ENTRY_ENTITY = "nodimentryentity";
    private static final String KEY_PROP_NAME_NO_DIM = "propnamenodim";
    private static final String KEY_DISPLAY_NAME_NO_DIM = "displaynamenodim";
    private static final String KEY_BTN_OK = "btnok";
    private static final String FORM_ID_IDI_STAT_TARGET_CONFIG = "idi_stat_target_config";
    private static final String CustomParamKey_ENTITY_NUMBER = "entitynumber";
    private static final String CustomParamKey_FORMULA = "formula";
    private static final String CustomParamKey_TARGETENTITY_NUMBER = "targetEntityNumber";
    private static final String CustomParamKey_DETAIL_CONFIG = "detailConfig";
    private static final String ACTION_ID_SET_TARGET_CONDITION = "setTargetCondition";
    private static final String KEY_OPERATE_DIMNEWENTRY = "dimnewentry";
    private static final String KEY_OPERATE_DIMCOPYENTRYROW = "dimcopyentryrow";
    private static final String KEY_OPERATE_NODIMNEWENTRY = "nodimnewentry";
    private static final String KEY_OPERATE_NODIMCOPYENTRYROW = "nodimcopyentryrow";
    private static final String CONFIRM_MODIFY_SOURCEBILL = "confirm_modify_sourcebill";
    private static final String STATISTICS_FIELD = "statisticsfield";
    private static final String RENAME_STATISTICS = "renamestatistics";
    private static final String DIMPROP_ENTRY = "dimpropentry";
    private static final String STATISTICS_ENTRY_NUMBER = "statisticsentrynumber";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String detailConfig = (String)formShowParameter.getCustomParam(CustomParamKey_DETAIL_CONFIG);
        if (StringUtils.isNotEmpty((String)detailConfig)) {
            StatisticsConfig statisticsConfig = (StatisticsConfig)IDIJSONUtils.cast((String)detailConfig, StatisticsConfig.class);
            model.setValue(KEY_TARGET_BILL_TYPE, (Object)statisticsConfig.getTargetBillType());
            IDICondition condition = statisticsConfig.getCondition();
            model.setValue(KEY_CONDITION_JSON, (Object)IDIJSONUtils.toJsonString((Object)condition));
            model.setValue(KEY_CONDITION, (Object)(condition.getDescription() != null ? condition.getDescription().getLocaleValue() : ""));
            if (statisticsConfig.getCustomTimes() > 0) {
                model.setValue("customerlast", (Object)String.valueOf(statisticsConfig.getCustomTimes()));
            }
            List processConfigList = statisticsConfig.getProcessConfigList();
            String dimFieldType = statisticsConfig.getDimFieldType() != null ? statisticsConfig.getDimFieldType().getType() : "";
            String dimPropName = statisticsConfig.getDimPropName();
            String dimPropNames = statisticsConfig.getDimPropNameSting(dimPropName);
            String showField = statisticsConfig.getShowField();
            String renameShowField = statisticsConfig.getRenameShowField();
            this.handleStatisticsPageLogic(IDIJSONUtils.toJsonString((Object)condition), processConfigList, dimFieldType, dimPropName, showField, renameShowField, false, dimPropNames, statisticsConfig.getRenameDimPropNames());
        } else {
            view.setVisible(Boolean.FALSE, new String[]{KEY_DIM_FLEX, KEY_PROCESS_CONFIG_FLEX});
        }
        if (this.getModel().getValue(KEY_CONDITION_JSON) != null) {
            this.getPageCache().put(KEY_CONDITION_JSON, (String)this.getModel().getValue(KEY_CONDITION_JSON));
        }
    }

    private void handleStatisticsPageLogic(String conditionJson, List<StatisticsConfig.DataProcessConfig> processConfigList, String dimFieldType, String dimPropName, String showField, String renameShowField, boolean dimPropNameChangeFlag, String dimPropNames, List<String> renameDimProps) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (StringUtils.isEmpty((String)conditionJson) || model.getValue(KEY_TARGET_BILL_TYPE) == null) {
            model.setValue(KEY_CONDITION_JSON, (Object)"");
            model.setValue(KEY_CONDITION, (Object)"");
            view.setVisible(Boolean.FALSE, new String[]{KEY_DIM_FLEX, KEY_PROCESS_CONFIG_FLEX});
            model.setValue(KEY_DIM_FIELD_TYPE, (Object)"");
            model.setValue(KEY_DIM_PROP_NAME, (Object)"");
            model.deleteEntryData(DIMPROP_ENTRY);
            model.setValue(KEY_SHOW_FIELD, (Object)"");
            model.setValue(KEY_RENAME_SHOW_FIELD, (Object)"");
            model.deleteEntryData(KEY_DIM_ENTRY_ENTITY);
            model.deleteEntryData(KEY_NO_DIM_ENTRY_ENTITY);
            return;
        }
        IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
        boolean lastTimeFlag = this.isLastTimes(condition);
        if (lastTimeFlag) {
            model.setValue(KEY_DIM_FIELD_TYPE, (Object)"");
            model.setValue(KEY_DIM_PROP_NAME, (Object)"");
            model.deleteEntryData(DIMPROP_ENTRY);
            model.setValue(KEY_SHOW_FIELD, (Object)"");
            model.setValue(KEY_RENAME_SHOW_FIELD, (Object)"");
            model.deleteEntryData(KEY_DIM_ENTRY_ENTITY);
            view.setVisible(Boolean.FALSE, new String[]{KEY_DIM_FLEX, KEY_DIM_PROP_NAME_FLEX, KEY_SHOW_FIELD_FLEX, KEY_DIM_ENTRY_ENTITY_FLEX});
            view.setVisible(Boolean.TRUE, new String[]{KEY_PROCESS_CONFIG_FLEX, KEY_NO_DIM_ENTRY_ENTITY_FLEX});
            model.deleteEntryData(KEY_NO_DIM_ENTRY_ENTITY);
            if (processConfigList != null && !processConfigList.isEmpty()) {
                AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
                abstractModel.beginInit();
                TableValueSetter tvs = new TableValueSetter(new String[0]);
                tvs.addField(KEY_PROP_NAME_NO_DIM, new Object[0]);
                tvs.addField(KEY_DISPLAY_NAME_NO_DIM, new Object[0]);
                for (StatisticsConfig.DataProcessConfig processConfig : processConfigList) {
                    tvs.addRow(new Object[]{processConfig.getPropName(), processConfig.getDisplayName()});
                }
                abstractModel.batchCreateNewEntryRow(KEY_NO_DIM_ENTRY_ENTITY, tvs);
                abstractModel.endInit();
                this.getView().updateView(KEY_NO_DIM_ENTRY_ENTITY);
            } else {
                model.createNewEntryRow(KEY_NO_DIM_ENTRY_ENTITY);
                model.createNewEntryRow(KEY_NO_DIM_ENTRY_ENTITY);
            }
            this.initPropNameComb(IDIJSONUtils.toJsonString((Object)condition));
        } else {
            model.deleteEntryData(KEY_NO_DIM_ENTRY_ENTITY);
            view.setVisible(Boolean.FALSE, new String[]{KEY_NO_DIM_ENTRY_ENTITY_FLEX});
            view.setVisible(Boolean.TRUE, new String[]{KEY_DIM_FLEX});
            model.setValue(KEY_DIM_FIELD_TYPE, (Object)dimFieldType);
            if (StringUtils.isNotEmpty((String)dimFieldType)) {
                TableValueSetter tvs;
                AbstractFormDataModel abstractModel;
                view.setVisible(Boolean.TRUE, new String[]{KEY_PROCESS_CONFIG_FLEX});
                if (StatisticsConfig.DimFieldType.HEADER.getType().equalsIgnoreCase(dimFieldType)) {
                    view.setVisible(Boolean.TRUE, new String[]{KEY_DIM_ENTRY_ENTITY_FLEX});
                    model.setValue(KEY_DIM_PROP_NAME, (Object)"");
                    model.deleteEntryData(DIMPROP_ENTRY);
                    model.setValue(KEY_SHOW_FIELD, (Object)"");
                    model.setValue(KEY_RENAME_SHOW_FIELD, (Object)"");
                    view.setVisible(Boolean.FALSE, new String[]{KEY_DIM_PROP_NAME_FLEX, KEY_SHOW_FIELD_FLEX, KEY_LAST_TIME_PROP_NAME});
                    model.deleteEntryData(KEY_DIM_ENTRY_ENTITY);
                    if (processConfigList != null && !processConfigList.isEmpty()) {
                        abstractModel = (AbstractFormDataModel)model;
                        abstractModel.beginInit();
                        tvs = new TableValueSetter(new String[0]);
                        tvs.addField(KEY_METHOD, new Object[0]);
                        tvs.addField(KEY_PROP_NAME_DIM, new Object[0]);
                        tvs.addField(KEY_DISPLAY_NAME_DIM, new Object[0]);
                        for (StatisticsConfig.DataProcessConfig processConfig : processConfigList) {
                            tvs.addRow(new Object[]{processConfig.getMethod(), processConfig.getPropName(), processConfig.getDisplayName()});
                        }
                        abstractModel.batchCreateNewEntryRow(KEY_DIM_ENTRY_ENTITY, tvs);
                        abstractModel.endInit();
                        this.getView().updateView(KEY_DIM_ENTRY_ENTITY);
                    } else {
                        model.createNewEntryRow(KEY_DIM_ENTRY_ENTITY);
                        model.createNewEntryRow(KEY_DIM_ENTRY_ENTITY);
                    }
                    this.initMethodComb(StatisticsConfig.DimFieldType.HEADER);
                    this.initPropNameComb(IDIJSONUtils.toJsonString((Object)condition));
                } else {
                    if (!dimPropNameChangeFlag) {
                        view.setVisible(Boolean.TRUE, new String[]{KEY_DIM_PROP_NAME_FLEX, KEY_SHOW_FIELD_FLEX});
                        this.initDimPropNameCombo();
                        this.initShowField(dimPropNames);
                        model.setValue(KEY_DIM_PROP_NAME, (Object)dimPropName);
                        model.setValue(KEY_SHOW_FIELD, (Object)showField);
                        model.setValue(KEY_RENAME_SHOW_FIELD, (Object)renameShowField);
                        this.initMethodComb(StatisticsConfig.DimFieldType.ENTRY);
                        this.initTimePropComb(IDIJSONUtils.toJsonString((Object)condition));
                    }
                    model.deleteEntryData(KEY_DIM_ENTRY_ENTITY);
                    if (StringUtils.isNotEmpty((String)dimPropNames)) {
                        if (renameDimProps == null) {
                            renameDimProps = Collections.emptyList();
                        }
                        view.setVisible(Boolean.TRUE, new String[]{KEY_DIM_ENTRY_ENTITY_FLEX, KEY_LAST_TIME_PROP_NAME});
                        if (processConfigList != null && !processConfigList.isEmpty()) {
                            abstractModel = (AbstractFormDataModel)model;
                            abstractModel.beginInit();
                            tvs = new TableValueSetter(new String[0]);
                            tvs.addField(KEY_METHOD, new Object[0]);
                            tvs.addField(KEY_PROP_NAME_DIM, new Object[0]);
                            tvs.addField(KEY_DISPLAY_NAME_DIM, new Object[0]);
                            tvs.addField(KEY_LAST_TIME_PROP_NAME, new Object[0]);
                            for (StatisticsConfig.DataProcessConfig processConfig : processConfigList) {
                                tvs.addRow(new Object[]{processConfig.getMethod(), processConfig.getPropName(), processConfig.getDisplayName(), processConfig.getLastTimePropName()});
                            }
                            abstractModel.batchCreateNewEntryRow(KEY_DIM_ENTRY_ENTITY, tvs);
                            List<String> mulDimPropList = this.getMulDimPropList(dimPropNames);
                            if (!mulDimPropList.isEmpty()) {
                                TableValueSetter dimTvs = new TableValueSetter(new String[0]);
                                dimTvs.addField(STATISTICS_FIELD, new Object[0]);
                                dimTvs.addField(RENAME_STATISTICS, new Object[0]);
                                for (int i = 0; i < mulDimPropList.size(); ++i) {
                                    String rename = i < renameDimProps.size() ? renameDimProps.get(i) : "";
                                    dimTvs.addRow(new Object[]{mulDimPropList.get(i), rename});
                                    this.updateStatisticsField(mulDimPropList.get(i));
                                }
                                abstractModel.batchCreateNewEntryRow(DIMPROP_ENTRY, dimTvs);
                            }
                            abstractModel.endInit();
                            this.getView().updateView(KEY_DIM_ENTRY_ENTITY);
                        } else {
                            model.createNewEntryRow(KEY_DIM_ENTRY_ENTITY);
                            model.createNewEntryRow(KEY_DIM_ENTRY_ENTITY);
                        }
                        this.initPropNameComb(IDIJSONUtils.toJsonString((Object)condition));
                    } else {
                        view.setVisible(Boolean.FALSE, new String[]{KEY_DIM_ENTRY_ENTITY_FLEX});
                    }
                }
                if (processConfigList != null && !processConfigList.isEmpty()) {
                    for (int rowIndex = 0; rowIndex < processConfigList.size(); ++rowIndex) {
                        StatisticsConfig.DataProcessConfig processConfig = processConfigList.get(rowIndex);
                        this.methodChange(processConfig.getMethod() != null ? processConfig.getMethod().getType() : "", rowIndex);
                    }
                }
            } else {
                model.setValue(KEY_DIM_PROP_NAME, (Object)"");
                model.deleteEntryData(DIMPROP_ENTRY);
                model.setValue(KEY_SHOW_FIELD, (Object)"");
                model.setValue(KEY_RENAME_SHOW_FIELD, (Object)"");
                model.deleteEntryData(KEY_DIM_ENTRY_ENTITY);
                view.setVisible(Boolean.FALSE, new String[]{KEY_DIM_PROP_NAME_FLEX, KEY_SHOW_FIELD_FLEX, KEY_DIM_ENTRY_ENTITY_FLEX});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_CONDITION, KEY_BTN_OK});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "condition": {
                this.showConditionForm();
                break;
            }
            case "btnok": {
                if (!this.validate()) break;
                String result = this.save();
                this.getView().returnDataToParent((Object)result);
                this.getView().close();
                break;
            }
        }
    }

    private boolean validate() {
        IDataModel model = this.getModel();
        Object targetBill = model.getValue(KEY_TARGET_BILL_TYPE);
        String targetCondition = (String)model.getValue(KEY_CONDITION);
        String targetConditionJson = (String)model.getValue(KEY_CONDITION_JSON);
        StringBuilder notifyMessage = new StringBuilder();
        if (targetBill == null) {
            notifyMessage.append(ResManager.loadKDString((String)"\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d", (String)"IDIStatisticsFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)targetCondition) || StringUtils.isEmpty((String)targetConditionJson)) {
            if (notifyMessage.length() > 0) {
                notifyMessage.append('\uff0c');
            }
            notifyMessage.append(ResManager.loadKDString((String)"\u201c\u76ee\u6807\u5355\u8fc7\u6ee4\u6761\u4ef6\u201d", (String)"IDIStatisticsFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
        if (notifyMessage.length() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165%s\u3002", (String)"IDIStatisticsFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]), notifyMessage.toString()));
            return false;
        }
        String renameShowField = (String)model.getValue(KEY_RENAME_SHOW_FIELD);
        String showField = (String)model.getValue(KEY_SHOW_FIELD);
        if (StringUtils.isNotEmpty((String)renameShowField) && StringUtils.isEmpty((String)showField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c55\u793a\u5b57\u6bb5\u6216\u6e05\u7a7a\u91cd\u547d\u540d\u5c55\u793a\u5b57\u6bb5\u7684\u5185\u5bb9\u3002", (String)"IDIStatisticsFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Integer> deleteList = new ArrayList<Integer>();
        if (this.isLastTimes((IDICondition)IDIJSONUtils.cast((String)targetConditionJson, IDICondition.class))) {
            int rowCount = model.getEntryRowCount(KEY_NO_DIM_ENTRY_ENTITY);
            for (int i = 0; i < rowCount; ++i) {
                String propName = (String)model.getValue(KEY_PROP_NAME_NO_DIM, i);
                if (!StringUtils.isEmpty((String)propName)) continue;
                deleteList.add(i);
            }
            int[] deleteArr = new int[deleteList.size()];
            for (int i = 0; i < deleteArr.length; ++i) {
                deleteArr[i] = (Integer)deleteList.get(i);
            }
            model.deleteEntryRows(KEY_NO_DIM_ENTRY_ENTITY, deleteArr);
            rowCount = this.getModel().getEntryRowCount(KEY_NO_DIM_ENTRY_ENTITY);
            if (rowCount > 5 && this.isLastThreeTimes()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u8fc7\u6ee4\u4e3a\u201c\u6700\u8fd1\u4e09\u6b21\u201d\u65f6\uff0c\u201c\u6570\u636e\u5904\u7406\u201d\u6700\u591a\u589e\u52a05\u884c\u3002", (String)"IDIStatisticsFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (rowCount == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5c55\u793a\u5b57\u6bb5\u201d\u4fe1\u606f\u3002", (String)"IDIStatisticsFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            String dimFieldType = (String)this.getModel().getValue(KEY_DIM_FIELD_TYPE);
            if (StringUtils.isEmpty((String)dimFieldType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b57\u6bb5\u7c7b\u578b\u201d\u3002", (String)"IDIStatisticsFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            int rowCount = model.getEntryRowCount(KEY_DIM_ENTRY_ENTITY);
            for (int i = 0; i < rowCount; ++i) {
                String method = (String)model.getValue(KEY_METHOD, i);
                String propName = (String)model.getValue(KEY_PROP_NAME_DIM, i);
                String displayNameDim = (String)model.getValue(KEY_DISPLAY_NAME_DIM, i);
                if (StringUtils.isEmpty((String)method) && StringUtils.isEmpty((String)propName)) {
                    deleteList.add(i);
                    continue;
                }
                if (StringUtils.isEmpty((String)method)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIStatisticsFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u201c\u5904\u7406\u65b9\u5f0f\u201d", (String)"IDIStatisticsFormPlugin_13", (String)"data-idi-formplugin", (Object[])new Object[0])));
                    return false;
                }
                if (!StatisticsConfig.MethodType.COUNT.getType().equalsIgnoreCase(method) && StringUtils.isEmpty((String)propName)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIStatisticsFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u201c\u5904\u7406\u5b57\u6bb5\u201d", (String)"IDIStatisticsFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0])));
                    return false;
                }
                if (StringUtils.isEmpty((String)displayNameDim)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIStatisticsFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u201c\u5904\u7406\u7ed3\u679c\u547d\u540d\u201d", (String)"IDIStatisticsFormPlugin_15", (String)"data-idi-formplugin", (Object[])new Object[0])));
                    return false;
                }
                String lastTimePropName = (String)model.getValue(KEY_LAST_TIME_PROP_NAME, i);
                if (!StatisticsConfig.MethodType.LAST.getType().equalsIgnoreCase(method) || !StringUtils.isEmpty((String)lastTimePropName)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IDIStatisticsFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u201c\u65e5\u671f\u5b57\u6bb5\u201d", (String)"IDIStatisticsFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0])));
                return false;
            }
            if (!this.judgeCountAndEntry()) {
                return false;
            }
            int[] deleteArr = new int[deleteList.size()];
            for (int i = 0; i < deleteArr.length; ++i) {
                deleteArr[i] = (Integer)deleteList.get(i);
            }
            model.deleteEntryRows(KEY_DIM_ENTRY_ENTITY, deleteArr);
            rowCount = model.getEntryRowCount(KEY_DIM_ENTRY_ENTITY);
            if (StatisticsConfig.DimFieldType.ENTRY.getType().equalsIgnoreCase(dimFieldType) && rowCount > 4) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u4e3a\u201c\u5206\u5f55\u5b57\u6bb5\u201d\u65f6\uff0c\u201c\u6570\u636e\u5904\u7406\u201d\u6700\u591a\u589e\u52a04\u884c\u3002", (String)"IDIStatisticsFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (rowCount == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5904\u7406\u65b9\u5f0f\u201d\u548c\u201c\u5904\u7406\u5b57\u6bb5\u201d\u3002", (String)"IDIStatisticsFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private String save() {
        DynamicObjectCollection collection;
        IDataModel model = this.getModel();
        StatisticsConfig statisticsConfig = new StatisticsConfig();
        statisticsConfig.setTargetBillType((String)((DynamicObject)model.getValue(KEY_TARGET_BILL_TYPE)).getPkValue());
        String conditionJson = (String)model.getValue(KEY_CONDITION_JSON);
        statisticsConfig.setCondition((IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class));
        statisticsConfig.setDimFieldType(StatisticsConfig.DimFieldType.convert((String)((String)model.getValue(KEY_DIM_FIELD_TYPE))));
        statisticsConfig.setDimPropName((String)model.getValue(KEY_DIM_PROP_NAME));
        statisticsConfig.setShowField((String)model.getValue(KEY_SHOW_FIELD));
        statisticsConfig.setRenameShowField((String)model.getValue(KEY_RENAME_SHOW_FIELD));
        ArrayList<StatisticsConfig.DataProcessConfig> processConfigList = new ArrayList<StatisticsConfig.DataProcessConfig>();
        if (this.isLastTimes((IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class))) {
            collection = model.getEntryEntity(KEY_NO_DIM_ENTRY_ENTITY);
            for (DynamicObject dynamicObject : collection) {
                StatisticsConfig.DataProcessConfig dataProcessConfig = new StatisticsConfig.DataProcessConfig();
                dataProcessConfig.setMethod(StatisticsConfig.MethodType.DISPLAY);
                dataProcessConfig.setPropName(dynamicObject.getString(KEY_PROP_NAME_NO_DIM));
                dataProcessConfig.setDisplayName(dynamicObject.getString(KEY_DISPLAY_NAME_NO_DIM));
                processConfigList.add(dataProcessConfig);
            }
        } else {
            collection = model.getEntryEntity(KEY_DIM_ENTRY_ENTITY);
            for (DynamicObject dynamicObject : collection) {
                StatisticsConfig.DataProcessConfig dataProcessConfig = new StatisticsConfig.DataProcessConfig();
                dataProcessConfig.setMethod(StatisticsConfig.MethodType.convert((String)dynamicObject.getString(KEY_METHOD)));
                dataProcessConfig.setPropName(dynamicObject.getString(KEY_PROP_NAME_DIM));
                dataProcessConfig.setDisplayName(dynamicObject.getString(KEY_DISPLAY_NAME_DIM));
                dataProcessConfig.setLastTimePropName(dynamicObject.getString(KEY_LAST_TIME_PROP_NAME));
                processConfigList.add(dataProcessConfig);
            }
            DynamicObjectCollection dimPropCollection = model.getEntryEntity(DIMPROP_ENTRY);
            ArrayList<String> dimPropNames = new ArrayList<String>(4);
            ArrayList<String> reNameDimPropNames = new ArrayList<String>(4);
            for (DynamicObject obj : dimPropCollection) {
                if (!StringUtils.isNotEmpty((String)obj.getString(STATISTICS_FIELD))) continue;
                dimPropNames.add(obj.getString(STATISTICS_FIELD));
                reNameDimPropNames.add(obj.getString(RENAME_STATISTICS));
            }
            statisticsConfig.setDimPropNames(dimPropNames);
            statisticsConfig.setRenameDimPropNames(reNameDimPropNames);
        }
        statisticsConfig.setProcessConfigList(processConfigList);
        String customLastStr = (String)this.getModel().getValue("customerlast");
        if (StringUtils.isNotEmpty((String)customLastStr)) {
            statisticsConfig.setCustomTimes(Integer.parseInt(customLastStr));
        }
        return IDIJSONUtils.toJsonString((Object)statisticsConfig);
    }

    private void showConditionForm() {
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue(KEY_TARGET_BILL_TYPE);
        if (targetBill == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d\u3002", (String)"IDIStatisticsFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceBill = this.getSourceEntityNumber();
        Objects.requireNonNull(sourceBill);
        String conditionJson = (String)this.getModel().getValue(KEY_CONDITION_JSON);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_IDI_STAT_TARGET_CONFIG);
        showParameter.setCaption(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u8fc7\u6ee4\u6761\u4ef6", (String)"IDIStatisticsFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]));
        showParameter.getCustomParams().put(CustomParamKey_FORMULA, conditionJson);
        showParameter.getCustomParams().put(CustomParamKey_ENTITY_NUMBER, sourceBill);
        showParameter.getCustomParams().put(CustomParamKey_TARGETENTITY_NUMBER, targetBill.getPkValue());
        showParameter.getCustomParams().put("customValue", this.getModel().getValue("customerlast"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_ID_SET_TARGET_CONDITION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        if (ACTION_ID_SET_TARGET_CONDITION.equals(actionId)) {
            this.receiveStatisticsTargetConfig((Map)result);
        }
    }

    private void receiveStatisticsTargetConfig(Map<String, String> result) {
        if (result != null) {
            String conditionStr = result.get(CustomParamKey_FORMULA);
            if (StringUtils.isNotEmpty((String)conditionStr)) {
                IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionStr, IDICondition.class);
                this.getModel().setValue(KEY_CONDITION_JSON, (Object)conditionStr);
                this.getModel().setValue(KEY_CONDITION, (Object)(condition.getDescription() != null ? condition.getDescription().getLocaleValue() : ""));
            }
            String customLastStr = result.get("customValue");
            this.getModel().setValue("customerlast", (Object)customLastStr);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int entryRowCount;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ((KEY_OPERATE_DIMNEWENTRY.equalsIgnoreCase(operateKey) || KEY_OPERATE_DIMCOPYENTRYROW.equalsIgnoreCase(operateKey)) && StatisticsConfig.DimFieldType.ENTRY.getType().equalsIgnoreCase((String)this.getModel().getValue(KEY_DIM_FIELD_TYPE))) {
            int count = this.getModel().getEntryRowCount(KEY_DIM_ENTRY_ENTITY);
            if (count >= 4) {
                args.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u4e3a\u201c\u5206\u5f55\u5b57\u6bb5\u201d\u65f6\uff0c\u201c\u6570\u636e\u5904\u7406\u201d\u6700\u591a\u589e\u52a04\u884c\u3002", (String)"IDIStatisticsFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        } else if ((KEY_OPERATE_NODIMNEWENTRY.equalsIgnoreCase(operateKey) || KEY_OPERATE_NODIMCOPYENTRYROW.equalsIgnoreCase(operateKey)) && this.isLastThreeTimes()) {
            int count = this.getModel().getEntryRowCount(KEY_NO_DIM_ENTRY_ENTITY);
            if (count >= 5) {
                args.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u8fc7\u6ee4\u4e3a\u201c\u6700\u8fd1\u4e09\u6b21\u201d\u65f6\uff0c\u201c\u6570\u636e\u5904\u7406\u201d\u6700\u591a\u589e\u52a05\u884c\u3002", (String)"IDIStatisticsFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        } else if ("newentry_sta".equals(operateKey) && (entryRowCount = this.getModel().getEntryRowCount(DIMPROP_ENTRY)) == 3) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u5141\u8bb8\u65b0\u589e3\u884c\u7edf\u8ba1\u5b57\u6bb5\u3002", (String)"IDIStatisticsFormPlugin_21", (String)"data-idi-formplugin", (Object[])new Object[0]));
            args.cancel = true;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("deleteentry_sta")) {
            int entryRowCount = model.getEntryRowCount(DIMPROP_ENTRY);
            boolean reset = true;
            for (int i = 0; i < entryRowCount; ++i) {
                if (model.getValue(STATISTICS_FIELD, i) == null || !StringUtils.isNotEmpty((String)model.getValue(STATISTICS_FIELD, i).toString())) continue;
                reset = false;
                break;
            }
            if (reset) {
                this.updateStatisticsField(null);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        if (CONFIRM_MODIFY_SOURCEBILL.equalsIgnoreCase(actionId)) {
            if (MessageBoxResult.No == messageBoxResult) {
                String oldNumber = messageBoxClosedEvent.getCustomVaule();
                this.getPageCache().put("mark", "-1");
                this.getModel().setValue(KEY_TARGET_BILL_TYPE, (Object)oldNumber);
            } else if (MessageBoxResult.Yes == messageBoxResult) {
                this.basicPropertyChanged(KEY_TARGET_BILL_TYPE, null);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        IDataModel model = this.getModel();
        switch (propertyName) {
            case "targetbilltype": {
                String mark = this.getPageCache().get("mark");
                if (StringUtils.isEmpty((String)mark)) {
                    if (oldValue != null) {
                        DynamicObject oldBill = (DynamicObject)oldValue;
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u76ee\u6807\u5355\u7c7b\u578b\u540e\uff0c\u68c0\u67e5\u9879\u7684\u914d\u7f6e\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\u3002\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"IDIStatisticsFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_MODIFY_SOURCEBILL, (IFormPlugin)this), null, (String)oldBill.get("number"));
                        break;
                    }
                    if (newValue == null) break;
                    this.basicPropertyChanged(propertyName, null);
                    break;
                }
                if (!"-1".equals(this.getPageCache().get("mark"))) break;
                this.getPageCache().remove("mark");
                break;
            }
            case "condition": {
                if (StringUtils.isEmpty((String)((String)oldValue)) || StringUtils.isEmpty((String)((String)newValue))) {
                    this.basicPropertyChanged(propertyName, (String)newValue);
                } else {
                    IDICondition oldCondition = (IDICondition)IDIJSONUtils.cast((String)this.getPageCache().get(KEY_CONDITION_JSON), IDICondition.class);
                    IDICondition newCondition = (IDICondition)IDIJSONUtils.cast((String)((String)this.getModel().getValue(KEY_CONDITION_JSON)), IDICondition.class);
                    if (this.isLastTimes(oldCondition) != this.isLastTimes(newCondition)) {
                        this.basicPropertyChanged(propertyName, (String)newValue);
                    } else {
                        this.initTimePropComb((String)this.getModel().getValue(KEY_CONDITION_JSON));
                    }
                }
                this.getPageCache().put(KEY_CONDITION_JSON, (String)this.getModel().getValue(KEY_CONDITION_JSON));
                break;
            }
            case "dimfieldtype": {
                ComboEdit showFieldCombo = (ComboEdit)this.getControl(KEY_SHOW_FIELD);
                showFieldCombo.setComboItems(Collections.emptyList());
                this.dimFieldTypeChanged((String)newValue);
                break;
            }
            case "dimpropname": {
                this.dimPropNameChanged((String)newValue);
                this.initShowField((String)newValue);
                break;
            }
            case "showfield": {
                this.getModel().setValue(KEY_RENAME_SHOW_FIELD, (Object)"");
                break;
            }
            case "method": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.methodChange((String)newValue, rowIndex);
                break;
            }
            case "statisticsfield": {
                int entryRowCount = model.getEntryRowCount(DIMPROP_ENTRY);
                int changIndex = changeData.getRowIndex();
                if (newValue != null && StringUtils.isNotEmpty((String)newValue.toString())) {
                    String fieldNumber = newValue.toString();
                    this.updateStatisticsField(fieldNumber);
                    for (int i = 0; i < entryRowCount; ++i) {
                        if (i == changIndex || !newValue.toString().equals(model.getValue(STATISTICS_FIELD, i))) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6709\u91cd\u590d\u7684\u7edf\u8ba1\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IDIStatisticsFormPlugin_22", (String)"data-idi-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                } else {
                    boolean reset = true;
                    for (int i = 0; i < entryRowCount; ++i) {
                        if (i == changIndex || model.getValue(STATISTICS_FIELD, i) == null || !StringUtils.isNotEmpty((String)model.getValue(STATISTICS_FIELD, i).toString())) continue;
                        reset = false;
                        break;
                    }
                    if (reset) {
                        this.updateStatisticsField(null);
                    }
                }
                String dimPropStatistics = this.getDimPropStatistics();
                this.dimPropNamesChanged(dimPropStatistics);
                this.initShowField(dimPropStatistics);
                break;
            }
        }
    }

    private void methodChange(String methodType, int rowIndex) {
        if (StatisticsConfig.MethodType.LAST.getType().equalsIgnoreCase(methodType)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{KEY_LAST_TIME_PROP_NAME});
        } else {
            this.getModel().setValue(KEY_LAST_TIME_PROP_NAME, (Object)"", rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{KEY_LAST_TIME_PROP_NAME});
        }
        if (StatisticsConfig.MethodType.COUNT.getType().equalsIgnoreCase(methodType)) {
            this.getModel().setValue(KEY_PROP_NAME_DIM, (Object)"", rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{KEY_PROP_NAME_DIM});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{KEY_PROP_NAME_DIM});
        }
    }

    private void basicPropertyChanged(String key, String newValue) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (KEY_TARGET_BILL_TYPE.equalsIgnoreCase(key)) {
            model.setValue(KEY_CONDITION_JSON, (Object)"");
            model.setValue(KEY_CONDITION, (Object)"");
            model.setValue("customerlast", (Object)"");
            return;
        }
        view.setVisible(Boolean.FALSE, new String[]{KEY_DIM_FLEX, KEY_PROCESS_CONFIG_FLEX});
        String conditionJson = "";
        if (StringUtils.isNotEmpty((String)newValue)) {
            conditionJson = (String)model.getValue(KEY_CONDITION_JSON);
        }
        this.handleStatisticsPageLogic(conditionJson, null, null, null, null, null, false, null, null);
    }

    private void dimFieldTypeChanged(String newValue) {
        if (StringUtils.isNotEmpty((String)newValue)) {
            String conditionJson = (String)this.getModel().getValue(KEY_CONDITION_JSON);
            this.handleStatisticsPageLogic(conditionJson, null, newValue, null, null, null, false, null, null);
            if (StatisticsConfig.DimFieldType.ENTRY.getType().equalsIgnoreCase(newValue)) {
                this.getModel().createNewEntryRow(DIMPROP_ENTRY);
                this.getModel().createNewEntryRow(DIMPROP_ENTRY);
            }
        }
    }

    private void dimPropNameChanged(String newValue) {
        if (StringUtils.isNotEmpty((String)newValue)) {
            String conditionJson = (String)this.getModel().getValue(KEY_CONDITION_JSON);
            String dimFieldType = (String)this.getModel().getValue(KEY_DIM_FIELD_TYPE);
            this.handleStatisticsPageLogic(conditionJson, null, dimFieldType, newValue, null, null, true, null, null);
        }
    }

    private void dimPropNamesChanged(String newValue) {
        if (StringUtils.isNotEmpty((String)newValue)) {
            List<String> mulDimPropList = this.getMulDimPropList(newValue);
            String conditionJson = (String)this.getModel().getValue(KEY_CONDITION_JSON);
            String dimFieldType = (String)this.getModel().getValue(KEY_DIM_FIELD_TYPE);
            this.handleStatisticsPageLogic(conditionJson, null, dimFieldType, mulDimPropList.get(0), null, null, true, newValue, null);
        }
    }

    private void initDimPropNameCombo() {
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue(KEY_TARGET_BILL_TYPE);
        String targetBillPkValue = (String)targetBill.getPkValue();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetBillPkValue);
        EntityTypeUtil helper = new EntityTypeUtil();
        List filterFields = helper.getFilterFields((IDataEntityType)entityType, false);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_DIM_PROP_NAME);
        ComboEdit statistics = (ComboEdit)this.getControl(STATISTICS_FIELD);
        for (FilterField filterField : filterFields) {
            if (filterField.getEntityKey().equalsIgnoreCase(targetBillPkValue) || filterField.getSrcFieldProp().getParent() instanceof SubEntryType) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(filterField.getCaption());
            comboItem.setValue(filterField.getFullFieldName());
            comboItemList.add(comboItem);
        }
        comboEdit.setComboItems(comboItemList);
        statistics.setComboItems(comboItemList);
        this.getPageCache().remove(STATISTICS_ENTRY_NUMBER);
    }

    private void initMethodComb(StatisticsConfig.DimFieldType dimFieldType) {
        DynamicObject targetBill;
        String targetBillNumber;
        Object sourceBill;
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(6);
        List<StatisticsConfig.MethodType> methodTypeList = dimFieldType.getType().equalsIgnoreCase(StatisticsConfig.DimFieldType.ENTRY.getType()) ? Arrays.asList(StatisticsConfig.MethodType.MIN, StatisticsConfig.MethodType.MAX, StatisticsConfig.MethodType.SUM, StatisticsConfig.MethodType.AVG, StatisticsConfig.MethodType.LAST, StatisticsConfig.MethodType.COUNT) : (((String)(sourceBill = this.getSourceEntityNumber())).equals(targetBillNumber = (String)(targetBill = (DynamicObject)this.getModel().getValue(KEY_TARGET_BILL_TYPE)).getPkValue()) ? Arrays.asList(StatisticsConfig.MethodType.MIN, StatisticsConfig.MethodType.MAX, StatisticsConfig.MethodType.SUM, StatisticsConfig.MethodType.AVG, StatisticsConfig.MethodType.RANK, StatisticsConfig.MethodType.COUNT) : Arrays.asList(StatisticsConfig.MethodType.MIN, StatisticsConfig.MethodType.MAX, StatisticsConfig.MethodType.SUM, StatisticsConfig.MethodType.AVG, StatisticsConfig.MethodType.COUNT));
        for (StatisticsConfig.MethodType methodType : methodTypeList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(methodType.getDesc()));
            comboItem.setValue(methodType.getType());
            comboItemList.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_METHOD);
        comboEdit.setComboItems(comboItemList);
    }

    private void initPropNameComb(String conditionJson) {
        List filterFields;
        IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue(KEY_TARGET_BILL_TYPE);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)targetBill.getPkValue()));
        EntityTypeUtil helper = new EntityTypeUtil();
        if (this.isEntryDimFieldType()) {
            filterFields = helper.getFilterFields((IDataEntityType)entityType, false);
            List<String> mulDimPropList = this.getMulDimPropList(this.getDimPropStatistics());
            if (mulDimPropList.isEmpty()) {
                return;
            }
            String dimPropName = mulDimPropList.get(0);
            String entityKey = null;
            for (FilterField filterField : filterFields) {
                if (!filterField.getFullFieldName().equalsIgnoreCase(dimPropName)) continue;
                entityKey = filterField.getEntityKey();
                break;
            }
            if (StringUtils.isNotEmpty(entityKey)) {
                for (FilterField filterField : filterFields) {
                    if (filterField.getFieldProp() instanceof FlexProp || !StringUtils.isEmpty((String)filterField.getBaseDataFilterControlType()) || !filterField.getEntityKey().equalsIgnoreCase(entityKey) || !this.isNumberField(filterField.getFieldType())) continue;
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(filterField.getCaption());
                    comboItem.setValue(filterField.getFullFieldName());
                    comboItemList.add(comboItem);
                }
            }
        } else {
            filterFields = helper.getFilterFields((IDataEntityType)entityType, true);
            boolean lastTime = this.isLastTimes(condition);
            for (FilterField filterField : filterFields) {
                if (!lastTime && (!this.isNumberField(filterField.getFieldType()) || filterField.getFieldProp() instanceof FlexProp || StringUtils.isNotEmpty((String)filterField.getBaseDataFilterControlType()))) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(filterField.getCaption());
                comboItem.setValue(filterField.getFullFieldName());
                comboItemList.add(comboItem);
            }
        }
        ComboEdit comboEdit = this.isLastTimes(condition) ? (ComboEdit)this.getControl(KEY_PROP_NAME_NO_DIM) : (ComboEdit)this.getControl(KEY_PROP_NAME_DIM);
        comboEdit.setComboItems(comboItemList);
    }

    private boolean isNumberField(int fieldType) {
        return fieldType == -7 || fieldType == -5 || fieldType == 3 || fieldType == 6 || fieldType == 4 || fieldType == 2 || fieldType == 7 || fieldType == 5 || fieldType == -6 || fieldType == 8;
    }

    private boolean isLastTimes(IDICondition condition) {
        if (condition == null) {
            return false;
        }
        FilterCondition filterCondition = condition.getFilterCondition();
        if (filterCondition != null) {
            List filterRowList = filterCondition.getFilterRow();
            for (SimpleFilterRow filterRow : filterRowList) {
                if (!"lastTime".equals(filterRow.getCompareType()) && !"lastThreeTimes".equals(filterRow.getCompareType()) && !"lastCustomTimes".equals(filterRow.getCompareType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLastThreeTimes() {
        IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)((String)this.getModel().getValue(KEY_CONDITION_JSON)), IDICondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        List filterRowList = filterCondition.getFilterRow();
        for (SimpleFilterRow filterRow : filterRowList) {
            if (!"lastThreeTimes".equals(filterRow.getCompareType())) continue;
            return true;
        }
        return false;
    }

    private boolean isEntryDimFieldType() {
        String dimFieldType = (String)this.getModel().getValue(KEY_DIM_FIELD_TYPE);
        return StatisticsConfig.DimFieldType.ENTRY.getType().equalsIgnoreCase(dimFieldType);
    }

    private void initTimePropComb(String conditionJson) {
        IDICondition condition = (IDICondition)IDIJSONUtils.cast((String)conditionJson, IDICondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        if (filterCondition != null) {
            List filterRowList = filterCondition.getFilterRow();
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_LAST_TIME_PROP_NAME);
            DynamicObject targetBill = (DynamicObject)this.getModel().getValue(KEY_TARGET_BILL_TYPE);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)targetBill.getPkValue()));
            EntityTypeUtil helper = new EntityTypeUtil();
            List filterFields = helper.getFilterFields((IDataEntityType)entityType, false);
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(filterRowList.size());
            ArrayList<String> fieldNameList = new ArrayList<String>(filterRowList.size());
            for (SimpleFilterRow filterRow : filterRowList) {
                if (fieldNameList.contains(filterRow.getFieldName()) || !this.parseDateTimeCondition(filterRow)) continue;
                for (FilterField filterField : filterFields) {
                    if (!filterField.getFieldName().equalsIgnoreCase(filterRow.getFieldName())) continue;
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(filterField.getCaption());
                    comboItem.setValue(filterField.getFullFieldName());
                    comboItemList.add(comboItem);
                    break;
                }
                fieldNameList.add(filterRow.getFieldName());
            }
            comboEdit.setComboItems(comboItemList);
            int entryRowCount = this.getModel().getEntryRowCount(KEY_DIM_ENTRY_ENTITY);
            block2: for (int i = 0; i < entryRowCount; ++i) {
                String timeProp = (String)this.getModel().getValue(KEY_LAST_TIME_PROP_NAME, i);
                for (String fieldName : fieldNameList) {
                    if (!fieldName.equalsIgnoreCase(timeProp)) continue;
                    continue block2;
                }
                this.getModel().setValue(KEY_LAST_TIME_PROP_NAME, null, i);
            }
        }
    }

    private boolean parseDateTimeCondition(SimpleFilterRow filterRow) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)((DynamicObject)this.getModel().getValue(KEY_TARGET_BILL_TYPE)).getPkValue()));
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
        for (Map fieldMap : cols) {
            Integer fieldType;
            if (!filterRow.getFieldName().equals(fieldMap.get("fieldName")) || (fieldType = (Integer)fieldMap.get("fieldType")) != 91 && fieldType != 93) continue;
            return true;
        }
        return false;
    }

    private String getSourceEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CustomParamKey_ENTITY_NUMBER);
    }

    private void initShowField(String dimPropFields) {
        IDataModel model = this.getModel();
        model.setValue(KEY_SHOW_FIELD, (Object)"");
        model.setValue(KEY_RENAME_SHOW_FIELD, (Object)"");
        if (StringUtils.isNotEmpty((String)dimPropFields) && this.isEntryDimFieldType()) {
            List<String> mulDimPropList = this.getMulDimPropList(dimPropFields);
            if (mulDimPropList.isEmpty()) {
                return;
            }
            HashSet<String> fullNameSet = new HashSet<String>(10);
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(8);
            for (String dimPropField : mulDimPropList) {
                DynamicObject targetBill = (DynamicObject)model.getValue(KEY_TARGET_BILL_TYPE);
                String targetBillPkValue = (String)targetBill.getPkValue();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetBillPkValue);
                List filterFields = new EntityTypeUtil().getFilterFields((IDataEntityType)entityType, false);
                String entityKey = null;
                String srcFieldKey = null;
                FilterField entityField = null;
                for (FilterField filterField : filterFields) {
                    if (!filterField.getFullFieldName().equalsIgnoreCase(dimPropField)) continue;
                    entityKey = filterField.getEntityKey();
                    srcFieldKey = filterField.getSrcFieldKey();
                    entityField = filterField;
                    break;
                }
                if (!StringUtils.isNotEmpty(entityKey) || entityField == null || !(entityField.getSrcFieldProp() instanceof BasedataProp)) continue;
                for (FilterField filterField : filterFields) {
                    if (!filterField.getEntityKey().equalsIgnoreCase(entityKey) || srcFieldKey != null && (filterField.getSrcFieldKey() == null || !filterField.getSrcFieldKey().equals(srcFieldKey)) || fullNameSet.contains(filterField.getFullFieldName())) continue;
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(filterField.getCaption());
                    comboItem.setValue(filterField.getFullFieldName());
                    fullNameSet.add(filterField.getFullFieldName());
                    comboItemList.add(comboItem);
                }
            }
            ComboEdit showFieldCombo = (ComboEdit)this.getControl(KEY_SHOW_FIELD);
            showFieldCombo.setComboItems(comboItemList);
        }
    }

    public List<String> getMulDimPropList(String value) {
        return value != null ? Arrays.stream(value.split(",")).filter(x -> !x.isEmpty()).collect(Collectors.toList()) : new ArrayList<String>(1);
    }

    public String getDimPropStatistics() {
        IDataModel model = this.getModel();
        DynamicObjectCollection dimPropCollection = model.getEntryEntity(DIMPROP_ENTRY);
        ArrayList<String> dimPropNames = new ArrayList<String>(4);
        for (DynamicObject obj : dimPropCollection) {
            if (!StringUtils.isNotEmpty((String)obj.getString(STATISTICS_FIELD))) continue;
            dimPropNames.add(obj.getString(STATISTICS_FIELD));
        }
        return dimPropNames.isEmpty() ? null : "," + String.join((CharSequence)",", dimPropNames) + ",";
    }

    public boolean judgeCountAndEntry() {
        IDataModel model = this.getModel();
        if (this.isEntryDimFieldType()) {
            DynamicObjectCollection dimPropCollection = model.getEntryEntity(DIMPROP_ENTRY);
            if (dimPropCollection == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7edf\u8ba1\u5b57\u6bb5\u3002", (String)"IDIStatisticsFormPlugin_24", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            int i = 1;
            ArrayList<String> tipIndexs = new ArrayList<String>(dimPropCollection.size());
            HashSet<String> statisticFieldSet = new HashSet<String>(3);
            HashSet<String> statisticEntrySet = new HashSet<String>(3);
            int allNullCount = 0;
            int validCount = 0;
            for (DynamicObject obj : dimPropCollection) {
                if (StringUtils.isEmpty((String)obj.getString(STATISTICS_FIELD)) && StringUtils.isNotEmpty((String)obj.getString(RENAME_STATISTICS))) {
                    tipIndexs.add(String.valueOf(i));
                } else if (StringUtils.isNotEmpty((String)obj.getString(STATISTICS_FIELD))) {
                    statisticFieldSet.add(obj.getString(STATISTICS_FIELD));
                    statisticEntrySet.add(obj.getString(STATISTICS_FIELD).split("\\.")[0]);
                    ++validCount;
                } else if (StringUtils.isEmpty((String)obj.getString(STATISTICS_FIELD)) && StringUtils.isEmpty((String)obj.getString(RENAME_STATISTICS))) {
                    ++allNullCount;
                }
                ++i;
            }
            if (dimPropCollection.isEmpty() || allNullCount == dimPropCollection.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7edf\u8ba1\u5b57\u6bb5\u3002", (String)"IDIStatisticsFormPlugin_24", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (dimPropCollection.size() > 3) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u5141\u8bb8\u65b0\u589e3\u884c\u7edf\u8ba1\u5b57\u6bb5\u3002", (String)"IDIStatisticsFormPlugin_21", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!tipIndexs.isEmpty()) {
                String index = String.join((CharSequence)",", tipIndexs);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%1$s\u884c\u7edf\u8ba1\u5b57\u6bb5\u6216\u6e05\u7a7a\u7b2c%2$s\u884c\u91cd\u547d\u540d\u7edf\u8ba1\u5b57\u6bb5\u7684\u5185\u5bb9\u3002", (String)"IDIStatisticsFormPlugin_23", (String)"data-idi-formplugin", (Object[])new Object[0]), index, index));
                return false;
            }
            if (statisticEntrySet.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5b57\u6bb5\u6240\u9009\u7684\u5b57\u6bb5\u5fc5\u987b\u662f\u540c\u4e00\u4e2a\u5206\u5f55\u7684\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IDIStatisticsFormPlugin_20", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (statisticFieldSet.size() != validCount) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6709\u91cd\u590d\u7684\u7edf\u8ba1\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IDIStatisticsFormPlugin_22", (String)"data-idi-formplugin", (Object[])new Object[0]), new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void updateStatisticsField(String fieldNumber) {
        if (fieldNumber == null) {
            this.initDimPropNameCombo();
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DIM_ENTRY_ENTITY_FLEX});
            this.getModel().deleteEntryData(KEY_DIM_ENTRY_ENTITY);
            return;
        }
        String entryNumber = fieldNumber.split("\\.")[0];
        String entryNumberCache = this.getPageCache().get(STATISTICS_ENTRY_NUMBER);
        if (StringUtils.isEmpty((String)entryNumberCache) || !entryNumber.equals(entryNumberCache)) {
            this.getPageCache().put(STATISTICS_ENTRY_NUMBER, entryNumber);
            DynamicObject targetBill = (DynamicObject)this.getModel().getValue(KEY_TARGET_BILL_TYPE);
            String targetBillPkValue = (String)targetBill.getPkValue();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetBillPkValue);
            EntityTypeUtil helper = new EntityTypeUtil();
            List filterFields = helper.getFilterFields((IDataEntityType)entityType, false);
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
            ComboEdit statistics = (ComboEdit)this.getControl(STATISTICS_FIELD);
            for (FilterField filterField : filterFields) {
                if (filterField.getEntityKey().equalsIgnoreCase(targetBillPkValue) || !filterField.getEntityKey().equals(entryNumber)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(filterField.getCaption());
                comboItem.setValue(filterField.getFullFieldName());
                comboItemList.add(comboItem);
            }
            statistics.setComboItems(comboItemList);
        }
    }
}

