/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.EventObject;
import kd.bd.assistant.plugin.helper.FinPicHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.CodeRuleServiceHelper;

public class FinOrgInfoListPlugin
extends StandardTreeListPlugin {
    public static final String TBL_SETCATE = "tblsetcate";
    public static final String TBL_FINTYPE = "tblfinorgtype";
    public static final String TBL_RESIN_BANK = "tblresin";
    public static final String KEY_RESIN = "KEY_RESIN";
    public static final String KEY_BANKCATE = "KEY_BANKCATE";

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if ("city.number".equals(filterCol.getFieldName())) {
            args.getQFilters().add(this.getCityFilter());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("city.id".equals(fieldName)) {
            args.getQfilters().add(this.getCityFilter());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        String orderBy = String.format("%s, %s", "number", "name");
        billList.setOrderBy(orderBy);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"tblrefresh", (CharSequence)itemKey)) {
            this.getPageCache().remove(KEY_BANKCATE);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection dataList = super.getData(arg0, arg1);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                if (!((DynamicObject)dataList.get(0)).getDataEntityType().getProperties().containsKey((Object)"logo")) {
                    return dataList;
                }
                for (DynamicObject data : dataList) {
                    String logo = data.getString("logo");
                    if (!StringUtils.isNotEmpty((CharSequence)logo)) continue;
                    data.set("logo", (Object)FinPicHelper.getRealPath((String)logo));
                }
                return dataList;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"batchresin")) {
            ORM orm = ORM.create();
            DynamicObject finOrgInfo = orm.newDynamicObject("bd_finorginfo");
            boolean exist = CodeRuleServiceHelper.isExist((String)"bd_finorginfo", (DynamicObject)finOrgInfo, null);
            if (!exist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"FinOrgInfoListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            } else {
                this.showResInDialog(true);
            }
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"singleresin")) {
            this.showResInDialog(false);
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"showbankcate")) {
            ListShowParameter showPara = new ListShowParameter();
            showPara.setBillFormId("bd_bankcgsetting");
            showPara.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showPara);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String isFilterBankCate = this.getPageCache().get(KEY_BANKCATE);
        ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
        if (isFilterBankCate == null && !sp.isLookUp()) {
            this.getPageCache().put(KEY_BANKCATE, "");
            ORM orm = ORM.create();
            int count = orm.count("bd_finorginfo", "bd_finorginfo", new QFilter[]{this.getNonBankCateFilter()});
            if (count > 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%d\u6761\u5408\u4f5c\u91d1\u878d\u673a\u6784\u6ca1\u6709\u7ef4\u62a4\u201c\u94f6\u884c\u7c7b\u522b\u201d\uff0c\u4f1a\u5f71\u54cd\u6570\u636e\u8fc7\u6ee4\u548c\u7edf\u8ba1\uff0c\u7acb\u523b\u8fdb\u884c\u7ef4\u62a4\uff1f", (String)"FinOrgInfoListPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]), count), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_BANKCATE, (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((CharSequence)KEY_BANKCATE, (CharSequence)callBackId) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList list = (BillList)this.getControl("billlistap");
            list.setFilter(this.getNonBankCateFilter());
            list.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    private QFilter getCityFilter() {
        return new QFilter("level", "=", (Object)2);
    }

    private QFilter getNonBankCateFilter() {
        return new QFilter("bank_cate", "=", (Object)0L).and(new QFilter("finorgtype.type", "=", (Object)"0")).and(new QFilter("enable", "=", (Object)Boolean.TRUE));
    }

    private void showResInDialog(boolean isMultiSelect) {
        ListShowParameter showPara = ShowFormHelper.createShowListForm((String)"bd_bebank", (boolean)isMultiSelect);
        showPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_RESIN));
        StyleCss css = new StyleCss();
        css.setWidth("1440px");
        css.setHeight("650px");
        showPara.getOpenStyle().setInlineStyleCss(css);
        showPara.setCustomParam("resin", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)showPara);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)KEY_RESIN) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
            if (sp.isLookUp()) {
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else {
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

