/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.assistant.plugin.util.ExpenseItemUtils;
import kd.bd.assistant.plugin.util.LogUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ErExpenseItemSettingPlugin
extends AbstractBillPlugIn {
    private static final String BILL_TYPE = "er_billtype";
    private static final String LAYOUT_TYPE = "er_layouttype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"editbilltype"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("savebtn".equals(evt.getItemKey())) {
            List<Long> expenseItemPks = this.getExpenseItemPks();
            List<Object> billTypePks = this.getRelatedBillTypePks("billtypeentry", "billtype", "setrelate");
            try (TXHandle h = TX.requiresNew();){
                try {
                    DynamicObject[] dynamicObjects;
                    ExpenseItemUtils.deleteRelation4ExpenseItem((Object[])expenseItemPks.toArray());
                    ExpenseItemUtils.saveRelation((Object[])expenseItemPks.toArray(), (Object[])billTypePks.toArray());
                    for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", expenseItemPks)})) {
                        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        dynamicObject.set("modifytime", (Object)new Date());
                    }
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                    String msg = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u5173\u8054\u5355\u636e", (String)"ErExpenseItemSettingPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
                    String opName = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ExpitemRelDeptEdit_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
                    AppLogInfo logInfo = LogUtils.recordLogInfo(msg, RequestContext.get().getOrgId(), opName, this.getView());
                    ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
                    logService.addLog(logInfo);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ErExpenseItemSettingPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        } else if ("bar_refresh".equals(evt.getItemKey())) {
            this.initBillTypeEntry();
        }
    }

    private List<Object> getRelatedBillTypePks(String entryName, String billtypeField, String relateField) {
        ArrayList<Object> billTypePks = new ArrayList<Object>();
        DynamicObjectCollection billTypeEntry = this.getModel().getEntryEntity(entryName);
        billTypeEntry.forEach(billType -> {
            if (billType.getBoolean(relateField)) {
                billTypePks.add(billType.getDynamicObject(billtypeField).getPkValue());
            }
        });
        return billTypePks;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("editbilltype".equals(key)) {
            this.openEditBillType(BILL_TYPE, ResManager.loadKDString((String)"\u8bbe\u7f6e\u8d39\u7528\u53ef\u5173\u8054\u5355\u636e", (String)"ErExpenseItemSettingPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        } else if ("editlayouttype".equals(key)) {
            this.openEditBillType(LAYOUT_TYPE, ResManager.loadKDString((String)"\u8bbe\u7f6e\u8d39\u7528\u53ef\u5173\u8054\u5e03\u5c40", (String)"ErExpenseItemSettingPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBillTypeEntry();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initLabelInfo();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        List<Long> expenseItemPks = null;
        if (BILL_TYPE.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            expenseItemPks = this.getExpenseItemPks();
            this.initBillTypeEntry(BILL_TYPE, "er_expenseitembill", "billtype", "billtypeentry", "billtype", "setrelate", expenseItemPks);
        }
    }

    private List<Long> getExpenseItemPks() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List expenseItemIds = (List)formShowParameter.getCustomParam("id");
        ArrayList<Long> resultList = new ArrayList<Long>();
        if (expenseItemIds != null && expenseItemIds.size() > 0) {
            for (Object element : expenseItemIds) {
                if (element instanceof Integer) {
                    resultList.add(Long.parseLong(element.toString()));
                    continue;
                }
                if (!(element instanceof Long)) continue;
                resultList.add((Long)element);
            }
        }
        return resultList;
    }

    private void initLabelInfo() {
        List<Long> expenseItemPks = this.getExpenseItemPks();
        if (!expenseItemPks.isEmpty()) {
            DynamicObject[] expenseItems = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", expenseItemPks)});
            StringBuilder sBuffer = new StringBuilder();
            for (DynamicObject expenseItem : expenseItems) {
                sBuffer.append(String.format("%s,%s; ", expenseItem.get("number"), expenseItem.getLocaleString("name").getLocaleValue()));
            }
            Label label = (Label)this.getControl("expenseitemlabel");
            label.setText(sBuffer.toString());
        }
    }

    private void initBillTypeEntry() {
        List<Long> expenseItemPks = this.getExpenseItemPks();
        this.initBillTypeEntry(BILL_TYPE, "er_expenseitembill", "billtype", "billtypeentry", "billtype", "setrelate", expenseItemPks);
    }

    private void initBillTypeEntry(String typeEntity, String relationEntity, String relationField, String entryName, String typeField, String relateField, List<Long> expenseItemPks) {
        DynamicObject[] relation = BusinessDataServiceHelper.load((String)relationEntity, (String)relationField, (QFilter[])new QFilter[]{new QFilter("expenseitem.id", "in", expenseItemPks)});
        Set billTypeSet = Stream.of(relation).filter(v -> v != null && v.getDynamicObject(relationField) != null).map(v -> v.getDynamicObject(relationField).getPkValue()).collect(Collectors.toSet());
        DynamicObject[] billTypeDyms = BusinessDataServiceHelper.load((String)typeEntity, (String)"id,bizappid.id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        this.getModel().deleteEntryData(entryName);
        this.getModel().beginInit();
        for (DynamicObject billTypDym : billTypeDyms) {
            int rowIndex = this.getModel().createNewEntryRow(entryName);
            this.getModel().setValue(typeField, billTypDym.getPkValue(), rowIndex);
            this.getModel().setValue("bizappid", billTypDym.get("bizappid.id"), rowIndex);
            if (!billTypeSet.contains(billTypDym.getPkValue())) continue;
            this.getModel().setValue(relateField, (Object)Boolean.TRUE, rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(entryName);
    }

    private void openEditBillType(String billFormId, String caption) {
        ListShowParameter formShowParameter;
        ListShowParameter listShowParameter = formShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setLookUp(false);
        listShowParameter.setListFilterParameter(null);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, billFormId));
        formShowParameter.setShowTitle(true);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

