/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.er.web.ExpitemRelDeptEdit;
import kd.bd.assistant.plugin.util.ExpenseItemUtils;
import kd.bd.assistant.plugin.util.LogUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ExpenseRelCenterEdit
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ExpitemRelDeptEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
        this.addClickListeners(new String[]{"btn_add", "btn_del"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        ArrayList expItems = (ArrayList)showParameter.getCustomParam("expitems");
        if (expItems == null) {
            expItems = new ArrayList();
        }
        this.getPageCache().put("expitems", SerializationUtils.serializeToBase64(expItems));
        this.getModel().setValue("expitems", (Object)expItems.toArray());
        List<Long> centerList = this.initAllCenterData();
        QFilter filter = new QFilter("expenseitem.id", "in", expItems);
        filter.and(new QFilter("relcenter.id", "in", centerList));
        DynamicObjectCollection relCenters = QueryServiceHelper.query((String)"bd_expitemrelcenter", (String)"id,relcenter", (QFilter[])new QFilter[]{filter});
        if (relCenters == null) {
            return;
        }
        HashSet<Long> relCenterIds = new HashSet<Long>(relCenters.size());
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(relCenters.size());
        for (DynamicObject relDept : relCenters) {
            Long relorgId = relDept.getLong("relcenter");
            relCenterIds.add(relorgId);
            TreeNode treeNode = new TreeNode();
            treeNode.setId(relorgId + "");
            checkNodes.add(treeNode);
        }
        TreeView centerTree = (TreeView)this.getControl("tree_allcenter");
        centerTree.checkNodesWithoutChild(checkNodes);
        Map centerDyms = BusinessDataServiceHelper.loadFromCache((Object[])relCenterIds.toArray(), (String)"bos_costcenter");
        centerDyms.forEach((k, v) -> {
            int rowIndex = this.getModel().createNewEntryRow("centerrelate");
            this.getModel().setValue("centerid", v.getPkValue(), rowIndex);
            this.getModel().setValue("centername", (Object)v.getString("name"), rowIndex);
            this.getModel().setValue("centernumber", (Object)v.getString("number"), rowIndex);
        });
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_add": {
                this.addToRel();
                break;
            }
            case "btn_del": {
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.saveExpItemRelDept();
                break;
            }
            case "bar_cancel": {
                this.getView().close();
                break;
            }
            case "bar_refresh": {
                this.getView().updateView();
                break;
            }
        }
    }

    private List<Long> initAllCenterData() {
        TreeView centerTree = (TreeView)this.getControl("tree_allcenter");
        ArrayList<Long> allIds = new ArrayList<Long>();
        QFilter rootFilter = new QFilter("enable", "=", (Object)true);
        rootFilter.and("parent", "=", (Object)0);
        rootFilter.and("level", "=", (Object)1);
        Map rootCeneterDyms = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{rootFilter});
        rootCeneterDyms.forEach((id, rootOrgDym) -> {
            TreeNode node = new TreeNode();
            node.setId(id.toString());
            node.setText(rootOrgDym.getLocaleString("name").getLocaleValue());
            centerTree.addNode(node);
            allIds.add((Long)id);
        });
        QFilter allFilter = new QFilter("enable", "=", (Object)true);
        allFilter.and("parent", "!=", (Object)0);
        Map allCenters = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{allFilter});
        allCenters.forEach((id, dym) -> {
            TreeNode node = new TreeNode();
            node.setId(id.toString());
            node.setText(dym.getLocaleString("name").getLocaleValue());
            DynamicObject parent = dym.getDynamicObject("parent");
            if (parent != null) {
                node.setParentid(String.valueOf(parent.getPkValue()));
                centerTree.addNode(node);
                allIds.add((Long)id);
            }
        });
        return allIds;
    }

    private void addToRel() {
        TreeView allorg = (TreeView)this.getControl("tree_allcenter");
        List selectedNodes = allorg.getTreeState().getSelectedNodes();
        HashSet<Long> orgids = new HashSet<Long>();
        selectedNodes.forEach(node -> orgids.add(Long.parseLong(node.get("id").toString())));
        DynamicObjectCollection authedOrgs = this.getModel().getEntryEntity("centerrelate");
        authedOrgs.forEach(authedOrg -> orgids.remove(authedOrg.getLong("centerid")));
        this.fillAuthOrgEntry(orgids);
    }

    private void saveExpItemRelDept() {
        DynamicObject[] dynamicObjects;
        DynamicObjectCollection orgrelate = this.getModel().getEntryEntity("centerrelate");
        String expItemString = this.getPageCache().get("expitems");
        List expItems = (List)SerializationUtils.deSerializeFromBase64((String)expItemString);
        HashSet relExpItems = new HashSet();
        relExpItems.addAll(expItems);
        for (Object item : expItems) {
            List subLevle = ExpenseItemUtils.getSubLevle((String)item.toString());
            if (subLevle.isEmpty()) continue;
            Set set = subLevle.stream().filter(e -> StringUtils.isEmpty((String)e)).map(e -> Long.valueOf(e)).collect(Collectors.toSet());
            relExpItems.addAll(set);
        }
        QFilter qFilter = new QFilter("expenseitem", "in", relExpItems);
        DeleteServiceHelper.delete((String)"bd_expitemrelcenter", (QFilter[])new QFilter[]{qFilter});
        ArrayList authOrgItems = new ArrayList();
        for (Object e2 : relExpItems) {
            orgrelate.forEach(centerItem -> {
                DynamicObject rel = BusinessDataServiceHelper.newDynamicObject((String)"bd_expitemrelcenter");
                rel.set("expenseitem", expItem);
                rel.set("relcenter", (Object)centerItem.getString("centerid"));
                authOrgItems.add(rel);
            });
        }
        if (!authOrgItems.isEmpty()) {
            SaveServiceHelper.saveOperate((String)"bd_expitemrelcenter", (DynamicObject[])authOrgItems.toArray(new DynamicObject[authOrgItems.size()]), (OperateOption)OperateOption.create());
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)expItems)})) {
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        String string = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ExpenseRelCenterEdit_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
        String opName = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ExpitemRelDeptEdit_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]);
        AppLogInfo logInfo = LogUtils.recordLogInfo(string, RequestContext.get().getOrgId(), opName, this.getView());
        ILogService iLogService = (ILogService)ServiceFactory.getService(ILogService.class);
        iLogService.addLog(logInfo);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ExpenseRelCenterEdit_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
    }

    private void fillAuthOrgEntry(Set<Long> orgids) {
        Map orgDym = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgids)});
        orgDym.forEach((id, org) -> {
            int rowIndex = this.getModel().createNewEntryRow("centerrelate");
            this.getModel().setValue("centername", (Object)org.getString("name"), rowIndex);
            this.getModel().setValue("centernumber", (Object)org.getString("number"), rowIndex);
            this.getModel().setValue("centerid", id, rowIndex);
        });
    }
}

