/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orgview.costcenter.CostCenterTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CostCenterTreeListPlugin
extends StandardTreeListPlugin {
    private final Log logger = LogFactory.getLog(CostCenterTreeListPlugin.class);
    private static final String APPID_SCA = "0DDNKGUZRMR8";
    private static final String APPID_ACA = "0YH2ZWPSCB+4";
    private Boolean ISSHOW_SOURCEDATA = Boolean.FALSE;
    private static final String BTNENTRYDATA = "btnentrydata";
    private static final String LONG_NUMBER_UPDATE = "numberupdate";
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private Map<String, List<Map<String, String>>> childNodes = null;

    public void beforeShowBill(BeforeShowBillFormEvent arg0) {
        super.beforeShowBill(arg0);
        BillShowParameter paramter = arg0.getParameter();
        Map customParams = paramter.getCustomParams();
        if (!customParams.containsKey("tree_parent_id")) {
            return;
        }
        Object parentParam = customParams.get("tree_parent_id");
        if (parentParam == null || !(parentParam instanceof Map)) {
            return;
        }
        Map parentParamMap = (Map)parentParam;
        Object value = parentParamMap.get("value");
        if (value == null) {
            return;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(value.toString()));
        QFilter[] filters = new QFilter[]{enableFilter, idFilter};
        DynamicObject parentObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (String)"enable", (QFilter[])filters);
        if (parentObj == null) {
            customParams.remove("tree_parent_id");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("tblclose".equalsIgnoreCase(evt.getItemKey().toLowerCase())) {
            return;
        }
        super.beforeItemClick(evt);
        switch (evt.getItemKey().toLowerCase()) {
            case "btnbatchcreatecostcenter": {
                if (!PermissionServiceHelper.hasNewPermission((long)RequestContext.getOrCreate().getCurrUserId(), (String)this.getAppId(), (String)"bos_costcenter")) break;
                this.showOrgUnitEdit();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("searchup".equals(operate.getOperateKey())) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                return;
            }
            Object[] selectCostCenterIds = selectedRows.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("costcenter", "in", Arrays.asList(selectCostCenterIds));
            List costCenterMapIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcentersourcemap", (QFilter[])qFilter.toArray(), null, (int)-1);
            if (CollectionUtils.isEmpty((Collection)costCenterMapIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6210\u672c\u4e2d\u5fc3\u672a\u5173\u8054\u6709\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u914d\u7f6e\u3002", (String)"CostCenterTreeListPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("bos_costcentersourcemap");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setShowFilter(false);
            listShowParameter.setShowQuickFilter(false);
            listShowParameter.setCustomParam("costCenterMapIds", (Object)costCenterMapIds);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTNENTRYDATA.equals(evt.getItemKey())) {
            this.updateCostCenterEntryData();
        }
        if (LONG_NUMBER_UPDATE.equals(evt.getItemKey())) {
            this.updateCostCenterLongNumber();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Boolean.TRUE.equals(this.ISSHOW_SOURCEDATA)) {
            this.setSourceData();
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        this.initTreeData();
        List<TreeNode> treeNodes = this.getTreeChildren(e.getNodeId().toString());
        e.setChildNodes(treeNodes);
        this.childNodes = null;
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("number asc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                CostCenterTreeListPlugin.this.ISSHOW_SOURCEDATA = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"entryentity.id") ? Boolean.TRUE : Boolean.FALSE;
                return rows;
            }
        });
    }

    private void showOrgUnitEdit() {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("bos_costcenter_quickadd");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5feb\u901f\u65b0\u589e", (String)"CostCenterTreeListPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_costcenter_quickadd"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent arg0) {
        if ("bos_costcenter_quickadd".equals(arg0.getActionId())) {
            Object returnData = arg0.getReturnData();
            if (returnData == null) {
                return;
            }
            Map returnDataMap = (Map)returnData;
            if (!returnDataMap.containsKey("ischanged")) {
                return;
            }
            TreeNode rootNode = this.getTreeModel().getRoot();
            ITreeListView tv = this.getTreeListView();
            tv.getTreeView().focusNode(rootNode);
            tv.getTreeModel().setCurrentNodeId((Object)rootNode.getId());
            tv.refresh();
        }
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        List<Map<String, String>> curData = this.getCurTreeData(nodeId);
        if (curData == null || curData.size() == 0) {
            return treeNodes;
        }
        TreeNode treeNode = null;
        for (Map<String, String> entry : curData) {
            boolean isLeaf;
            treeNode = new TreeNode();
            treeNode.setId(entry.get("id"));
            treeNode.setParentid(entry.get("parentid") != null ? entry.get("parentid") : "0");
            treeNode.setText(entry.get("name"));
            treeNode.setLongNumber(entry.get("longnumber"));
            boolean bl = isLeaf = entry.get("isleaf") == null ? true : Boolean.parseBoolean(entry.get("isleaf"));
            if (!isLeaf && this.isLeafNode(entry.get("id")).booleanValue()) {
                treeNode.setLeaf(true);
                treeNode.addChildren(this.getTreeChildren(entry.get("id")));
            } else {
                treeNode.setLeaf(false);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private List<Map<String, String>> getCurTreeData(String nodeId) {
        String parentId = ROOTNODEID.equals(nodeId) ? "0" : nodeId;
        return this.childNodes.get(parentId);
    }

    private Boolean isLeafNode(String nodeId) {
        String parentId = ROOTNODEID.equals(nodeId) ? "0" : nodeId;
        List<Map<String, String>> child = this.childNodes.get(parentId);
        if (child == null || child.size() == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void initTreeData() {
        ITreeListView treeView;
        ITreeModel treeModel;
        List treeFilter;
        this.childNodes = new HashMap<String, List<Map<String, String>>>(16);
        QFilter qfEnable = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isFilterLeftTree = false;
        if (listShowParameter.isLookUp() && (treeFilter = (treeModel = (treeView = this.getTreeListView()).getTreeModel()).getTreeFilter()) != null && treeFilter.size() > 0) {
            isFilterLeftTree = true;
            treeFilter.forEach(s -> qfEnable.and(s));
        }
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qfEnable}, (String)"number asc");
        DynamicObject val = null;
        HashMap<String, String> map = null;
        List<Map<String, String>> curChild = null;
        HashSet<Long> parentIds = new HashSet<Long>(16);
        HashSet<Long> loadIds = new HashSet<Long>(16);
        for (Map.Entry entry : loadFromCache.entrySet()) {
            val = (DynamicObject)entry.getValue();
            map = new HashMap<String, String>(16);
            map.put("id", val.getString("id"));
            map.put("number", val.getString("number"));
            map.put("name", val.getString("name"));
            map.put("text", val.getString("name"));
            map.put("parentid", val.getDynamicObject("parent") != null ? val.getDynamicObject("parent").getString("id") : "0");
            map.put("longnumber", val.getString("longnumber"));
            map.put("isleaf", val.getString("isleaf"));
            if (val.getDynamicObject("parent") != null) {
                parentIds.add(val.getDynamicObject("parent").getLong("id"));
            }
            loadIds.add(val.getLong("id"));
            curChild = this.childNodes.get(map.get("parentid"));
            if (curChild == null) {
                curChild = new ArrayList<Map<String, String>>();
            }
            curChild.add(map);
            this.childNodes.put((String)map.get("parentid"), curChild);
        }
        if (listShowParameter.isLookUp() && isFilterLeftTree) {
            parentIds.removeAll(loadIds);
            this.buildParentNode(parentIds, 0);
        }
    }

    private void buildParentNode(Set<Long> parentIds, int count) {
        if (parentIds == null || parentIds.size() == 0 || count > 50) {
            return;
        }
        QFilter id = new QFilter("id", "in", parentIds);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])id.toArray(), (String)"number asc");
        parentIds = new HashSet<Long>(16);
        HashSet<Long> loadIds = new HashSet<Long>(16);
        for (Map.Entry entry : loadFromCache.entrySet()) {
            DynamicObject val = (DynamicObject)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", val.getString("id"));
            map.put("number", val.getString("number"));
            map.put("name", val.getString("name"));
            map.put("text", val.getString("name"));
            map.put("parentid", val.getDynamicObject("parent") != null ? val.getDynamicObject("parent").getString("id") : "0");
            if (val.getDynamicObject("parent") != null) {
                parentIds.add(val.getDynamicObject("parent").getLong("id"));
            }
            loadIds.add(val.getLong("id"));
            map.put("longnumber", val.getString("longnumber"));
            map.put("isleaf", val.getString("isleaf"));
            this.childNodes.computeIfAbsent((String)map.get("parentid"), (Function<String, List<Map<String, String>>>)((Function<String, List>)s -> new ArrayList())).add(map);
        }
        parentIds.removeAll(loadIds);
        this.buildParentNode(parentIds, ++count);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryValues = e.getQueryValues();
        int count = 0;
        if (queryValues != null && queryValues.length > 0) {
            try {
                for (DynamicObject dynamicObject : queryValues) {
                    DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                    if (entryEntity != null && entryEntity.size() > 0) {
                        count += entryEntity.size();
                        continue;
                    }
                    ++count;
                }
            }
            catch (Exception ex) {
                count = queryValues.length;
            }
        }
        this.cacheCount(count);
    }

    private void cacheCount(int count) {
        String currCount = this.getPageCache().get("count");
        if (StringUtils.isEmpty((CharSequence)currCount)) {
            currCount = "0";
        }
        int total = Integer.parseInt(currCount) + count;
        this.getPageCache().put("count", String.valueOf(total));
    }

    public void afterExportFile(ExportFileEvent e) {
        super.afterExportFile(e);
        File file = e.getFile();
        if (file != null) {
            String id = "ID";
            String number = ResManager.loadKDString((String)"\u7f16\u7801", (String)"CostCenterTreeListPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            String orgDuty = ResManager.loadKDString((String)"\u7c7b\u578b", (String)"CostCenterTreeListPlugin_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            String sourceTypeObj = ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b", (String)"CostCenterTreeListPlugin_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            String dataNum = ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e.\u7f16\u7801", (String)"CostCenterTreeListPlugin_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            String dataName = ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e.\u540d\u79f0", (String)"CostCenterTreeListPlugin_7", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            String srcTypeNum = ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b.\u7f16\u7801", (String)"CostCenterTreeListPlugin_8", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            String srcTypeName = ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b.\u540d\u79f0", (String)"CostCenterTreeListPlugin_9", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                HashMap<String, Integer> propNumMap = new HashMap<String, Integer>();
                int headIndex = this.getHeadIndex(sheet);
                HashMap<String, List<DynamicObject>> costCenterSrcMap = new HashMap<String, List<DynamicObject>>();
                HashSet<Object> srcTypeSet = new HashSet<Object>();
                HashSet<String> srcTypeNumSet = new HashSet<String>();
                this.getBatchSrcMap(sheet, headIndex, costCenterSrcMap, srcTypeSet, srcTypeNumSet);
                Map<String, String> orgDutyMap = this.getBatchOrgDuty(costCenterSrcMap);
                Map<String, DynamicObject> srcTypeMap = this.getSrcTypeMap(srcTypeSet, srcTypeNumSet);
                int currNumIndex = 0;
                List currListData = null;
                int i = 0;
                while (sheet.getRow(i) != null) {
                    Row row = sheet.getRow(i);
                    if (i == headIndex) {
                        for (int colNum = 0; colNum < row.getLastCellNum(); ++colNum) {
                            Cell cell = row.getCell(colNum);
                            if (cell == null) continue;
                            String colName = cell.getStringCellValue();
                            String[] colNameArr = colName.split("#");
                            if (colNameArr.length == 1) {
                                String[] colPropNameArr = colNameArr[0].split("\\*");
                                String propNum = colPropNameArr[colPropNameArr.length - 1];
                                if (id.equals(propNum)) {
                                    propNumMap.put("entryid", cell.getColumnIndex());
                                    continue;
                                }
                                if (number.equals(propNum)) {
                                    propNumMap.put("number", cell.getColumnIndex());
                                    continue;
                                }
                                if (orgDuty.equals(propNum)) {
                                    propNumMap.put("orgduty", cell.getColumnIndex());
                                    continue;
                                }
                                if (sourceTypeObj.equals(propNum)) {
                                    propNumMap.put("sourcetypeobj", cell.getColumnIndex());
                                    continue;
                                }
                                if (dataNum.equals(propNum)) {
                                    propNumMap.put("dataNum", cell.getColumnIndex());
                                    continue;
                                }
                                if (dataName.equals(propNum)) {
                                    propNumMap.put("dataName", cell.getColumnIndex());
                                    continue;
                                }
                                if (srcTypeNum.equals(propNum)) {
                                    propNumMap.put("srcTypeNum", cell.getColumnIndex());
                                    continue;
                                }
                                if (!srcTypeName.equals(propNum)) continue;
                                propNumMap.put("srcTypeName", cell.getColumnIndex());
                                continue;
                            }
                            String propNum = colNameArr[1].trim();
                            this.fillPropNumMap(propNumMap, cell, propNum);
                        }
                    }
                    if (i > headIndex) {
                        if (row == null) continue;
                        Cell numberCell = propNumMap.get("number") != null ? row.getCell(((Integer)propNumMap.get("number")).intValue()) : null;
                        DynamicObject costCenterSource = null;
                        if (numberCell != null) {
                            List costCenterSourceList = (List)costCenterSrcMap.get(numberCell.getStringCellValue());
                            currNumIndex = i;
                            currListData = costCenterSourceList;
                            if (costCenterSourceList != null && !costCenterSourceList.isEmpty()) {
                                costCenterSource = (DynamicObject)costCenterSourceList.get(0);
                            }
                            this.setCellEntryValue(row, (Integer)propNumMap.get("orgduty"), orgDutyMap.get(numberCell.getStringCellValue()));
                        } else if (currListData != null && !currListData.isEmpty() && currListData.size() > i - currNumIndex) {
                            costCenterSource = (DynamicObject)currListData.get(i - currNumIndex);
                        }
                        if (costCenterSource != null) {
                            DynamicObject data = srcTypeMap.get(costCenterSource.getString("data"));
                            if (data != null) {
                                this.setCellEntryValue(row, (Integer)propNumMap.get("dataNum"), data.getString("dataNum"));
                                this.setCellEntryValue(row, (Integer)propNumMap.get("dataName"), data.getString("dataName"));
                            }
                            this.setCellEntryValue(row, (Integer)propNumMap.get("entryid"), costCenterSource.getString("entryid"));
                            this.setCellEntryValue(row, (Integer)propNumMap.get("sourcetypeobj"), costCenterSource.getString("sourcetypeobj"));
                            this.setCellEntryValue(row, (Integer)propNumMap.get("srcTypeNum"), costCenterSource.getString("srcTypeNum"));
                            this.setCellEntryValue(row, (Integer)propNumMap.get("srcTypeName"), costCenterSource.getString("srcTypeName"));
                        }
                    }
                    ++i;
                }
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage());
            }
        }
    }

    private Map<String, String> getBatchOrgDuty(Map<String, List<DynamicObject>> costCenterSrcMap) {
        HashMap<String, String> orgDutyMap = new HashMap<String, String>(16);
        if (costCenterSrcMap == null || costCenterSrcMap.isEmpty()) {
            return orgDutyMap;
        }
        Set<String> costCenterNumSet = costCenterSrcMap.keySet();
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"number, orgduty.name AS orgduty", (QFilter[])new QFilter[]{new QFilter("number", "in", costCenterNumSet)});
        costCenters.forEach(e -> orgDutyMap.put(e.getString("number"), e.getString("orgduty")));
        return orgDutyMap;
    }

    private void fillPropNumMap(Map<String, Integer> propNumMap, Cell cell, String propNum) {
        switch (propNum) {
            case "number": {
                propNumMap.put("number", cell.getColumnIndex());
                break;
            }
            case "orgduty": {
                propNumMap.put("orgduty", cell.getColumnIndex());
                break;
            }
            case "entryid": {
                propNumMap.put("entryid", cell.getColumnIndex());
                break;
            }
            case "sourcetypeobj": {
                propNumMap.put("sourcetypeobj", cell.getColumnIndex());
                break;
            }
            case "data.number": {
                propNumMap.put("dataNum", cell.getColumnIndex());
                break;
            }
            case "data.name": {
                propNumMap.put("dataName", cell.getColumnIndex());
                break;
            }
            case "sourcetype.number": {
                propNumMap.put("srcTypeNum", cell.getColumnIndex());
                break;
            }
            case "sourcetype.name": {
                propNumMap.put("srcTypeName", cell.getColumnIndex());
            }
        }
    }

    private Map<String, DynamicObject> getSrcTypeMap(Set<Object> srcTypeSet, Set<String> srcTypeNumSet) {
        HashMap<String, DynamicObject> srcTypeMap = new HashMap<String, DynamicObject>();
        for (String srcTypeNum : srcTypeNumSet) {
            DynamicObjectCollection datas = QueryServiceHelper.query((String)srcTypeNum, (String)"id,number AS dataNum, name AS dataName", (QFilter[])new QFilter[]{new QFilter("id", "in", srcTypeSet)});
            datas.forEach(e -> srcTypeMap.put(e.getString("id"), (DynamicObject)e));
        }
        return srcTypeMap;
    }

    private void getBatchSrcMap(Sheet sheet, int headIndex, Map<String, List<DynamicObject>> costCenterSrcMap, Set<Object> srcTypeSet, Set<String> srcTypeNumSet) {
        String propNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"CostCenterTreeListPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
        ArrayList<String> numberList = new ArrayList<String>();
        int numberIndex = 0;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (i == headIndex) {
                for (int colNum = 0; colNum < row.getLastCellNum(); ++colNum) {
                    Cell cell = row.getCell(colNum);
                    if (cell == null) continue;
                    String colName = cell.getStringCellValue();
                    String[] colNameArr = colName.split("#");
                    if (colNameArr.length == 1) {
                        String[] colPropNameArr = colNameArr[0].split("\\*");
                        String propNum = colPropNameArr[colPropNameArr.length - 1];
                        if (!propNumber.equals(propNum)) continue;
                        numberIndex = cell.getColumnIndex();
                        break;
                    }
                    String propNum = colNameArr[1].trim();
                    if (!"number".equals(propNum)) continue;
                    numberIndex = cell.getColumnIndex();
                    break;
                }
            }
            if (i <= headIndex) continue;
            Cell numberCell = row.getCell(numberIndex);
            if (numberCell != null) {
                numberList.add(numberCell.getStringCellValue());
                continue;
            }
            this.logger.info(String.format("numberCell = null\uff0ci=%s\uff0cheadIndex=%s\uff0cnumberIndex=%s", i, headIndex, numberIndex));
        }
        QFilter[] filters = new QFilter[]{new QFilter("costcenter.number", "in", numberList)};
        String selectFields = "id AS entryid,costcenter.number AS costCenterNum,sourcetype.name AS sourcetypeobj,data AS data,sourcetype.number AS srcTypeNum,sourcetype.name AS srcTypeName";
        DynamicObjectCollection costCenterSources = QueryServiceHelper.query((String)"bos_costcentersource", (String)selectFields, (QFilter[])filters);
        for (DynamicObject costCenterSource : costCenterSources) {
            costCenterSrcMap.computeIfAbsent(costCenterSource.getString("costCenterNum"), s -> new ArrayList()).add(costCenterSource);
            srcTypeSet.add(costCenterSource.get("data"));
            if (StringUtils.isEmpty((CharSequence)costCenterSource.getString("srcTypeNum"))) continue;
            srcTypeNumSet.add(costCenterSource.getString("srcTypeNum"));
        }
        for (String number : numberList) {
            if (costCenterSrcMap.containsKey(number)) continue;
            costCenterSrcMap.put(number, null);
        }
    }

    private int getHeadIndex(Sheet sheet) {
        if (this.getPageCache().get("count") == null) {
            return 0;
        }
        int count = Integer.parseInt(this.getPageCache().get("count"));
        int lastRowNum = sheet.getLastRowNum();
        int headIndex = lastRowNum - count;
        return headIndex;
    }

    private void setCellEntryValue(Row row, Integer cellIndex, String propValue) {
        if (cellIndex == null) {
            return;
        }
        Cell currCell = row.getCell(cellIndex.intValue());
        if (currCell == null) {
            currCell = row.createCell(cellIndex.intValue());
        }
        currCell.setCellValue(propValue);
    }

    private String getAppId() {
        String appNumber;
        String appId = null;
        switch (appNumber = this.getView().getFormShowParameter().getAppId().toLowerCase()) {
            case "basedata": {
                appId = "83bfebc8000037ac";
                break;
            }
            case "sca": {
                appId = APPID_SCA;
                break;
            }
            case "aca": {
                appId = APPID_ACA;
                break;
            }
            default: {
                appId = "83bfebc8000037ac";
            }
        }
        return appId;
    }

    private void setSourceData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.isEmpty()) {
            return;
        }
        DataSet sourceTypeDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getSourceType"), (String)"bos_costcentersourcetype", (String)"id,bizobject", null, null, (int)100);
        QFilter[] filters = new QFilter[]{new QFilter("entryentity.id", "in", (Object)rows.getEntryPrimaryKeyValues()), new QFilter("entryentity.id", ">", (Object)0L)};
        DataSet entryDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".sourceDataSet"), (String)"bos_costcenter", (String)"entryentity.id entryid,entryentity.sourcetype sourcetypeid,entryentity.data dataid", (QFilter[])filters, null);
        entryDataSet = entryDataSet.leftJoin(sourceTypeDataSet.copy()).on("sourcetypeid", "id").select(new String[]{"entryid", "sourcetypeid", "dataid"}, new String[]{"bizobject"}).finish();
        if ((entryDataSet = this.getSourceTypeDataSet(entryDataSet, sourceTypeDataSet)) == null) {
            return;
        }
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        for (kd.bos.algo.Row row : entryDataSet) {
            result.put(row.getLong("entryid"), row.getString("name"));
        }
        for (ListSelectedRow row : rows) {
            String value = (String)result.get(row.getEntryPrimaryKeyValue());
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            billList.setCellFieldValue("sourcedata", row.getRowKey(), (Object)value);
        }
    }

    private void updateCostCenterLongNumber() {
        QFilter qFilter = new QFilter("parent", "=", (Object)0L);
        DataSet updateDataSet = QueryServiceHelper.queryDataSet((String)"queryCostCenter", (String)"bos_costcenter", (String)"id,parent,number,name", (QFilter[])qFilter.toArray(), null);
        HashMap<Long, String> longNumberMap = new HashMap<Long, String>(256);
        HashMap<Long, String> fullNameMap = new HashMap<Long, String>(256);
        HashSet<Long> rootParentIds = new HashSet<Long>(16);
        for (kd.bos.algo.Row row : updateDataSet) {
            Long id = row.getLong("id");
            String number = row.getString("number");
            String name = row.getString("name");
            longNumberMap.put(id, number);
            fullNameMap.put(id, name);
            rootParentIds.add(id);
        }
        String longNumberDLM = CostCenterTreeUtils.getLongNumberDML();
        this.queryChildData(rootParentIds, longNumberMap, fullNameMap, longNumberDLM);
        if (longNumberMap.size() > 0) {
            DynamicObject[] costCenterBills;
            QFilter idQFilter = new QFilter("id", "in", longNumberMap.keySet());
            for (DynamicObject costCenter : costCenterBills = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,longnumber,fullname", (QFilter[])idQFilter.toArray())) {
                long costCenterId = costCenter.getLong("id");
                costCenter.set("longnumber", longNumberMap.get(costCenterId));
                costCenter.set("fullname", fullNameMap.get(costCenterId));
            }
            SaveServiceHelper.update((DynamicObject[])costCenterBills);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u957f\u7f16\u7801\u66f4\u65b0\u6210\u529f\u3002", (String)"CostCenterTreeListPlugin_10", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void queryChildData(Set<Long> parentIds, Map<Long, String> longNumberMap, Map<Long, String> fullNameMap, String longNumberDLM) {
        QFilter parentFilter = new QFilter("parent", "in", parentIds);
        DataSet levelDataSet = QueryServiceHelper.queryDataSet((String)"queryCostCenter", (String)"bos_costcenter", (String)"id,parent,number,name", (QFilter[])parentFilter.toArray(), null);
        if (levelDataSet == null || levelDataSet.isEmpty()) {
            return;
        }
        HashSet<Long> currentParentIds = new HashSet<Long>(16);
        String longNumberFormat = "%s" + longNumberDLM + "%s";
        for (kd.bos.algo.Row row : levelDataSet) {
            long parentId = row.getLong("parent");
            Long id = row.getLong("id");
            String number = row.getString("number");
            String name = row.getString("name");
            String parentNumber = longNumberMap.get(parentId);
            String parentName = fullNameMap.get(parentId);
            String longNumber = String.format(longNumberFormat, parentNumber, number);
            String fullName = String.format(longNumberFormat, parentName, name);
            longNumberMap.put(id, longNumber);
            fullNameMap.put(id, fullName);
            currentParentIds.add(id);
        }
        this.queryChildData(currentParentIds, longNumberMap, fullNameMap, longNumberDLM);
    }

    private void updateCostCenterEntryData() {
        DBRoute route = DBRoute.of((String)"sys");
        String strSql = "SELECT FCOSTCENTERID,FSOURCETYPEID,FDATAID,FSEQ FROM T_BAS_COSTCENTERSOURCE WHERE FCOSTCENTERID NOT IN (SELECT FID FROM T_BAS_COSTCENTERENTRY);";
        DataSet updateDataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".updateCostCenterEntryData"), (DBRoute)route, (String)strSql);
        int count = updateDataSet.copy().count("FCOSTCENTERID", false);
        Iterator it = updateDataSet.iterator();
        long[] ids = DB.genLongIds((String)"T_BAS_COSTCENTERENTRY", (int)count);
        String insertSql = "INSERT INTO T_BAS_COSTCENTERENTRY(FID,FENTRYID,FSEQ,FDATAID,FSOURCETYPEID) VALUES(?,?,?,?,?);";
        ArrayList<SqlParameter[]> params = new ArrayList<SqlParameter[]>(16);
        int index = 0;
        while (it.hasNext()) {
            kd.bos.algo.Row row = (kd.bos.algo.Row)it.next();
            SqlParameter[] param = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)row.getLong("FCOSTCENTERID")), new SqlParameter(":FENTRYID", -5, (Object)ids[index]), new SqlParameter(":FSEQ", 4, (Object)row.getInteger("FSEQ")), new SqlParameter(":FDATAID", -5, (Object)row.getLong("FDATAID")), new SqlParameter(":FSOURCETYPEID", -5, (Object)row.getLong("FSOURCETYPEID"))};
            params.add(param);
            ++index;
        }
        if (params.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u9700\u540c\u6b65\u5206\u5f55\u6570\u636e\u3002", (String)"CostCenterTreeListPlugin_11", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return;
        }
        DB.executeBatch((DBRoute)route, (String)insertSql, params);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5206\u5f55\u6570\u636e\u64cd\u4f5c\u6210\u529f\u3002", (String)"CostCenterTreeListPlugin_12", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private DataSet getSourceTypeDataSet(DataSet entryDataSet, DataSet sourceTypeDataSet) {
        Iterator it = sourceTypeDataSet.iterator();
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(3);
        DataSet data = null;
        while (it.hasNext()) {
            String entityName = ((kd.bos.algo.Row)it.next()).getString("bizobject");
            DataSet bizObjectDataSet = this.getBizObjectDataSet(entryDataSet, entityName);
            if (bizObjectDataSet == null) continue;
            if (data == null) {
                data = bizObjectDataSet;
                continue;
            }
            dataSets.add(bizObjectDataSet);
        }
        if (data == null) {
            return null;
        }
        data = dataSets.isEmpty() ? data : data.union(dataSets.toArray(new DataSet[0]));
        entryDataSet = entryDataSet.leftJoin(data).on("dataid", "id").on("bizobject", "bizobject").select(new String[]{"entryid", "sourcetypeid", "dataid", "bizobject"}, new String[]{"name"}).finish();
        return entryDataSet;
    }

    private DataSet getBizObjectDataSet(DataSet entryDataSet, String entityName) {
        DataSet data = entryDataSet.copy().filter(String.format("bizobject = '%s'", entityName));
        HashSet<Long> ids = new HashSet<Long>();
        Iterator it = data.iterator();
        while (it.hasNext()) {
            ids.add(((kd.bos.algo.Row)it.next()).getLong("dataid"));
        }
        if (ids.isEmpty()) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getDataSetNameById." + entityName), (String)entityName, (String)String.format("id,name,'%s' bizobject", entityName), (QFilter[])filters, null);
    }
}

