/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.service.common.OrgManagerUtils;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orgview.costcenter.CostCenterTreeUtils;
import kd.bos.orgview.costcenter.CostOrgViewSchemaTreeUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class QuickAddCostCenterFormPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(QuickAddCostCenterFormPlugin.class);
    public static final String AP_BIZ_UNIT_TREE = "bizunittree";
    public static final String AP_BIZ_VIEW_TREE = "bizviewtree";
    public static final String LASTTIME_CLICK_NODE = "lasttime_click_node";
    public static final String CACHE_ORG_UNIT_TREE_ROOTNODE = "CACHE_ORG_UNIT_TREE_ROOTNODE";
    public static final String CACHE_ORG_UNIT_TREE_ROOTNODE_CHECKED = "CACHE_ORG_UNIT_TREE_ROOTNODE_CHECKED";
    public static final String CACHE_ORG_VIEW_TREE_ROOTNODE = "CACHE_ORG_VIEW_TREE_ROOTNODE";
    public static final String CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED = "CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED";
    public static final String KEY_ADDNODE = "_addNode_";
    public static final String KEY_UPDATENODE = "_updateNode_";
    public static final String KEY_DELETENODE = "_deleteNode_";
    public static final String IS_CHECK_UNIT_CHILD = "ischeckunitchild";
    public static final String IS_CHECK_VIEW_CHILD = "ischeckviewchild";
    public static final String ENTITY_COST_CENTER = "bos_costcenter";
    public static final String ENTITY_COST_CENTER_SOURCE = "bos_costcentersource";
    public static final long ADMIN_SOURCE_TYPE_ID = 708643427767573504L;

    public void registerListener(EventObject e) {
        Search viewsearchap;
        this.registerTreeListener((TreeView)this.getControl(AP_BIZ_UNIT_TREE));
        this.registerTreeListener((TreeView)this.getControl(AP_BIZ_VIEW_TREE));
        this.addClickListeners(new String[]{"btn_addnode", "btn_deletenode", "btn_uncheckunit", "btn_uncheckview", "btn_stepaddnode"});
        this.addItemClickListeners(new String[]{"tbmain", "toolbarap"});
        Search orgsearchap = (Search)this.getView().getControl("orgsearchap");
        if (orgsearchap != null) {
            orgsearchap.addEnterListener((SearchEnterListener)this);
        }
        if ((viewsearchap = (Search)this.getView().getControl("viewsearchap")) != null) {
            viewsearchap.addEnterListener((SearchEnterListener)this);
        }
    }

    private void registerTreeListener(TreeView treeView) {
        if (treeView == null) {
            return;
        }
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getRootNodeFromCache(this.getLeftTreeViewSchema()) == null) {
            this.initAfterCreateNewData();
        } else {
            this.clearSearchText();
        }
    }

    public void initAfterCreateNewData() {
        this.initViewTree(AP_BIZ_UNIT_TREE, "0", "01");
        this.enableAddNodeButton();
        String schemaId = "costCenter";
        this.initCostCenterTree(AP_BIZ_VIEW_TREE, "0", schemaId);
    }

    private void initCostCenterTree(String treeKey, String strZero, String schemaId) {
        TreeView treeView = (TreeView)this.getControl(treeKey);
        TreeNode rootNode = this.initCostCenterTreeRootNode(treeView, schemaId);
        if (rootNode == null) {
            if (AP_BIZ_VIEW_TREE.equals(treeKey)) {
                TreeView unitTreeView = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
                unitTreeView.setMulti(false);
            }
        } else {
            treeView.addNodes(this.queryCostCenterTreeNodeChildren(treeKey, rootNode.getId(), schemaId));
        }
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
    }

    private TreeNode initCostCenterTreeRootNode(TreeView treeView, String schemaId) {
        treeView.deleteAllNodes();
        if ("0".equals(schemaId)) {
            return null;
        }
        List<TreeNode> nodes = this.queryCostCenterTreeNodeChildren(treeView.getKey(), "0", schemaId);
        if (Utils.isListEmpty(nodes)) {
            return null;
        }
        TreeNode rootNode = nodes.get(0);
        rootNode.setParentid("");
        rootNode.setIsOpened(true);
        this.updateRootNodeCache(schemaId, rootNode);
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        return rootNode;
    }

    private List<TreeNode> queryCostCenterTreeNodeChildren(String treeKey, String parentId, String schemaId) {
        return this.queryCostCenterTreeNodeChildren(treeKey, parentId, schemaId, false);
    }

    private List<TreeNode> queryCostCenterTreeNodeChildren(String treeKey, String parentId, String schemaId, boolean isCheckChildren) {
        TreeNode curNode;
        if ("0".equals(schemaId)) {
            return new ArrayList<TreeNode>(0);
        }
        TreeNode rootNode = this.getRootNodeFromCache(schemaId);
        String selectFields = "id, enable,number, name, parent,longnumber,isleaf";
        boolean showDisableCenter = (Boolean)this.getModel().getValue("showdisablecenter");
        QFilter viewFilter = showDisableCenter ? null : new QFilter("enable", "=", (Object)Boolean.TRUE);
        String longnumber = "";
        if (isCheckChildren && rootNode != null && (curNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)parentId)) != null) {
            longnumber = curNode.getLongNumber();
        }
        QFilter parentFilter = null;
        if (StringUtils.isBlank((CharSequence)longnumber)) {
            parentFilter = new QFilter("parent", "=", (Object)Long.parseLong(parentId));
        } else {
            if (longnumber.indexOf(33) == -1) {
                if (AP_BIZ_VIEW_TREE.equals(treeKey)) {
                    this.getPageCache().put(CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED, "");
                } else {
                    this.getPageCache().put(CACHE_ORG_UNIT_TREE_ROOTNODE_CHECKED, "");
                }
            }
            parentFilter = new QFilter("longnumber", "like", (Object)(longnumber + "!" + "%"));
        }
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        DynamicObjectCollection costCenterCol = QueryServiceHelper.query((String)ENTITY_COST_CENTER, (String)selectFields, (QFilter[])filters, (String)"level,longnumber");
        if (Utils.isListEmpty((List)costCenterCol)) {
            return new ArrayList<TreeNode>(0);
        }
        int count = costCenterCol.size();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(count);
        List<String> newParentList = this.getUpdateCache(treeKey);
        List<String> deleteList = this.getDeleteCache(treeKey);
        HashMap<String, TreeNode> notLeafNodeMap = new HashMap<String, TreeNode>(count);
        ArrayList<Long> notLeafNodeIds = new ArrayList<Long>(count);
        for (DynamicObject costCenterObj : costCenterCol) {
            String nodeId = String.valueOf(costCenterObj.getLong("id"));
            if (newParentList.contains(nodeId) || deleteList.contains(nodeId)) continue;
            String curParentId = costCenterObj.getString("parent");
            String name = costCenterObj.getString("name");
            String number = costCenterObj.getString("number");
            String longNumber = costCenterObj.getString("longnumber");
            boolean isleaf = costCenterObj.getBoolean("isleaf");
            TreeNode node = new TreeNode(curParentId, nodeId, this.getShowName(name, number, costCenterObj.getBoolean("enable"), false));
            node.setLongNumber(longNumber);
            if (!isleaf) {
                node.setChildren(new ArrayList());
                if (!"0".equals(nodeId)) {
                    notLeafNodeIds.add(Long.parseLong(nodeId));
                    notLeafNodeMap.put(nodeId, node);
                }
            }
            nodeList.add(node);
            if (rootNode == null || OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId) != null) continue;
            TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)curParentId);
            if (parentNode == null) {
                rootNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        this.rebuildCostCenterTreeNodeLeaf(notLeafNodeMap, notLeafNodeIds, viewFilter);
        if (rootNode != null) {
            this.updateRootNodeCache(schemaId, rootNode);
        }
        return nodeList;
    }

    private String getShowName(String name, String number, boolean isEnable, boolean isFreeze) {
        String showName = String.format("%s -%s", name, number);
        if (!isEnable) {
            showName = String.format("\uff08%s\uff09%s", ResManager.loadKDString((String)"\u7981\u7528", (String)"QuickAddCostCenterFormPlugin_18", (String)"bd-assistant-formplugin", (Object[])new Object[0]), showName);
        }
        if (isFreeze) {
            showName = String.format("\uff08%s\uff09%s", ResManager.loadKDString((String)"\u5c01\u5b58", (String)"QuickAddCostCenterFormPlugin_19", (String)"bd-assistant-formplugin", (Object[])new Object[0]), showName);
        }
        return showName;
    }

    private void rebuildCostCenterTreeNodeLeaf(Map<String, TreeNode> notLeafNodeMap, List<Long> notLeafNodeIds, QFilter viewFilter) {
        if (notLeafNodeIds.isEmpty()) {
            return;
        }
        QFilter parentFilter = new QFilter("parent", "in", notLeafNodeIds);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.costcenter.QuickAddCostCenterFormPlugin.rebuildCostCenterTreeNodeLeaf", (String)ENTITY_COST_CENTER, (String)"parent", (QFilter[])filters, (String)"");){
            if (ds.hasNext()) {
                for (Row row : ds) {
                    notLeafNodeMap.remove(row.getString("parent"));
                }
            }
        }
        for (TreeNode node : notLeafNodeMap.values()) {
            node.setChildren(null);
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        Search search = (Search)evt.getSource();
        if ("orgsearchap".equals(search.getKey())) {
            TreeView treeView = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
            CostOrgViewSchemaTreeUtils.searchTreeNode(this.getView(), treeView, this.getLeftTreeViewSchema(), searchText);
        } else {
            TreeView treeView = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
            CostCenterTreeUtils.searchTreeNode(this.getView(), treeView, this.getCostCenterKey(), searchText);
        }
    }

    private void enableAddNodeButton() {
        DynamicObject schemaObj = this.getModel().getDataEntity();
        if (schemaObj == null) {
            return;
        }
        boolean isAddNodeAble = true;
        this.getView().setEnable(Boolean.valueOf(isAddNodeAble), new String[]{"viewschemapanel"});
        this.getView().setEnable(Boolean.valueOf(isAddNodeAble), new String[]{"treeviewpanel"});
        this.getView().setEnable(Boolean.valueOf(isAddNodeAble), new String[]{"bar_new"});
        this.getView().setEnable(Boolean.valueOf(isAddNodeAble), new String[]{"bar_save"});
    }

    public String getCostCenterKey() {
        return "costCenter";
    }

    private void changeBizUnitTreeMulti(boolean isMulti) {
        TreeView bizUnitTree = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
        bizUnitTree.setMulti(isMulti);
        if (isMulti) {
            bizUnitTree.uncheckNodes(bizUnitTree.getTreeState().getSelectedNodeId());
        } else {
            bizUnitTree.focusNode(new TreeNode("", Long.toString(OrgUnitServiceHelper.getRootOrgId()), ""));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String itemKey;
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        switch (itemKey = ((Button)src).getKey()) {
            case "btn_addnode": {
                if (this.isAddAble(false)) break;
                evt.setCancel(true);
                break;
            }
            case "btn_stepaddnode": {
                if (this.isAddAble(true)) break;
                evt.setCancel(true);
                break;
            }
            case "btn_deletenode": {
                if (this.isDeleteAble()) break;
                evt.setCancel(true);
                break;
            }
            case "bar_close": {
                if (this.isDeleteAble()) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    private long getAccountOrg(long orgId, int count) {
        if (count >= 50) {
            return 0L;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", orgIds);
        if (directSuperiorOrg != null && !directSuperiorOrg.isEmpty()) {
            long parentOrgId = (Long)directSuperiorOrg.values().iterator().next();
            boolean isAccountOrg = OrgUnitServiceHelper.checkOrgFunction((Long)parentOrgId, (String)"10");
            if (isAccountOrg) {
                return parentOrgId;
            }
            return this.getAccountOrg(parentOrgId, ++count);
        }
        return 0L;
    }

    private boolean isAddAble(boolean isStepAdd) {
        TreeView bizUnitTree = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
        String focusNodeId = bizUnitTree.getTreeState().getFocusNodeId();
        ArrayList<String> selectedList = bizUnitTree.getTreeState().getSelectedNodeId();
        if (Utils.isListEmpty((List)selectedList)) {
            if (StringUtils.isBlank((CharSequence)focusNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"QuickAddCostCenterFormPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return false;
            }
            selectedList = new ArrayList<String>(1);
            selectedList.add(focusNodeId);
        }
        String bizViewRootNodeCache = this.getPageCache().get(CACHE_ORG_VIEW_TREE_ROOTNODE);
        boolean isHasRootNode = false;
        if (StringUtils.isNotBlank((CharSequence)bizViewRootNodeCache)) {
            isHasRootNode = true;
        }
        TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
        String bizViewParentId = "";
        List bizViewParentIds = bizViewTree.getTreeState().getSelectedNodeId();
        if (Utils.isListEmpty((List)bizViewParentIds)) {
            if (isHasRootNode) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4ece%s\u6811\u9009\u62e9\u4e00\u4e2a\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e3a\u4e0a\u7ea7\u3002", (String)"QuickAddCostCenterFormPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]), this.getRightTreeViewTitle()));
                return false;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6839\u8282\u70b9\uff0c\u8bf7\u624b\u5de5\u589e\u52a0\u4e00\u4e2a\u6210\u672c\u4e2d\u5fc3\u505a\u4e3a\u6839\u8282\u70b9\u3002", (String)"QuickAddCostCenterFormPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return false;
        }
        int selectedCount = bizViewParentIds.size();
        if (selectedCount > 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4ece%1$s\u6811\u9009\u62e9\u4e00\u4e2a\u6210\u672c\u4e2d\u5fc3\u4f5c\u4e3a\u4e0a\u7ea7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%2$s\u3002", (String)"QuickAddCostCenterFormPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), this.getRightTreeViewTitle(), selectedCount));
            return false;
        }
        bizViewParentId = (String)bizViewParentIds.get(0);
        HashSet<String> filterCostCenterNumber = new HashSet<String>(16);
        if (isStepAdd ? !this.isStepFullNameValid(bizViewParentId, bizUnitTree, filterCostCenterNumber) : !this.isFullnameValid(bizViewParentId, bizUnitTree, filterCostCenterNumber)) {
            return false;
        }
        if (!this.isNumberValid(selectedList, filterCostCenterNumber)) {
            return false;
        }
        if (this.isFreezeOrEnable(selectedList)) {
            return false;
        }
        this.updateAddNodeCache(selectedList, bizViewParentId, isStepAdd, filterCostCenterNumber);
        return true;
    }

    private boolean isFreezeOrEnable(List<String> selectedList) {
        String selectFields = "number,name";
        HashSet<Long> selectedIds = new HashSet<Long>(10);
        for (String selected : selectedList) {
            selectedIds.add(Long.parseLong(selected));
        }
        QFilter idFilter = new QFilter("id", "in", selectedIds);
        QFilter stateFilter = new QFilter("structure.isfreeze", "=", (Object)Boolean.TRUE);
        stateFilter.or("enable", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{idFilter, stateFilter};
        StringBuilder sb = new StringBuilder();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.costcenter.QuickAddCostCenterFormPlugin.isFreezeOrEnable", (String)"bos_org", (String)selectFields, (QFilter[])filters, null);){
            for (Row row : ds) {
                sb.append(row.getString("name")).append(" -").append(row.getString("number")).append("\u3001");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5c01\u5b58\u6216\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u6210\u672c\u4e2d\u5fc3\u3002", (String)"QuickAddCostCenterFormPlugin_20", (String)"bd-assistant-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)));
            return true;
        }
        return false;
    }

    private boolean isStepFullNameValid(String bizViewParentId, TreeView bizUnitTree, Set<String> filterCostCenterNumber) {
        List selectedNodeList = bizUnitTree.getTreeState().getSelectedNodes();
        ArrayList allSelectIds = new ArrayList(selectedNodeList.size());
        selectedNodeList.forEach(s -> allSelectIds.add(s.get("id")));
        ArrayList selectedNameList = new ArrayList(selectedNodeList.size());
        for (Map nodeMap : selectedNodeList) {
            if (allSelectIds.contains(nodeMap.get("parentid"))) continue;
            selectedNameList.add(nodeMap.get("text"));
        }
        String selectFields = "parent.name parent,name,enable,number";
        QFilter nameFilter = new QFilter("name", "in", selectedNameList);
        QFilter parentFilter = new QFilter("parent", "=", (Object)Long.parseLong(bizViewParentId));
        QFilter[] filters = new QFilter[]{nameFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.costcenter.QuickAddCostCenterFormPlugin.isStepFullNameValid", (String)ENTITY_COST_CENTER, (String)selectFields, (QFilter[])filters, (String)"level", (int)-1);){
            for (Row row : ds) {
                filterCostCenterNumber.add(row.getString("number"));
            }
        }
        return true;
    }

    private boolean isFullnameValid(String bizViewParentId, TreeView bizUnitTree, Set<String> filterCostCenterNumber) {
        List selectedNodeList = bizUnitTree.getTreeState().getSelectedNodes();
        ArrayList selectedNameList = new ArrayList(selectedNodeList.size());
        for (Map nodeMap : selectedNodeList) {
            selectedNameList.add(nodeMap.get("text"));
        }
        String selectFields = "parent.name parent,name,enable,number";
        QFilter nameFilter = new QFilter("name", "in", selectedNameList);
        QFilter parentFilter = new QFilter("parent", "=", (Object)Long.parseLong(bizViewParentId));
        QFilter[] filters = new QFilter[]{nameFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.costcenter.QuickAddCostCenterFormPlugin.isFullnameValid", (String)ENTITY_COST_CENTER, (String)selectFields, (QFilter[])filters, (String)"level", (int)-1);){
            for (Row row : ds) {
                filterCostCenterNumber.add(row.getString("number"));
            }
        }
        return true;
    }

    private boolean isNumberValid(List<String> selectedList, Set<String> filterCostCenterNumber) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)ENTITY_COST_CENTER, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)ENTITY_COST_CENTER), (String)"");
        if (codeRuleInfo != null) {
            return true;
        }
        String selectFields = "id,number,name";
        HashSet<Long> selectedIds = new HashSet<Long>(10);
        for (String selected : selectedList) {
            selectedIds.add(Long.parseLong(selected));
        }
        QFilter idFilter = new QFilter("id", "in", selectedIds);
        QFilter[] filters = new QFilter[]{idFilter};
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (orgMap == null || orgMap.isEmpty()) {
            return true;
        }
        int count = orgMap.size();
        ArrayList<String> orgNumberList = new ArrayList<String>(count);
        for (Map.Entry entry : orgMap.entrySet()) {
            DynamicObject orgObj = (DynamicObject)entry.getValue();
            String number = orgObj.getString("number");
            orgNumberList.add(number);
        }
        selectFields = "id,number,name";
        QFilter numberFilter = new QFilter("number", "in", orgNumberList);
        filters = new QFilter[]{numberFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.costcenter.QuickAddCostCenterFormPlugin.isNumberValid", (String)ENTITY_COST_CENTER, (String)selectFields, (QFilter[])filters, (String)"level", (int)-1);){
            for (Row row : ds) {
                filterCostCenterNumber.add(row.getString("number"));
            }
        }
        return true;
    }

    private void updateAddNodeCache(List<String> selectedList, String bizViewParentId, boolean isStepAdd, Set<String> filterCostCenterNumber) {
        ArrayList<String> addNodeList = new ArrayList<String>(selectedList.size());
        String bizViewRootNodeCache = this.getPageCache().get(CACHE_ORG_VIEW_TREE_ROOTNODE);
        TreeNode bizViewRootNode = null;
        ArrayList nodeIdList = new ArrayList();
        selectedList.forEach(s -> {
            if (StringUtils.isNotBlank((CharSequence)s)) {
                nodeIdList.add(Long.parseLong(s));
            }
        });
        QFilter orgFilter = new QFilter("id", "in", nodeIdList);
        DataSet orgInfoDs = QueryServiceHelper.queryDataSet((String)"QuickAddCostCenterGetOrgInfo", (String)"bos_org", (String)"id,number", (QFilter[])orgFilter.toArray(), null);
        HashMap orgIdToNumberMap = new HashMap(16);
        orgInfoDs.forEach(s -> orgIdToNumberMap.put(s.getString("id"), s.getString("number")));
        if (StringUtils.isNotBlank((CharSequence)bizViewRootNodeCache)) {
            bizViewRootNode = (TreeNode)SerializationUtils.fromJsonString((String)bizViewRootNodeCache, TreeNode.class);
        }
        for (String nodeId : selectedList) {
            String orgNumber;
            TreeNode addedNode;
            if (bizViewParentId.equals(nodeId) || bizViewRootNode != null && (addedNode = OrgTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)nodeId)) != null && addedNode.getChildren() != null || filterCostCenterNumber.contains(orgNumber = (String)orgIdToNumberMap.get(nodeId))) continue;
            addNodeList.add(nodeId);
        }
        ArrayList<String> addToViewNodeList = new ArrayList<String>();
        this.removeDeletedNodeFromCache(addNodeList, addToViewNodeList, bizViewParentId);
        this.removeAddedNodeFromCache(addNodeList, bizViewParentId);
        HashMap<String, String> costCenterMap = new HashMap<String, String>();
        TreeView bizUnitTree = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
        if (!addNodeList.isEmpty()) {
            HashSet currentSelectNodeIds = new HashSet(16);
            List selectedNodes = bizUnitTree.getTreeState().getSelectedNodes();
            if (isStepAdd) {
                selectedNodes.forEach(s -> {
                    if (s.get("id") != null) {
                        currentSelectNodeIds.add(String.valueOf(s.get("id")));
                    }
                });
            }
            HashMap curAddCacheMap = new HashMap(addNodeList.size());
            for (Map nodeMap : selectedNodes) {
                String nodeId = String.valueOf(nodeMap.get("id"));
                if (!addNodeList.contains(nodeId)) continue;
                String name = String.valueOf(nodeMap.get("text"));
                HashMap<String, String> dataMap = new HashMap<String, String>();
                if (isStepAdd) {
                    boolean isSelectTopNode = false;
                    String parentNodeId = null;
                    if (nodeMap.get("parentid") != null && !currentSelectNodeIds.contains(parentNodeId = String.valueOf(nodeMap.get("parentid")))) {
                        isSelectTopNode = true;
                    }
                    if (isSelectTopNode || parentNodeId == null) {
                        dataMap.put("parentid", bizViewParentId);
                    } else {
                        dataMap.put("parentid", parentNodeId);
                    }
                } else {
                    dataMap.put("parentid", bizViewParentId);
                }
                dataMap.put("text", name);
                curAddCacheMap.put(nodeId, dataMap);
            }
            String addCache = this.getPageCache().get(KEY_ADDNODE);
            Map addCacheMap = null;
            if (StringUtils.isNotBlank((CharSequence)addCache)) {
                addCacheMap = (Map)SerializationUtils.fromJsonString((String)addCache, Map.class);
            }
            if (addCacheMap == null) {
                addCacheMap = curAddCacheMap;
            } else {
                addCacheMap.putAll(curAddCacheMap);
            }
            this.getPageCache().put(KEY_ADDNODE, SerializationUtils.toJsonString(addCacheMap));
        }
        addToViewNodeList.addAll(addNodeList);
        if (isStepAdd) {
            this.stepAddNodeToViewTree(bizUnitTree, selectedList, bizViewParentId, addToViewNodeList, costCenterMap);
        } else {
            this.addNodeToViewTree(bizUnitTree, selectedList, bizViewParentId, addToViewNodeList, costCenterMap);
        }
    }

    private void stepAddNodeToViewTree(TreeView bizUnitTree, List<String> selectedList, String bizViewParentId, List<String> addToViewNodeList, Map<String, String> costCenterMap) {
        TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
        String bizViewRootNodeCache = this.getPageCache().get(CACHE_ORG_VIEW_TREE_ROOTNODE);
        TreeNode bizViewRootNode = null;
        List bizViewParentIds = bizViewTree.getTreeState().getSelectedNodeId();
        if (StringUtils.isNotBlank((CharSequence)bizViewRootNodeCache)) {
            bizViewRootNode = (TreeNode)SerializationUtils.fromJsonString((String)bizViewRootNodeCache, TreeNode.class);
            if (Utils.isListNotEmpty((List)bizViewParentIds)) {
                bizViewParentId = (String)bizViewParentIds.get(0);
            }
        }
        List selectedUnitNodes = bizUnitTree.getTreeState().getSelectedNodes();
        String schemaId = this.getCostCenterKey();
        if (Utils.isListNotEmpty(addToViewNodeList)) {
            bizViewTree.deleteNodes(addToViewNodeList);
            HashSet currentSelectNodeIds = new HashSet(16);
            selectedUnitNodes.forEach(s -> {
                if (s.get("id") != null) {
                    currentSelectNodeIds.add(String.valueOf(s.get("id")));
                }
            });
            boolean isDataChanged = false;
            for (Map nodeMap : selectedUnitNodes) {
                TreeNode node;
                String costCenterId;
                String nodeId = String.valueOf(nodeMap.get("id"));
                if (!addToViewNodeList.contains(nodeId) && !addToViewNodeList.contains(costCenterId = costCenterMap.get(nodeId))) continue;
                String nodeParentId = String.valueOf(nodeMap.get("parentid"));
                String name = String.valueOf(nodeMap.get("text"));
                String parentId = bizViewParentId;
                if (currentSelectNodeIds.contains(nodeParentId)) {
                    parentId = nodeParentId;
                }
                if ((node = OrgTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)nodeId)) == null) {
                    node = new TreeNode(parentId, nodeId, name, false);
                } else {
                    TreeNode oldParentNode;
                    String oldParentId = node.getParentid();
                    if (bizViewRootNode != null) {
                        bizViewRootNode.deleteChildNode(node.getId());
                    }
                    if ((oldParentNode = OrgTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)oldParentId)) != null && Utils.isListEmpty((List)oldParentNode.getChildren())) {
                        oldParentNode.setChildren(null);
                        bizViewTree.updateNode(oldParentNode);
                    }
                    node.setParentid(bizViewParentId);
                    node.setChildren(null);
                }
                TreeNode bizViewParentNode = OrgTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)parentId);
                if (bizViewRootNode == null) {
                    bizViewRootNode = node;
                } else if (bizViewParentNode == null) {
                    bizViewRootNode.addChild(node);
                } else {
                    bizViewParentNode.addChild(node);
                }
                bizViewTree.addNode(node);
                isDataChanged = true;
            }
            if (isDataChanged) {
                this.updateRootNodeCache(schemaId, bizViewRootNode);
            }
        }
        bizViewTree.expand(bizViewParentId);
        bizViewTree.focusNode(new TreeNode("", bizViewParentId, ""));
        this.enableAddNodeButton();
        bizUnitTree.uncheckNodes(selectedList);
        bizUnitTree.setMulti(true);
    }

    private void addNodeToViewTree(TreeView bizUnitTree, List<String> selectedList, String bizViewParentId, List<String> addToViewNodeList, Map<String, String> costCenterMap) {
        TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
        String bizViewRootNodeCache = this.getPageCache().get(CACHE_ORG_VIEW_TREE_ROOTNODE);
        TreeNode bizViewRootNode = null;
        List bizViewParentIds = bizViewTree.getTreeState().getSelectedNodeId();
        if (StringUtils.isNotBlank((CharSequence)bizViewRootNodeCache)) {
            bizViewRootNode = (TreeNode)SerializationUtils.fromJsonString((String)bizViewRootNodeCache, TreeNode.class);
            if (Utils.isListNotEmpty((List)bizViewParentIds)) {
                bizViewParentId = (String)bizViewParentIds.get(0);
            }
        }
        List selectedUnitNodes = bizUnitTree.getTreeState().getSelectedNodes();
        String schemaId = this.getCostCenterKey();
        if (Utils.isListNotEmpty(addToViewNodeList)) {
            bizViewTree.deleteNodes(addToViewNodeList);
            boolean isDataChanged = false;
            for (Map nodeMap : selectedUnitNodes) {
                String costCenterId;
                String nodeId = String.valueOf(nodeMap.get("id"));
                if (!addToViewNodeList.contains(nodeId) && !addToViewNodeList.contains(costCenterId = costCenterMap.get(nodeId))) continue;
                String name = String.valueOf(nodeMap.get("text"));
                TreeNode node = OrgTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)nodeId);
                if (node == null) {
                    node = new TreeNode(bizViewParentId, nodeId, name, false);
                } else {
                    TreeNode oldParentNode;
                    String oldParentId = node.getParentid();
                    if (bizViewRootNode != null) {
                        bizViewRootNode.deleteChildNode(node.getId());
                    }
                    if ((oldParentNode = OrgTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)oldParentId)) != null && Utils.isListEmpty((List)oldParentNode.getChildren())) {
                        oldParentNode.setChildren(null);
                        bizViewTree.updateNode(oldParentNode);
                    }
                    node.setParentid(bizViewParentId);
                    node.setChildren(null);
                }
                TreeNode bizViewParentNode = OrgTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)bizViewParentId);
                if (bizViewRootNode == null) {
                    bizViewRootNode = node;
                } else if (bizViewParentNode == null) {
                    bizViewRootNode.addChild(node);
                } else {
                    bizViewParentNode.addChild(node);
                }
                bizViewTree.addNode(node);
                isDataChanged = true;
            }
            if (isDataChanged) {
                this.updateRootNodeCache(schemaId, bizViewRootNode);
            }
        }
        bizViewTree.expand(bizViewParentId);
        bizViewTree.focusNode(new TreeNode("", bizViewParentId, ""));
        this.enableAddNodeButton();
        bizUnitTree.uncheckNodes(selectedList);
        bizUnitTree.setMulti(true);
    }

    private void removeDeletedNodeFromCache(List<String> addNodeList, List<String> addToViewNodeList, String bizViewParentId) {
        if (addNodeList.isEmpty()) {
            return;
        }
        String deleteCache = this.getPageCache().get(KEY_DELETENODE);
        if (StringUtils.isBlank((CharSequence)deleteCache)) {
            return;
        }
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)deleteCache, Map.class);
        if (nodeMap == null || nodeMap.isEmpty()) {
            return;
        }
        HashMap<String, Map<String, Object>> curUpdateCacheMap = new HashMap<String, Map<String, Object>>(addNodeList.size());
        Iterator it = nodeMap.entrySet().iterator();
        while (!addNodeList.isEmpty() && it.hasNext()) {
            Map.Entry entry = it.next();
            String orgId = (String)entry.getKey();
            if (!addNodeList.contains(orgId)) continue;
            it.remove();
            addToViewNodeList.add(orgId);
            Map deletedNodeMap = (Map)entry.getValue();
            Object parentId = deletedNodeMap.get("parentid");
            if (bizViewParentId.equals(parentId)) {
                addNodeList.remove(orgId);
                continue;
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("parentid", bizViewParentId);
            dataMap.put("text", (String)deletedNodeMap.get("text"));
            curUpdateCacheMap.put(orgId, dataMap);
        }
        this.getPageCache().put(KEY_DELETENODE, SerializationUtils.toJsonString((Object)nodeMap));
        this.addNodeToUpdateCache(curUpdateCacheMap);
    }

    private void removeAddedNodeFromCache(List<String> addNodeList, String bizViewParentId) {
        if (addNodeList.isEmpty()) {
            return;
        }
        String addCache = this.getPageCache().get(KEY_ADDNODE);
        if (StringUtils.isBlank((CharSequence)addCache)) {
            return;
        }
        Map addCacheMap = (Map)SerializationUtils.fromJsonString((String)addCache, Map.class);
        if (addCacheMap == null || addCacheMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : addCacheMap.entrySet()) {
            String orgId = (String)entry.getKey();
            if (!addNodeList.contains(orgId) || !bizViewParentId.equals(((Map)entry.getValue()).get("parentid"))) continue;
            addNodeList.remove(orgId);
        }
    }

    private void addNodeToUpdateCache(Map<String, Map<String, Object>> curUpdateCacheMap) {
        if (curUpdateCacheMap.isEmpty()) {
            return;
        }
        String updateCache = this.getPageCache().get(KEY_UPDATENODE);
        HashMap<String, Map<String, Object>> updateCacheMap = null;
        if (StringUtils.isNotBlank((CharSequence)updateCache)) {
            updateCacheMap = (HashMap<String, Map<String, Object>>)SerializationUtils.fromJsonString((String)updateCache, Map.class);
        }
        if (updateCacheMap == null) {
            updateCacheMap = new HashMap<String, Map<String, Object>>();
        }
        updateCacheMap.putAll(curUpdateCacheMap);
        this.getPageCache().put(KEY_UPDATENODE, SerializationUtils.toJsonString(updateCacheMap));
    }

    private boolean isDeleteAble() {
        TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
        List selectedNodes = bizViewTree.getTreeState().getSelectedNodes();
        if (Utils.isListEmpty((List)selectedNodes)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4ece%s\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"QuickAddCostCenterFormPlugin_7", (String)"bd-assistant-formplugin", (Object[])new Object[0]), this.getRightTreeViewTitle()));
            return false;
        }
        String schemaId = this.getCostCenterKey();
        TreeNode rootNode = this.getRootNodeFromCache(schemaId);
        if (rootNode == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4ece%s\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"QuickAddCostCenterFormPlugin_7", (String)"bd-assistant-formplugin", (Object[])new Object[0]), this.getRightTreeViewTitle()));
            return false;
        }
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"83bfebc8000037ac", (String)ENTITY_COST_CENTER, (String)"47160c2b000000ac")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7981\u7528\u64cd\u4f5c\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\u6210\u672c\u4e2d\u5fc3\u3002", (String)"QuickAddCostCenterFormPlugin_8", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<TreeNode> allDeleteNodeList = new ArrayList<TreeNode>(selectedNodes.size());
        String rootId = rootNode.getId();
        boolean isDeleteRootNode = false;
        ArrayList<String> allDeleteNodeIds = new ArrayList<String>(selectedNodes.size());
        for (Map nodeMap : selectedNodes) {
            String nodeId = String.valueOf(nodeMap.get("id"));
            if (rootId.equals(nodeId)) {
                isDeleteRootNode = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u7ea7\u6210\u672c\u4e2d\u5fc3\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"QuickAddCostCenterFormPlugin_9", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return false;
            }
            TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
            allDeleteNodeIds.add(nodeId);
            if (treeNode == null) continue;
            allDeleteNodeList.add(treeNode);
            this.findAllChildren(treeNode, allDeleteNodeList, allDeleteNodeIds);
        }
        this.updateCacheWhenDeleteNode(selectedNodes, rootNode, allDeleteNodeList, isDeleteRootNode);
        return true;
    }

    private void updateCacheWhenDeleteNode(List<Map<String, Object>> selectedNodes, TreeNode rootNode, List<TreeNode> allDeleteNodeList, boolean isDeleteRootNode) {
        this.deleteNodeFromAddCache(rootNode, allDeleteNodeList);
        this.deleteNodeFromUpdateCache(rootNode, allDeleteNodeList);
        if (!allDeleteNodeList.isEmpty()) {
            HashMap curDeleteCacheMap = new HashMap(allDeleteNodeList.size(), 0.75f);
            ArrayList<TreeNode> updateParentNodes = new ArrayList<TreeNode>(allDeleteNodeList.size());
            for (TreeNode node : allDeleteNodeList) {
                String parentId = node.getParentid();
                String nodeId = node.getId();
                HashMap<String, String> nodeMap = new HashMap<String, String>();
                nodeMap.put("id", nodeId);
                nodeMap.put("parentid", parentId);
                nodeMap.put("text", node.getText());
                nodeMap.put("longnumber", node.getLongNumber());
                curDeleteCacheMap.put(nodeId, nodeMap);
                rootNode.deleteChildNode(nodeId);
                TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)node.getParentid());
                if (parentNode == null || !Utils.isListEmpty((List)parentNode.getChildren())) continue;
                parentNode.setChildren(null);
                updateParentNodes.add(parentNode);
            }
            String deleteCache = this.getPageCache().get(KEY_DELETENODE);
            Map deleteCacheMap = null;
            if (StringUtils.isNotBlank((CharSequence)deleteCache)) {
                deleteCacheMap = (Map)SerializationUtils.fromJsonString((String)deleteCache, Map.class);
            }
            if (deleteCacheMap == null) {
                deleteCacheMap = curDeleteCacheMap;
            } else {
                deleteCacheMap.putAll(curDeleteCacheMap);
            }
            this.getPageCache().put(KEY_DELETENODE, SerializationUtils.toJsonString(deleteCacheMap));
            if (!updateParentNodes.isEmpty()) {
                TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
                bizViewTree.updateNodes(updateParentNodes);
            }
        }
        this.deleteNodeFromViewTree(rootNode, isDeleteRootNode);
    }

    private void deleteNodeFromViewTree(TreeNode bizViewRootNode, boolean isDeleteRootNode) {
        TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
        String schemaId = this.getCostCenterKey();
        if (isDeleteRootNode) {
            bizViewTree.deleteAllNodes();
            bizViewRootNode = null;
        } else {
            List bizViewParentIds = bizViewTree.getTreeState().getSelectedNodeId();
            for (String nodeId : bizViewParentIds) {
                if (bizViewRootNode != null) {
                    bizViewRootNode.deleteChildNode(nodeId);
                }
                bizViewTree.deleteNode(nodeId);
            }
        }
        this.updateRootNodeCache(schemaId, bizViewRootNode);
        this.changeBizUnitTreeMulti(this.getRootNodeFromCache(schemaId) != null);
        this.enableAddNodeButton();
    }

    private void deleteNodeFromAddCache(TreeNode rootNode, List<TreeNode> allDeleteNodeList) {
        String addCache = this.getPageCache().get(KEY_ADDNODE);
        if (StringUtils.isBlank((CharSequence)addCache)) {
            return;
        }
        Map addCacheMap = (Map)SerializationUtils.fromJsonString((String)addCache, Map.class);
        if (addCacheMap == null || addCacheMap.isEmpty()) {
            return;
        }
        int count = allDeleteNodeList.size();
        ArrayList<TreeNode> cacheNodeList = new ArrayList<TreeNode>(count);
        ArrayList<TreeNode> updateParentNodes = new ArrayList<TreeNode>(count);
        for (TreeNode node : allDeleteNodeList) {
            String nodeId = node.getId();
            if (!addCacheMap.containsKey(nodeId)) continue;
            addCacheMap.remove(nodeId);
            cacheNodeList.add(node);
            rootNode.deleteChildNode(nodeId);
            TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)node.getParentid());
            if (parentNode == null || !Utils.isListEmpty((List)parentNode.getChildren())) continue;
            parentNode.setChildren(null);
            updateParentNodes.add(parentNode);
        }
        if (!updateParentNodes.isEmpty()) {
            TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
            bizViewTree.updateNodes(updateParentNodes);
        }
        if (cacheNodeList.isEmpty()) {
            return;
        }
        allDeleteNodeList.removeAll(cacheNodeList);
        if (addCacheMap == null || addCacheMap.isEmpty()) {
            this.getPageCache().remove(KEY_ADDNODE);
        } else {
            this.getPageCache().put(KEY_ADDNODE, SerializationUtils.toJsonString((Object)addCacheMap));
        }
    }

    private void deleteNodeFromUpdateCache(TreeNode rootNode, List<TreeNode> allDeleteNodeList) {
        if (allDeleteNodeList.isEmpty()) {
            return;
        }
        String updateCache = this.getPageCache().get(KEY_UPDATENODE);
        if (StringUtils.isBlank((CharSequence)updateCache)) {
            return;
        }
        Map updateCacheMap = (Map)SerializationUtils.fromJsonString((String)updateCache, Map.class);
        if (updateCacheMap == null || updateCacheMap.isEmpty()) {
            return;
        }
        int count = allDeleteNodeList.size();
        ArrayList<TreeNode> cacheNodeList = new ArrayList<TreeNode>(count);
        ArrayList<TreeNode> updateParentNodes = new ArrayList<TreeNode>(count);
        for (TreeNode node : allDeleteNodeList) {
            String nodeId = node.getId();
            if (!updateCacheMap.containsKey(nodeId)) continue;
            updateCacheMap.remove(nodeId);
            cacheNodeList.add(node);
            rootNode.deleteChildNode(nodeId);
            TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)node.getParentid());
            if (parentNode == null || !Utils.isListEmpty((List)parentNode.getChildren())) continue;
            parentNode.setChildren(null);
            updateParentNodes.add(parentNode);
        }
        if (!updateParentNodes.isEmpty()) {
            TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
            bizViewTree.updateNodes(updateParentNodes);
        }
        if (cacheNodeList.isEmpty()) {
            return;
        }
        allDeleteNodeList.removeAll(cacheNodeList);
        if (updateCacheMap == null || updateCacheMap.isEmpty()) {
            this.getPageCache().remove(KEY_UPDATENODE);
        } else {
            this.getPageCache().put(KEY_UPDATENODE, SerializationUtils.toJsonString((Object)updateCacheMap));
        }
    }

    public void click(EventObject evt) {
        String itemKey;
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        switch (itemKey = ((Button)src).getKey()) {
            case "btn_uncheckunit": {
                TreeView bizUnitTree = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
                List selectedUnitList = bizUnitTree.getTreeState().getSelectedNodeId();
                bizUnitTree.uncheckNodes(selectedUnitList);
                break;
            }
            case "btn_uncheckview": {
                TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
                List bizViewParentIds = bizViewTree.getTreeState().getSelectedNodeId();
                bizViewTree.uncheckNodes(bizViewParentIds);
                break;
            }
        }
    }

    private void clearSearchText() {
        Search viewsearchap;
        Search orgsearchap = (Search)this.getView().getControl("orgsearchap");
        if (orgsearchap != null) {
            orgsearchap.setSearchKey("");
        }
        if ((viewsearchap = (Search)this.getView().getControl("viewsearchap")) != null) {
            viewsearchap.setSearchKey("");
        }
    }

    public String getRightTreeViewTitle() {
        return ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3", (String)"QuickAddCostCenterFormPlugin_10", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        if (AP_BIZ_UNIT_TREE.equals(treeKey)) {
            this.orgUnitTreeNodeCheck(evt);
        } else {
            this.orgViewTreeNodeCheck(evt);
        }
    }

    public void orgUnitTreeNodeCheck(TreeNodeCheckEvent evt) {
        boolean isCheckChildren = (Boolean)this.getModel().getValue(IS_CHECK_UNIT_CHILD);
        if (!isCheckChildren) {
            return;
        }
        String schemaId = this.getLeftTreeViewSchema();
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        String nodeId = evt.getNodeId().toString();
        TreeNode rootNode = this.getRootNodeFromCache(schemaId);
        if (evt.getChecked().booleanValue()) {
            boolean isOpened = false;
            TreeNode nodeCache = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
            if (nodeCache != null) {
                if ((StringUtils.isNotBlank((CharSequence)nodeCache.getParentid()) || this.getPageCache().get(CACHE_ORG_UNIT_TREE_ROOTNODE_CHECKED) != null) && nodeCache.getIsOpened()) {
                    isOpened = true;
                    ArrayList<TreeNode> allChildren = new ArrayList<TreeNode>();
                    this.findAllChildren(nodeCache, allChildren, null);
                    treeView.checkNodes(allChildren);
                } else {
                    nodeCache.setIsOpened(true);
                    this.updateRootNodeCache(schemaId, rootNode);
                }
            }
            if (isOpened) {
                TreeNode node = new TreeNode(evt.getParentNodeId().toString(), nodeId, "");
                treeView.checkNode(node);
            } else {
                List<TreeNode> nodeList = this.queryViewTreeNodeChildren(treeKey, nodeId, schemaId, isCheckChildren);
                treeView.addNodes(nodeList);
                treeView.checkNodes(nodeList);
            }
        } else {
            TreeNode nodeCache = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
            if (nodeCache != null) {
                ArrayList<TreeNode> allChildren = new ArrayList<TreeNode>();
                this.findAllChildren(nodeCache, allChildren, null);
                ArrayList<String> nodes = new ArrayList<String>(allChildren.size() + 1);
                nodes.add(nodeId);
                for (TreeNode node : allChildren) {
                    nodes.add(node.getId());
                }
                treeView.uncheckNodes(nodes);
            }
        }
    }

    public void orgViewTreeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode nodeCache;
        boolean isCheckChildren = true;
        if (!isCheckChildren || !evt.getChecked().booleanValue()) {
            return;
        }
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        String nodeId = evt.getNodeId().toString();
        String schemaId = this.getModel().getDataEntity().getPkValue().toString();
        TreeNode rootNode = this.getRootNodeFromCache(schemaId);
        boolean isOpened = false;
        if (rootNode != null && (nodeCache = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId)) != null) {
            if ((StringUtils.isNotBlank((CharSequence)nodeCache.getParentid()) || this.getPageCache().get(CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED) != null) && nodeCache.getIsOpened()) {
                isOpened = true;
            } else {
                nodeCache.setIsOpened(true);
                this.updateRootNodeCache(schemaId, rootNode);
            }
        }
        if (isOpened) {
            TreeNode node = new TreeNode(evt.getParentNodeId().toString(), nodeId, "");
            treeView.checkNode(node);
        } else {
            List<TreeNode> nodeList = this.queryViewTreeNodeChildren(treeKey, nodeId, schemaId, isCheckChildren);
            treeView.addNodes(nodeList);
        }
    }

    private void findAllChildren(TreeNode treeNode, List<TreeNode> allChildren, List<String> allDeleteNodeIds) {
        List children = treeNode.getChildren();
        if (Utils.isListEmpty((List)children)) {
            return;
        }
        for (TreeNode node : children) {
            allChildren.add(node);
            if (allDeleteNodeIds != null) {
                allDeleteNodeIds.add(node.getId());
            }
            this.findAllChildren(node, allChildren, allDeleteNodeIds);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        String nodeId = evt.getNodeId().toString();
        switch (treeKey) {
            case "bizunittree": {
                treeView.addNodes(this.queryViewTreeNodeChildren(treeKey, nodeId, this.getLeftTreeViewSchema()));
                break;
            }
            case "bizviewtree": {
                treeView.addNodes(this.queryCostCenterTreeNodeChildren(treeKey, nodeId, this.getCostCenterKey()));
                break;
            }
        }
    }

    public void initViewTree(String treeKey, String parentId, String schemaId) {
        TreeView treeView = (TreeView)this.getControl(treeKey);
        TreeNode rootNode = this.initViewTreeRootNode(treeView, schemaId);
        if (rootNode == null) {
            if (AP_BIZ_VIEW_TREE.equals(treeKey)) {
                TreeView unitTreeView = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
                unitTreeView.setMulti(false);
            }
        } else {
            treeView.addNodes(this.queryViewTreeNodeChildren(treeKey, rootNode.getId(), schemaId));
        }
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
    }

    private TreeNode initViewTreeRootNode(TreeView treeView, String schemaId) {
        treeView.deleteAllNodes();
        if ("0".equals(schemaId)) {
            return null;
        }
        List<TreeNode> nodes = this.queryViewTreeNodeChildren(treeView.getKey(), "0", schemaId);
        if (Utils.isListEmpty(nodes)) {
            return null;
        }
        TreeNode rootNode = nodes.get(0);
        rootNode.setParentid("");
        rootNode.setIsOpened(true);
        this.updateRootNodeCache(schemaId, rootNode);
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        return rootNode;
    }

    public List<TreeNode> queryViewTreeNodeChildren(String treeKey, String parentId, String schemaId) {
        return this.queryViewTreeNodeChildren(treeKey, parentId, schemaId, false);
    }

    public List<TreeNode> queryViewTreeNodeChildren(String treeKey, String parentId, String schemaId, boolean isCheckChildren) {
        TreeNode curNode;
        boolean showFreezeUnit;
        if ("0".equals(schemaId)) {
            return new ArrayList<TreeNode>(0);
        }
        TreeNode rootNode = this.getRootNodeFromCache(schemaId);
        String selectFields = "org,isfreeze,org.enable enable,org.number number,org.name name,parent,longnumber,isleaf,isctrlunit";
        QFilter viewFilter = new QFilter("view", "=", (Object)Long.parseLong(schemaId));
        boolean showDisableUnit = (Boolean)this.getModel().getValue("showdisableunit");
        if (!showDisableUnit) {
            QFilter orgEnableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
            viewFilter = viewFilter.and(orgEnableFilter);
        }
        if (!(showFreezeUnit = ((Boolean)this.getModel().getValue("showfreezeunit")).booleanValue())) {
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            viewFilter = viewFilter.and(freezeFilter);
        }
        String longnumber = "";
        if (isCheckChildren && rootNode != null && (curNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)parentId)) != null) {
            longnumber = curNode.getLongNumber();
        }
        QFilter parentFilter = null;
        if (StringUtils.isBlank((CharSequence)longnumber)) {
            parentFilter = new QFilter("parent", "=", (Object)Long.parseLong(parentId));
        } else {
            if (longnumber.indexOf(33) == -1) {
                if (AP_BIZ_VIEW_TREE.equals(treeKey)) {
                    this.getPageCache().put(CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED, "");
                } else {
                    this.getPageCache().put(CACHE_ORG_UNIT_TREE_ROOTNODE_CHECKED, "");
                }
            }
            parentFilter = new QFilter("longnumber", "like", (Object)(longnumber + "!" + "%"));
        }
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        DynamicObjectCollection orgStrucCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"level,sortcode,longnumber");
        if (Utils.isListEmpty((List)orgStrucCol)) {
            return new ArrayList<TreeNode>(0);
        }
        int count = orgStrucCol.size();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(count);
        List<String> newParentList = this.getUpdateCache(treeKey);
        List<String> deleteList = this.getDeleteCache(treeKey);
        boolean isBDControl = false;
        HashMap<String, TreeNode> notLeafNodeMap = new HashMap<String, TreeNode>(count);
        ArrayList<Long> notLeafNodeIds = new ArrayList<Long>(count);
        for (DynamicObject strucObj : orgStrucCol) {
            String nodeId = strucObj.getString("org");
            if (newParentList.contains(nodeId) || deleteList.contains(nodeId)) continue;
            String curParentId = strucObj.getString("parent");
            String name = strucObj.getString("name");
            String number = strucObj.getString("number");
            String longNumber = strucObj.getString("longnumber");
            boolean isleaf = strucObj.getBoolean("isleaf");
            boolean isctrlunit = strucObj.getBoolean("isctrlunit");
            String showName = this.getShowName(name, number, strucObj.getBoolean("enable"), strucObj.getBoolean("isfreeze"));
            if (isBDControl && isctrlunit && AP_BIZ_VIEW_TREE.equals(treeKey)) {
                showName = showName + "\uff08CU\uff09";
            }
            TreeNode node = new TreeNode(curParentId, nodeId, showName);
            node.setLongNumber(longNumber);
            if (!isleaf) {
                node.setChildren(new ArrayList());
                if (!"0".equals(nodeId)) {
                    notLeafNodeIds.add(Long.parseLong(nodeId));
                    notLeafNodeMap.put(nodeId, node);
                }
            }
            nodeList.add(node);
            if (rootNode == null || OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId) != null) continue;
            TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)curParentId);
            if (parentNode == null) {
                rootNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        this.rebuildTreeNodeLeaf(notLeafNodeMap, notLeafNodeIds, viewFilter);
        if (rootNode != null) {
            this.updateRootNodeCache(schemaId, rootNode);
        }
        return nodeList;
    }

    private void rebuildTreeNodeLeaf(Map<String, TreeNode> notLeafNodeMap, List<Long> notLeafNodeIds, QFilter viewFilter) {
        if (notLeafNodeIds.isEmpty()) {
            return;
        }
        QFilter parentFilter = new QFilter("parent", "in", notLeafNodeIds);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.costcenter.QuickAddCostCenterFormPlugin.rebuildTreeNodeLeaf", (String)"bos_org_structure", (String)"parent", (QFilter[])filters, (String)"");){
            if (ds.hasNext()) {
                for (Row row : ds) {
                    notLeafNodeMap.remove(row.getString("parent"));
                }
            }
        }
        for (TreeNode node : notLeafNodeMap.values()) {
            node.setChildren(null);
        }
    }

    private List<String> getUpdateCache(String treeKey) {
        ArrayList<String> nodeList = new ArrayList<String>();
        if (AP_BIZ_VIEW_TREE.equals(treeKey)) {
            String cache = this.getPageCache().get(KEY_UPDATENODE);
            Map cacheMap = null;
            if (StringUtils.isNotBlank((CharSequence)cache) && (cacheMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class)) != null && !cacheMap.isEmpty()) {
                for (String orgId : cacheMap.keySet()) {
                    nodeList.add(orgId);
                }
            }
        }
        return nodeList;
    }

    private List<String> getDeleteCache(String treeKey) {
        ArrayList<String> nodeList = new ArrayList<String>();
        if (AP_BIZ_VIEW_TREE.equals(treeKey)) {
            String cache = this.getPageCache().get(KEY_DELETENODE);
            Map cacheMap = null;
            if (StringUtils.isNotBlank((CharSequence)cache) && (cacheMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class)) != null && !cacheMap.isEmpty()) {
                for (String orgId : cacheMap.keySet()) {
                    nodeList.add(orgId);
                }
            }
        }
        return nodeList;
    }

    public TreeNode getRootNodeFromCache(String schemaId) {
        TreeNode rootNode = null;
        if (this.getLeftTreeViewSchema().equals(schemaId)) {
            String rootNodeCache = this.getPageCache().get(CACHE_ORG_UNIT_TREE_ROOTNODE);
            if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
                rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
            }
        } else {
            String rootNodeCache = this.getPageCache().get(CACHE_ORG_VIEW_TREE_ROOTNODE);
            if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
                rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
            }
        }
        return rootNode;
    }

    public void updateRootNodeCache(String schemaId, TreeNode rootNode) {
        String rootNodeView = "";
        rootNodeView = this.getLeftTreeViewSchema().equals(schemaId) ? CACHE_ORG_UNIT_TREE_ROOTNODE : CACHE_ORG_VIEW_TREE_ROOTNODE;
        if (rootNode == null) {
            this.getPageCache().remove(rootNodeView);
        } else {
            this.getPageCache().put(rootNodeView, SerializationUtils.toJsonString((Object)rootNode));
        }
    }

    private void sortAddedTreeNode(Map<String, Object> cacheMap, String addCache) {
        List orgIds;
        int level;
        if (StringUtils.isBlank((CharSequence)addCache)) {
            return;
        }
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)addCache, Map.class);
        if (nodeMap == null || nodeMap.isEmpty()) {
            return;
        }
        String schemaId = this.getCostCenterKey();
        TreeNode rootNode = this.getRootNodeFromCache(schemaId);
        TreeMap levelMap = new TreeMap();
        for (Map.Entry nodeEntry : nodeMap.entrySet()) {
            String orgId = (String)nodeEntry.getKey();
            level = rootNode.getNodeLevel(orgId, 1);
            orgIds = (ArrayList<String>)levelMap.get(level);
            if (orgIds == null) {
                orgIds = new ArrayList<String>();
                levelMap.put(level, orgIds);
            }
            orgIds.add(orgId);
        }
        ArrayList<Map> sortedNodeList = new ArrayList<Map>(nodeMap.size());
        for (Map.Entry levelEntry : levelMap.entrySet()) {
            level = (Integer)levelEntry.getKey();
            orgIds = (List)levelEntry.getValue();
            for (String orgId : orgIds) {
                Map orgMap = (Map)nodeMap.get(orgId);
                orgMap.put("id", orgId);
                orgMap.put("level", level);
                sortedNodeList.add(orgMap);
            }
        }
        cacheMap.put(KEY_ADDNODE, SerializationUtils.toJsonString(sortedNodeList));
    }

    public void updateRightTreeView() {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isChangedCache = this.getPageCache().get("ischanged");
        if (StringUtils.isBlank((CharSequence)isChangedCache)) {
            e.setCheckDataChange(false);
            this.getView().returnDataToParent(null);
        } else {
            HashMap<String, Boolean> returnData = new HashMap<String, Boolean>(1);
            returnData.put("ischanged", Boolean.TRUE);
            this.getView().returnDataToParent(returnData);
        }
    }

    private void clearCache() {
        this.getPageCache().remove(KEY_ADDNODE);
        this.getPageCache().remove(KEY_UPDATENODE);
        this.getPageCache().remove(KEY_DELETENODE);
        this.getPageCache().remove(CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED);
    }

    public String getLeftTreeViewSchema() {
        return "01";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if ("orgpattern".equals(proName)) {
            this.checkNodeByOrgPattern(e.getChangeSet()[0]);
        }
        if ("showdisablecenter".equals(proName)) {
            String schemaId = "costCenter";
            this.initCostCenterTree(AP_BIZ_VIEW_TREE, "0", schemaId);
        }
        if ("showdisableunit".equals(proName) || "showfreezeunit".equals(proName)) {
            this.initViewTree(AP_BIZ_UNIT_TREE, "0", "01");
        }
    }

    private void checkNodeByOrgPattern(ChangeData cd) {
        TreeView adminTreeView = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
        List selectedUnitList = adminTreeView.getTreeState().getSelectedNodeId();
        adminTreeView.uncheckNodes(selectedUnitList);
        if (cd == null) {
            return;
        }
        Object newValue = cd.getNewValue();
        if (newValue == null) {
            return;
        }
        String[] patternArr = newValue.toString().split(",");
        ArrayList<String> patternList = new ArrayList<String>(patternArr.length);
        for (String orgPattern : patternArr) {
            if (!StringUtils.isNotBlank((CharSequence)orgPattern)) continue;
            patternList.add(orgPattern);
        }
        if (patternList.isEmpty()) {
            return;
        }
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter orgpatternFilter = new QFilter("org.orgpattern", "in", patternList);
        QFilter viewFilter = new QFilter("view.number", "in", (Object)"01");
        QFilter[] filters = new QFilter[]{orgpatternFilter, viewFilter};
        DynamicObjectCollection orgStruCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (Utils.isListEmpty((List)orgStruCol)) {
            return;
        }
        this.queryParentNode(adminTreeView, orgStruCol);
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(orgStruCol.size());
        for (DynamicObject strucObj : orgStruCol) {
            String parentId = strucObj.getString("parent");
            String orgId = strucObj.getString("org");
            String orgName = strucObj.getString("name");
            TreeNode curNode = new TreeNode(parentId, orgId, orgName);
            checkNodes.add(curNode);
        }
        adminTreeView.checkNodes(checkNodes);
    }

    private TreeNode queryParentNode(TreeView adminTreeView, DynamicObjectCollection orgStruCol) {
        TreeNode rootNode = this.getRootNodeFromCache("01");
        if (rootNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6839\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u9000\u51fa\u5e76\u91cd\u65b0\u6253\u5f00\u5f53\u524d\u9875\u9762\u3002", (String)"QuickAddCostCenterFormPlugin_11", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
        HashSet parentLongnumbers = new HashSet();
        for (DynamicObject strucObj : orgStruCol) {
            String orgId = strucObj.getString("org");
            TreeNode node = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)orgId);
            if (node != null) continue;
            String longnumber = strucObj.getString("longnumber");
            parentLongnumbers.addAll(OrgViewUtils.getAllSuperiorLongnumber((String)longnumber));
        }
        String selectFields = "id,org,parent,longnumber";
        QFilter orgpatternFilter = new QFilter("longnumber", "in", parentLongnumbers);
        QFilter viewFilter = new QFilter("view.number", "in", (Object)"01");
        QFilter[] filters = new QFilter[]{orgpatternFilter, viewFilter};
        DynamicObjectCollection parentOrgStruCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (Utils.isListEmpty((List)parentOrgStruCol)) {
            return rootNode;
        }
        ArrayList<String> addedParentIds = new ArrayList<String>();
        for (DynamicObject strucObj : parentOrgStruCol) {
            String orgId = strucObj.getString("org");
            TreeNode node = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)orgId);
            if (node == null) {
                String parentId = strucObj.getString("parent");
                if (addedParentIds.contains(parentId)) continue;
                adminTreeView.addNodes(this.queryViewTreeNodeChildren(AP_BIZ_UNIT_TREE, parentId, this.getLeftTreeViewSchema()));
                addedParentIds.add(parentId);
            } else {
                if (addedParentIds.contains(orgId)) continue;
                adminTreeView.addNodes(this.queryViewTreeNodeChildren(AP_BIZ_UNIT_TREE, orgId, this.getLeftTreeViewSchema()));
                addedParentIds.add(orgId);
            }
            rootNode = this.getRootNodeFromCache("01");
        }
        return rootNode;
    }

    /*
     * Loose catch block
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block27: {
            Throwable throwable;
            TXHandle h;
            block24: {
                block25: {
                    block26: {
                        HashMap<String, Object> cacheMap;
                        block21: {
                            block22: {
                                block23: {
                                    DefaultEntityOperate oper;
                                    super.beforeDoOperation(args);
                                    Object source = args.getSource();
                                    if (!(source instanceof DefaultEntityOperate) || !"saveview".equals((oper = (DefaultEntityOperate)source).getOperateKey())) break block27;
                                    IPageCache pageCache = this.getPageCache();
                                    String deleteCache = pageCache.get(KEY_DELETENODE);
                                    String updateCache = this.getPageCache().get(KEY_UPDATENODE);
                                    String addCache = this.getPageCache().get(KEY_ADDNODE);
                                    if (StringUtils.isBlank((CharSequence)deleteCache) && StringUtils.isBlank((CharSequence)addCache) && StringUtils.isBlank((CharSequence)updateCache)) {
                                        args.setCancel(true);
                                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u65e0\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u6267\u884c\u4fdd\u5b58\u3002", (String)"QuickAddCostCenterFormPlugin_12", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                                        return;
                                    }
                                    this.getPageCache().put("ischanged", "1");
                                    cacheMap = new HashMap<String, Object>(3);
                                    cacheMap.put(KEY_DELETENODE, deleteCache);
                                    cacheMap.put(KEY_UPDATENODE, updateCache);
                                    this.sortAddedTreeNode(cacheMap, addCache);
                                    h = TX.required();
                                    throwable = null;
                                    this.disableCostCenter(cacheMap);
                                    HashMap<String, String> tipMap = new HashMap<String, String>(2);
                                    if (this.addCostCenter(cacheMap, tipMap)) break block21;
                                    if (tipMap != null && tipMap.size() > 0) {
                                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s\u3002", (String)"QuickAddCostCenterFormPlugin_13", (String)"bd-assistant-formplugin", (Object[])new Object[0]), tipMap.get("tip")));
                                    }
                                    args.setCancel(true);
                                    if (h == null) break block22;
                                    if (throwable == null) break block23;
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block22;
                                }
                                h.close();
                            }
                            return;
                        }
                        if (this.updateCostCenter(cacheMap)) break block24;
                        args.setCancel(true);
                        if (h == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block25;
                    }
                    h.close();
                }
                return;
            }
            try {
                break block27;
                catch (Exception e) {
                    String cancelMessage = String.format(ResManager.loadKDString((String)"\u65b0\u6210\u672c\u4e2d\u5fc3\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff1a%s\u3002", (String)"QuickAddCostCenterFormPlugin_14", (String)"bd-assistant-formplugin", (Object[])new Object[0]), e.getMessage());
                    log.error(cancelMessage, (Throwable)e);
                    this.getView().showErrorNotification(cancelMessage);
                    args.setCancel(true);
                    h.markRollback();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
    }

    private boolean disableCostCenter(Map<String, Object> cacheMap) {
        String cache = (String)cacheMap.get(KEY_DELETENODE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return true;
        }
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        if (nodeMap == null || nodeMap.isEmpty()) {
            return true;
        }
        ArrayList<Long> ids = new ArrayList<Long>(nodeMap.size());
        for (String id : nodeMap.keySet()) {
            ids.add(Long.parseLong(id));
        }
        String selectProperties = "id,enable,disabler,disabledate,modifier,modifytime";
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] costCenterArr = BusinessDataServiceHelper.load((String)ENTITY_COST_CENTER, (String)selectProperties, (QFilter[])filters);
        if (costCenterArr == null || costCenterArr.length == 0) {
            return true;
        }
        Date currentDate = new Date();
        String currentUserId = RequestContext.get().getUserId();
        for (DynamicObject costCenterObj : costCenterArr) {
            costCenterObj.set("enable", (Object)"0");
            costCenterObj.set("disabler", (Object)currentUserId);
            costCenterObj.set("disabledate", (Object)currentDate);
            costCenterObj.set("modifier", (Object)currentUserId);
            costCenterObj.set("modifytime", (Object)currentDate);
        }
        SaveServiceHelper.save((DynamicObject[])costCenterArr);
        return true;
    }

    private boolean addCostCenter(Map<String, Object> cacheMap, Map<String, String> tipMap) {
        String cache = (String)cacheMap.get(KEY_ADDNODE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return true;
        }
        List nodeList = (List)SerializationUtils.fromJsonString((String)cache, List.class);
        if (nodeList == null || nodeList.isEmpty()) {
            return true;
        }
        ArrayList<DynamicObject> costCenterList = new ArrayList<DynamicObject>(nodeList.size());
        DynamicObject costCenter = null;
        String parentID = null;
        DynamicObject parentCostCenter = null;
        String adminOrgID = null;
        DynamicObject adminOrg = null;
        ArrayList<DynamicObject> costCenterSourceList = new ArrayList<DynamicObject>(nodeList.size());
        DynamicObject costCenterSource = null;
        ArrayList<Long> nodeIdList = new ArrayList<Long>(nodeList.size());
        ArrayList<Long> parentIdList = new ArrayList<Long>(nodeIdList.size());
        for (Map node : nodeList) {
            nodeIdList.add(Long.parseLong(node.get("id").toString()));
            Object parentId = node.get("parentid");
            if (!StringUtils.isNotBlank(parentId)) continue;
            parentIdList.add(Long.parseLong(parentId.toString()));
        }
        TreeNode rootNode = this.getRootNodeFromCache(this.getCostCenterKey());
        Map<String, DynamicObject> orgMap = this.getOrg(nodeIdList);
        Map<String, Long> orgDutyMap = this.getOrgDuty(nodeIdList);
        Map<String, DynamicObject> parentCostCenterMap = this.getParentCostCenter(parentIdList);
        ORM orm = ORM.create();
        HashMap<String, TreeNode> newNodeMap = new HashMap<String, TreeNode>(nodeList.size(), 0.75f);
        HashMap<String, String> dealNodes = new HashMap<String, String>(16);
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)ENTITY_COST_CENTER, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)ENTITY_COST_CENTER), (String)"", (int)nodeList.size());
        long[] ids = orm.genLongIds(ENTITY_COST_CENTER, nodeList.size());
        int numberIndex = 0;
        int index = 0;
        boolean isCheckPass = true;
        StringBuilder tipSb = new StringBuilder();
        String longNumberDML = CostCenterTreeUtils.getLongNumberDML();
        for (Object node : nodeList) {
            adminOrgID = (String)node.get("id");
            adminOrg = orgMap.get(adminOrgID);
            if (adminOrg == null) continue;
            boolean isAccountingOrg = OrgUnitServiceHelper.checkOrgFunction((Long)Long.parseLong(adminOrgID), (String)"10");
            String number = "";
            number = numberArr != null && numberArr.length > numberIndex ? numberArr[numberIndex++] : adminOrg.getString("number");
            String name = adminOrg.getString("name");
            parentID = (String)node.get("parentid");
            parentCostCenter = parentCostCenterMap.get(parentID);
            if (parentCostCenter == null && !adminOrgID.equals(rootNode.getId())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u83b7\u53d6\u4e0a\u7ea7\u6210\u672c\u4e2d\u5fc3\uff0c\u6dfb\u52a0\u5931\u8d25\u3002", (String)"QuickAddCostCenterFormPlugin_15", (String)"bd-assistant-formplugin", (Object[])new Object[0]), name));
                return false;
            }
            String parentCostCenterId = "";
            String longnumber = number;
            String fullname = name;
            int level = 1;
            if (parentCostCenter != null) {
                parentCostCenterId = parentCostCenter.getString("id");
                longnumber = parentCostCenter.getString("longnumber") + longNumberDML + number;
                fullname = parentCostCenter.getString("fullname") + longNumberDML + name;
                level = parentCostCenter.getInt("level") + 1;
                parentCostCenter.set("isleaf", (Object)Boolean.FALSE);
                TreeNode costCenterParentNode = (TreeNode)newNodeMap.get(parentCostCenterId);
                if (costCenterParentNode != null) {
                    costCenterParentNode.setChildren(new ArrayList());
                }
            }
            costCenter = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_COST_CENTER);
            long id = ids[index];
            ++index;
            costCenter.set("id", (Object)id);
            costCenter.set("masterid", (Object)id);
            costCenter.set("number", (Object)number);
            costCenter.set("name", adminOrg.get("name"));
            if (isAccountingOrg) {
                costCenter.set("accountorg", (Object)Long.parseLong(adminOrgID));
            } else {
                long accountOrg = this.getAccountOrg(Long.parseLong(adminOrgID), 1);
                costCenter.set("accountorg", (Object)accountOrg);
            }
            costCenter.set("parent", (Object)parentCostCenter);
            costCenter.set("longnumber", (Object)longnumber);
            costCenter.set("fullname", (Object)fullname);
            costCenter.set("level", (Object)level);
            if (orgDutyMap.get(adminOrgID) != null) {
                costCenter.set("orgduty", (Object)orgDutyMap.get(adminOrgID));
            } else {
                costCenter.set("orgduty", (Object)1L);
            }
            OrgManagerUtils.genCommonField((DynamicObject)costCenter, (boolean)true);
            costCenterList.add(costCenter);
            parentCostCenterMap.put(adminOrgID, costCenter);
            costCenterSource = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_COST_CENTER_SOURCE);
            costCenterSource.set("fseq", (Object)1);
            costCenterSource.set("costcenter", (Object)costCenter);
            costCenterSource.set("sourcetype", (Object)708643427767573504L);
            costCenterSource.set("data", (Object)adminOrgID);
            costCenterSourceList.add(costCenterSource);
            String nodeId = Long.toString(id);
            dealNodes.put(nodeId, adminOrgID);
            TreeNode costCenterNode = new TreeNode(parentCostCenterId, nodeId, this.getShowName(name, number, true, false));
            costCenterNode.setLongNumber(longnumber);
            newNodeMap.put(nodeId, costCenterNode);
        }
        if (!isCheckPass) {
            tipMap.put("tip", tipSb.toString());
            return false;
        }
        SaveServiceHelper.save((DynamicObject[])costCenterList.toArray(new DynamicObject[costCenterList.size()]));
        SaveServiceHelper.save((DynamicObject[])costCenterSourceList.toArray(new DynamicObject[costCenterSourceList.size()]));
        ArrayList<TreeNode> addNodes = new ArrayList<TreeNode>(newNodeMap.size());
        for (TreeNode costCenterNode : newNodeMap.values()) {
            TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)costCenterNode.getParentid());
            String deleteNodeId = (String)dealNodes.get(costCenterNode.getId());
            if (StringUtils.isEmpty((CharSequence)deleteNodeId)) continue;
            if (parentNode == null) {
                rootNode.addChild(costCenterNode);
                rootNode.deleteChildNode(deleteNodeId);
            } else {
                parentNode.addChild(costCenterNode);
                parentNode.deleteChildNode(deleteNodeId);
            }
            addNodes.add(costCenterNode);
        }
        this.updateRootNodeCache(this.getCostCenterKey(), rootNode);
        TreeView bizViewTree = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
        bizViewTree.deleteNodes(new ArrayList(dealNodes.values()));
        bizViewTree.addNodes(addNodes);
        return true;
    }

    private Map<String, DynamicObject> getOrg(List<Long> orgList) {
        QFilter orgFilter = new QFilter("id", "in", orgList);
        QFilter[] filters = new QFilter[]{orgFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])filters);
        if (orgObjMap == null || orgObjMap.isEmpty()) {
            return new HashMap<String, DynamicObject>();
        }
        HashMap<String, DynamicObject> orgMap = new HashMap<String, DynamicObject>(orgObjMap.size());
        for (Map.Entry entry : orgObjMap.entrySet()) {
            orgMap.put(String.valueOf(entry.getKey()), (DynamicObject)entry.getValue());
        }
        return orgMap;
    }

    private Map<String, Long> getOrgDuty(List<Long> orgList) {
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter[] filters = new QFilter[]{orgFilter};
        Map orgDutyObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_dutyrelation", (QFilter[])filters);
        if (orgDutyObjMap == null || orgDutyObjMap.isEmpty()) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> orgDutyMap = new HashMap<String, Long>(orgDutyObjMap.size());
        for (DynamicObject dutyObj : orgDutyObjMap.values()) {
            DynamicObject orgObj = dutyObj.getDynamicObject("org");
            DynamicObject orgDutyObj = dutyObj.getDynamicObject("orgduty");
            if (orgObj == null || orgDutyObj == null) continue;
            orgDutyMap.put(orgObj.getString("id"), orgDutyObj.getLong("id"));
        }
        return orgDutyMap;
    }

    private Map<String, DynamicObject> getParentCostCenter(List<Long> parentList) {
        HashMap<String, DynamicObject> parentCostCenterMap = new HashMap<String, DynamicObject>(parentList.size(), 0.75f);
        if (parentList.isEmpty()) {
            return parentCostCenterMap;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITY_COST_CENTER);
        DynamicObject[] parentObjArr = BusinessDataServiceHelper.load((Object[])parentList.toArray(new Object[parentList.size()]), (DynamicObjectType)type);
        if (parentObjArr == null || parentObjArr.length == 0) {
            return new HashMap<String, DynamicObject>();
        }
        for (DynamicObject obj : parentObjArr) {
            obj.set("isleaf", (Object)Boolean.FALSE);
            parentCostCenterMap.put(obj.getString("id"), obj);
        }
        SaveServiceHelper.save((DynamicObject[])parentObjArr);
        return parentCostCenterMap;
    }

    private boolean updateCostCenter(Map<String, Object> cacheMap) {
        String cache = (String)cacheMap.get(KEY_UPDATENODE);
        if (StringUtils.isBlank((CharSequence)cache)) {
            return true;
        }
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        if (nodeMap == null || nodeMap.isEmpty()) {
            return true;
        }
        ArrayList<Object> nodeIdList = new ArrayList<Object>(10);
        ArrayList<Long> newParentIdList = new ArrayList<Long>(10);
        HashMap<String, String> parentMap = new HashMap<String, String>(16, 0.75f);
        for (Map.Entry entry : nodeMap.entrySet()) {
            String id = (String)entry.getKey();
            String parentId = String.valueOf(((Map)entry.getValue()).get("parentid"));
            nodeIdList.add(id);
            newParentIdList.add(Long.parseLong(parentId));
            parentMap.put(id, parentId);
        }
        this.updateOldParent(nodeIdList);
        Map<String, DynamicObject> parentCostCenterMap = this.getParentCostCenter(newParentIdList);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITY_COST_CENTER);
        DynamicObject[] costCenterObjArr = BusinessDataServiceHelper.load((Object[])nodeIdList.toArray(new Object[nodeIdList.size()]), (DynamicObjectType)type);
        if (costCenterObjArr == null || costCenterObjArr.length == 0) {
            return true;
        }
        String parentID = null;
        DynamicObject parentCostCenter = null;
        String longNumberDML = CostCenterTreeUtils.getLongNumberDML();
        for (DynamicObject costCenterObj : costCenterObjArr) {
            String id = costCenterObj.getString("id");
            String number = costCenterObj.getString("number");
            String name = costCenterObj.getString("name");
            parentID = (String)parentMap.get(id);
            parentCostCenter = parentCostCenterMap.get(parentID);
            if (parentCostCenter == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u83b7\u53d6\u4e0a\u7ea7\u6210\u672c\u4e2d\u5fc3\uff0c\u6dfb\u52a0\u5931\u8d25\u3002", (String)"QuickAddCostCenterFormPlugin_15", (String)"bd-assistant-formplugin", (Object[])new Object[0]), name));
                return false;
            }
            costCenterObj.set("parent", (Object)parentCostCenter);
            String longnumber = parentCostCenter.getString("longnumber") + longNumberDML + number;
            String fullname = parentCostCenter.getString("fullname") + longNumberDML + name;
            int level = parentCostCenter.getInt("level") + 1;
            costCenterObj.set("longnumber", (Object)longnumber);
            costCenterObj.set("fullname", (Object)fullname);
            costCenterObj.set("level", (Object)level);
            OrgManagerUtils.genCommonField((DynamicObject)costCenterObj, (boolean)false);
        }
        SaveServiceHelper.save((DynamicObject[])costCenterObjArr);
        return true;
    }

    private void updateOldParent(List<Object> nodeIdList) {
        ArrayList<String> oldParentIds = new ArrayList<String>(nodeIdList.size());
        QFilter idFilter = new QFilter("id", "in", nodeIdList);
        QFilter[] filters = new QFilter[]{idFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.costcenter.QuickAddCostCenterFormPlugin.updateOldParent", (String)ENTITY_COST_CENTER, (String)"parent", (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                oldParentIds.add(row.getString("parent"));
            }
        }
        if (oldParentIds.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITY_COST_CENTER);
        DynamicObject[] parentObjArr = BusinessDataServiceHelper.load((Object[])oldParentIds.toArray(new Object[oldParentIds.size()]), (DynamicObjectType)type);
        if (parentObjArr == null || parentObjArr.length == 0) {
            return;
        }
        TreeNode rootNode = this.getRootNodeFromCache(this.getCostCenterKey());
        ArrayList<String> loadedParentList = new ArrayList<String>(parentObjArr.length);
        ArrayList<String> isLeafParentList = new ArrayList<String>(parentObjArr.length);
        for (Object e : oldParentIds) {
            TreeNode oldParentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)e.toString());
            if (oldParentNode == null) continue;
            String nodeId = oldParentNode.getId();
            loadedParentList.add(nodeId);
            if (!Utils.isListEmpty((List)oldParentNode.getChildren())) continue;
            isLeafParentList.add(nodeId);
        }
        QFilter[] qFilters = null;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (DynamicObject obj : parentObjArr) {
            String id = obj.getString("id");
            if (loadedParentList.contains(id)) {
                if (isLeafParentList.contains(id)) {
                    obj.set("isleaf", (Object)1);
                    continue;
                }
                obj.set("isleaf", (Object)0);
                continue;
            }
            Integer val = (Integer)hashMap.get(id);
            if (val != null) {
                obj.set("isleaf", (Object)val);
                continue;
            }
            QFilter idNotInFilter = new QFilter("id", "not in", nodeIdList);
            QFilter parentFilter = new QFilter("parent", "=", (Object)id);
            qFilters = new QFilter[]{idNotInFilter, parentFilter};
            int isLeaf = 1;
            if (QueryServiceHelper.exists((String)ENTITY_COST_CENTER, (QFilter[])qFilters)) {
                isLeaf = 0;
            }
            obj.set("isleaf", (Object)isLeaf);
            hashMap.put(id, isLeaf);
        }
        SaveServiceHelper.save((DynamicObject[])parentObjArr);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult opResult = evt.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        String operateKey = evt.getOperateKey();
        if ("saveview".equals(operateKey)) {
            List idList = opResult.getSuccessPkIds();
            if (Utils.isListEmpty((List)idList)) {
                return;
            }
            this.updateRightTreeView();
            this.clearCache();
            this.getModel().setDataChanged(false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QuickAddCostCenterFormPlugin_17", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
    }
}

