/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class AddressHelper {
    private static final Log log = LogFactory.getLog(AddressHelper.class);
    public static final String RESULT = "result";
    private static final String ADD_ADDRESS = "add_address";
    private static final String DEL_ADDRESS = "del_address";
    private static final String NEWENTRY_ADDR = "newentry_addr";
    private static final String DELETEENTRY_ADDR = "deleteentry_addr";

    public static void addressOperate(String operationKey, IFormPlugin plugin, IDataModel model, IFormView view, String entityType) throws KDBizException {
        if (ADD_ADDRESS.equals(operationKey) || NEWENTRY_ADDR.equals(operationKey)) {
            AddressHelper.addAddressData(plugin, model, view, entityType);
        } else if (DEL_ADDRESS.equals(operationKey) || DELETEENTRY_ADDR.equals(operationKey)) {
            AddressHelper.deleteAddressData(model, view, entityType);
        }
    }

    public static void addAddressData(IFormPlugin plugin, IDataModel model, IFormView view, String entityType) {
        Map<String, Object> result = AddressHelper.checkEnable(model, view);
        if (!((Boolean)result.get(RESULT)).booleanValue()) {
            return;
        }
        BaseShowParameter fsp = FormShowParameterUtil.getShowParamter("bd_address", true, ShowType.Modal);
        if ("bd_supplier".equals(entityType)) {
            fsp.setCloseCallBack(new CloseCallBack(plugin, "supplieraddress"));
            fsp.setCustomParam("supplierid", result.get("id"));
            fsp.setCustomParam("isSupplier", (Object)Boolean.TRUE);
            fsp.setCustomParam("isCustomer", (Object)Boolean.FALSE);
        } else if ("bd_customer".equals(entityType)) {
            fsp.setCloseCallBack(new CloseCallBack(plugin, "customeraddress"));
            fsp.setCustomParam("customerid", result.get("id"));
            fsp.setCustomParam("isSupplier", (Object)Boolean.FALSE);
            fsp.setCustomParam("isCustomer", (Object)Boolean.TRUE);
        }
        fsp.setCustomParam("createorg", ((DynamicObject)model.getValue("createorg")).getPkValue());
        view.showForm((FormShowParameter)fsp);
    }

    public static Map<String, Object> checkEnable(IDataModel model, IFormView view) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        boolean flag = true;
        Object pk = model.getDataEntity().getPkValue();
        if (pk != null && Long.parseLong(pk.toString()) != 0L) {
            result.put("id", pk);
        } else {
            if ("bd_supplier".equals(model.getDataEntity().getDataEntityType().getName())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u4f9b\u5e94\u5546\u4fe1\u606f\u3002", (String)"AddressHelper_0", (String)"bd-master-business", (Object[])new Object[0]));
            } else if ("bd_customer".equals(model.getDataEntity().getDataEntityType().getName())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5ba2\u6237\u4fe1\u606f\u3002", (String)"AddressHelper_1", (String)"bd-master-business", (Object[])new Object[0]));
            }
            flag = false;
        }
        result.put(RESULT, flag);
        return result;
    }

    public static void deleteAddressData(IDataModel model, IFormView view, String entityType) throws KDBizException {
        EntryGrid grid = (EntryGrid)view.getControl("entry_address");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows.length == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"AddressHelper_2", (String)"bd-master-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((Object)model.getDataEntity().getPkValue(), (String)entityType);
        DynamicObjectCollection address = (DynamicObjectCollection)model.getValue("entry_address");
        DynamicObjectCollection linkmans = null;
        DynamicObjectCollection linkmanUis = (DynamicObjectCollection)model.getValue("entry_linkman");
        HashSet linkmandatas = new HashSet();
        linkmandatas.addAll(linkmanUis);
        String billaddressPk = null;
        if (data != null) {
            linkmans = data.getDynamicObjectCollection("entry_linkman");
            linkmandatas.addAll(linkmans);
            if (data.getDynamicObjectType().getProperty("billaddress") != null && data.getDynamicObject("billaddress") != null) {
                billaddressPk = data.getDynamicObject("billaddress").getString("id");
            }
        }
        if (model.getDataEntity().getDynamicObjectType().getProperty("billaddress") != null && (DynamicObject)model.getValue("billaddress") != null) {
            billaddressPk = ((DynamicObject)model.getValue("billaddress")).getString("id");
        }
        if (address != null && address.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(rows.length);
            StringBuilder idsql = new StringBuilder();
            if ((linkmandatas == null || linkmandatas.size() == 0) && billaddressPk == null) {
                StringBuilder errorinfo = new StringBuilder();
                HashSet<Integer> lastrows = new HashSet<Integer>(rows.length);
                for (int i2 = 0; i2 < rows.length; ++i2) {
                    if ("bd_customer".equals(entityType) && ((DynamicObject)address.get(rows[i2])).getBoolean("isdeliveryaddress")) {
                        errorinfo.append(((DynamicObject)address.get(rows[i2])).getString("addnumber"));
                        errorinfo.append(": ");
                        errorinfo.append(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u4e3a\u5168\u6e20\u9053\u4e91\uff0c\u8bf7\u5728\u201c\u5168\u6e20\u9053\u4e91>\u6e20\u9053\u5ba2\u6237\u4e2d\u5fc3>\u6e20\u9053\u4fe1\u606f>\u6e20\u9053\u6536\u8d27\u5730\u5740\u201d\u4e2d\u8fdb\u884c\u5220\u9664\u3002", (String)"AddressHelper_5", (String)"bd-master-business", (Object[])new Object[0]));
                        errorinfo.append("\r\n");
                        continue;
                    }
                    lastrows.add(rows[i2]);
                    ids.add(((DynamicObject)address.get(rows[i2])).getLong("addid"));
                    if (i2 == rows.length - 1) {
                        idsql.append(((DynamicObject)address.get(rows[i2])).get("addid"));
                        continue;
                    }
                    idsql.append(((DynamicObject)address.get(rows[i2])).get("addid")).append(',');
                }
                AddressHelper.excuteDeleteOp(model, address, ids, idsql);
                model.deleteEntryRows("entry_address", lastrows.stream().mapToInt(i -> i).toArray());
                if (errorinfo.toString().length() > 0) {
                    view.showErrorNotification(errorinfo.toString());
                }
            } else {
                int[] arr;
                StringBuilder errorinfo = new StringBuilder();
                HashSet<Integer> lastrows = new HashSet<Integer>(rows.length);
                List repeatDatas = null;
                if (linkmandatas != null && linkmandatas.size() > 0) {
                    repeatDatas = address.stream().filter(add -> AddressHelper.find(add.getString("addid"), new ArrayList<DynamicObject>(linkmandatas)) > -1).collect(Collectors.toList());
                }
                List deleteRows = Arrays.stream(rows).boxed().collect(Collectors.toList());
                boolean flag = false;
                Iterator iterator = deleteRows.iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)iterator.next();
                    if ("bd_customer".equals(entityType) && ((DynamicObject)address.get(row)).getBoolean("isdeliveryaddress")) {
                        errorinfo.append(((DynamicObject)address.get(row)).getString("addnumber"));
                        errorinfo.append(':');
                        errorinfo.append(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u4e3a\u5168\u6e20\u9053\u4e91\uff0c\u8bf7\u5728\u201c\u5168\u6e20\u9053\u4e91>\u6e20\u9053\u5ba2\u6237\u4e2d\u5fc3>\u6e20\u9053\u4fe1\u606f>\u6e20\u9053\u6536\u8d27\u5730\u5740\u201d\u4e2d\u8fdb\u884c\u5220\u9664\u3002", (String)"AddressHelper_5", (String)"bd-master-business", (Object[])new Object[0]));
                        errorinfo.append("\r\n");
                        flag = true;
                        continue;
                    }
                    if (repeatDatas != null && repeatDatas.size() > 0 && address.get(row) != null && repeatDatas.contains(address.get(row))) {
                        errorinfo.append(((DynamicObject)address.get(row)).getString("addnumber"));
                        errorinfo.append(':');
                        errorinfo.append(ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u5220\u9664\uff1a\u201c\u8054\u7cfb\u4eba\u9875\u7b7e\u201d\u5b57\u6bb5\u201c\u5173\u8054\u5730\u5740\u201d\u5f15\u7528\u4e86\u6b64\u57fa\u7840\u8d44\u6599\u3002", (String)"AddressHelper_3", (String)"bd-master-business", (Object[])new Object[0]));
                        errorinfo.append("\r\n");
                        continue;
                    }
                    if (billaddressPk != null && billaddressPk.equals(((DynamicObject)address.get(row)).getString("addid"))) {
                        errorinfo.append(((DynamicObject)address.get(row)).getString("addnumber"));
                        errorinfo.append(':');
                        errorinfo.append(ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u5220\u9664\uff1a\u201c\u53d1\u7968\u4fe1\u606f\u9875\u7b7e\u201d\u5b57\u6bb5\u201c\u5f00\u7968\u5730\u5740\u201d\u5f15\u7528\u4e86\u6b64\u57fa\u7840\u8d44\u6599\u3002", (String)"AddressHelper_4", (String)"bd-master-business", (Object[])new Object[0]));
                        errorinfo.append("\r\n");
                        continue;
                    }
                    ids.add(((DynamicObject)address.get(row)).getLong("addid"));
                    if (row == rows.length - 1) {
                        idsql.append(((DynamicObject)address.get(row)).get("addid"));
                    } else {
                        idsql.append(((DynamicObject)address.get(row)).get("addid")).append(',');
                    }
                    lastrows.add(row);
                }
                if (errorinfo.toString().length() > 0) {
                    if (flag) {
                        view.showErrorNotification(errorinfo.toString());
                    } else {
                        view.showErrorNotification(errorinfo.toString().substring(0, errorinfo.toString().length() - 1));
                    }
                }
                if ((arr = lastrows.stream().mapToInt(i -> i).toArray()).length > 0) {
                    AddressHelper.excuteDeleteOp(model, address, ids, idsql);
                    model.deleteEntryRows("entry_address", arr);
                }
            }
        }
    }

    private static int find(String addressId, List<DynamicObject> linkman) {
        int res = -1;
        for (int i = 0; i < linkman.size(); ++i) {
            DynamicObject associatedaddress = linkman.get(i).getDynamicObject("associatedaddress");
            if (associatedaddress == null || !associatedaddress.getString("id").equals(addressId)) continue;
            res = i;
            break;
        }
        return res;
    }

    private static void excuteDeleteOp(IDataModel model, DynamicObjectCollection address, List<Long> ids, StringBuilder idsql) throws KDBizException {
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"bd_address", (Object[])ids.toArray(new Long[ids.size()]), (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < result.getAllErrorOrValidateInfo().size(); ++i) {
                if (i == result.getAllErrorOrValidateInfo().size() - 1) {
                    sb.append(((IOperateInfo)result.getAllErrorOrValidateInfo().get(i)).getMessage());
                    log.error(sb.toString());
                    throw new KDBizException(sb.toString());
                }
                sb.append(((IOperateInfo)result.getAllErrorOrValidateInfo().get(i)).getMessage());
                sb.append(';');
            }
        }
    }

    public static void queryAddressData(IDataModel model, String type) {
        DynamicObject data = model.getDataEntity();
        Long pk = (Long)data.getPkValue();
        if (pk != 0L) {
            QFilter[] qfs = null;
            if ("bd_supplier".equals(type)) {
                qfs = new QFilter[]{new QFilter("supplierid", "=", (Object)String.valueOf(pk))};
            } else if ("bd_customer".equals(type)) {
                qfs = new QFilter[]{new QFilter("customerid", "=", (Object)String.valueOf(pk))};
            }
            Map address = BusinessDataServiceHelper.loadFromCache((String)"bd_address", qfs);
            model.deleteEntryData("entry_address");
            if (address != null && address.size() > 0) {
                model.batchCreateNewEntryRow("entry_address", address.size());
                int i = 0;
                for (Map.Entry<Object, DynamicObject> entry : address.entrySet()) {
                    AddressHelper.assignmentData(model, type, i, entry);
                    ++i;
                }
            }
            model.setDataChanged(false);
        }
    }

    private static void assignmentData(IDataModel model, String type, int i, Map.Entry<Object, DynamicObject> map) {
        model.setValue("addnumber", map.getValue().get("number"), i);
        model.setValue("addname", (Object)map.getValue().getLocaleString("name").getLocaleValue(), i);
        model.setValue("addlinkman", map.getValue().get("linkman"), i);
        model.setValue("addphone", (Object)map.getValue().getLocaleString("phone").getLocaleValue(), i);
        model.setValue("addemail", map.getValue().get("addemail"), i);
        model.setValue("addtimezone", map.getValue().get("timezone") == null ? map.getValue().get("timezone") : ((DynamicObject)map.getValue().get("timezone")).get("name"), i);
        model.setValue("addid", map.getKey(), i);
        model.setValue("addinvalid", map.getValue().get("invalid"), i);
        model.setValue("default", map.getValue().get("default"), i);
        model.setValue("addstatus", map.getValue().get("enable"), i);
        model.setValue("addpostalcode", map.getValue().get("zipcode"), i);
        DynamicObject admindivision = map.getValue().getDynamicObject("admindivisiondata");
        if (admindivision != null) {
            DynamicObject admindivisionData = BusinessDataServiceHelper.loadSingleFromCache((Object)admindivision.getPkValue(), (String)"bd_admindivision", (String)"fullname,citynumber");
            model.setValue("addadmindivision", (Object)admindivisionData.getString("fullname"), i);
            model.setValue("addphonecode", (Object)admindivisionData.getString("citynumber"), i);
        }
        if ("bd_supplier".equals(type)) {
            model.setValue("supplieraddress", map.getKey(), i);
            DynamicObject supplieraddrsspurpose = map.getValue().getDynamicObject("supplieraddrsspurpose");
            if (supplieraddrsspurpose != null) {
                model.setValue("addsupplieraddrsspurpose", (Object)supplieraddrsspurpose.getString("name"), i);
            }
        } else if ("bd_customer".equals(type)) {
            DynamicObject tradeterms;
            model.setValue("customeraddress", map.getKey(), i);
            DynamicObject customeraddrsspurpose = map.getValue().getDynamicObject("customeraddrsspurpose");
            if (customeraddrsspurpose != null) {
                model.setValue("addcustomeraddrsspurpose", (Object)customeraddrsspurpose.getString("name"), i);
            }
            if ((tradeterms = map.getValue().getDynamicObject("hihn_tradeterms")) != null) {
                model.setValue("hihn_tradeterms", (Object)tradeterms.getString("name"), i);
            }
            model.setValue("hihn_clearanceco", map.getValue().get("hihn_clearanceco"), i);
            model.setValue("hihn_forwarderco", map.getValue().get("hihn_forwarderco"), i);
            model.setValue("isdeliveryaddress", map.getValue().get("isdeliveryaddress"), i);
        }
        model.setValue("addfulladdress", (Object)map.getValue().getLocaleString("detailaddress").getLocaleValue(), i);
    }
}

