/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PbdStrategyReportListDataPlugin
extends AbstractReportListDataPlugin {
    private static final Map<String, String> STRATEGY_PROPERTY = new HashMap<String, String>(3);
    private static String COMMON_SELECT = "createorg,enable,category,category.name,category.fullname,material,material.name,type,id billid,number";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        DataSet dataSet3 = null;
        DataSet dataSet = this.getSourceDataSet("bd_centralpurchaselist", "1 source", reportQueryParam);
        DataSet dataSet1 = this.getSourceDataSet("bd_purstrategy", "2 source", reportQueryParam);
        DataSet dataSet2 = this.getSourceDataSet("bd_srcstrategy", "3 source", reportQueryParam);
        DataSet union = dataSet.union(dataSet1).union(dataSet2);
        GroupbyDataSet groupbyDataSet = union.groupBy(new String[]{"createorg", "category", "material", "enable"});
        dataSet3 = groupbyDataSet.reduceGroup(new ReduceGroupFunctionWithCollector(){

            public void reduce(Iterator<Row> iterator, Collector collector) {
                Long createOrg = null;
                Long category = null;
                Long material = null;
                String categoryFullName = null;
                Object categoryName = null;
                String materialName = null;
                String centralListNo = null;
                String purListNo = null;
                String srcListNo = null;
                String enable = null;
                String type = null;
                long centralListID = 0L;
                long purStrategyId = 0L;
                long srcStrategyId = 0L;
                while (iterator.hasNext()) {
                    Row next = iterator.next();
                    createOrg = next.getLong("createorg");
                    category = next.getLong("category");
                    material = next.getLong("material");
                    categoryFullName = next.getString("category.fullname");
                    materialName = next.getString("material.name");
                    enable = next.getString("enable");
                    Integer source = next.getInteger("source");
                    type = next.getString("type");
                    if (source == 1) {
                        centralListNo = next.getString("number");
                        centralListID = next.getLong("billid");
                        continue;
                    }
                    if (source == 2) {
                        purStrategyId = next.getLong("billid");
                        purListNo = next.getString("number");
                        continue;
                    }
                    srcStrategyId = next.getLong("billid");
                    srcListNo = next.getString("number");
                }
                collector.collect(new Object[]{createOrg, category, material, enable, type, centralListID, purStrategyId, srcStrategyId, categoryFullName, materialName, centralListNo, purListNo, srcListNo, categoryName});
            }

            public RowMeta getResultRowMeta() {
                return new RowMeta(new String[]{"createorg", "category", "material", "enable", "type", "centrallist", "purstrategy", "srcstrategy", "cateogryfullname", "materialname", "centrallistbillno", "purstrategybillno", "srcstrategybillno", "categoryname"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType});
            }
        });
        Map<String, Object> param = this.buildStrategyFilters(reportQueryParam);
        List headFilters = reportQueryParam.getFilter().getHeadFilters();
        for (QFilter headFilter : headFilters) {
            String property = headFilter.getProperty();
            if (StringUtils.equals((CharSequence)"category", (CharSequence)property) || StringUtils.equals((CharSequence)"material", (CharSequence)property)) {
                property = property + "name";
            }
            dataSet3 = dataSet3.filter(property + " " + headFilter.getCP() + " '" + headFilter.getValue() + "'");
        }
        for (Map.Entry<String, String> next : STRATEGY_PROPERTY.entrySet()) {
            String value = next.getValue();
            if (!param.containsKey(value)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(value + "param", param.get(value));
            dataSet3 = dataSet3.where(value + " in " + value + "param", map);
        }
        if (reportQueryParam.getSortInfo() != null) {
            return dataSet3.orderBy(new String[]{reportQueryParam.getSortInfo()});
        }
        return dataSet3;
    }

    private DataSet getSourceDataSet(String entityName, String type, ReportQueryParam reportQueryParam) {
        List<QFilter> qFilters = this.buildQueryFilters(entityName, reportQueryParam);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        QFilter[] qFilters1 = qFilters.toArray(new QFilter[0]);
        return QueryServiceHelper.queryDataSet((String)PbdStrategyReportListDataPlugin.class.getName(), (String)entityName, (String)(COMMON_SELECT + "," + type), (QFilter[])qFilters1, null);
    }

    private Map<String, Object> buildStrategyFilters(ReportQueryParam reportQueryParam) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        FilterInfo filter = reportQueryParam.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            String property = STRATEGY_PROPERTY.get(propName);
            if (!StringUtils.isNotBlank((CharSequence)property)) continue;
            param.put(property, filterItem.getValue());
        }
        return param;
    }

    private List<QFilter> buildQueryFilters(String entityName, ReportQueryParam reportQueryParam) {
        FilterInfo filter = reportQueryParam.getFilter();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        List filterItems = filter.getFilterItems();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(filterItems.size());
        QFilter fastFilter = this.buildFastFilter(filter, dataEntityType);
        for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            if (STRATEGY_PROPERTY.containsKey(propName) || !this.effectiveProperty(dataEntityType, propName = propName.replace("filtercolum.", "."))) continue;
            QFilter qFilter = new QFilter(propName, filterItem.getCompareType(), filterItem.getValue());
            qFilters.add(qFilter);
        }
        if (fastFilter != null) {
            qFilters.add(fastFilter);
        }
        return qFilters;
    }

    private QFilter buildFastFilter(FilterInfo filterInfo, MainEntityType dataEntityType) {
        FastFilter fastFilter = filterInfo.getFastFilter();
        QFilter qFilter = null;
        if (fastFilter != null) {
            List fastFilter1 = fastFilter.getFastFilter();
            for (Map next : fastFilter1) {
                List objects = (List)next.get("FieldName");
                List values = (List)next.get("Value");
                for (Object object : objects) {
                    String property;
                    if (object == null || !this.effectiveProperty(dataEntityType, property = String.valueOf(object))) continue;
                    for (Object value : values) {
                        if (qFilter == null) {
                            qFilter = new QFilter(property, "ftlike", value);
                        }
                        qFilter.or(property, "ftlike", value);
                    }
                }
            }
        }
        return qFilter;
    }

    private boolean effectiveProperty(MainEntityType dataEntityType, String propName) {
        int i = propName.indexOf(".");
        if (i > 0) {
            String substring = propName.substring(0, i);
            DynamicProperty property = dataEntityType.getProperty(substring);
            return property != null;
        }
        return false;
    }

    static {
        STRATEGY_PROPERTY.put("centrallistfiltercolum.id", "centrallist");
        STRATEGY_PROPERTY.put("purstrategyfiltercolum.id", "purstrategy");
        STRATEGY_PROPERTY.put("srcstrategyfiltercolum.id", "srcstrategy");
    }
}

