/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GroupDataImportOp
extends BatchImportPlugin {
    public static final String IMPORTTYPE = "importtype";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_FULLNAME = "fullname";
    public static final String JBFLBZ_NUMBER = "JBFLBZ";
    public static final String IMPORTTYPE_NEW = "new";
    private Map<String, String> fullNames = new HashMap<String, String>();
    private Map<String, Long> parentIds = new HashMap<String, Long>();

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.beforeImportBill(rowdatas, logger);
        if (rowdatas.isEmpty()) {
            return null;
        }
        return super.save(rowdatas, logger);
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Object object;
        ImportContext ctx = this.ctx;
        String billFormId = ctx.getBillFormId();
        String longNumberDlm = ".";
        MainEntityType dynamicObjectType = (MainEntityType)BusinessDataServiceHelper.newDynamicObject((String)billFormId).getDynamicObjectType();
        DynamicProperty property = dynamicObjectType.getProperty(PROP_PARENT);
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        Map option = ctx.getOption();
        String importtype = IMPORTTYPE_NEW;
        if (option != null && !option.isEmpty() && (object = option.get(IMPORTTYPE)) != null) {
            importtype = object.toString();
        }
        HashSet<String> parentNumbers = new HashSet<String>(rowdatas.size());
        HashSet<String> standardNumbers = new HashSet<String>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            String parentNumber;
            JSONObject data = rowdata.getData();
            Iterator standard = data.get((Object)"standard");
            if (StringUtils.isBlank((Object)standard)) {
                if (!IMPORTTYPE_NEW.equals(importtype)) continue;
                String standardId = GroupStandardUtils.getDefGroupStandard((String)billFormId);
                HashMap<String, String> standardMap = new HashMap<String, String>();
                standardMap.put("id", standardId);
                standardMap.put("number", JBFLBZ_NUMBER);
                standard = standardMap;
                data.put("standard", standardMap);
            }
            String standardNumber = (String)((Map)((Object)standard)).get("number");
            standardNumbers.add(standardNumber);
            Object parent = data.get((Object)PROP_PARENT);
            if (StringUtils.isBlank((Object)parent) || StringUtils.isBlank((CharSequence)(parentNumber = (String)((Map)parent).get("number")))) continue;
            parentNumbers.add(parentNumber);
        }
        QFilter qFilterParent = new QFilter("number", "in", parentNumbers);
        QFilter qFilterStandard = new QFilter("standard.number", "in", standardNumbers);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)billFormId, (String)"id,number,standard.number,fullname", (QFilter[])new QFilter[]{qFilterParent, qFilterStandard});
        for (DynamicObject entity : loadFromCache.values()) {
            ILocaleString fullname = entity.getLocaleString(PROP_FULLNAME);
            String number = entity.getString("number");
            String standardNumber = entity.getDynamicObject("standard").getString("number");
            this.fullNames.put(number + '_' + standardNumber, fullname.getLocaleValue());
            this.parentIds.put(number + '_' + standardNumber, entity.getLong("id"));
        }
        Lang lang = RequestContext.get().getLang();
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            this.handleRowData(logger, iterator, lang.name(), billFormId, longNumberDlm);
        }
    }

    private void handleRowData(ImportLogger logger, Iterator<ImportBillData> iterator, String language, String billFormId, String longNumberDlm) {
        String parentFullName;
        ImportBillData rowdata = iterator.next();
        JSONObject data = rowdata.getData();
        String number = data.getString("number");
        Object fullNameLocale = data.get((Object)"name");
        String fullName = (String)((Map)fullNameLocale).get(language);
        Object standard = data.get((Object)"standard");
        if (StringUtils.isBlank((Object)standard)) {
            return;
        }
        String standardNumber = (String)((Map)standard).get("number");
        Object parent = data.get((Object)PROP_PARENT);
        if (StringUtils.isBlank((Object)parent)) {
            data.put(PROP_FULLNAME, (Object)fullName);
            this.fullNames.put(number + '_' + standardNumber, fullName);
            return;
        }
        Map parentMap = (Map)parent;
        String parentNumber = (String)parentMap.get("number");
        if (StringUtils.isBlank((CharSequence)parentNumber)) {
            data.put(PROP_FULLNAME, (Object)fullName);
            this.fullNames.put(number + '_' + standardNumber, fullName);
            return;
        }
        String key = parentNumber + '_' + standardNumber;
        Long parentId = this.parentIds.get(key);
        if (StringUtils.isNotBlank((Object)parentId)) {
            parentMap.put("id", parentId.toString());
        }
        if (StringUtils.isBlank((CharSequence)(parentFullName = this.fullNames.get(key)))) {
            data.put(PROP_FULLNAME, (Object)fullName);
            this.fullNames.put(number + '_' + standardNumber, fullName);
            return;
        }
        fullName = parentFullName + longNumberDlm + fullName;
        data.put(PROP_FULLNAME, (Object)fullName);
        this.fullNames.put(number + '_' + standardNumber, fullName);
    }
}

