/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.master.MasterDataImportOp;
import kd.bd.master.enums.MaterialEnableBizInfoTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialDataImportOp
extends MasterDataImportOp {
    @Override
    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeImportBill(rowdatas, logger);
        Map importParamMap = this.ctx.getOption();
        String importType = importParamMap.get("importtype").toString();
        if ("new".equals(importType)) {
            return;
        }
        ArrayList<String> numbers = new ArrayList<String>(16);
        for (ImportBillData rowdata : rowdatas) {
            numbers.add(rowdata.getData().getString("number"));
        }
        DynamicObjectCollection updateDatas = QueryServiceHelper.query((String)"bd_material", (String)"id,number,createorg,enablepur,enablesale,enableinv,enableproduct,enableinspect", (QFilter[])new QFilter("number", "in", numbers).toArray());
        Map updateDataMap = updateDatas.stream().collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity()));
        HashMap<ImportBillData, List<String>> validateBizInfoMap = new HashMap<ImportBillData, List<String>>(16);
        try (TraceSpan span = Tracer.create((String)"MaterialDataImportOp", (String)"validateSwitchCheckBizInfo");){
            for (ImportBillData rowdata : rowdatas) {
                List<String> validateBizInfo;
                DynamicObject material = (DynamicObject)updateDataMap.get(rowdata.getData().getString("number"));
                if (material == null || (validateBizInfo = this.getValidateBizInfo(rowdata, material)).isEmpty()) continue;
                validateBizInfoMap.put(rowdata, validateBizInfo);
            }
            Iterator<ImportBillData> iterator = rowdatas.iterator();
            while (iterator.hasNext()) {
                ImportBillData billData = iterator.next();
                String number = billData.getData().getString("number");
                DynamicObject importMaterial = (DynamicObject)updateDataMap.get(number);
                if (importMaterial == null) continue;
                Long pkey = ((DynamicObject)updateDataMap.get(number)).getLong("id");
                ArrayList errorList = new ArrayList(4);
                List checkBizeInfo = (List)validateBizInfoMap.get(billData);
                StringBuilder errorMsg = new StringBuilder();
                if (checkBizeInfo == null || checkBizeInfo.isEmpty()) continue;
                checkBizeInfo.forEach(bizInfo -> {
                    boolean exists = QueryServiceHelper.exists((String)bizInfo, (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)pkey)});
                    if (exists) {
                        errorMsg.append(this.gengerateErrorMsg((String)bizInfo)).append("\n");
                        errorList.add(bizInfo);
                    }
                });
                if (errorList.isEmpty()) continue;
                iterator.remove();
                logger.log(Integer.valueOf(billData.getStartIndex()), errorMsg.toString()).fail();
            }
        }
    }

    private List<String> getValidateBizInfo(ImportBillData rowdata, DynamicObject material) {
        ArrayList<String> enableBizInfoList = new ArrayList<String>(4);
        for (MaterialEnableBizInfoTypeEnum value : MaterialEnableBizInfoTypeEnum.values()) {
            Boolean enableBizFlg = rowdata.getData().getBoolean(value.getEnableTag());
            if (enableBizFlg == null || material.getBoolean(value.getEnableTag()) == enableBizFlg.booleanValue() || enableBizFlg.booleanValue()) continue;
            enableBizInfoList.add(value.getBizInfoTag());
        }
        return enableBizInfoList;
    }

    private String gengerateErrorMsg(String bizInfo) {
        String errorMsg = "";
        String enableFlg = "";
        MainEntityType bizInfoEntityType = EntityMetadataCache.getDataEntityType((String)bizInfo);
        MainEntityType materialEntityType = EntityMetadataCache.getDataEntityType((String)"bd_material");
        String bizInfoNameStr = bizInfoEntityType.getDisplayName().getLocaleValue();
        switch (bizInfo) {
            case "bd_materialpurchaseinfo": {
                enableFlg = materialEntityType.findProperty(MaterialEnableBizInfoTypeEnum.ENABLEPUR.getEnableTag()).getDisplayName().getLocaleValue();
                errorMsg = ResManager.loadKDString((String)"\u7269\u6599\u5df2\u751f\u6210{0}\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u201c{1}\u201d\u3002", (String)"BASEDATA-W-242421", (String)"bd-master-opplugin", (Object[])new Object[]{bizInfoNameStr, enableFlg});
                break;
            }
            case "bd_materialsalinfo": {
                enableFlg = materialEntityType.findProperty(MaterialEnableBizInfoTypeEnum.ENABLESALE.getEnableTag()).getDisplayName().getLocaleValue();
                errorMsg = ResManager.loadKDString((String)"\u7269\u6599\u5df2\u751f\u6210{0}\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u201c{1}\u201d\u3002", (String)"BASEDATA-W-242421", (String)"bd-master-opplugin", (Object[])new Object[]{bizInfoNameStr, enableFlg});
                break;
            }
            case "bd_materialinventoryinfo": {
                enableFlg = materialEntityType.findProperty(MaterialEnableBizInfoTypeEnum.ENABLEINV.getEnableTag()).getDisplayName().getLocaleValue();
                errorMsg = ResManager.loadKDString((String)"\u7269\u6599\u5df2\u751f\u6210{0}\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u201c{1}\u201d\u3002", (String)"BASEDATA-W-242421", (String)"bd-master-opplugin", (Object[])new Object[]{bizInfoNameStr, enableFlg});
                break;
            }
            case "bd_materialmftinfo": {
                enableFlg = materialEntityType.findProperty(MaterialEnableBizInfoTypeEnum.ENABLEPRODUCT.getEnableTag()).getDisplayName().getLocaleValue();
                errorMsg = ResManager.loadKDString((String)"\u7269\u6599\u5df2\u751f\u6210{0}\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u201c{1}\u201d\u3002", (String)"BASEDATA-W-242421", (String)"bd-master-opplugin", (Object[])new Object[]{bizInfoNameStr, enableFlg});
                break;
            }
            case "bd_inspect_cfg": {
                enableFlg = materialEntityType.findProperty(MaterialEnableBizInfoTypeEnum.ENABLEINSPECT.getEnableTag()).getDisplayName().getLocaleValue();
                errorMsg = ResManager.loadKDString((String)"\u7269\u6599\u5df2\u751f\u6210{0}\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u201c{1}\u201d\u3002", (String)"BASEDATA-W-242421", (String)"bd-master-opplugin", (Object[])new Object[]{bizInfoNameStr, enableFlg});
                break;
            }
        }
        return errorMsg;
    }
}

