/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(MaterialDeletePlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        try (TraceSpan traceSpan = Tracer.create((String)"MaterialDeletePlugin", (String)"onAddValidators");){
            super.onAddValidators(e);
            this.getOption().setVariableValue("ignorerefentityids", "bd_multimeasureunit,bd_materialgroupdetail");
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        log.info("MaterialDeletePlugin.beforeExecuteOperationTransaction, record num:" + (e.getDataEntities() == null ? "null" : Integer.valueOf(e.getDataEntities().length)));
        try (TraceSpan traceSpan = Tracer.create((String)"MaterialDeletePlugin", (String)"beforeExecuteOperationTransaction");){
            super.beforeExecuteOperationTransaction(e);
            if (e.getDataEntities() == null || e.getDataEntities().length <= 0) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(e.getDataEntities().length);
            for (DynamicObject obj : e.getDataEntities()) {
                Long dataId = (Long)obj.getPkValue();
                ids.add(dataId);
            }
            try (TraceSpan span = Tracer.create((String)"MaterialDeletePlugin", (String)"delete bd_multimeasureunit");){
                DeleteServiceHelper.delete((String)"bd_multimeasureunit", (QFilter[])new QFilter[]{new QFilter("materialid", "in", ids)});
            }
            span = Tracer.create((String)"MaterialDeletePlugin", (String)"delete bd_materialgroupdetail");
            var6_10 = null;
            try {
                DeleteServiceHelper.delete((String)"bd_materialgroupdetail", (QFilter[])new QFilter[]{new QFilter("material", "in", ids)});
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (span != null) {
                    if (var6_10 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
    }
}

