/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;

public class CustomerAddressDeleteApiService
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(CustomerAddressDeleteApiService.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult apiResult = null;
        try {
            apiResult = this.executeDeleteCustomerAddress(params);
        }
        catch (Exception e) {
            apiResult = ApiResult.fail((String)new Throwable(e).toString());
            logger.error("errorinfo:" + new Throwable(e));
        }
        return apiResult;
    }

    private ApiResult executeDeleteCustomerAddress(Map<String, Object> params) {
        JSONArray customers;
        ApiResult relut = null;
        if (!"deleteaddress".equals(params.get("operation"))) {
            return ApiResult.fail((String)"data formatting error");
        }
        String datas = JSON.toJSONString((Object)params.get("data"));
        if (!StringUtils.isEmpty((String)datas) && (customers = JSON.parseArray((String)datas)) != null && customers.size() > 0) {
            ArrayList<String> ids = new ArrayList<String>(customers.size());
            ArrayList<String> entryNumbers = null;
            HashMap map = new HashMap(customers.size());
            for (Object customer : customers) {
                JSONObject cus = JSON.parseObject((String)customer.toString());
                Long id = cus.getLong("id");
                JSONArray customerAddressDatas = JSON.parseArray((String)cus.getString("entry_address"));
                if (id == null || id == 0L || customerAddressDatas == null || customerAddressDatas.size() <= 0) continue;
                ids.add(id.toString());
                entryNumbers = new ArrayList<String>(customerAddressDatas.size());
                for (Object address : customerAddressDatas) {
                    JSONObject add = JSON.parseObject((String)address.toString());
                    String addnumber = add.getString("number");
                    entryNumbers.add(addnumber);
                }
                map.put(id.toString(), entryNumbers);
            }
            DynamicObject[] customerAddressDatas = BusinessDataServiceHelper.load((String)"bd_address", (String)"id,customerid", (QFilter[])new QFilter[]{new QFilter("customerid", "in", ids)});
            if (customerAddressDatas != null && customerAddressDatas.length > 0) {
                ArrayList<Long> pks = new ArrayList<Long>(customerAddressDatas.length);
                for (DynamicObject address : customerAddressDatas) {
                    if (map.get(address.getString("customerid")) == null) continue;
                    pks.add(address.getLong("id"));
                }
                DeleteServiceHelper.delete((String)"bd_address", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
            }
            relut = ApiResult.success((Object)"operate successfully.");
        }
        return relut;
    }
}

