/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.webapi.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class MasterWebApiServiceHelper {
    public void createGroupStandData(DynamicObject result, Map<String, String> entityNameMap, Map<String, Map<String, String>> entryMap, Map.Entry<String, Object> entry) {
        JSONArray groupstandards = JSON.parseArray((String)entry.getValue().toString());
        if (groupstandards != null && groupstandards.size() > 0) {
            JSONObject object = null;
            EntryProp entryProp = (EntryProp)result.getDynamicObjectType().getProperties().get((Object)"entry_groupstandard");
            DynamicObject groupstand = null;
            for (int i = 0; i < groupstandards.size(); ++i) {
                object = JSONObject.parseObject((String)groupstandards.getString(i));
                Iterator it = object.entrySet().iterator();
                Map.Entry map = null;
                groupstand = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    if (!(map.getValue() instanceof JSONObject)) continue;
                    JSONObject groupInfo = JSON.parseObject((String)map.getValue().toString());
                    Long id = groupInfo.getLong("id");
                    String number = groupInfo.getString("number");
                    DynamicObject obj = null;
                    if (id != null && id != 0L) {
                        obj = BusinessDataServiceHelper.loadSingleFromCache((String)entryMap.get("entry_groupstandard").get(map.getKey()), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                    }
                    if (obj == null && !StringUtils.isBlank((String)number) && !StringUtils.isEmpty((String)entityNameMap.get(map.getKey()))) {
                        obj = BusinessDataServiceHelper.loadSingleFromCache((String)entryMap.get("entry_groupstandard").get(map.getKey()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                    }
                    if (obj == null) continue;
                    groupstand.set((String)map.getKey(), obj);
                }
                result.getDynamicObjectCollection("entry_groupstandard").add((Object)groupstand);
            }
        }
    }

    public void createBankData(DynamicObject result, Map<String, String> entityNameMap, Map<String, Map<String, String>> entryMap, Map.Entry<String, Object> entry) {
        JSONArray banks = JSON.parseArray((String)entry.getValue().toString());
        if (banks != null && banks.size() > 0) {
            JSONObject object = null;
            EntryProp entryProp = (EntryProp)result.getDynamicObjectType().getProperties().get((Object)"entry_bank");
            DynamicObject bank = null;
            for (int i = 0; i < banks.size(); ++i) {
                object = JSONObject.parseObject((String)banks.getString(i));
                Iterator it = object.entrySet().iterator();
                Map.Entry map = null;
                bank = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
                bank.set("seq", (Object)(i + 1));
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    if (map.getValue() instanceof JSONObject) {
                        JSONObject bankInfo = JSON.parseObject((String)map.getValue().toString());
                        Long id = bankInfo.getLong("id");
                        String number = bankInfo.getString("number");
                        DynamicObject obj = null;
                        if (id != null && id != 0L) {
                            obj = BusinessDataServiceHelper.newDynamicObject((String)entryMap.get("entry_bank").get(map.getKey()));
                            obj.set("id", (Object)id);
                        }
                        if (obj == null && !StringUtils.isBlank((String)number) && !StringUtils.isEmpty((String)entityNameMap.get(map.getKey()))) {
                            obj = BusinessDataServiceHelper.loadSingleFromCache((String)entryMap.get("entry_bank").get(map.getKey()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                        }
                        if (obj == null) continue;
                        bank.set((String)map.getKey(), obj);
                        continue;
                    }
                    bank.set((String)map.getKey(), map.getValue());
                }
                result.getDynamicObjectCollection("entry_bank").add((Object)bank);
            }
        }
    }

    public void createLinkManData(DynamicObject result, Map.Entry<String, Object> entry) {
        JSONArray linkmans = JSON.parseArray((String)entry.getValue().toString());
        if (linkmans != null && linkmans.size() > 0) {
            JSONObject object = null;
            EntryProp entryProp = (EntryProp)result.getDynamicObjectType().getProperties().get((Object)"entry_linkman");
            DynamicObject linkMan = null;
            for (int i = 0; i < linkmans.size(); ++i) {
                object = JSONObject.parseObject((String)linkmans.getString(i));
                Iterator it = object.entrySet().iterator();
                Map.Entry map = null;
                linkMan = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
                linkMan.set("seq", (Object)(i + 1));
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    linkMan.set((String)map.getKey(), map.getValue());
                }
                result.getDynamicObjectCollection("entry_linkman").add((Object)linkMan);
            }
        }
    }

    public void createFormData(DynamicObject result, Map<String, String> entityNameMap, Map.Entry<String, Object> entry, Set<String> dateProSet) throws Throwable {
        if (entry.getValue() instanceof JSONObject) {
            JSONObject object = JSON.parseObject((String)entry.getValue().toString());
            Long id = object.getLong("id");
            String number = object.getString("number");
            DynamicObject obj = null;
            if (id != null && id != 0L) {
                obj = BusinessDataServiceHelper.newDynamicObject((String)entityNameMap.get(entry.getKey()));
                obj.set("id", (Object)id);
            }
            if (obj == null && !StringUtils.isBlank((String)number) && !StringUtils.isEmpty((String)entityNameMap.get(entry.getKey()))) {
                obj = BusinessDataServiceHelper.loadSingleFromCache((String)entityNameMap.get(entry.getKey()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            }
            if (obj != null) {
                result.set(entry.getKey(), obj);
            }
        } else if (dateProSet.contains(entry.getKey()) && entry.getValue() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            result.set(entry.getKey(), (Object)sdf.parse(String.valueOf(entry.getValue())));
        } else {
            result.set(entry.getKey(), entry.getValue());
        }
    }

    public List<DynamicObject> getAddressInfo(Map<String, String> entityNameMap, Map<String, Map<String, String>> entryMap, Map.Entry<String, Object> entry, Map<String, String> addressEntityNameMap) {
        JSONArray addressList = JSON.parseArray((String)entry.getValue().toString());
        ArrayList<DynamicObject> result = null;
        if (addressList != null && addressList.size() > 0) {
            result = new ArrayList<DynamicObject>(addressList.size());
            DynamicObject address = null;
            Map.Entry map2 = null;
            JSONObject object = null;
            for (int i = 0; i < addressList.size(); ++i) {
                address = BusinessDataServiceHelper.newDynamicObject((String)"bd_address");
                object = JSONObject.parseObject((String)addressList.getString(i));
                for (Map.Entry map2 : object.entrySet()) {
                    if (map2.getValue() instanceof JSONObject) {
                        JSONObject data = JSON.parseObject((String)map2.getValue().toString());
                        Long id = data.getLong("id");
                        String number = data.getString("number");
                        DynamicObject obj = null;
                        if (id != null && id != 0L && !StringUtils.isEmpty((String)addressEntityNameMap.get(map2.getKey()))) {
                            obj = BusinessDataServiceHelper.newDynamicObject((String)addressEntityNameMap.get(map2.getKey()));
                            obj.set("id", (Object)id);
                        }
                        if (obj == null && !StringUtils.isBlank((String)number) && !StringUtils.isEmpty((String)addressEntityNameMap.get(map2.getKey()))) {
                            obj = BusinessDataServiceHelper.loadSingleFromCache((String)addressEntityNameMap.get(map2.getKey()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                        }
                        if (obj == null) continue;
                        address.set((String)map2.getKey(), obj);
                        continue;
                    }
                    address.set((String)map2.getKey(), map2.getValue());
                }
                result.add(address);
            }
        }
        return result;
    }

    public void updateFormData(DynamicObject result, Map<String, String> entityNameMap, Map.Entry<String, Object> entry, Set<String> dateProSet) throws ParseException {
        if (entry.getValue() instanceof JSONObject) {
            Long oldPk;
            JSONObject object = JSON.parseObject((String)entry.getValue().toString());
            Long id = object.getLong("id") == null ? Long.valueOf(0L) : object.getLong("id");
            String number = object.getString("number");
            DynamicObject oldData = result.getDynamicObject(entry.getKey());
            DynamicObject obj = null;
            if (oldData != null && !(oldPk = Long.valueOf(oldData.getLong("id"))).equals(id)) {
                if (id != null && id != 0L) {
                    obj = BusinessDataServiceHelper.newDynamicObject((String)entityNameMap.get(entry.getKey()));
                    obj.set("id", (Object)id);
                }
                if (obj == null && !StringUtils.isBlank((String)number) && !StringUtils.isEmpty((String)entityNameMap.get(entry.getKey()))) {
                    obj = BusinessDataServiceHelper.loadSingleFromCache((String)entityNameMap.get(entry.getKey()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                }
                if (obj != null) {
                    result.set(entry.getKey(), obj);
                }
            }
        } else if (dateProSet.contains(entry.getKey()) && entry.getValue() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            result.set(entry.getKey(), (Object)sdf.parse(String.valueOf(entry.getValue())));
        } else {
            result.set(entry.getKey(), entry.getValue());
        }
    }

    public void updateLinkManData(DynamicObject dynamicObject, Map.Entry<String, Object> entry) {
        DynamicObjectCollection likmanDyns = dynamicObject.getDynamicObjectCollection("entry_linkman");
        JSONArray linkmans = JSON.parseArray((String)entry.getValue().toString());
        HashMap<String, JSONObject> updateMap = new HashMap<String, JSONObject>();
        if (linkmans != null && linkmans.size() > 0) {
            JSONObject object = null;
            EntryProp entryProp = (EntryProp)dynamicObject.getDynamicObjectType().getProperties().get((Object)"entry_linkman");
            DynamicObject linkMan = null;
            int num = 0;
            for (int i = 0; i < linkmans.size(); ++i) {
                num = linkmans.size();
                object = JSONObject.parseObject((String)linkmans.getString(i));
                String id = object.getString("id");
                if (!StringUtils.isEmpty((String)id) && Long.parseLong(id) != 0L) {
                    updateMap.put(id, object);
                    continue;
                }
                Iterator it = object.entrySet().iterator();
                Map.Entry map = null;
                linkMan = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
                linkMan.set("seq", (Object)(num + 1));
                ++num;
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    linkMan.set((String)map.getKey(), map.getValue());
                }
                dynamicObject.getDynamicObjectCollection("entry_linkman").add((Object)linkMan);
            }
        }
        if (likmanDyns != null && likmanDyns.size() > 0) {
            JSONObject linkmanObject = null;
            for (DynamicObject linkman : likmanDyns) {
                linkmanObject = (JSONObject)updateMap.get(linkman.getString("id"));
                if (linkmanObject == null) continue;
                Iterator it = linkmanObject.entrySet().iterator();
                Map.Entry map = null;
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    linkman.set((String)map.getKey(), map.getValue());
                }
            }
        }
    }

    public void updateBankData(DynamicObject dynamicObject, Map<String, Map<String, String>> entryMap, Map<String, String> entryEntityNameMap, Map.Entry<String, Object> entry) {
        DynamicObjectCollection bankDyns = dynamicObject.getDynamicObjectCollection("entry_bank");
        JSONArray banks = JSON.parseArray((String)entry.getValue().toString());
        HashMap<String, JSONObject> updateMap = new HashMap<String, JSONObject>();
        if (banks != null && banks.size() > 0) {
            JSONObject object = null;
            EntryProp entryProp = (EntryProp)dynamicObject.getDynamicObjectType().getProperties().get((Object)"entry_bank");
            DynamicObject bank = null;
            int num = 0;
            for (int i = 0; i < banks.size(); ++i) {
                num = banks.size();
                object = JSONObject.parseObject((String)banks.getString(i));
                String id = object.getString("id");
                if (!StringUtils.isEmpty((String)id) && Long.parseLong(id) != 0L) {
                    updateMap.put(id, object);
                    continue;
                }
                Iterator it = object.entrySet().iterator();
                Map.Entry map = null;
                bank = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
                bank.set("seq", (Object)(num + 1));
                ++num;
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    bank.set((String)map.getKey(), map.getValue());
                }
                dynamicObject.getDynamicObjectCollection("entry_bank").add((Object)bank);
            }
        }
        if (bankDyns != null && bankDyns.size() > 0) {
            JSONObject bankObject = null;
            for (DynamicObject bank : bankDyns) {
                bankObject = (JSONObject)updateMap.get(bank.getString("id"));
                if (bankObject == null) continue;
                Iterator it = bankObject.entrySet().iterator();
                Map.Entry map = null;
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    if (map.getValue() instanceof JSONObject) {
                        JSONObject bankInfo = JSON.parseObject((String)map.getValue().toString());
                        Long id = bankInfo.getLong("id");
                        String number = bankInfo.getString("number");
                        DynamicObject obj = null;
                        if (id != null && id != 0L) {
                            obj = BusinessDataServiceHelper.newDynamicObject((String)entryMap.get("entry_bank").get(map.getKey()));
                            obj.set("id", (Object)id);
                        }
                        if (obj == null && !StringUtils.isBlank((String)number) && !StringUtils.isEmpty((String)entryMap.get("entry_bank").get(map.getKey()))) {
                            obj = BusinessDataServiceHelper.loadSingleFromCache((String)entryMap.get("entry_bank").get(map.getKey()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                        }
                        if (obj == null) continue;
                        bank.set((String)map.getKey(), obj);
                        continue;
                    }
                    bank.set((String)map.getKey(), map.getValue());
                }
            }
        }
    }

    public void updateGroupStandData(DynamicObject dynamicObject, Map<String, String> entityNameMap, Map<String, Map<String, String>> entryMap, Map.Entry<String, Object> entry) {
        JSONArray groupstandards = JSON.parseArray((String)entry.getValue().toString());
        if (groupstandards != null && groupstandards.size() > 0) {
            JSONObject object = null;
            EntryProp entryProp = (EntryProp)dynamicObject.getDynamicObjectType().getProperties().get((Object)"entry_groupstandard");
            DynamicObject groupstand = null;
            for (int i = 0; i < groupstandards.size(); ++i) {
                object = JSONObject.parseObject((String)groupstandards.getString(i));
                Iterator it = object.entrySet().iterator();
                Map.Entry map = null;
                groupstand = new DynamicObject(entryProp.getDynamicCollectionItemPropertyType());
                while (it.hasNext()) {
                    map = (Map.Entry)it.next();
                    if (!(map.getValue() instanceof JSONObject)) continue;
                    JSONObject groupInfo = JSON.parseObject((String)map.getValue().toString());
                    Long id = groupInfo.getLong("id");
                    String number = groupInfo.getString("number");
                    DynamicObject obj = null;
                    if (id != null && id != 0L) {
                        obj = BusinessDataServiceHelper.newDynamicObject((String)entryMap.get("entry_groupstandard").get(map.getKey()));
                        obj.set("id", (Object)id);
                    }
                    if (obj == null && !StringUtils.isBlank((String)number) && !StringUtils.isEmpty((String)entityNameMap.get(map.getKey()))) {
                        obj = BusinessDataServiceHelper.loadSingleFromCache((String)entryMap.get("entry_groupstandard").get(map.getKey()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                    }
                    if (obj == null) continue;
                    groupstand.set((String)map.getKey(), obj);
                }
                dynamicObject.getDynamicObjectCollection("entry_groupstandard").add((Object)groupstand);
            }
        }
    }

    public void updateAddressInfoData(DynamicObject dynamicObject, Map<String, String> entryEntityNameMap, Map<String, Map<String, String>> entryMap, Map.Entry<String, Object> entry, String entityName, Map<String, String> addressEntityNameMap) {
        JSONArray addressList = JSON.parseArray((String)entry.getValue().toString());
        ArrayList<String> numbers = new ArrayList<String>();
        if (addressList != null && addressList.size() > 0) {
            JSONObject object = null;
            ArrayList<JSONObject> addJsonObjs = new ArrayList<JSONObject>(addressList.size());
            for (int i = 0; i < addressList.size(); ++i) {
                object = JSONObject.parseObject((String)addressList.getString(i));
                numbers.add(object.getString("number"));
                addJsonObjs.add(object);
            }
            String selectProperties = "id,number,name,linkman,phone,addemail,timezone,enable,status,invalid,default,detailaddress,admindivision,issupplieradd,supplierid,iscustomeradd,customerid";
            QFilter qf1 = new QFilter("number", "in", numbers);
            QFilter qf2 = null;
            if ("bd_supplier".equals(entityName)) {
                qf2 = new QFilter("supplierid", "=", (Object)dynamicObject.getString("id"));
            } else if ("bd_customer".equals(entityName)) {
                qf2 = new QFilter("customerid", "=", (Object)dynamicObject.getString("id"));
            }
            DynamicObject[] exitDatas = BusinessDataServiceHelper.load((String)"bd_address", (String)"id,number,name,linkman,phone,addemail,timezone,enable,status,invalid,default,detailaddress,admindivision,issupplieradd,supplierid,iscustomeradd,customerid", (QFilter[])new QFilter[]{qf1, qf2});
            List<DynamicObject> datas = this.dealAddress(addJsonObjs, exitDatas, dynamicObject, addressEntityNameMap);
            if (datas != null && datas.size() > 0) {
                OperationServiceHelper.executeOperate((String)"save", (String)"bd_address", (DynamicObject[])datas.toArray(new DynamicObject[datas.size()]), null);
            }
        }
    }

    private List<DynamicObject> dealAddress(List<JSONObject> addJsonObjs, DynamicObject[] exitDatas, DynamicObject object, Map<String, String> addressEntityNameMap) {
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(addJsonObjs.size());
        if (exitDatas != null && exitDatas.length > 0) {
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(exitDatas.length);
            for (DynamicObject add : exitDatas) {
                map.put(add.getString("number"), add);
            }
            for (JSONObject address : addJsonObjs) {
                if (map != null && map.size() > 0 && map.get(address.getString("number")) != null) {
                    DynamicObject exitAdd = (DynamicObject)map.get(address.getString("number"));
                    exitAdd.getLocaleString("name").setLocaleValue(address.getString("name"));
                    exitAdd.getLocaleString("phone").setLocaleValue(address.getString("phone"));
                    exitAdd.set("linkman", (Object)address.getString("linkman"));
                    exitAdd.set("addemail", (Object)address.getString("addemail"));
                    exitAdd.set("invalid", address.get((Object)"invalid"));
                    exitAdd.set("default", address.get((Object)"default"));
                    exitAdd.getLocaleString("detailaddress").setLocaleValue(StringUtils.isEmpty((String)address.getString("detailaddress")) ? " " : address.getString("detailaddress"));
                    exitAdd.set("timezone", (Object)this.queryData(address, "timezone", addressEntityNameMap));
                    exitAdd.set("admindivision", address.get((Object)"admindivision") == null ? Integer.valueOf(0) : address.get((Object)"admindivision"));
                    datas.add(exitAdd);
                    continue;
                }
                DynamicObject addressDyn = BusinessDataServiceHelper.newDynamicObject((String)"bd_address");
                if (object.getDataEntityType().getName().contains("bd_supplier")) {
                    addressDyn.set("supplierid", (Object)String.valueOf(object.getPkValue()));
                    addressDyn.set("issupplieradd", (Object)Boolean.TRUE);
                } else if (object.getDataEntityType().getName().contains("bd_customer")) {
                    addressDyn.set("customerid", (Object)String.valueOf(object.getPkValue()));
                    addressDyn.set("iscustomeradd", (Object)Boolean.TRUE);
                }
                addressDyn.set("number", address.get((Object)"addnumber"));
                addressDyn.set("name", (Object)new LocaleString(address.getString("addname")));
                addressDyn.set("phone", (Object)new LocaleString(address.getString("addphone")));
                addressDyn.set("linkman", address.get((Object)"addlinkman"));
                addressDyn.set("addemail", address.get((Object)"addemail"));
                addressDyn.set("invalid", address.get((Object)"addinvalid"));
                addressDyn.set("default", address.get((Object)"default"));
                addressDyn.set("detailaddress", (Object)new LocaleString(address.getString("addfulladdress")));
                addressDyn.set("timezone", (Object)this.queryData(address, "timezone", addressEntityNameMap));
                addressDyn.set("admindivision", address.get((Object)"addadmindivision") == null ? Integer.valueOf(0) : address.get((Object)"addadmindivision"));
                datas.add(addressDyn);
            }
        }
        return datas;
    }

    private DynamicObject queryData(JSONObject address, String key, Map<String, String> addressEntityNameMap) {
        DynamicObject obj = null;
        JSONObject jsonObject = JSON.parseObject((String)address.getString(key));
        if (jsonObject != null) {
            Long id = jsonObject.getLong("id");
            String number = jsonObject.getString("number");
            if (id != null && id != 0L && jsonObject != null) {
                obj = BusinessDataServiceHelper.newDynamicObject((String)addressEntityNameMap.get(key));
                obj.set("id", (Object)id);
            }
            if (obj == null && !StringUtils.isBlank((String)number) && jsonObject != null) {
                obj = BusinessDataServiceHelper.loadSingleFromCache((String)addressEntityNameMap.get(key), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            }
        }
        return obj;
    }
}

