/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.webapi.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.enums.EnableEnum;
import kd.bd.master.enums.StatusEnum;
import kd.bd.master.util.ErrorInfoConverUtil;
import kd.bd.master.vo.OpResultVo;
import kd.bd.master.vo.OperationApiVo;
import kd.bd.master.webapi.business.MaterialWebApiServiceHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public class MaterialWebpiService {
    private static Log logger = LogFactory.getLog(MaterialWebpiService.class);
    private MaterialWebApiServiceHelper webApiServiceHelper = new MaterialWebApiServiceHelper();
    private static final String INVENTORY_UNIT = "inventoryunit";
    private static final String PURCHASE_UNIT = "purchaseunit";
    private static final String SALES_UNIT = "salesunit";
    private static final String MFT_UNIT = "mftunit";
    private static final String MATERIAL_ATTR = "materialattr";
    private static final String MATERIAL_ATTR_DEFAULTVAL = "10030";
    private static final String BOM_VERSION_RULE = "bomversionrule";
    private static final Long BOM_VERSION_RULE_DEFAULTVAL = 780605109909666816L;

    public void setRequiredParameterValue(JSONObject data) {
        String status = data.getString("status");
        String enable = data.getString("enable");
        if (StringUtils.isEmpty((String)status)) {
            data.put("status", (Object)"A");
        }
        if (StringUtils.isEmpty((String)enable)) {
            data.put("enable", (Object)"1");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public OpResultVo createMasterData(List<JSONObject> newDatas, String entityName) throws Throwable {
        HashMap<String, OperationApiVo> resultMap = new HashMap<String, OperationApiVo>(newDatas.size());
        DynamicObject material = null;
        ArrayList<DynamicObject> materialObjs = new ArrayList<DynamicObject>(newDatas.size());
        long[] ids = DB.genLongIds((String)"T_BD_MATERIAL", (int)newDatas.size());
        HashMap<String, OperationApiVo> errorMap = null;
        int i = 0;
        while (true) {
            Map.Entry entry;
            Iterator iter;
            HashMap<String, Map<String, String>> entryMap;
            HashSet<String> dateProSet;
            HashMap<String, String> entityNameMap;
            if (i < newDatas.size()) {
                material = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                material.set("id", (Object)ids[i]);
                entityNameMap = new HashMap<String, String>();
                dateProSet = new HashSet<String>();
                entryMap = new HashMap<String, Map<String, String>>();
                this.analysePropertyData(entityName, entityNameMap, dateProSet, entryMap);
                iter = newDatas.get(i).entrySet().iterator();
                entry = null;
            } else {
                if (materialObjs.size() > 0) {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"bd_material", (DynamicObject[])materialObjs.toArray(new DynamicObject[materialObjs.size()]), (OperateOption)OperateOption.create());
                    if (result.isSuccess() && errorMap == null) {
                        for (Object id : result.getSuccessPkIds()) {
                            String key = id.toString();
                            if (resultMap.containsKey(key)) continue;
                            resultMap.remove(key);
                        }
                        return new OpResultVo(true, resultMap);
                    } else {
                        if (errorMap == null) {
                            errorMap = new HashMap<String, OperationApiVo>();
                        }
                        ErrorInfoConverUtil.billPKErrorMapping(errorMap, (OperationResult)result);
                        if (result.getSuccessPkIds().size() <= 0) return new OpResultVo(false, errorMap);
                        return new OpResultVo(true, errorMap);
                    }
                }
                if (errorMap == null) return new OpResultVo(true, resultMap);
                return new OpResultVo(false, errorMap);
            }
            while (iter.hasNext()) {
                entry = (Map.Entry)iter.next();
                if ("auxptyentry".equals(entry.getKey())) {
                    this.webApiServiceHelper.setEntryAuxptyentryData(material, entryMap, entry);
                    continue;
                }
                if ("entryentity".equals(entry.getKey())) {
                    this.webApiServiceHelper.setEntryentityData(material, entryMap, entry);
                    continue;
                }
                if ("entry_groupstandard".equals(entry.getKey())) {
                    this.webApiServiceHelper.setGroupStandData(material, entryMap, entry);
                    continue;
                }
                this.webApiServiceHelper.setFormData(material, entityNameMap, entry, dateProSet);
            }
            DynamicObject createorg = material.getDynamicObject("createorg");
            if (createorg != null) {
                resultMap.put(String.valueOf(ids[i]), new OperationApiVo(String.valueOf(ids[i]), material.getString("number"), "", "true"));
                materialObjs.add(material);
            } else {
                if (errorMap == null) {
                    errorMap = new HashMap();
                }
                errorMap.put(material.getString("id"), new OperationApiVo(material.getString("id"), material.getString("number"), "createOrg as required, not allowed to be empty.", "false"));
            }
            ++i;
        }
    }

    public OpResultVo updateMasterData(List<Long> ids, Map<Long, JSONObject> jsonDatas, String entityName) throws Throwable {
        HashMap<String, OperationApiVo> resultMap = null;
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType();
        DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[ids.size()]), (DynamicObjectType)dynamicObjectType);
        if (datas != null && datas.length > 0) {
            JSONObject jsondata = null;
            resultMap = new HashMap<String, OperationApiVo>(datas.length);
            ArrayList<DynamicObject> materialObjs = new ArrayList<DynamicObject>(datas.length);
            HashMap<String, OperationApiVo> errorMap = null;
            for (DynamicObject material : datas) {
                jsondata = jsonDatas.get(material.getPkValue());
                HashMap<String, String> entityNameMap = new HashMap<String, String>();
                HashSet<String> dateProSet = new HashSet<String>();
                HashMap<String, Map<String, String>> entryMap = new HashMap<String, Map<String, String>>();
                this.analysePropertyData(entityName, entityNameMap, dateProSet, entryMap);
                Iterator iter = jsondata.entrySet().iterator();
                Map.Entry entry = null;
                while (iter.hasNext()) {
                    entry = (Map.Entry)iter.next();
                    if ("auxptyentry".equals(entry.getKey())) {
                        this.webApiServiceHelper.updateEntryAuxptyentryData(material, entryMap, entry);
                        continue;
                    }
                    if ("entryentity".equals(entry.getKey())) {
                        this.webApiServiceHelper.setEntryentityData(material, entryMap, entry);
                        continue;
                    }
                    if ("entry_groupstandard".equals(entry.getKey())) {
                        this.webApiServiceHelper.setGroupStandData(material, entryMap, entry);
                        continue;
                    }
                    this.webApiServiceHelper.setFormData(material, entityNameMap, entry, dateProSet);
                }
                DynamicObject createorg = material.getDynamicObject("createorg");
                if (createorg != null) {
                    resultMap.put(material.getString("id"), new OperationApiVo(material.getString("id"), material.getString("number"), "", "true"));
                    materialObjs.add(material);
                    continue;
                }
                if (errorMap == null) {
                    errorMap = new HashMap();
                }
                errorMap.put(material.getString("id"), new OperationApiVo(material.getString("id"), material.getString("number"), "createOrg as required, not allowed to be empty.", "false"));
            }
            if (materialObjs.size() > 0) {
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"bd_material", (DynamicObject[])materialObjs.toArray(new DynamicObject[materialObjs.size()]), (OperateOption)OperateOption.create());
                if (result.isSuccess() && errorMap == null) {
                    for (Object id : result.getSuccessPkIds()) {
                        String key = id.toString();
                        if (resultMap.containsKey(key)) continue;
                        resultMap.remove(key);
                    }
                } else {
                    if (errorMap == null) {
                        errorMap = new HashMap<String, OperationApiVo>();
                    }
                    ErrorInfoConverUtil.billPKErrorMapping(errorMap, (OperationResult)result);
                    if (result.getSuccessPkIds().size() > 0) {
                        return new OpResultVo(true, errorMap);
                    }
                    return new OpResultVo(false, errorMap);
                }
            }
            return new OpResultVo(true, resultMap);
        }
        HashMap<String, OperationApiVo> map = new HashMap<String, OperationApiVo>(1);
        map.put("There is a problem with the incoming data, the database does not exist", new OperationApiVo("", "", "There is a problem with the incoming data, the database does not exist", "false"));
        return new OpResultVo(false, map);
    }

    private void analysePropertyData(String entityName, Map<String, String> entityNameMap, Set<String> dateProSet, Map<String, Map<String, String>> entryMap) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection propertyColl = type.getProperties();
        DynamicProperty property = null;
        HashMap<String, String> entryEntityNameMap = null;
        int j = propertyColl.size();
        for (int i = 0; i < j; ++i) {
            property = (DynamicProperty)propertyColl.get(i);
            if (property instanceof BasedataProp) {
                entityNameMap.put(property.getName(), ((BasedataProp)property).getBaseEntityId());
            }
            if (property instanceof DateProp || property instanceof DateTimeProp) {
                dateProSet.add(property.getName());
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection propertyCollection = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
            entryEntityNameMap = new HashMap<String, String>();
            entryMap.put(property.getName(), entryEntityNameMap);
            if (propertyCollection == null || propertyCollection.size() <= 0) continue;
            int k = propertyCollection.size();
            for (int t = 0; t < k; ++t) {
                if (!(propertyCollection.get(t) instanceof BasedataProp)) continue;
                entryEntityNameMap.put(((IDataEntityProperty)propertyCollection.get(t)).getName(), ((BasedataProp)propertyCollection.get(t)).getBaseEntityId());
            }
        }
    }

    public OpResultVo initMaterialBizInfoByMaterial(List<DynamicObject> materialList, String bizInfoFormId) {
        logger.info("initMaterialBizInfoByMaterial, materialList size:" + materialList.size() + ",bizInfoFormId:" + bizInfoFormId);
        List createOrgs = materialList.stream().map(m -> m.getDynamicObject("createorg").getLong("id")).distinct().collect(Collectors.toList());
        Map ctrlStrgyMap = BaseDataServiceHelper.getBdCtrlStrgyBatch((String)bizInfoFormId, createOrgs);
        DynamicObject[] materialBizInfoArr = new DynamicObject[materialList.size()];
        long[] bizInfoIds = DB.genGlobalLongIds((int)materialList.size());
        int len = materialList.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject material = materialList.get(i);
            DynamicObject materialCreateOrg = material.getDynamicObject("createorg");
            DynamicObject materialBizInfo = BusinessDataServiceHelper.newDynamicObject((String)bizInfoFormId);
            materialBizInfo.set("id", (Object)bizInfoIds[i]);
            materialBizInfo.set("masterid", (Object)material);
            materialBizInfo.set("createorg", (Object)materialCreateOrg);
            materialBizInfo.set("ctrlstrategy", ctrlStrgyMap.get(materialCreateOrg.getString("id")));
            materialBizInfo.set("status", (Object)StatusEnum.SAVE.getCode());
            materialBizInfo.set("enable", (Object)EnableEnum.ENABLE.getCode());
            if ("bd_materialinventoryinfo".equals(bizInfoFormId)) {
                materialBizInfo.set(INVENTORY_UNIT, material.get("baseunit"));
                materialBizInfo.set("baseunit", material.get("baseunit"));
            } else if ("bd_materialpurchaseinfo".equals(bizInfoFormId)) {
                materialBizInfo.set(PURCHASE_UNIT, material.get("baseunit"));
            } else if ("bd_materialsalinfo".equals(bizInfoFormId)) {
                materialBizInfo.set(SALES_UNIT, material.get("baseunit"));
            } else if ("bd_materialmftinfo".equals(bizInfoFormId)) {
                materialBizInfo.set(MFT_UNIT, material.get("baseunit"));
                materialBizInfo.set(MATERIAL_ATTR, (Object)MATERIAL_ATTR_DEFAULTVAL);
                materialBizInfo.set(BOM_VERSION_RULE, (Object)BOM_VERSION_RULE_DEFAULTVAL);
                materialBizInfo.set("material", (Object)material);
            } else if ("bd_inspect_cfg".equals(bizInfoFormId)) {
                materialBizInfo.set("material", (Object)material);
            }
            materialBizInfoArr[i] = materialBizInfo;
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)bizInfoFormId, (DynamicObject[])materialBizInfoArr, (OperateOption)OperateOption.create());
        Map resultMap = ErrorInfoConverUtil.buildMaterialBizInfoErrorMapping((DynamicObject[])materialBizInfoArr, (OperationResult)saveResult);
        if (saveResult.isSuccess()) {
            return new OpResultVo(true, resultMap);
        }
        return new OpResultVo(false, resultMap);
    }

    public void forceSetStatusAndEnable(JSONObject jsonObj) {
        if (jsonObj == null) {
            return;
        }
        jsonObj.put("status", (Object)StatusEnum.SAVE.getCode());
        jsonObj.put("enable", (Object)EnableEnum.ENABLE.getCode());
    }
}

