/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bd.assistant.api.BdWbsService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BdWbsServiceImpl
implements BdWbsService {
    private static final Log logger = LogFactory.getLog(BdWbsServiceImpl.class);

    public Map<String, Object> queryBdWbs(String projectNum, String wbsNum, Boolean isCheck, Boolean isInvoice, Boolean isPlan) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("success", false);
        resultMap.put("errorMsg", "");
        resultMap.put("data", null);
        try {
            if (StringUtils.isBlank((CharSequence)projectNum) && StringUtils.isBlank((CharSequence)wbsNum)) {
                resultMap.put("errorMsg", ResManager.loadKDString((String)"\u9879\u76ee\u53f7\u548cwbs\u7f16\u7801\u81f3\u5c11\u5f55\u5165\u4e00\u4e2a\u3002", (String)"BdWbsServiceImpl_0", (String)"bd-assistant-mservice", (Object[])new Object[0]));
                return resultMap;
            }
            logger.info(String.format("\u67e5\u8be2bd_wbs\u670d\u52a1\u53c2\u6570\uff0c\u9879\u76ee\u53f7\uff1a%1$s\uff0cwbs\u7f16\u7801:%2$s,isCheck:%3$s,isInvoice:%4$s,isPlan:%5$s", projectNum, wbsNum, this.getBooleanString(isCheck), this.getBooleanString(isInvoice), this.getBooleanString(isPlan)));
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            if (StringUtils.isNotBlank((CharSequence)projectNum)) {
                qFilterList.add(new QFilter("project.number", "=", (Object)projectNum));
            }
            if (StringUtils.isNotBlank((CharSequence)wbsNum)) {
                qFilterList.add(new QFilter("number", "=", (Object)wbsNum));
            }
            if (isCheck != null) {
                qFilterList.add(new QFilter("ischeck", "=", (Object)isCheck));
            }
            if (isInvoice != null) {
                qFilterList.add(new QFilter("isinvoice", "=", (Object)isInvoice));
            }
            if (isPlan != null) {
                qFilterList.add(new QFilter("isplan", "=", (Object)isPlan));
            }
            DynamicObject[] wbsColl = BusinessDataServiceHelper.load((String)"bd_wbs", (String)"project, id, number, name, isplan, ischeck, isinvoice, level", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
            ArrayList dataList = new ArrayList(wbsColl.length);
            for (DynamicObject wbsDyn : wbsColl) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("wbsId", wbsDyn.getLong("id"));
                dataMap.put("wbsNumber", wbsDyn.getString("number"));
                dataMap.put("wbsName", wbsDyn.getString("name"));
                dataMap.put("projectId", wbsDyn.getLong("project.id"));
                dataMap.put("projectNumber", wbsDyn.getString("project.number"));
                dataMap.put("projectName", wbsDyn.getString("project.name"));
                dataMap.put("isCheck", wbsDyn.getBoolean("ischeck"));
                dataMap.put("isInvoice", wbsDyn.getBoolean("isinvoice"));
                dataMap.put("isPlan", wbsDyn.getBoolean("isplan"));
                dataMap.put("wbsLevel", wbsDyn.getInt("level"));
                dataList.add(dataMap);
            }
            resultMap.put("success", true);
            resultMap.put("data", dataList);
            logger.info("\u67e5\u8be2bd_wbs\u670d\u52a1\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString(resultMap));
            return resultMap;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2bd_wbs\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            resultMap.put("errorMsg", e.getMessage());
            return resultMap;
        }
    }

    private String getBooleanString(Boolean b) {
        return b == null ? "" : b.toString();
    }

    public Map<String, Object> queryBdWbsForProject(Set<Long> projectSet, Set<Long> wbsSet, Boolean isCheck, Boolean isInvoice, Boolean isPlan) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("success", false);
        resultMap.put("errorMsg", "");
        resultMap.put("data", null);
        try {
            if (projectSet != null && wbsSet != null) {
                resultMap.put("errorMsg", ResManager.loadKDString((String)"\u9879\u76ee\u53f7\u548cwbs\u7f16\u7801\u81f3\u5c11\u5f55\u5165\u4e00\u4e2a\u3002", (String)"BdWbsServiceImpl_0", (String)"bd-assistant-mservice", (Object[])new Object[0]));
                return resultMap;
            }
            logger.info(String.format("\u67e5\u8be2bd_wbs\u670d\u52a1\u53c2\u6570\uff0c\u9879\u76ee\u53f7\uff1a%1$s\uff0cwbs\u7f16\u7801:%2$s,isCheck:%3$s,isInvoice:%4$s,isPlan:%5$s", projectSet, wbsSet, this.getBooleanString(isCheck), this.getBooleanString(isInvoice), this.getBooleanString(isPlan)));
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            if (projectSet != null) {
                qFilterList.add(new QFilter("project.id", "in", projectSet));
            }
            if (wbsSet != null) {
                qFilterList.add(new QFilter("id", "in", wbsSet));
            }
            if (isCheck != null) {
                qFilterList.add(new QFilter("ischeck", "=", (Object)isCheck));
            }
            if (isInvoice != null) {
                qFilterList.add(new QFilter("isinvoice", "=", (Object)isInvoice));
            }
            if (isPlan != null) {
                qFilterList.add(new QFilter("isplan", "=", (Object)isPlan));
            }
            DynamicObject[] wbsColl = BusinessDataServiceHelper.load((String)"bd_wbs", (String)"project, id, number, name, isplan, ischeck, isinvoice, level", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
            ArrayList dataList = new ArrayList(wbsColl.length);
            for (DynamicObject wbsDyn : wbsColl) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("wbsId", wbsDyn.getLong("id"));
                dataMap.put("wbsNumber", wbsDyn.getString("number"));
                dataMap.put("wbsName", wbsDyn.getString("name"));
                dataMap.put("projectId", wbsDyn.getLong("project.id"));
                dataMap.put("projectNumber", wbsDyn.getString("project.number"));
                dataMap.put("projectName", wbsDyn.getString("project.name"));
                dataMap.put("isCheck", wbsDyn.getBoolean("ischeck"));
                dataMap.put("isInvoice", wbsDyn.getBoolean("isinvoice"));
                dataMap.put("isPlan", wbsDyn.getBoolean("isplan"));
                dataMap.put("wbsLevel", wbsDyn.getInt("level"));
                dataList.add(dataMap);
            }
            resultMap.put("success", true);
            resultMap.put("data", dataList);
            logger.info("\u67e5\u8be2bd_wbs\u670d\u52a1\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString(resultMap));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2bd_wbs\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            resultMap.put("errorMsg", e.getMessage());
        }
        return resultMap;
    }
}

