/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bd.sbd.enums.AuxPtyValueTypeEnum;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.ErrorType;
import kd.bd.sbd.enums.StatusEnum;
import kd.bd.sbd.errorcode.SbdBaseErrorCode;
import kd.bd.sbd.errorcode.ScmErrorCodeUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class AuxPtyValueFormPlugin
extends AbstractBillPlugIn
implements ItemClickListener,
RowClickEventListener {
    private static final String ISSHOWALLNOORG = "isShowAllNoOrg";
    private static final String ISSHOWALLNOORG_TRUE = "true";
    private static final String AUXPTY_SELECTED_CALLBACK = "auxptySelectedCallBack";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("isFromMaterial") != null && customParams.get("isFromMaterial").toString().equals("1")) {
            this.getModel().setValue("material", customParams.get("material") != null ? customParams.get("material").toString() : null);
            this.getModel().setValue("auxpty", customParams.get("auxpty") != null ? customParams.get("auxpty").toString() : null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"material", "auxpty"});
        } else if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"material", "auxpty"});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"material", "auxpty"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
        Object modifier = this.getModel().getValue("modifier");
        if (modifier == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object status = this.getModel().getValue("modifier");
        if (status != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pagepanel"});
        }
        this.getView().updateView("pagepanel");
        if (e.getSource() != null && e.getSource().toString().contains("SaveAndNew") && e.getOperationResult().isSuccess()) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.ADDNEW);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initMaterialF7();
        this.initAuxPtyF7();
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        String operationKey = e.getOperationKey();
        if ("btnreset".equals(itemKey)) {
            this.getModel().deleteEntryData("entryentity");
            this.rebuildAuxPtyEntry(this.getModel().getValue("auxpty"));
        }
        if ("btn_addrow".equals(operationKey)) {
            this.addRowClick();
        }
    }

    private void addRowClick() {
        Object material = this.getModel().getValue("material");
        if (material == null) {
            new ScmErrorCodeUtils().showMessge(this.getView(), new SbdBaseErrorCode().getErrorInfo(ErrorType.MSG_NoMaterial));
            return;
        }
        Object auxpty = this.getModel().getValue("auxpty");
        if (auxpty == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f85\u52a9\u5c5e\u6027\u3002", (String)"BASEDATA-P-021562", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject auxptyDO = (DynamicObject)auxpty;
        auxptyDO = BusinessDataServiceHelper.loadSingle((Object)auxptyDO.getPkValue(), (String)"bd_auxproperty", (String)"id,number,name,valuetype,valuesource,assistanttype");
        String bdSouNumber = null;
        long assTypeId = 0L;
        if (AuxPtyValueTypeEnum.BASEDATA.getValue().equals(auxptyDO.getString("valuetype"))) {
            bdSouNumber = auxptyDO.getDynamicObject("valuesource").getString("number");
        } else if (AuxPtyValueTypeEnum.ASSISTDATA.getValue().equals(auxptyDO.getString("valuetype"))) {
            bdSouNumber = "bos_assistantdata_detail";
            DynamicObject assistanttype = auxptyDO.getDynamicObject("assistanttype");
            if (assistanttype == null) {
                return;
            }
            assTypeId = assistanttype.getLong("id");
        }
        if (bdSouNumber == null) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)bdSouNumber, (boolean)true);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        Object[] muids = new Long[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            muids[i] = (Long)this.getModel().getValue("auxptyvalueid", i);
        }
        lsp.setSelectedRows(muids);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, AUXPTY_SELECTED_CALLBACK));
        MainEntityType apValueDynObjType = EntityMetadataCache.getDataEntityType((String)bdSouNumber);
        HashSet<QFilter> qfilterset = new HashSet<QFilter>();
        if (apValueDynObjType.getProperty("status") != null) {
            QFilter qfilter1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            qfilterset.add(qfilter1);
        }
        if (apValueDynObjType.getProperty("enable") != null) {
            QFilter qfilter2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            qfilterset.add(qfilter2);
        }
        if (assTypeId > 0L) {
            QFilter qfilter3 = new QFilter("group", "=", (Object)assTypeId);
            qfilterset.add(qfilter3);
        }
        lsp.getListFilterParameter().getQFilters().addAll(qfilterset);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (AUXPTY_SELECTED_CALLBACK.equals(actionId)) {
            try (TraceSpan span = Tracer.create((String)"AuxPtyValueFormPlugin", (String)"showAuxPtyEntry");){
                this.showAuxPtyEntry(e);
            }
        }
    }

    private void showAuxPtyEntry(ClosedCallBackEvent e) {
        ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
        if (col == null || col.size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        HashSet<Long> muids = new HashSet<Long>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            muids.add((Long)this.getModel().getValue("auxptyvalueid", i));
        }
        ArrayList<Long> muidsToAdd = new ArrayList<Long>();
        for (ListSelectedRow row : col) {
            Long muid = (Long)row.getPrimaryKeyValue();
            if (muids.contains(muid)) continue;
            muidsToAdd.add(muid);
        }
        QFilter ids = new QFilter("id", "in", muidsToAdd);
        Object auxpty = this.getModel().getValue("auxpty");
        DynamicObject auxptyDO = (DynamicObject)auxpty;
        auxptyDO = BusinessDataServiceHelper.loadSingle((Object)auxptyDO.getPkValue(), (String)"bd_auxproperty", (String)"id,number,name,valuetype,valuesource,assistanttype");
        String bdSouNumber = null;
        if (AuxPtyValueTypeEnum.BASEDATA.getValue().equals(auxptyDO.getString("valuetype"))) {
            bdSouNumber = auxptyDO.getDynamicObject("valuesource").getString("number");
        } else if (AuxPtyValueTypeEnum.ASSISTDATA.getValue().equals(auxptyDO.getString("valuetype"))) {
            bdSouNumber = "bos_assistantdata_detail";
        }
        if (bdSouNumber == null) {
            return;
        }
        if (muidsToAdd.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", muidsToAdd.size());
            DynamicObject[] apValueDOArray = BusinessDataServiceHelper.load((String)bdSouNumber, (String)"id,number,name,status,enable", (QFilter[])new QFilter[]{ids});
            this.getModel().beginInit();
            for (int i = 0; i < apValueDOArray.length; ++i) {
                DynamicObject apValueDO = apValueDOArray[i];
                this.getModel().setValue("auxptyvalueid", apValueDO.get("id"), i + rowCount);
                this.getModel().setValue("apvaluenum", apValueDO.get("number"), i + rowCount);
                this.getModel().setValue("apvaluenames", apValueDO.get("name"), i + rowCount);
                this.getModel().setValue("isenable", (Object)true, i + rowCount);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == null && oldValue == null || newValue != null && newValue.equals(oldValue)) {
            return;
        }
        if ("material".equals(name)) {
            this.getModel().setValue("auxpty", null);
            this.getModel().deleteEntryData("entryentity");
        } else if ("auxpty".equals(name)) {
            this.getModel().deleteEntryData("entryentity");
        } else if (newValue instanceof Boolean && Boolean.parseBoolean(newValue.toString()) && "isdefault".equals(name)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            int rowsel = this.getModel().getEntryCurrentRowIndex("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                if (i == rowsel) continue;
                this.getModel().setValue("isdefault", (Object)Boolean.FALSE, i);
            }
        }
    }

    private void initMaterialF7() {
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("material");
        materialF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter1 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            QFilter qFilter2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            QFilter qFilter3 = new QFilter("isuseauxpty", "=", (Object)Boolean.TRUE);
            showParameter.setCustomParam(ISSHOWALLNOORG, (Object)ISSHOWALLNOORG_TRUE);
            showParameter.getListFilterParameter().setFilter(qFilter1.and(qFilter2).and(qFilter3));
        });
    }

    private void initAuxPtyF7() {
        BasedataEdit auxPtyF7 = (BasedataEdit)this.getControl("auxpty");
        auxPtyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject dy = this.getModel().getDataEntity();
            HashSet<Long> auxptyidset = new HashSet<Long>();
            if (dy != null) {
                DynamicObject materialDO = dy.getDynamicObject("material");
                if (materialDO == null) {
                    new ScmErrorCodeUtils().showMessge(this.getView(), new SbdBaseErrorCode().getErrorInfo(ErrorType.MSG_NoMaterial));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObjectCollection materialapentrys = materialDO.getDynamicObjectCollection("auxptyentry");
                if (materialapentrys != null && materialapentrys.size() > 0) {
                    for (DynamicObject mapEntry : materialapentrys) {
                        DynamicObject mapDO = mapEntry.getDynamicObject("auxpty");
                        Long mapauxptyid = mapDO.getLong("id");
                        DynamicObject matauxptyDO = BusinessDataServiceHelper.loadSingle((Object)mapDO.getPkValue(), (String)"bd_auxproperty", (String)"id,number,name,valuetype,valuesource,assistanttype");
                        if (AuxPtyValueTypeEnum.BYHANDINPUT.getValue().equals(matauxptyDO.getString("valuetype")) || auxptyidset.contains(mapauxptyid)) continue;
                        auxptyidset.add(mapauxptyid);
                    }
                }
            }
            QFilter qFilter = new QFilter("id", "in", auxptyidset);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void rebuildAuxPtyEntry(Object auxpty) {
        DynamicObject auxptyDO = null;
        if (auxpty instanceof DynamicObject) {
            auxptyDO = (DynamicObject)auxpty;
            auxptyDO = BusinessDataServiceHelper.loadSingle((Object)auxptyDO.getPkValue(), (String)"bd_auxproperty", (String)"id,number,name,valuetype,valuesource,assistanttype");
            String bdSouNumber = null;
            long assTypeId = 0L;
            if (AuxPtyValueTypeEnum.BASEDATA.getValue().equals(auxptyDO.getString("valuetype"))) {
                bdSouNumber = auxptyDO.getDynamicObject("valuesource").getString("number");
            } else if (AuxPtyValueTypeEnum.ASSISTDATA.getValue().equals(auxptyDO.getString("valuetype"))) {
                bdSouNumber = "bos_assistantdata_detail";
                DynamicObject assistanttype = auxptyDO.getDynamicObject("assistanttype");
                if (assistanttype == null) {
                    return;
                }
                assTypeId = assistanttype.getLong("id");
            }
            MainEntityType apValueDynObjType = EntityMetadataCache.getDataEntityType((String)bdSouNumber);
            QFilter qfilter1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            QFilter qfilter2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            QFilter qfilter3 = null;
            HashSet<QFilter> qfilterset = new HashSet<QFilter>();
            if (apValueDynObjType.getProperty("status") != null) {
                qfilterset.add(qfilter1);
            }
            if (apValueDynObjType.getProperty("enable") != null) {
                qfilterset.add(qfilter2);
            }
            if (assTypeId > 0L) {
                qfilter3 = new QFilter("group", "=", (Object)assTypeId);
                qfilterset.add(qfilter3);
            }
            DynamicObject[] apValueDOArray = BusinessDataServiceHelper.load((String)bdSouNumber, (String)"id,number,name,status,enable", (QFilter[])qfilterset.toArray(new QFilter[0]));
            this.getModel().deleteEntryData("entryentity");
            if (apValueDOArray != null && apValueDOArray.length > 0) {
                for (int i = 0; i < apValueDOArray.length; ++i) {
                    int newrowIndex = this.getModel().createNewEntryRow("entryentity");
                    DynamicObject entryDO = apValueDOArray[i];
                    DynamicObjectType entryDODynObjType = entryDO.getDynamicObjectType();
                    long id = entryDODynObjType.getProperty("id") != null ? entryDO.getLong("id") : 0L;
                    this.getModel().setValue("auxptyvalueid", (Object)id, newrowIndex);
                    String number = entryDODynObjType.getProperty("number") != null ? entryDO.getString("number") : "";
                    this.getModel().setValue("apvaluenum", (Object)number, newrowIndex);
                    ILocaleString name = entryDODynObjType.getProperty("name") != null ? entryDO.getLocaleString("name") : null;
                    this.getModel().setValue("apvaluenames", (Object)name, newrowIndex);
                    this.getModel().setValue("isdefault", (Object)Boolean.FALSE, newrowIndex);
                    this.getModel().setValue("isenable", (Object)Boolean.TRUE, newrowIndex);
                }
            }
            this.getModel().getEntryEntity("entryentity");
        }
    }
}

