/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class TrackNumberListPlugin
extends AbstractTreeListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List columns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : columns) {
            if (!"createorg.number".equals(filterColumn.getFieldName())) continue;
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
            DynamicObjectCollection orgIdList = this.getAuthorizedOrg(Long.parseLong(RequestContext.get().getUserId()), "bd_tracknumber", "47156aff000000ac");
            for (DynamicObject dynamicObject : orgIdList) {
                ComboItem customFiter = new ComboItem();
                customFiter.setCaption(new LocaleString(dynamicObject.getString("name")));
                customFiter.setValue(String.valueOf(dynamicObject.get("id")));
                combos.add(customFiter);
            }
            CommonFilterColumn orgColumn = (CommonFilterColumn)filterColumn;
            orgColumn.setComboItems(combos);
            orgColumn.setType("enum");
            if (orgIdList.size() <= 0) continue;
            String orgId = String.valueOf(((DynamicObject)orgIdList.get(0)).get("id"));
            filterColumn.setDefaultValue(orgId);
            this.getPageCache().put("createorg", orgId);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList != null) {
            this.getPageCache().remove("createorg");
            for (Map map : customFiterList) {
                List orgIds;
                List fieldNames = (List)map.get("FieldName");
                if (fieldNames == null || fieldNames.size() == 0 || !"createorg.id".equals(fieldNames.get(0)) || (orgIds = (List)map.get("Value")) == null || orgIds.size() == 0) continue;
                String orgId = String.valueOf(orgIds.get(0));
                this.getPageCache().put("createorg", orgId);
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)e.getParameter();
        String numberCache = this.getPageCache().get("createorg");
        if (null != numberCache && !"".equals(numberCache)) {
            String selectOrgId = (String)SerializationUtils.fromJsonString((String)numberCache, String.class);
            if (selectOrgId == null) {
                List orgIdList = PermissionServiceHelper.getUserOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
                selectOrgId = String.valueOf(orgIdList.get(0));
            }
            baseShowParameter.setCustomParam("SELECT_ORG_ID", (Object)selectOrgId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if ("closestatus".equals(operationKey) || "unclosestatus".equals(operationKey)) {
            this.refreshList();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String id;
        super.closedCallBack(closedCallBackEvent);
        switch (id = closedCallBackEvent.getActionId()) {
            case "newcallback": {
                this.refreshList();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    private DynamicObjectCollection getAuthorizedOrg(Long userID, String entityID, String permissionItem) {
        List orgIdList = PermissionServiceHelper.getUserOrgs((long)userID);
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIdList.toArray(), (DynamicObjectType)orgType);
        DynamicObjectCollection col = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgMap.values()) {
            if (!org.getBoolean("enable")) continue;
            col.add((Object)org);
        }
        return col;
    }

    private void refreshList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }
}

