/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.mds;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class PurDemandDefinitionListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(PurDemandDefinitionListPlugin.class);
    public static final String SUBMIT = "submit";
    public static final String BILLLIST = "billlistap";
    public static final String MDS_DMTP = "mds_dmtp";
    private static final String KEY_SHORT_CUTS_KEY = "ctrl+alt+o";
    private static final String KEY_SHORT_CUTS_VALUE = "[17,18,79]";
    private static final String CUS_EVT_SHORT_CUTS = "shortCuts";
    private static final String BAR_SYNC_HIS_DATA = "barsynchisdata";
    private static final String OP_SYNC_HIS_DATA = "synchisdata";

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        String eventName = e.getEventName();
        if (CUS_EVT_SHORT_CUTS.equalsIgnoreCase(eventName) && KEY_SHORT_CUTS_VALUE.equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SYNC_HIS_DATA});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SYNC_HIS_DATA});
        this.setShortCuts();
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyDown");
        item.put(CUS_EVT_SHORT_CUTS, (Object)KEY_SHORT_CUTS_KEY);
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        if (SUBMIT.equals(key) && !this.valid()) {
            args.setCancel(true);
        }
        super.beforeDoOperation(args);
    }

    private boolean valid() {
        BillList list = (BillList)this.getView().getControl(BILLLIST);
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (!rows.isEmpty()) {
            DynamicObject[] sings;
            Object[] pkArray = new Object[rows.size()];
            int i = 0;
            for (ListSelectedRow r : rows) {
                pkArray[i++] = r.getPrimaryKeyValue();
            }
            for (DynamicObject o : sings = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)list.getEntityType())) {
                if (this.dateValidation(o.getDate("startdate"), o.getDate("enddate"))) continue;
                return false;
            }
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String cdate = sdf.format(now);
        Date comp = null;
        try {
            comp = sdf.parse(cdate);
        }
        catch (ParseException e1) {
            comp = now;
        }
        String sqlk = " update t_bd_dmtp set fenable='0' where fenddate<? and fstatus='C' and  fenable<>'0' ";
        DB.update((DBRoute)DBRoute.of((String)"sbd"), (String)sqlk, (Object[])new Object[]{comp});
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc");
    }

    private boolean dateValidation(Date start, Date end) {
        Date now = new Date(System.currentTimeMillis());
        if (start != null && !this.comp(start, now)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u64cd\u4f5c\u65f6\u95f4\u3002", (String)"PurDemandDefinitionListPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (end != null && this.comp(now, end)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u64cd\u4f5c\u65f6\u95f4\u3002", (String)"PurDemandDefinitionListPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (start != null && end != null && this.comp(start, end)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u65f6\u95f4\u3002", (String)"PurDemandDefinitionListPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean comp(Date comp, Date now) {
        Calendar nCal = Calendar.getInstance();
        nCal.setTime(now);
        Calendar cCal = Calendar.getInstance();
        cCal.setTime(comp);
        if (cCal.get(1) > nCal.get(1)) {
            return true;
        }
        if (cCal.get(1) < nCal.get(1)) {
            return false;
        }
        if (cCal.get(2) > nCal.get(2)) {
            return true;
        }
        if (cCal.get(2) < nCal.get(2)) {
            return false;
        }
        return cCal.get(5) >= nCal.get(5);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (OP_SYNC_HIS_DATA.equals(operateKey) && result.isSuccess()) {
            try {
                this.syncHisData();
                this.getView().updateView();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5386\u53f2\u6570\u636e\u6210\u529f\u3002", (String)"PurDemandDefinitionListPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            }
            catch (Exception exception) {
                logger.error("\u9700\u6c42\u7c7b\u578b\u5347\u7ea7\u5386\u53f2\u6570\u636e\u51fa\u73b0\u5f02\u5e38", (Throwable)exception);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9700\u6c42\u7c7b\u578b\u5347\u7ea7\u5386\u53f2\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"PurDemandDefinitionListPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void syncHisData() {
        DBRoute dbRoutScm = DBRoute.of((String)"scm");
        DBRoute dbRoutSys = DBRoute.of((String)"sys");
        String algoKey = ((Object)((Object)this)).getClass().getName();
        List<String> mainTableFields = this.getMainTableFields();
        String selectScmData = String.format("select %s from t_mds_dmtp;", String.join((CharSequence)",", mainTableFields));
        DataSet scmData = DB.queryDataSet((String)algoKey, (DBRoute)dbRoutScm, (String)selectScmData);
        ArrayList<Object[]> scmDataParamList = new ArrayList<Object[]>();
        ArrayList<Object> scmDataIdList = new ArrayList<Object>();
        HashMap<Long, Long> dataOrgMap = new HashMap<Long, Long>(16);
        for (Row row : scmData) {
            Object[] param = new Object[mainTableFields.size()];
            for (int i = 0; i < mainTableFields.size(); ++i) {
                param[i] = row.get(i);
            }
            scmDataParamList.add(param);
            scmDataIdList.add(row.get("fid"));
            dataOrgMap.put(row.getLong("fid"), row.getLong("fcreateorgid"));
        }
        if (scmDataParamList.isEmpty()) {
            logger.info("\u9700\u6c42\u7c7b\u578b\u540c\u6b65\u5386\u53f2\u6570\u636e\uff1a\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\u3002");
            return;
        }
        List<String> mulLangTableFields = this.getMulLangTableFields();
        String selectScmMulLangData = String.format("select %s from t_mds_dmtp_l;", String.join((CharSequence)",", mulLangTableFields));
        DataSet scmMulLangData = DB.queryDataSet((String)algoKey, (DBRoute)dbRoutScm, (String)selectScmMulLangData);
        ArrayList<Object[]> scmMulLangDataParamList = new ArrayList<Object[]>();
        for (Row row : scmMulLangData) {
            Object[] param = new Object[mulLangTableFields.size()];
            for (int i = 0; i < mulLangTableFields.size(); ++i) {
                param[i] = row.get(i);
            }
            scmMulLangDataParamList.add(param);
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                UpgradeResult presetCtrlResult;
                SqlBuilder deleteSysData = new SqlBuilder();
                deleteSysData.append("delete from t_bd_dmtp where ", new Object[0]);
                deleteSysData.appendIn(" fid ", scmDataIdList);
                DB.execute((DBRoute)dbRoutSys, (SqlBuilder)deleteSysData);
                String insertSysData = String.format("insert into t_bd_dmtp (%1$s) values (%2$s);", String.join((CharSequence)",", mainTableFields), this.buildParamPlaceholder(mainTableFields.size()));
                DB.executeBatch((DBRoute)dbRoutSys, (String)insertSysData, scmDataParamList);
                if (!scmMulLangDataParamList.isEmpty()) {
                    SqlBuilder deleteSysMulLangData = new SqlBuilder();
                    deleteSysMulLangData.append("delete from t_bd_dmtp_l where ", new Object[0]);
                    deleteSysMulLangData.appendIn(" fid ", scmDataIdList);
                    DB.execute((DBRoute)dbRoutSys, (SqlBuilder)deleteSysMulLangData);
                    String insertSysMulLangData = String.format("insert into t_bd_dmtp_l (%1$s) values (%2$s);", String.join((CharSequence)",", mulLangTableFields), this.buildParamPlaceholder(mulLangTableFields.size()));
                    DB.executeBatch((DBRoute)dbRoutSys, (String)insertSysMulLangData, scmMulLangDataParamList);
                }
                if (!(presetCtrlResult = BaseDataServiceHelper.presetCtrlOrgUseRangData((String)"sys", (String)MDS_DMTP, (String)"t_bd_dmtp", dataOrgMap, (boolean)false)).isSuccess()) {
                    throw new KDBizException(String.format("BaseDataServiceHelper.presetCtrlOrgUseRangData failed. %s", presetCtrlResult.getErrorInfo()));
                }
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }

    private List<String> getMainTableFields() {
        ArrayList<String> fields = new ArrayList<String>(20);
        fields.add("fid");
        fields.add("fnumber");
        fields.add("fstatus");
        fields.add("fcreatorid");
        fields.add("fmodifierid");
        fields.add("fenable");
        fields.add("fcreatetime");
        fields.add("fmodifytime");
        fields.add("fmasterid");
        fields.add("fcreateorgid");
        fields.add("forgid");
        fields.add("fctrlstrategy");
        fields.add("fremark");
        fields.add("fstartdate");
        fields.add("fenddate");
        fields.add("fauditorid");
        fields.add("fauditordate");
        return fields;
    }

    private List<String> getMulLangTableFields() {
        ArrayList<String> fields = new ArrayList<String>(10);
        fields.add("fpkid");
        fields.add("fid");
        fields.add("flocaleid");
        fields.add("fname");
        return fields;
    }

    private String buildParamPlaceholder(int cnt) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < cnt; ++i) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("?");
        }
        return builder.toString();
    }
}

