/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.pdm;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.utils.pdm.configcode.BillSelectFieldHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ConfigCodeAttrPlugin
extends AbstractFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addCellClickListener((CellClickListener)this);
        BasedataEdit sourceObj = (BasedataEdit)this.getView().getControl("sourceobject");
        sourceObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultShowData();
    }

    private void setDefaultShowData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject rowData = (DynamicObject)entryEntity.get(i);
            String sourceFieldShow = rowData.getString("sourcefieldshow");
            String sourceField = rowData.getString("sourcefield");
            if (StringUtils.isNotEmpty((CharSequence)sourceField) && StringUtils.isEmpty((CharSequence)sourceFieldShow)) {
                String sourceFieldName = this.setFiledNamePropV("sourceobject", sourceField, i);
                model.setValue("sourcefieldshow", (Object)sourceFieldName, i);
            }
            String vFieldShow = rowData.getString("valuefieldshow");
            String vField = rowData.getString("valuefield");
            if (!StringUtils.isNotEmpty((CharSequence)vField) || !StringUtils.isEmpty((CharSequence)vFieldShow)) continue;
            String vFieldName = this.setFiledNamePropV("valueobject", vField, i);
            model.setValue("valuefieldshow", (Object)vFieldName, i);
        }
    }

    public void cellClick(CellClickEvent evt) {
        String number;
        Object sourceObj;
        IDataModel modle = this.getModel();
        String sourceFldKey = evt.getFieldKey();
        int rowIndex = evt.getRow();
        String status = "";
        Object statusObj = modle.getValue("status");
        if (StringUtils.isNotBlank((Object)statusObj)) {
            status = String.valueOf(statusObj);
        }
        if ("valuefield".equals(sourceFldKey) && "A".equals(status)) {
            String number2;
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            DynamicObject dynamicObject = (DynamicObject)modle.getValue("sourceobject", rowIndex);
            if (dynamicObject == null) {
                int seq = rowIndex + 1;
                String cancelMessage = String.format(ResManager.loadKDString((String)"\u53d6\u503c\u6765\u6e90\u7b2c\u201c%s\u201d\u884c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5bf9\u8c61\u3002", (String)"ConfigCodeAttrPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]), seq);
                this.getView().showTipNotification(cancelMessage);
                eg.selectRows(rowIndex, false);
                return;
            }
            String type = dynamicObject.getString("modeltype");
            if ("BillFormModel".equals(type)) {
                this.dealBillWind(dynamicObject);
            }
            if ("pdm_productconfig".equals(number2 = dynamicObject.getString("number"))) {
                String sourcefield = modle.getValue("sourcefield", rowIndex) != null ? modle.getValue("sourcefield", rowIndex).toString() : "";
                String cacheTreeJson = this.getPageCache().get(sourcefield);
                if (StringUtils.isNotBlank((CharSequence)cacheTreeJson)) {
                    TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)cacheTreeJson, TreeNode.class);
                    this.showSelectFieldForm(treeNode);
                } else if (StringUtils.isNotEmpty((CharSequence)sourcefield)) {
                    this.rebuildCacheAndReadCache(rowIndex);
                }
            }
            eg.selectRows(rowIndex, false);
        } else if ("sourcefield".equals(sourceFldKey) && "A".equals(status) && (sourceObj = this.getModel().getValue("sourceobject", rowIndex)) instanceof DynamicObject && StringUtils.equals((CharSequence)"pdm_productconfig", (CharSequence)(number = ((DynamicObject)sourceObj).getString("number")))) {
            this.dealSourceField(modle, rowIndex);
        }
    }

    private void rebuildCacheAndReadCache(int rowIndex) {
        Object sourceObj = this.getModel().getValue("sourceobject", rowIndex);
        if (sourceObj instanceof DynamicObject) {
            this.getSourceSrcBillNode((DynamicObject)sourceObj);
            IDataModel model = this.getModel();
            String sourcefield = model.getValue("sourcefield", rowIndex) != null ? model.getValue("sourcefield", rowIndex).toString() : "";
            String cacheTreeJson = this.getPageCache().get(sourcefield);
            if (StringUtils.isNotBlank((CharSequence)cacheTreeJson)) {
                TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)cacheTreeJson, TreeNode.class);
                this.showSelectFieldForm(treeNode);
            }
        }
    }

    private void dealSourceField(IDataModel modle, int rowIndex) {
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        DynamicObject dynamicObject = (DynamicObject)modle.getValue("sourceobject", rowIndex);
        if (dynamicObject == null) {
            int seq = rowIndex + 1;
            String cancelMessage = String.format(ResManager.loadKDString((String)"\u53d6\u503c\u6765\u6e90\u7b2c\u201c%s\u201d\u884c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5bf9\u8c61\u3002", (String)"ConfigCodeAttrPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]), seq);
            this.getView().showTipNotification(cancelMessage);
            eg.selectRows(rowIndex, false);
            return;
        }
        this.dealSourceFieldWind(dynamicObject);
        eg.selectRows(rowIndex, false);
    }

    private boolean getShowCacheData() {
        String showFieldFlag = this.getPageCache().get("showFieldFlag");
        if (StringUtils.isBlank((CharSequence)showFieldFlag) || StringUtils.equals((CharSequence)"0", (CharSequence)showFieldFlag)) {
            this.getPageCache().put("showFieldFlag", "1");
            return true;
        }
        return false;
    }

    private void dealSourceFieldWind(DynamicObject dynamicObject) {
        TreeNode srcBillNode = this.getSourceSrcBillNode(dynamicObject);
        this.showSourceFieldForm(srcBillNode);
    }

    private void showSourceFieldForm(TreeNode srcBillNode) {
        boolean showFieldFlag = this.getShowCacheData();
        if (!showFieldFlag) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sourcefield"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void dealConfigWind(int seq) {
    }

    private void dealBillWind(DynamicObject dynamicObject) {
        TreeNode srcBillNode = this.getSrcBillNode(dynamicObject);
        this.showSelectFieldForm(srcBillNode);
    }

    private void showSelectFieldForm(TreeNode srcBillNode) {
        boolean showFieldFlag = this.getShowCacheData();
        if (!showFieldFlag) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bd_configcodeattr"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode getSrcBillNode(DynamicObject dynamicObject) {
        IDataModel modle = this.getModel();
        String attrType = String.valueOf(modle.getValue("attrtype"));
        IDataEntityProperty targetProperty = this.getMatchedProperty(attrType);
        String name = dynamicObject.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)name);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType, null, targetProperty);
        parameter.setIncludePKField(Boolean.TRUE.booleanValue());
        TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        return srcBillNode;
    }

    private IDataEntityProperty getMatchedProperty(String attrType) {
        TextProp targetProperty = null;
        if ("A".equals(attrType)) {
            targetProperty = new TextProp();
        }
        if ("B".equals(attrType)) {
            targetProperty = new DateTimeProp();
        }
        if ("C".equals(attrType)) {
            targetProperty = new EntryProp();
        }
        return targetProperty;
    }

    private TreeNode getSourceSrcBillNode(DynamicObject dynamicObject) {
        IDataModel modle = this.getModel();
        String name = dynamicObject.getString("number");
        String attrType = String.valueOf(modle.getValue("attrtype"));
        IDataEntityProperty targetProperty = this.getMatchedProperty(attrType);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)name);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType, null, targetProperty);
        parameter.setIncludePKField(Boolean.TRUE.booleanValue());
        TreeNode srcBillNode = this.buildTreeNode(parameter);
        return srcBillNode;
    }

    private TreeNode buildTreeNode(BillTreeBuildParameter parameter) {
        TreeNode srcBillNode;
        MainEntityType mainType = parameter.getMainType();
        Set dynamicObjectFields = this.getDynamicObjectField(mainType);
        TreeNode billNode = srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        HashMap<TreeNode, List<TreeNode>> childTrees = new HashMap<TreeNode, List<TreeNode>>(32);
        this.scanTreeNode(dynamicObjectFields, childTrees, billNode);
        this.buildDynamicRefTrees(childTrees);
        return srcBillNode;
    }

    private void buildDynamicRefTrees(Map<TreeNode, List<TreeNode>> topTreeMap) {
        for (Map.Entry<TreeNode, List<TreeNode>> entry : topTreeMap.entrySet()) {
            TreeNode pNode = entry.getKey();
            List<TreeNode> childrenNodes = entry.getValue();
            String pNodeID = pNode.getId();
            if (childrenNodes == null || childrenNodes.isEmpty()) continue;
            pNode.addChildren(childrenNodes);
            this.recursionNodeID(pNodeID, childrenNodes);
            String cacheTreeJson = SerializationUtils.toJsonString((Object)pNode);
            this.getPageCache().put(pNodeID, cacheTreeJson);
        }
    }

    private void recursionNodeID(String topNodeID, List<TreeNode> treeNodes) {
        StringBuilder nodeIdBuild = new StringBuilder();
        for (TreeNode node : treeNodes) {
            List childrens;
            String[] split;
            String nodeId = node.getId();
            nodeIdBuild.setLength(0);
            nodeIdBuild.append(topNodeID).append(".");
            if (nodeId.contains(nodeIdBuild.toString()) && (split = nodeId.split(nodeIdBuild.toString(), 2)).length > 1) {
                node.setId(split[1]);
            }
            if ((childrens = node.getChildren()) == null) continue;
            this.recursionNodeID(topNodeID, childrens);
        }
    }

    private void scanTreeNode(Set dynamicObjectFields, Map<TreeNode, List<TreeNode>> childTrees, TreeNode billNode) {
        String biiNodeId = billNode.getId();
        List childrens = billNode.getChildren();
        if (StringUtils.isNotBlank((CharSequence)biiNodeId) && dynamicObjectFields.contains(biiNodeId.split("\\.")[0])) {
            TreeNode pNode = new TreeNode("", biiNodeId, billNode.getText());
            pNode.setIsOpened(true);
            childTrees.put(pNode, childrens);
            billNode.setChildren(null);
        } else if (childrens != null) {
            for (TreeNode node : childrens) {
                this.scanTreeNode(dynamicObjectFields, childTrees, node);
            }
        }
    }

    private boolean notIncludeNode(TreeNode treeNode, TreeNode node) {
        for (TreeNode nodeD : treeNode.getChildren()) {
            if (!StringUtils.equals((CharSequence)nodeD.getId(), (CharSequence)node.getId())) continue;
            return false;
        }
        return true;
    }

    private Set getDynamicObjectField(MainEntityType mainType) {
        HashSet<String> dynamicFields = new HashSet<String>();
        for (Map.Entry entry : mainType.getAllFields().entrySet()) {
            String propKey = (String)entry.getKey();
            IDataEntityProperty entityProp = (IDataEntityProperty)entry.getValue();
            Class propertyType = entityProp.getPropertyType();
            if (propertyType == null || !propertyType.getName().contains("dataentity.entity.DynamicObject")) continue;
            dynamicFields.add(propKey);
        }
        return dynamicFields;
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object returnData = evt.getReturnData();
        int index = this.getCurrentSelectRow();
        this.getPageCache().put("showFieldFlag", "0");
        if (null == returnData || index < 0) {
            return;
        }
        if ("bd_configcodeattr".equals(action)) {
            String valueFiledName = this.setFiledNamePropV("valueobject", returnData.toString(), index);
            this.getModel().setValue("valuefieldshow", (Object)valueFiledName, index);
            this.getModel().setValue("valuefield", returnData, index);
        } else if ("sourcefield".equals(action)) {
            String sourceFiledName = this.setFiledNamePropV("sourceobject", returnData.toString(), index);
            this.getModel().setValue("sourcefieldshow", (Object)sourceFiledName, index);
            this.getModel().setValue("sourcefield", returnData, index);
        }
    }

    private String setFiledNamePropV(String fieldObject, String returnData, int index) {
        Object fieldObj = this.getFieldObjectValue(fieldObject, index);
        if (fieldObj == null) {
            return "";
        }
        Object sourceObj = this.getModel().getValue("sourceobject", index);
        boolean showHeadName = sourceObj != null && StringUtils.equals((CharSequence)"pdm_productconfig", (CharSequence)((DynamicObject)sourceObj).getString("number")) ? StringUtils.equals((CharSequence)"sourceobject", (CharSequence)fieldObject) : true;
        DynamicObject entity = (DynamicObject)fieldObj;
        Object billentityPkValue = entity.getPkValue();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
        String fieldName = BillSelectFieldHelper.buildPropFullCaption((EntityType)dataEntityType, (String)returnData, (boolean)showHeadName);
        return fieldName;
    }

    private Object getFieldObjectValue(String fieldObject, int index) {
        Object fieldObj = this.getModel().getValue(fieldObject, index);
        if (StringUtils.equals((CharSequence)"valueobject", (CharSequence)fieldObject) && fieldObj == null) {
            fieldObj = this.getModel().getValue("sourceobject", index);
        }
        return fieldObj;
    }

    private int getCurrentSelectRow() {
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        int[] arr = eg.getSelectRows();
        int index = -1;
        if (arr != null && arr.length > 0) {
            index = arr[0];
        }
        return index;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String attrtype;
        super.beforeDoOperation(args);
        AbstractOperate obj = (AbstractOperate)args.getSource();
        String key = obj.getOperateKey();
        if ("save".equals(key)) {
            attrtype = this.getModel().getValue("attrtype").toString();
            HashSet<String> arrStr = new HashSet<String>();
            arrStr.add("A");
            arrStr.add("B");
            arrStr.add("C");
            int count = this.getModel().getEntryRowCount("entryentity");
            if (arrStr.contains(attrtype) && count == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u7c7b\u578b\u4e3a\u6587\u672c/\u65e5\u671f/\u884c\u53f7\uff0c\u53d6\u503c\u6765\u6e90\u5206\u5f55\u5fc5\u987b\u6709\u5206\u5f55\u884c\u3002", (String)"ConfigCodeAttrPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if ("newentry".equals(key) && ("D".equals(attrtype = String.valueOf(this.getModel().getValue("attrtype"))) || "E".equals(attrtype))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u7c7b\u578b\u4e3a\u5e38\u91cf/\u6d41\u6c34\u53f7\uff0c\u65e0\u6cd5\u65b0\u589e\u884c\u3002", (String)"ConfigCodeAttrPlugin_5", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(key)) {
            this.getModel().setValue("status", (Object)"C");
            String number = this.getModel().getValue("number").toString();
            QFilter filter = new QFilter("number", "=", (Object)number);
            QFilter[] arr = new QFilter[]{filter};
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bd_configcodeattr", (String)"number,status", (QFilter[])arr);
            obj.set("status", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
        if ("modify".equals(key)) {
            this.getModel().setValue("status", (Object)"A");
        }
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("status").getOrdinal(), false);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String attrType;
        String proName = event.getProperty().getName();
        ChangeData[] changeDatas = event.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        ChangeData changeData = changeDatas[0];
        Object newobj = changeData.getNewValue();
        if ("attrtype".equals(proName) && ("D".equals(attrType = String.valueOf(newobj)) || "E".equals(attrType))) {
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            return;
        }
        int seq = changeData.getRowIndex();
        if ("sourceobject".equals(proName)) {
            String type;
            if (null == newobj) {
                this.clearCurrentRowEntryData(seq);
                return;
            }
            String number = ((DynamicObject)newobj).getString("number");
            if ("pdm_productconfig".equals(number)) {
                this.getView().setEnable(Boolean.valueOf(true), seq, new String[]{"sourcefield"});
                this.getView().setEnable(Boolean.valueOf(true), seq, new String[]{"sourcefieldshow"});
                this.getView().setEnable(Boolean.valueOf(true), seq, new String[]{"valueobject"});
                this.getModel().setValue("valueobject", null, seq);
                this.getView().updateView("entryentity");
            }
            if ("BillFormModel".equals(type = ((DynamicObject)newobj).getString("modeltype"))) {
                this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{"sourcefield"});
                this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{"sourcefieldshow"});
                this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{"valueobject"});
                this.getModel().setValue("valueobject", newobj, seq);
                this.getModel().setValue("sourcefield", null, seq);
                this.getModel().setValue("sourcefieldshow", null, seq);
                this.getModel().setValue("valuefield", null, seq);
                this.getModel().setValue("valuefieldshow", null, seq);
                this.getView().updateView("entryentity");
            }
        }
        if ("sourcefield".equals(proName)) {
            DynamicObject object = (DynamicObject)this.getModel().getValue("sourceobject", seq);
            String number = object.getString("number");
            if (null == newobj) {
                this.getModel().beginInit();
                this.getModel().setValue("valuefield", null, seq);
                this.getModel().setValue("valuefieldshow", null, seq);
                if (null != object && "pdm_productconfig".equals(number)) {
                    this.getModel().setValue("valueobject", null, seq);
                }
                this.getModel().endInit();
                return;
            }
            String strName = newobj.toString();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)number);
            Map map = entityType.getAllFields();
            if (map.get(strName) instanceof BasedataProp) {
                BasedataProp prop = (BasedataProp)map.get(strName);
                String propName = prop.getBaseEntityId();
                this.getModel().setValue("valueobject", (Object)propName, seq);
                this.getModel().setValue("valuefield", null, seq);
                this.getModel().setValue("valuefieldshow", null, seq);
            } else {
                String attrType2 = String.valueOf(this.getModel().getValue("attrtype"));
                if ("A".equals(attrType2) && map.get(strName) instanceof TextProp || "B".equals(attrType2) && map.get(strName) instanceof DateTimeProp || "C".equals(attrType2) && map.get(strName) instanceof EntryProp) {
                    this.setValueFieldData(strName, seq);
                    return;
                }
                String cancelMessage = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u6765\u6e90\u5b57\u6bb5\u7c7b\u578b\u4e0e\u5c5e\u6027\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfigCodeAttrPlugin_6", (String)"bd-sbd-formplugin", (Object[])new Object[0]), seq + 1);
                this.getView().showTipNotification(cancelMessage);
                this.resetCurrentRowData(seq);
            }
        }
    }

    private void resetCurrentRowData(int seq) {
        this.getModel().beginInit();
        this.getModel().setValue("sourcefield", null, seq);
        this.getModel().setValue("sourcefieldshow", null, seq);
        this.getModel().setValue("valueobject", null, seq);
        this.getModel().setValue("valuefield", null, seq);
        this.getModel().setValue("valuefieldshow", null, seq);
        this.getModel().endInit();
        this.getView().updateView("entryentity", seq);
    }

    private void setValueFieldData(String strName, int seq) {
        Object showSourceField = this.getModel().getValue("sourcefieldshow", seq);
        this.getModel().beginInit();
        this.getModel().setValue("valuefield", (Object)strName, seq);
        this.getModel().setValue("valuefieldshow", showSourceField, seq);
        this.getModel().setValue("valueobject", null, seq);
        this.getModel().endInit();
        this.getView().updateView("valuefieldshow", seq);
        this.getView().updateView("valuefield", seq);
        this.getView().updateView("valueobject", seq);
    }

    private void clearCurrentRowEntryData(int seq) {
        this.getModel().beginInit();
        this.getModel().setValue("sourcefield", null, seq);
        this.getModel().setValue("sourcefieldshow", null, seq);
        this.getModel().setValue("valueobject", null, seq);
        this.getModel().setValue("valuefield", null, seq);
        this.getModel().setValue("valuefieldshow", null, seq);
        this.getModel().endInit();
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String pName = paramBeforeF7SelectEvent.getProperty().getName();
        if ("sourceobject".equals(pName)) {
            List<Object> ids = new ArrayList<Object>();
            ids = this.getIds(ids);
            QFilter listFilter = new QFilter("id", "not in", ids);
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(listFilter);
        }
    }

    private List<Object> getIds(List<Object> ids) {
        DynamicObjectCollection dataCol = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject obj : dataCol) {
            if (ObjectUtils.isEmpty((Object)obj.getDynamicObject("sourceobject"))) continue;
            Object id = obj.getDynamicObject("sourceobject").getPkValue();
            ids.add(id);
        }
        return ids;
    }
}

