/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;

public class IDGenerator {
    private static final int DEFAULT_BATCHSIZE = 100;
    private int fixedSize = 0;
    private Set<Long> idSet;
    private String tblName;

    public IDGenerator(String tblName, int fixedSize) {
        this.fixedSize = fixedSize;
        this.tblName = tblName;
    }

    public IDGenerator(String tblName) {
        this.tblName = tblName;
    }

    public IDGenerator(int fixedSize) {
        this.fixedSize = fixedSize;
    }

    public IDGenerator() {
    }

    public Long getIdByTabName() {
        long[] ids;
        if (this.idSet == null) {
            if (this.fixedSize == 0) {
                this.idSet = new HashSet<Long>(100);
            } else {
                this.idSet = new HashSet<Long>(this.fixedSize);
                for (long id : ids = DB.genGlobalLongIds((int)this.fixedSize)) {
                    this.idSet.add(id);
                }
            }
        }
        if (this.idSet.isEmpty()) {
            if (this.fixedSize == 0) {
                for (long id : ids = DB.genLongIds((String)this.tblName, (int)100)) {
                    this.idSet.add(id);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6ID\u6570\u91cf\u5df2\u8d85\u51fa\u9884\u5b9a\u4e0a\u9650\u3002", (String)"IDGenerator_0", (String)"bd-sbd-common", (Object[])new Object[0]));
            }
        }
        Iterator<Long> it = this.idSet.iterator();
        Long id = it.next();
        it.remove();
        return id;
    }

    public Long getGlobalId() {
        long[] ids;
        if (this.idSet == null) {
            if (this.fixedSize == 0) {
                this.idSet = new HashSet<Long>(100);
            } else {
                this.idSet = new HashSet<Long>(this.fixedSize);
                for (long id : ids = DB.genGlobalLongIds((int)this.fixedSize)) {
                    this.idSet.add(id);
                }
            }
        }
        if (this.idSet.isEmpty()) {
            if (this.fixedSize == 0) {
                for (long id : ids = DB.genGlobalLongIds((int)100)) {
                    this.idSet.add(id);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6ID\u6570\u91cf\u5df2\u8d85\u51fa\u9884\u5b9a\u4e0a\u9650\u3002", (String)"IDGenerator_0", (String)"bd-sbd-common", (Object[])new Object[0]));
            }
        }
        Iterator<Long> it = this.idSet.iterator();
        Long id = it.next();
        it.remove();
        return id;
    }
}

