/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.util.ArrayList;
import kd.bd.pbd.validator.DrpCustomerValidator;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class DrpCustomerUserSaveOP
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(DrpCustomerUserSaveOP.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("customerinfo");
        e.getFieldKeys().add("user");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DrpCustomerValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        int length = dataEntities.length;
        Object[] ids = new Object[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = dataEntities[i].getLong("id");
        }
        if (ids.length > 0) {
            final ArrayList params = new ArrayList(length);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("SELECT A.FID,B.FCUSTOMERINFOID FROM T_SEC_BIZPARTNERUSER A LEFT JOIN T_SEC_BIZPARTNERUSER_C B ON A.FID = B.FID WHERE", new Object[0]);
            sqlBuilder.appendIn("A.FID", ids);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<DataSet>(){

                public DataSet handle(ResultSet resultSet) throws Exception {
                    if (resultSet.next() && null == resultSet.getObject("FCUSTOMERINFOID")) {
                        Object[] param = new Object[]{resultSet.getLong("FID"), resultSet.getLong("FCUSTOMERINFOID")};
                        params.add(param);
                    }
                    return null;
                }
            });
            if (!CollectionUtils.isEmpty(params)) {
                String insertSql = "INSERT INTO T_SEC_BIZPARTNERUSER_C(FID,FCUSTOMERINFOID)VALUES(?,?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)insertSql, params);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length <= 0) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                this.createChannelUserHandler(dataEntities);
                this.createChannelAdminHandler(dataEntities);
            }
            catch (Throwable error) {
                h.markRollback();
                throw error;
            }
        }
    }

    private void createChannelAdminHandler(DynamicObject[] dataEntities) {
        int i = 0;
        DynamicObject data = dataEntities[i];
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dbd", (String)"DrpUserService", (String)"insertDrpAdmin", (Object[])new Object[]{UserServiceHelper.getCurrentUserId(), data.getLong("customerinfo_id")});
        if (0 != result.getIntValue("code")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6e20\u9053\u4eba\u5458\u6570\u636e\uff0c\u521b\u5efa\u6e20\u9053\u7ba1\u7406\u5458\u5931\u8d25!", (String)"DrpCustomerUserSaveOP_1", (String)"bd-pbd-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private void createChannelUserHandler(DynamicObject[] dataEntities) {
        int i = 0;
        DynamicObject data = dataEntities[i];
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dbd", (String)"DrpUserService", (String)"insertDrpUser", (Object[])new Object[]{data.getLong("user_id"), data.getLong("customerinfo_id")});
        if (0L != result.getLongValue("code")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6e20\u9053\u4eba\u5458\u6570\u636e\uff0c\u521b\u5efa\u6e20\u9053\u7528\u6237\u5931\u8d25!", (String)"DrpCustomerUserSaveOP_2", (String)"bd-pbd-opplugin", (Object[])new Object[0]), i + 1));
        }
    }
}

