/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PbdSupplierUserConfig
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(PbdSupplierUserConfig.class);

    public List<String> getDefaultLockUIs() {
        ArrayList<String> defaultLocks = new ArrayList<String>();
        defaultLocks.add("radiofield1");
        defaultLocks.add("keyfields");
        defaultLocks.add("radiofield2");
        return defaultLocks;
    }

    public String getDefaultImportType() {
        return "new";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            List<ImportLogger.ImportLog> logs = null;
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            logs = this.beforeImportOp((Map<String, Object>)data, this.ctx.getOption(), logger);
            if (logs.size() <= 0) continue;
            logger.logAll(Integer.valueOf(rowdata.getStartIndex()), logs).fail();
            it.remove();
        }
    }

    protected List<ImportLogger.ImportLog> beforeImportOp(Map<String, Object> data, Map<String, Object> option, ImportLogger importlogs) {
        Long UniqueSupplier;
        ImportLogger.ImportLog importLog;
        DynamicObject mpExistsUser;
        Object isAdmin;
        ArrayList<ImportLogger.ImportLog> logs = new ArrayList<ImportLogger.ImportLog>();
        Object bizpartner = data.get("bizpartner");
        Long bizParId = null;
        if (bizpartner instanceof JSONObject) {
            bizParId = this.checkBizSupplier((JSONObject)bizpartner);
        }
        if (bizParId == null) {
            ImportLogger.ImportLog importLog2 = new ImportLogger.ImportLog("bizpartner.number", ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"PbdSupplierUserImport_6", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            logs.add(importLog2);
        }
        JSONObject userJson = new JSONObject();
        Long userId = null;
        Object phone = data.get("phone");
        Object email = data.get("email");
        if (phone == null && email == null) {
            ImportLogger.ImportLog importLog3 = new ImportLogger.ImportLog("phone\u3001email", ResManager.loadKDString((String)"\u7528\u6237\u624b\u673a\u6216\u8005\u90ae\u7bb1\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u3002", (String)"PbdSupplierUserImport_2", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            logs.add(importLog3);
            return logs;
        }
        QFilter adminFilter = new QFilter("number", "!=", (Object)"administrator");
        QFilter phoneFilter = null;
        if (phone != null && !phone.toString().isEmpty()) {
            phoneFilter = new QFilter("phone", "=", phone);
        }
        if (email != null && !email.toString().isEmpty()) {
            if (phoneFilter != null) {
                phoneFilter.or(new QFilter("email", "=", email));
            } else {
                phoneFilter = new QFilter("email", "=", email);
            }
        }
        if ((isAdmin = data.get("isadmin")) != null && "true".equals(isAdmin) && this.checkBizSupplierHaveAdmin(bizParId).booleanValue()) {
            ImportLogger.ImportLog importLog4 = new ImportLogger.ImportLog("bizpartner", ResManager.loadKDString((String)"\u5f53\u524d\u5546\u52a1\u4f19\u4f34\u5df2\u5b58\u5728\u7ba1\u7406\u5458\u3002", (String)"PbdSupplierUserImport_3", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            logs.add(importLog4);
        }
        if ((mpExistsUser = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,usertype", (QFilter[])new QFilter[]{phoneFilter, adminFilter})) != null) {
            String userType = mpExistsUser.getString("usertype");
            if (userType != null && !"1".equals(userType) && !"7".equals(userType)) {
                userId = mpExistsUser.getLong("id");
            } else {
                importLog = new ImportLogger.ImportLog("phone\u3001email", ResManager.loadKDString((String)"\u624b\u673a\u6216\u8005\u90ae\u7bb1\u53f7\u6682\u4e0d\u652f\u6301\u6dfb\u52a0\u5230\u4f9b\u5e94\u5546\u7528\u6237\u4e2d\u3002", (String)"PbdSupplierUserImport_1", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                logs.add(importLog);
            }
        }
        if ((UniqueSupplier = this.checkBizSupplierUser(userId, bizParId)) == null) {
            userJson.put("id", userId);
        } else {
            importLog = new ImportLogger.ImportLog("phone\u3001email", ResManager.loadKDString((String)"\u624b\u673a\u53f7\u6216\u8005\u90ae\u7bb1\u5728\u5f53\u524d\u5546\u52a1\u4f19\u4f34\u4e0b\u9762\u5b58\u5728\u3002", (String)"PbdSupplierUserImport_5", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            logs.add(importLog);
        }
        data.put("type", "PT03");
        return logs;
    }

    private Long checkBizSupplier(JSONObject bizpartner) {
        QFilter qFilter = null;
        JSONObject jsonObject = bizpartner;
        if (jsonObject.containsKey((Object)"number")) {
            qFilter = new QFilter("number", "=", (Object)jsonObject.getString("number"));
        }
        if (qFilter == null) {
            return null;
        }
        qFilter.and("partnerrole", "match", (Object)"1");
        DynamicObject supUser = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return supUser != null ? Long.valueOf(supUser.getLong("id")) : null;
    }

    private Long checkBizSupplierUser(Long uId, Long bId) {
        QFilter qFilter = null;
        qFilter = new QFilter("user_id", "=", (Object)uId);
        qFilter.and(new QFilter("bizpartner_id", "=", (Object)bId));
        DynamicObject supUser = QueryServiceHelper.queryOne((String)"pur_supuser", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return supUser != null ? Long.valueOf(supUser.getLong("id")) : null;
    }

    private Boolean checkBizSupplierHaveAdmin(Long bId) {
        QFilter qFilter = null;
        qFilter = new QFilter("bizpartner_id", "=", (Object)bId);
        qFilter.and(new QFilter("isadmin", "=", (Object)"1"));
        DynamicObject supUser = QueryServiceHelper.queryOne((String)"pur_supuser", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return supUser != null ? Boolean.TRUE : Boolean.FALSE;
    }
}

