/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.pbd.plugin.PbdSupplierUserDeleteValidator;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PbdSupplierUserDeleteOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PbdSupplierUserDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizpartner");
        fieldKeys.add("user");
        fieldKeys.add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.getOption().setVariableValue("ignorerefentityids", "scp_bizperson,pbd_supbizperson");
        e.getValidators().add(new PbdSupplierUserDeleteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equalsIgnoreCase(operationKey)) {
            String personEntity;
            Long orgId = RequestContext.get().getOrgId();
            DynamicObject[] dataEntities = e.getDataEntities();
            int size = dataEntities.length;
            HashMap<Long, Long> userOfOrg = new HashMap<Long, Long>(size);
            HashSet<String> phones = new HashSet<String>(size);
            HashSet<String> emails = new HashSet<String>(size);
            ArrayList<Long> bizpartnerPkids = new ArrayList<Long>(size);
            for (DynamicObject dataEntity : dataEntities) {
                Long userId = dataEntity.getLong("user_id");
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org != null) {
                    userOfOrg.put(userId, org.getLong("id"));
                } else {
                    userOfOrg.put(userId, orgId);
                }
                bizpartnerPkids.add(dataEntity.getLong("bizpartner_id"));
                DynamicObject user = dataEntity.getDynamicObject("user");
                if (user == null) continue;
                phones.add(user.getString("phone"));
                emails.add(user.getString("email"));
            }
            HashMap assignInfo = new HashMap(1);
            ArrayList<String> roleList = new ArrayList<String>(1);
            roleList.add("0KF7KTPK48NB");
            roleList.add("0STD643M4QUO");
            for (Map.Entry entry : userOfOrg.entrySet()) {
                assignInfo.put(OrgUnitServiceHelper.getRootOrgId(), roleList);
                assignInfo.put((Long)entry.getValue(), roleList);
                boolean userId = PermissionServiceHelper.userAssignRole((Long)((Long)entry.getKey()), (String)"bos_org", assignInfo, null, (boolean)false);
            }
            ArrayList personPkIds = new ArrayList();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PbdSupplierUserDeleteOp", (String)"pbd_supbizperson", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "in", userOfOrg.keySet()).and(new QFilter("bizpartner", "in", bizpartnerPkids)).and(new QFilter("enable", "=", (Object)"1"))}, (String)"id");){
                dataSet.forEach(row -> personPkIds.add(row.getLong("id")));
            }
            String string = personEntity = this.billEntityType.getName().equals("pur_supuser") ? "pbd_supbizperson" : "scp_bizperson";
            if (!personPkIds.isEmpty()) {
                OperationResult operationResultEnable = OperationServiceHelper.executeOperate((String)"disable", (String)personEntity, (Object[])personPkIds.toArray(), (OperateOption)OperateOption.create());
                if (operationResultEnable.isSuccess()) {
                    log.info("\u4f9b\u5e94\u5546\u4e1a\u52a1\u5458\u7981\u7528\u6210\u529f" + operationResultEnable.getSuccessPkIds());
                } else {
                    e.setCancel(true);
                    StringBuilder message = new StringBuilder();
                    for (IOperateInfo operateInfo : operationResultEnable.getAllErrorOrValidateInfo()) {
                        message.append(operateInfo.getMessage());
                    }
                    log.info("\u4f9b\u5e94\u5546\u4e1a\u52a1\u5458\u7981\u7528\u5931\u8d25" + message);
                    e.setCancelMessage(message.toString());
                }
            }
            ArrayList srmUser = new ArrayList();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PbdSupplierUserDeleteOp", (String)"srm_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", bizpartnerPkids).and(new QFilter("number", "in", phones).or(new QFilter("number", "in", emails)))}, (String)"id");
            Object object = null;
            try {
                dataSet.forEach(row -> srmUser.add(row.getLong("id")));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (!srmUser.isEmpty()) {
                DeleteServiceHelper.delete((String)"srm_user", (QFilter[])new QFilter[]{new QFilter("id", "in", srmUser)});
            }
        }
    }
}

