/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.flow.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.gbs.core.flow.common.Enum.FlowCardJumpTypeEnum;
import kd.bd.gbs.core.flow.common.Enum.FlowCardMethodTypeEnum;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.PortalAppMetaDataUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class FlowCardFormUtil {
    public static void setDataToCustomCtl(IFormView formView, String globalId, FlowCardMethodTypeEnum methodEnum, JSONObject mainData, JSONObject otherDataMap, boolean isSuccess, String errorMsg) {
        CustomControl control = (CustomControl)formView.getControl("cusflow");
        if (control == null) {
            return;
        }
        if (mainData != null) {
            mainData.put("globalId", (Object)globalId);
        }
        JSONObject data = new JSONObject().fluentPut("success", (Object)isSuccess).fluentPut("method", (Object)methodEnum.getmethodType()).fluentPut("data", (Object)mainData).fluentPut("v", (Object)System.currentTimeMillis());
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            data.fluentPut("errorMessage", (Object)errorMsg);
        }
        if (MapUtils.isNotEmpty((Map)otherDataMap)) {
            otherDataMap.forEach((arg_0, arg_1) -> ((JSONObject)data).fluentPut(arg_0, arg_1));
        }
        control.setData((Object)data);
    }

    public static boolean isExsitScheme(Long flowId, JSONObject argsJson) {
        JSONObject flowData = argsJson.getJSONObject("data").getJSONObject("graphData");
        String name = flowData.getString("name");
        QFilter existQ = new QFilter("name", "=", (Object)name);
        if (flowId != null) {
            existQ.and("id", "!=", (Object)flowId);
        }
        return QueryServiceHelper.exists((String)"gbs_flowscheme", (QFilter[])existQ.toArray());
    }

    public static String getJumpModelType(String jumpType) {
        HashMap<String, String> JUMPTYPE_MAP = new HashMap<String, String>(16);
        JUMPTYPE_MAP.put(FlowCardJumpTypeEnum.BASE.getJumpType(), "BaseFormModel");
        JUMPTYPE_MAP.put(FlowCardJumpTypeEnum.RECEIPT.getJumpType(), "BillFormModel");
        JUMPTYPE_MAP.put(FlowCardJumpTypeEnum.REPORT.getJumpType(), "ReportFormModel");
        return (String)JUMPTYPE_MAP.get(jumpType);
    }

    public static AppMenuInfo getMenuInfo(String appId, String menuId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        if (appInfo == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"FlowCardFormUtil_0", (String)"bd-gbs-core", (Object[])new Object[0]), appId));
        }
        String appInfoId = appInfo.getId();
        Map appIdAndAllMenuByAppIds = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(new HashSet<String>(Collections.singletonList(appInfoId)), (boolean)true);
        if (MapUtils.isEmpty((Map)appIdAndAllMenuByAppIds) || CollectionUtils.isEmpty((Collection)((Collection)appIdAndAllMenuByAppIds.get(appInfoId)))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u201c%s\u201d\u6ca1\u6709\u83dc\u5355\u3002", (String)"FlowCardFormUtil_1", (String)"bd-gbs-core", (Object[])new Object[0]), appInfoId));
        }
        AppMenuInfo appMenuInfo = ((List)appIdAndAllMenuByAppIds.get(appInfoId)).stream().filter(menuInfo -> menuId.equals(menuInfo.getId())).findFirst().orElse(null);
        if (appMenuInfo == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83dc\u5355\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"FlowCardFormUtil_2", (String)"bd-gbs-core", (Object[])new Object[0]), menuId));
        }
        return appMenuInfo;
    }

    public static List<String> getOthereJumpType() {
        ArrayList<String> otherTypeList = new ArrayList<String>(16);
        otherTypeList.add("DynamicFormModel");
        otherTypeList.add("WidgetFormModel");
        otherTypeList.add("BalanceModel");
        return otherTypeList;
    }
}

