/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.flex.FlexFormMetaUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;

public class AssgrpSaveOp
extends AbstractOperationServicePlugIn {
    private static final String[] inBaseData = new String[]{"filterdesc", "filtercondition"};
    private static final String[] inAssistantBaseData = new String[]{"assistanttype"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"asstacttype")) {
                    Stream.of(this.dataEntities).filter(v -> !v.getDataEntity().getString("ctrlstrategy").equals("5")).forEach(v -> this.addErrorMessage((ExtendedDataEntity)v, ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u6a21\u5f0f\u4e0d\u652f\u6301\u8be5\u63a7\u5236\u7b56\u7565\u3002", (String)"AssgrpSaveOp_0", (String)"bd-assistant-opplugin", (Object[])new Object[0])));
                }
                Arrays.stream(this.dataEntities).filter(extEntity -> {
                    DynamicObject entity = extEntity.getDataEntity();
                    if ("1".equals(entity.getString("valuetype"))) {
                        if (null == entity.getDynamicObject("valuesource")) {
                            return false;
                        }
                        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)entity.getDynamicObject("valuesource").getPkValue().toString());
                        return sourceEntityType instanceof BillEntityType && 12 == sourceEntityType.getPrimaryKey().getDbType();
                    }
                    return false;
                }).forEach(entity -> this.addErrorMessage((ExtendedDataEntity)entity, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u4e3b\u952e\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u503c\u6765\u6e90\u3002", (String)"AssgrpSaveOp_1", (String)"bd-assistant-opplugin", (Object[])new Object[0])));
                this.businessValidate();
            }

            private void businessValidate() {
                List<String> shareCtrls = Arrays.asList("5", "6");
                Map<Object, DynamicObject> modifyAssistDys = Arrays.stream(this.dataEntities).filter(x -> x.getDataEntity().getDataEntityState().getFromDatabase()).collect(Collectors.toMap(x -> x.getDataEntity().getPkValue(), y -> y.getDataEntity()));
                HashMap<Object, BaseDataCheckRefrenceResult> checkRefrenced = new HashMap(8);
                Map<Object, Object> dbAssistInfoMap = new HashMap(8);
                if (!CollectionUtils.isEmpty(modifyAssistDys)) {
                    Set<Object> modifyPks = modifyAssistDys.keySet();
                    checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)"bd_asstacttype", (Object[])modifyPks.toArray(), null, null, null);
                    DynamicObject[] dbAssistDys = BusinessDataServiceHelper.load((String)"bd_asstacttype", (String)"id,number,valuetype,valuesource,createorg.id,ctrlstrategy,assistanttype", (QFilter[])new QFilter("id", "in", modifyPks).toArray());
                    dbAssistInfoMap = Arrays.stream(dbAssistDys).collect(Collectors.toMap(x -> x.getPkValue(), y -> y));
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject asst = dataEntity.getDataEntity();
                    String ctrlStrategy = asst.getString("ctrlstrategy");
                    if (!shareCtrls.contains(ctrlStrategy)) continue;
                    Boolean fromDatabase = asst.getDataEntityState().getFromDatabase();
                    String number = asst.getString("number");
                    Optional<String> checkMasterIdProp = this.checkValueSource(asst);
                    if (checkMasterIdProp.isPresent()) {
                        this.addErrorMessage(dataEntity, checkMasterIdProp.get());
                        continue;
                    }
                    Object pkValue = asst.getPkValue();
                    if (fromDatabase.booleanValue()) {
                        DynamicObject dbAssist = (DynamicObject)dbAssistInfoMap.get(pkValue);
                        Optional<String> checkReferenced = this.checkReferenced(checkRefrenced, asst, dbAssist);
                        if (checkReferenced.isPresent()) {
                            this.addErrorMessage(dataEntity, checkReferenced.get());
                            continue;
                        }
                        if (Objects.nonNull(dbAssist) && !number.equals(dbAssist.getString("number"))) {
                            fromDatabase = false;
                        }
                    }
                    String regex = "^[a-z0-9A-Z]+$";
                    if (!fromDatabase.booleanValue() && !Pattern.matches(regex, number)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7684\u7f16\u7801\uff08%s\uff09\u4e0d\u5141\u8bb8\u6709\u4efb\u4f55\u7b26\u53f7\u548c\u4e2d\u6587\uff0c\u53ea\u80fd\u662f\u82f1\u6587\u5927\u5c0f\u5199\u548c\u6570\u5b57\u3002", (String)"AssgrpSaveOp_3", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number));
                        continue;
                    }
                    String asstName = asst.getString("name");
                    long createorgId = asst.getLong("createorg_id");
                    boolean isExists = false;
                    if (asst.getDataEntityState().getFromDatabase()) {
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"number,createorg,name,ctrlstrategy", (QFilter[])new QFilter("id", "=", (Object)asst.getLong("id")).toArray());
                        if (!(number.equals(dynamicObject.getString("number")) && asstName.equals(dynamicObject.getString("name")) && ctrlStrategy.equals(dynamicObject.getString("ctrlStrategy")) && createorgId == dynamicObject.getLong("createorg"))) {
                            String dbCtrlStrategy = dynamicObject.getString("ctrlStrategy");
                            isExists = ctrlStrategy.equals("5") && dbCtrlStrategy.equals("6") ? this.modifyCtrlstrategyValidator(asst) : this.checkCurrNameExists(true, dataEntity, asstName);
                        }
                    } else {
                        isExists = this.checkCurrNameExists(false, dataEntity, asstName);
                    }
                    if (!isExists) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u540d\u79f0\u6216\u7f16\u7801\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"AssgrpSaveOp_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]), new Object[0]));
                    return;
                }
            }

            private boolean modifyCtrlstrategyValidator(DynamicObject asst) {
                String number = asst.getString("number");
                String asstName = asst.getString("name");
                QFilter filter = new QFilter("number", "=", (Object)number);
                filter.or("name", "=", (Object)asstName);
                QFilter flexFilter = new QFilter("flexid", "=", (Object)2);
                QFilter idFilter = new QFilter("id", "!=", asst.getPkValue());
                return QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])new QFilter[]{filter, flexFilter, idFilter});
            }

            private Optional<String> checkValueSource(DynamicObject asst) {
                String valueType = asst.getString("valuetype");
                if ("1".equals(valueType)) {
                    return this.checkEntityProp(asst.getDynamicObject("valuesource"));
                }
                return Optional.empty();
            }

            private Optional<String> checkEntityProp(DynamicObject valueSource) {
                if (Objects.nonNull(valueSource)) {
                    String valueSourceFormId = valueSource.getPkValue().toString();
                    MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)valueSourceFormId);
                    BasedataEntityType basedataEntityType = (BasedataEntityType)sourceEntityType;
                    if (StringUtils.isBlank((CharSequence)basedataEntityType.getNumberProperty())) {
                        return Optional.of(ResManager.loadKDString((String)"\u503c\u6765\u6e90\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u672a\u5b9a\u4e49\u7f16\u7801\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u503c\u6765\u6e90\u3002", (String)"AssgrpSaveOp_11", (String)"bos-form-business", (Object[])new Object[0]));
                    }
                    if (StringUtils.isBlank((CharSequence)basedataEntityType.getNameProperty())) {
                        return Optional.of(ResManager.loadKDString((String)"\u503c\u6765\u6e90\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u672a\u5b9a\u4e49\u540d\u79f0\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u503c\u6765\u6e90\u3002", (String)"AssgrpSaveOp_12", (String)"bos-form-business", (Object[])new Object[0]));
                    }
                }
                return Optional.empty();
            }

            private Optional<String> checkReferenced(Map<Object, BaseDataCheckRefrenceResult> checkRefrenced, DynamicObject asst, DynamicObject dbAssist) {
                Object pkValue = asst.getPkValue();
                BaseDataCheckRefrenceResult refrenceResult = checkRefrenced.get(pkValue);
                if (refrenceResult == null || !refrenceResult.isRefence()) {
                    return Optional.empty();
                }
                if (refrenceResult.isRefence()) {
                    Optional<String> checkResult = AssgrpSaveOp.this.checkPropertyChange(asst, dbAssist);
                    if (!checkResult.isPresent()) {
                        return Optional.empty();
                    }
                    MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                    String billName = refMainType.getDisplayName().getLocaleValue();
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u5f15\u7528\u4e86%2$s(%3$s)\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u4fee\u6539%4$s", (String)"AssgrpSaveOp_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]), billName, asst.getString("name"), asst.getString("number"), checkResult.get());
                    return Optional.of(msg);
                }
                return Optional.empty();
            }

            private boolean checkCurrNameExists(boolean fromDB, ExtendedDataEntity dataEntity, String asstName) {
                boolean isExists = this.checkNumberExists(fromDB, dataEntity);
                if (!isExists) {
                    isExists = this.checkNameExist(fromDB, dataEntity, asstName);
                }
                return isExists;
            }

            private boolean checkNumberExists(boolean fromDB, ExtendedDataEntity dataEntity) {
                String number = dataEntity.getDataEntity().getString("number");
                QFilter filter = new QFilter("number", "=", (Object)number);
                filter.and("flexid", "=", (Object)2);
                if (fromDB) {
                    filter.and("id", "!=", (Object)dataEntity.getDataEntity().getLong("id"));
                }
                return QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])filter.toArray());
            }

            private boolean checkNameExist(boolean fromDB, ExtendedDataEntity dataEntity, String asstName) {
                String ctrlstrategy = dataEntity.getDataEntity().getString("ctrlstrategy");
                QFilter nameFilter = new QFilter("name", "=", (Object)asstName);
                if (fromDB) {
                    nameFilter.and("id", "!=", (Object)dataEntity.getDataEntity().getLong("id"));
                }
                nameFilter.and("flexid", "=", (Object)2);
                if (ctrlstrategy.equals("5")) {
                    return QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])new QFilter[]{nameFilter});
                }
                QFilter globalFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
                if (QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])new QFilter[]{nameFilter, globalFilter})) {
                    return true;
                }
                Long createOrg = dataEntity.getDataEntity().getLong("createorg_id");
                List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(createOrg), (boolean)true);
                List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)createOrg);
                if (!superOrgIds.isEmpty()) {
                    orgIds.addAll(superOrgIds);
                }
                QFilter orgFilter = new QFilter("createorg", "in", (Object)orgIds);
                QFilter cuShareFilter = new QFilter("ctrlstrategy", "=", (Object)"6");
                return QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])new QFilter[]{nameFilter, orgFilter, cuShareFilter});
            }
        });
    }

    protected Optional<String> checkPropertyChange(DynamicObject asst, DynamicObject dbAssist) {
        HashSet<String> errPropertys = new HashSet<String>(8);
        if (!Objects.equals(dbAssist.getString("valuetype"), asst.getString("valuetype"))) {
            errPropertys.add(ResManager.loadKDString((String)"\u503c\u7c7b\u578b", (String)"AssgrpSaveOp_9", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
        }
        if (!Objects.equals(dbAssist.getString("ctrlStrategy"), asst.getString("ctrlStrategy"))) {
            errPropertys.add(ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565", (String)"AssgrpSaveOp_5", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
        }
        if (this.isModifiedCurrProp(dbAssist.getDynamicObject("valuesource"), asst.getDynamicObject("valuesource"))) {
            errPropertys.add(ResManager.loadKDString((String)"\u503c\u6765\u6e90", (String)"AssgrpSaveOp_6", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
        }
        if (!Objects.equals(dbAssist.getLong("createorg.id"), asst.getLong("createorg.id"))) {
            errPropertys.add(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"AssgrpSaveOp_7", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
        }
        if (this.isModifiedCurrProp(dbAssist.getDynamicObject("assistanttype"), asst.getDynamicObject("assistanttype"))) {
            errPropertys.add(ResManager.loadKDString((String)"\u8f85\u52a9\u503c\u6765\u6e90", (String)"AssgrpSaveOp_8", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
        }
        return errPropertys.isEmpty() ? Optional.empty() : Optional.of(((Object)errPropertys).toString());
    }

    private boolean isModifiedCurrProp(DynamicObject dbPropVal, DynamicObject curPropVal) {
        if (dbPropVal == null && curPropVal == null) {
            return false;
        }
        if (dbPropVal == null && curPropVal != null || dbPropVal != null && curPropVal == null) {
            return true;
        }
        return !Objects.equals(dbPropVal.getPkValue(), curPropVal.getPkValue());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String baseData = "1";
        String assistantBaseData = "2";
        String other = "3";
        block10: for (DynamicObject entity : e.getDataEntities()) {
            String type;
            switch (type = (String)entity.get("valuetype")) {
                case "1": {
                    this.repairInvalidData(entity, inAssistantBaseData);
                    continue block10;
                }
                case "2": {
                    this.repairInvalidData(entity, inBaseData);
                    continue block10;
                }
                case "3": {
                    this.repairInvalidData(entity, (String[])ArrayUtils.addAll((Object[])inBaseData, (Object[])inAssistantBaseData));
                }
            }
        }
    }

    private void repairInvalidData(DynamicObject entity, String[] array) {
        for (String key : array) {
            Object object = entity.get(key);
            if (object == null) continue;
            if (object instanceof String && !"".equals(object.toString())) {
                entity.set(key, (Object)"");
                continue;
            }
            entity.set(key, null);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (e.getOperationKey().equals("save")) {
            FlexEntityMetaUtils.clearFlexEntityMeta();
            FlexFormMetaUtils.clearFlexFormMeta();
        }
    }
}

