/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.consts.Inspect_cfgConst;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InspectCfgSynOp
extends AbstractOperationServicePlugIn {
    private static final Long QCP_FLG = 959929179238017024L;
    String[] TYPEARR = new String[]{"finishflg", "qcpflg", "osqcpflg", "procedureflg", "deliveryflg", "returnsflg", "stockflg", "productretflg", "prodpatrolflag"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("finishflg");
        e.getFieldKeys().add("qcpflg");
        e.getFieldKeys().add("osqcpflg");
        e.getFieldKeys().add("procedureflg");
        e.getFieldKeys().add("deliveryflg");
        e.getFieldKeys().add("returnsflg");
        e.getFieldKeys().add("stockflg");
        e.getFieldKeys().add("productretflg");
        e.getFieldKeys().add("prodpatrolflag");
        e.getFieldKeys().add("nocheckflg");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.inspecttype");
        e.getFieldKeys().add("entryentity.nocheckflag");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("entryentity.seq");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            boolean needSync = this.isNeedSync(obj);
            if (!needSync) continue;
            this.insertEntry(obj);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void insertEntry(DynamicObject obj) {
        List<Long> inspectTypeList = this.getInspectTypeList(obj);
        String noCheckFlg = obj.getBoolean("nocheckflg") ? "1" : "0";
        DynamicObjectCollection entryentity = obj.getDynamicObjectCollection("entryentity");
        for (int seq = 0; seq < inspectTypeList.size(); ++seq) {
            DynamicObject entry = new DynamicObject(entryentity.getDynamicObjectType());
            entry.set("seq", (Object)(seq + 1));
            entry.set("inspecttype", (Object)inspectTypeList.get(seq));
            if (QCP_FLG.equals(inspectTypeList.get(seq))) {
                entry.set("nocheckflag", (Object)noCheckFlg);
            } else {
                entry.set("nocheckflag", (Object)"0");
            }
            entryentity.add((Object)entry);
        }
    }

    private List<Long> getInspectTypeList(DynamicObject obj) {
        ArrayList<Long> inspectTypeList = new ArrayList<Long>(16);
        for (String s : this.TYPEARR) {
            Boolean flag = obj.getBoolean(s);
            if (!flag.booleanValue()) continue;
            if ("procedureflg".equals(s)) {
                inspectTypeList.add(960041773667747840L);
                inspectTypeList.add(960042738642880512L);
                continue;
            }
            inspectTypeList.add((Long)this.getKey(Inspect_cfgConst.transMap, s));
        }
        return inspectTypeList;
    }

    private <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean isNeedSync(DynamicObject dynObj) {
        boolean isNeedSync = false;
        DynamicObjectCollection entryCollection = dynObj.getDynamicObjectCollection("entryentity");
        if (entryCollection.isEmpty()) {
            isNeedSync = true;
        }
        return isNeedSync;
    }
}

