/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin.pdm.mftbom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.utils.BOMVersionUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BOMSetVersionValueValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(BOMSetVersionValueValidator.class);

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(operate)) {
            HashSet<Long> unVersionIdSet = new HashSet<Long>(16);
            HashMap<Long, DynamicObject> cacheEntryVersionMap = new HashMap<Long, DynamicObject>(16);
            HashMap<String, Boolean> cacheDataMap = new HashMap<String, Boolean>(16);
            for (ExtendedDataEntity obj : objs) {
                try {
                    this.createBomVersion(obj.getDataEntity(), unVersionIdSet);
                    this.createBomEntryVersion(obj.getDataEntity(), cacheEntryVersionMap, cacheDataMap, false);
                    this.createBomEntryVersion(obj.getDataEntity(), cacheEntryVersionMap, cacheDataMap, true);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.addErrorMessage(obj, e.getMessage());
                }
            }
        }
    }

    public boolean isEcoBom(DynamicObject bom) {
        return "pdm_ecobom".equals(bom.getDataEntityType().getName());
    }

    public boolean isMftBom(DynamicObject bom) {
        return "pdm_mftbom".equals(bom.getDataEntityType().getName());
    }

    private boolean isVersionType(DynamicObject type) {
        String isVersionField = "isversion";
        if (!type.containsProperty(isVersionField)) {
            type = BusinessDataServiceHelper.loadSingleFromCache((Object)type.getPkValue(), (String)type.getDataEntityType().getName(), (String)isVersionField);
        }
        return type.getBoolean(isVersionField);
    }

    private DynamicObject getMateria(DynamicObject bom) {
        Object masterId;
        DynamicObject material = bom.getDynamicObject("material");
        if (material != null && (masterId = material.get("masterid")) instanceof DynamicObject) {
            return (DynamicObject)masterId;
        }
        return material;
    }

    private DynamicObject getEntryMaterial(DynamicObject material) {
        Object masterId;
        if (material != null && (masterId = material.get("masterid")) instanceof DynamicObject) {
            return (DynamicObject)masterId;
        }
        return material;
    }

    public void createBomVersion(DynamicObject dataEntity, Set<Long> unVersionIdSet) {
        if (this.isEcoBom(dataEntity)) {
            return;
        }
        DynamicObject material = this.getMateria(dataEntity);
        if (material == null) {
            return;
        }
        DynamicObject type = dataEntity.getDynamicObject("type");
        DynamicObject version = dataEntity.getDynamicObject("version");
        if (version == null && (material.getBoolean("isenablematerialversion") || this.isVersionType(type))) {
            DynamicObject newVersion = BOMVersionUtil.createAndGetBomVersion((DynamicObject)dataEntity, (boolean)true, unVersionIdSet);
            dataEntity.set("version", (Object)newVersion);
            if (newVersion != null) {
                unVersionIdSet.add((Long)newVersion.getPkValue());
            }
        }
    }

    public void createBomEntryVersion(DynamicObject dataEntity, Map<Long, DynamicObject> cacheEntryVersionMap, Map<String, Boolean> cacheDataMap, boolean isCopEntry) {
        if (!this.isMftBom(dataEntity)) {
            return;
        }
        DynamicObject org = dataEntity.getDynamicObject("createorg");
        Long orgId = (Long)org.getPkValue();
        String paramKeys = orgId + (isCopEntry ? "_copentry" : "_entry");
        Boolean isSysParamVer = cacheDataMap.get(paramKeys);
        if (isSysParamVer == null) {
            isSysParamVer = isCopEntry ? BOMVersionUtil.isAutoGenCopEntryVersion((Long)orgId) : BOMVersionUtil.isAutoGenEntryVersion((Long)orgId);
            cacheDataMap.put(paramKeys, isSysParamVer);
        }
        if (!isSysParamVer.booleanValue()) {
            return;
        }
        String versionField = isCopEntry ? "copentryversion" : "entryversion";
        DynamicObject type = dataEntity.getDynamicObject("type");
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(isCopEntry ? "copentry" : "entry");
        for (DynamicObject entry : entryColl) {
            DynamicObject materialMft = entry.getDynamicObject(isCopEntry ? "copentrymaterial" : "entrymaterial");
            DynamicObject material = this.getEntryMaterial(materialMft);
            DynamicObject version = entry.getDynamicObject(versionField);
            if (version != null || material == null) continue;
            boolean isUnPur = this.isUnPurChaseMat(materialMft);
            boolean isTypeVer = this.isVersionType(type);
            boolean isMatVer = material.getBoolean("isenablematerialversion");
            if (!isMatVer && (isCopEntry || !isTypeVer || !isUnPur)) continue;
            Long matId = (Long)material.getPkValue();
            DynamicObject newVersion = cacheEntryVersionMap.get(matId);
            if (newVersion == null) {
                newVersion = BOMVersionUtil.createBomEntryVersion((DynamicObject)dataEntity, (DynamicObject)material);
                cacheEntryVersionMap.put(matId, newVersion);
            }
            entry.set(versionField, (Object)newVersion);
        }
    }

    private boolean isUnPurChaseMat(DynamicObject materialMft) {
        return true;
    }
}

