/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.business.helper.SnMainfileNewHelp;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SnMainFileSaveValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject snumberCfg = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_sndimension", (QFilter[])new QFilter("number", "=", (Object)"SNUMBER").toArray());
        String sncheckrange = snumberCfg.getString("sncheckrange");
        Set snUnqctrl = SnMainfileNewHelp.getSnUnqctrl((String)sncheckrange);
        HashSet<String> snumbers = new HashSet<String>(this.dataEntities.length);
        HashMap<String, ExtendedDataEntity> snNumberUnqs = new HashMap<String, ExtendedDataEntity>(this.dataEntities.length);
        String unqmsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5e8f\u5217\u53f7\u7f16\u7801\u91cd\u590d\u3002", (String)"snMainfileNewHelp_0", (String)"bd-sbd-business", (Object[])new Object[0]);
        if (snUnqctrl.size() == 0) {
            unqmsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5e8f\u5217\u53f7\u7f16\u7801\u91cd\u590d\u3002", (String)"snMainfileNewHelp_0", (String)"bd-sbd-business", (Object[])new Object[0]);
        } else if (snUnqctrl.size() == 1 && snUnqctrl.contains("1")) {
            unqmsg = ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u4e0b\u5e8f\u5217\u53f7\u91cd\u590d\u3002", (String)"snMainfileNewHelp_1", (String)"bd-sbd-business", (Object[])new Object[0]);
        } else if (snUnqctrl.size() == 1 && snUnqctrl.contains("2")) {
            unqmsg = ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u3001\u7269\u6599\u7f16\u7801\u7ec4\u5408\u503c\u91cd\u590d\u3002", (String)"snMainfileNewHelp_2", (String)"bd-sbd-business", (Object[])new Object[0]);
        } else if (snUnqctrl.size() == 2 && snUnqctrl.contains("1") && snUnqctrl.contains("2")) {
            unqmsg = ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u3001\u7269\u6599\u7f16\u7801\u3001\u7ec4\u7ec7\u7ec4\u5408\u503c\u91cd\u590d\u3002", (String)"snMainfileNewHelp_3", (String)"bd-sbd-business", (Object[])new Object[0]);
        }
        RowMeta dataUniRowMeta = new RowMeta(new Field[]{new Field("number", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("invorg", (DataType)DataType.LongType), new Field("lotnumber", (DataType)DataType.StringType), new Field("masterfiletype", (DataType)DataType.LongType)});
        DataSetBuilder dataUniDsBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(dataUniRowMeta);
        for (ExtendedDataEntity entity : this.dataEntities) {
            boolean isEnableType;
            DynamicObject dataentity = entity.getDataEntity();
            String number = dataentity.getString("number");
            DynamicObject material = dataentity.getDynamicObject("material");
            DynamicObject invOrg = dataentity.getDynamicObject("invorg");
            DynamicObject masterfiletype = dataentity.getDynamicObject("masterfiletype");
            if (material == null || invOrg == null || masterfiletype == null) continue;
            String lotnum = dataentity.getString("lotnumber");
            if (lotnum == null || lotnum.isEmpty()) {
                lotnum = " ";
            }
            if (!(isEnableType = masterfiletype.getBoolean("enable"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u7c7b\u578b\u5df2\u7981\u7528\u3002", (String)"SnMainFileSaveValidator_7", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n");
            }
            this.transferInTranSit(entity);
            Long materialid = material.getLong("id");
            Long invorgid = invOrg.getLong("id");
            Long masterfiletypeid = masterfiletype.getLong("id");
            String snNumberUnq = this.buildSnunqstr(snUnqctrl, number, materialid, invorgid, lotnum, masterfiletypeid);
            if (snNumberUnqs.containsKey(snNumberUnq)) {
                this.addErrorMessage(entity, unqmsg);
                continue;
            }
            dataUniDsBuilder.append(new Object[]{number, materialid, invorgid, lotnum, masterfiletypeid});
            snNumberUnqs.put(snNumberUnq, entity);
            snumbers.add(number);
        }
        if (!snNumberUnqs.isEmpty()) {
            DataSet dataUniDataSet = dataUniDsBuilder.build();
            DataSet snMainFileDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_snmainfile", (String)"id,number as db_number,invorg as db_invorg,material as db_material,lotnumber as db_lotnumber,masterfiletype as db_masterfiletype", (QFilter[])new QFilter("number", "in", snumbers).toArray(), null);
            JoinDataSet tempDataSet = dataUniDataSet.join(snMainFileDataSet).on("number", "db_number").on("masterfiletype", "db_masterfiletype");
            for (String unqctrl : snUnqctrl) {
                if (unqctrl.equals("2")) {
                    tempDataSet = tempDataSet.on("material", "db_material");
                }
                if (unqctrl.equals("1")) {
                    tempDataSet = tempDataSet.on("invorg", "db_invorg");
                }
                if (!unqctrl.equals("3")) continue;
                tempDataSet = tempDataSet.on("lotnumber", "db_lotnumber");
            }
            dataUniDataSet = tempDataSet.select(dataUniDataSet.getRowMeta().getFieldNames()).finish();
            for (Row row : dataUniDataSet) {
                String dbNumber = row.getString("number");
                Long dbInvorg = row.getLong("invorg");
                Long dbMaterial = row.getLong("material");
                String dbLotnumber = row.getString("lotnumber");
                Long dbMasterfiletype = row.getLong("masterfiletype");
                String dbSnNumberUnq = this.buildSnunqstr(snUnqctrl, dbNumber, dbMaterial, dbInvorg, dbLotnumber, dbMasterfiletype);
                this.addErrorMessage((ExtendedDataEntity)snNumberUnqs.get(dbSnNumberUnq), unqmsg);
            }
        }
        try (TraceSpan ignored = Tracer.create((String)"SnMainFileSaveValidator", (String)"snDimUniqCheck");){
            this.snDimUniqCheck();
        }
    }

    private void snDimUniqCheck() {
        Map dimcfgs = BusinessDataServiceHelper.loadFromCache((String)"bd_sndimension", (QFilter[])new QFilter("number", "!=", (Object)"SNUMBER").and("enable", "=", (Object)Boolean.TRUE).toArray());
        if (dimcfgs != null && !dimcfgs.isEmpty()) {
            for (DynamicObject dimcfg : dimcfgs.values()) {
                long dimitemid = dimcfg.getLong("id");
                String dimcheckrange = dimcfg.getString("sncheckrange");
                Set dimUnqctrl = SnMainfileNewHelp.getSnUnqctrl((String)dimcheckrange);
                HashSet<String> dimnumbers = new HashSet<String>(this.dataEntities.length);
                HashMap<String, ExtendedDataEntity> dimNumberUnqs = new HashMap<String, ExtendedDataEntity>(this.dataEntities.length);
                String unqmsg = ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u7ef4\u5ea6\u503c\u201c%1$s\u201d\u91cd\u590d\u3002", (String)"SnMainFileSaveValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n";
                if (dimUnqctrl.size() == 0) {
                    unqmsg = ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u7ef4\u5ea6\u503c\u201c%1$s\u201d\u91cd\u590d\u3002", (String)"SnMainFileSaveValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n";
                } else if (dimUnqctrl.size() == 1 && dimUnqctrl.contains("1")) {
                    unqmsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0b\u5e8f\u5217\u53f7\u7ef4\u5ea6\u503c\u201c%1$s\u201d\u91cd\u590d\u3002", (String)"SnMainFileSaveValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n";
                } else if (dimUnqctrl.size() == 1 && dimUnqctrl.contains("2")) {
                    unqmsg = ResManager.loadKDString((String)"\u7269\u6599\u4e0b\u5e8f\u5217\u53f7\u7ef4\u5ea6\u503c\u201c%1$s\u201d\u91cd\u590d\u3002", (String)"SnMainFileSaveValidator_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n";
                } else if (dimUnqctrl.size() == 2 && dimUnqctrl.contains("1") && dimUnqctrl.contains("2")) {
                    unqmsg = ResManager.loadKDString((String)"\u7ec4\u7ec7+\u7269\u6599\u4e0b\u5e8f\u5217\u53f7\u7ef4\u5ea6\u503c\u201c%1$s\u201c\u91cd\u590d\u3002", (String)"SnMainFileSaveValidator_3", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n";
                }
                RowMeta dataUniRowMeta = new RowMeta(new Field[]{new Field("dimnumber", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("invorg", (DataType)DataType.LongType), new Field("lotnumber", (DataType)DataType.StringType), new Field("masterfiletype", (DataType)DataType.LongType)});
                DataSetBuilder dataUniDsBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(dataUniRowMeta);
                for (ExtendedDataEntity entity : this.dataEntities) {
                    Long masterfiletypeid;
                    Long invorgid;
                    Long materialid;
                    String dimNumberUnq;
                    String dimnumber = null;
                    DynamicObject dataentity = entity.getDataEntity();
                    DynamicObjectCollection sndimEntity = dataentity.getDynamicObjectCollection("sndimentity");
                    if (!CollectionUtils.isEmpty((Collection)sndimEntity)) {
                        for (DynamicObject sndim : sndimEntity) {
                            DynamicObject dimitem = sndim.getDynamicObject("sndimitem");
                            if (dimitem == null || dimitem.getLong("id") != dimitemid) continue;
                            if (dimnumber != null) {
                                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u540c\u4e00\u8868\u5355\u4e2d\u5e8f\u5217\u53f7\u7ef4\u5ea6\u9879\u4e0d\u53ef\u91cd\u590d\u3002", (String)"SnMainFileSaveValidator_4", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n");
                                continue;
                            }
                            dimnumber = sndim.getString("sndimnumber");
                        }
                    }
                    if (dimnumber == null) continue;
                    DynamicObject material = dataentity.getDynamicObject("material");
                    DynamicObject invOrg = dataentity.getDynamicObject("invorg");
                    DynamicObject masterfiletype = dataentity.getDynamicObject("masterfiletype");
                    if (material == null || invOrg == null || masterfiletype == null) continue;
                    String lotnum = dataentity.getString("lotnumber");
                    if (lotnum == null || lotnum.isEmpty()) {
                        lotnum = " ";
                    }
                    if (dimNumberUnqs.containsKey(dimNumberUnq = this.buildSnunqstr(dimUnqctrl, dimnumber, materialid = Long.valueOf(material.getLong("id")), invorgid = Long.valueOf(invOrg.getLong("id")), lotnum, masterfiletypeid = Long.valueOf(masterfiletype.getLong("id"))))) {
                        this.addErrorMessage(entity, String.format(unqmsg, dimnumber));
                        continue;
                    }
                    dataUniDsBuilder.append(new Object[]{dimnumber, materialid, invorgid, lotnum, masterfiletypeid});
                    dimNumberUnqs.put(dimNumberUnq, entity);
                    dimnumbers.add(dimnumber);
                }
                if (dimNumberUnqs.isEmpty()) continue;
                DataSet dataUniDataSet = dataUniDsBuilder.build();
                SqlBuilder dimSql = new SqlBuilder();
                dimSql.append("select e.fentryid as entryid,e.fsndimnumber as db_dimnumber,m.fmaterialid as db_material,m.finvorgid as db_invorg,m.flotnumber as db_lotnumber,m.fmasterfiletypeid as db_masterfiletype ", new Object[0]).append(" from t_bd_sndimensionentry e", new Object[0]).append(" join t_bd_snmainfile m on e.fid = m.fid where", new Object[0]).appendIn("e.fsndimnumber", dimnumbers.toArray()).append(" and e.fsndimitem = ?", new Object[]{dimitemid});
                DataSet dimDataSet = this.excutedDB(dimSql);
                JoinDataSet tempDataSet = dataUniDataSet.join(dimDataSet).on("dimnumber", "db_dimnumber").on("masterfiletype", "db_masterfiletype");
                for (String unqctrl : dimUnqctrl) {
                    if (unqctrl.equals("2")) {
                        tempDataSet = tempDataSet.on("material", "db_material");
                    }
                    if (unqctrl.equals("1")) {
                        tempDataSet = tempDataSet.on("invorg", "db_invorg");
                    }
                    if (!unqctrl.equals("3")) continue;
                    tempDataSet = tempDataSet.on("lotnumber", "db_lotnumber");
                }
                dataUniDataSet = tempDataSet.select(dataUniDataSet.getRowMeta().getFieldNames()).finish();
                for (Row row : dataUniDataSet) {
                    String dbDimNumber = row.getString("dimnumber");
                    Long dbInvorg = row.getLong("invorg");
                    Long dbMaterial = row.getLong("material");
                    String dbLotnumber = row.getString("lotnumber");
                    Long dbMasterfiletype = row.getLong("masterfiletype");
                    String dbDimNumberUnq = this.buildSnunqstr(dimUnqctrl, dbDimNumber, dbMaterial, dbInvorg, dbLotnumber, dbMasterfiletype);
                    this.addErrorMessage((ExtendedDataEntity)dimNumberUnqs.get(dbDimNumberUnq), String.format(unqmsg, dbDimNumber));
                }
            }
        }
    }

    private DataSet excutedDB(SqlBuilder dimSql) {
        return DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)dimSql);
    }

    private void transferInTranSit(ExtendedDataEntity entity) {
        String snstatus = entity.getDataEntity().getString("snstatus");
        if ("E".equals(snstatus)) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u65b0\u589e\u5e8f\u5217\u53f7\u72b6\u6001\u4e0d\u80fd\u4e3a\u8c03\u62e8\u5728\u9014\u3002", (String)"SnMainFileSaveValidator_6", (String)"bd-sbd-opplugin", (Object[])new Object[0]) + "\n");
        }
    }

    private String buildSnunqstr(Set<String> unqctrl, String number, Long materialid, Long invorgid, String lotnum, Long masterfiletypeid) {
        StringBuilder unqstrbuilder = new StringBuilder(number);
        unqstrbuilder.append('.').append(masterfiletypeid);
        if (unqctrl.contains("1")) {
            unqstrbuilder.append('.').append(invorgid);
        }
        if (unqctrl.contains("2")) {
            unqstrbuilder.append('.').append(materialid);
        }
        if (unqctrl.contains("3")) {
            unqstrbuilder.append('.').append(lotnum);
        }
        return unqstrbuilder.toString();
    }
}

