/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator.materialplan;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialPlanBizValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MaterialPlanBizValidator", (String)"checkReferences");){
            this.checkCreateOrgData(this.dataEntities);
        }
    }

    private void checkCreateOrgData(ExtendedDataEntity[] dataEntities) {
        Set<Long> orgIdsByPlanView = this.getOrgIdsByPlanView();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity exData : dataEntities) {
            DynamicObject data = exData.getDataEntity();
            if (!(data.get("createorg") instanceof Long)) continue;
            Long orgId = (Long)data.get("createorg");
            orgIds.add(orgId);
        }
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        for (ExtendedDataEntity exData : dataEntities) {
            DynamicObject createorg;
            DynamicObject data = exData.getDataEntity();
            Long createorgId = 0L;
            String createorgName = "";
            if (data.get("createorg") instanceof DynamicObject) {
                createorg = data.getDynamicObject("createorg");
                createorgName = createorg.getLocaleString("name").getLocaleValue();
                createorgId = createorg.getLong("id");
            } else if (data.get("createorg") instanceof Long) {
                createorgId = (Long)data.get("createorg");
                createorg = (DynamicObject)orgMap.get(createorgId);
                if (createorg == null) continue;
                createorgName = createorg.getLocaleString("name").getLocaleValue();
            }
            if (!orgIdsByPlanView.contains(createorgId)) {
                this.addErrorMessage(exData, String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a\u201c%s\u201d\u4e0d\u5728\u8ba1\u5212\u89c6\u56fe\u8303\u56f4\u5185\u3002", (String)"MaterialPlanBizValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]), createorgName));
            }
            String permItem = this.getPermItem(this.getOperateKey());
            int hasPermissin = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)createorgId, (String)"mrp", (String)"mpdm_materialplan", (String)permItem);
            if (hasPermissin == 1) continue;
            this.addErrorMessage(exData, String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u4e0d\u80fd\u6267\u884c\u201c%2$s\u201d\u64cd\u4f5c\u3002", (String)"MaterialPlanBizValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]), createorgName, this.getOperationName()));
        }
    }

    private String getPermItem(String operateKey) {
        String permItem = "47150e89000000ac";
        if ("save".equals(operateKey)) {
            permItem = "47156aff000000ac";
        } else if ("submit".equals(operateKey)) {
            permItem = "804f6478000000ac";
        } else if ("unsubmit".equals(operateKey)) {
            permItem = "80513207000000ac";
        } else if ("audit".equals(operateKey)) {
            permItem = "47162f66000000ac";
        } else if ("unaudit".equals(operateKey)) {
            permItem = "47165e8e000000ac";
        }
        return permItem;
    }

    public static Long getDataId(Object object) {
        Long dataid = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject data = (DynamicObject)object;
            dataid = data.getLong("id");
        } else if (object instanceof Long) {
            dataid = (Long)object;
        }
        return dataid;
    }

    public Set<Long> getOrgIdsByPlanView() {
        HashSet<Long> idSet = new HashSet<Long>(16);
        QFilter viewfilter = new QFilter("view", "=", (Object)914427355726916608L);
        QFilter ctrlfilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        String selectProperties = "org,isctrlunit";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PlanViewOrgHelper", (String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{viewfilter, ctrlfilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong("org");
                idSet.add(id);
            }
        }
        return idSet;
    }
}

