/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MasterDataStandardService {
    private static final Log logger = LogFactory.getLog(MasterDataStandardService.class);
    public static final String ENTITY_GROUPSTANDARD = "groupstandard";
    public static final String ENTITY_GROUPDETAIL = "groupdetail";

    public Set<Long> getGroupStandard(String entityNumber, Long createOrg, boolean isAddEnable) {
        HashSet<Long> standardSetIds = new HashSet<Long>();
        try {
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
            if (ctrlview == null) {
                return standardSetIds;
            }
            ORM ormOv = ORM.create();
            QFilter f1 = new QFilter("view.id", "=", ctrlview.getPkValue());
            QFilter f2 = new QFilter("org", "=", (Object)createOrg);
            HashSet<String> orglongnumberSets = new HashSet<String>();
            DataSet ds = ormOv.queryDataSet(MasterDataStandardService.class.getName(), "bos_org_structure", "longnumber", new QFilter[]{f1, f2});
            Object object = null;
            try {
                for (Row row : ds) {
                    if (row.getString("longnumber") == null) continue;
                    orglongnumberSets.add(row.getString("longnumber"));
                }
            }
            catch (Throwable iter) {
                object = iter;
                throw iter;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable iter) {
                            ((Throwable)object).addSuppressed(iter);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            HashSet<String> orgnumberSets = new HashSet<String>();
            for (String orglongnumber : orglongnumberSets) {
                String[] orgnumbers = orglongnumber.split("!");
                orgnumberSets.addAll(new HashSet<String>(Arrays.asList(orgnumbers)));
            }
            QFilter f = new QFilter("number", "in", orgnumberSets);
            f2 = new QFilter("enable", "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{f, f2};
            HashSet<Long> orgIdSets = new HashSet<Long>();
            try (DataSet ds2 = ormOv.queryDataSet(MasterDataStandardService.class.getName(), "bos_org", "id", qFilters);){
                for (Row row : ds2) {
                    if (row.getLong("id") == null) continue;
                    orgIdSets.add(row.getLong("id"));
                }
            }
            f = new QFilter("createorg", "in", orgIdSets);
            qFilters = isAddEnable ? new QFilter[]{f, f2} : new QFilter[]{f};
            ds2 = ormOv.queryDataSet(MasterDataStandardService.class.getName(), entityNumber + ENTITY_GROUPSTANDARD, "id", qFilters);
            var15_20 = null;
            try {
                for (Row row : ds2) {
                    if (row.get("id") == null) continue;
                    standardSetIds.add(Long.parseLong(row.get("id").toString()));
                }
            }
            catch (Throwable throwable) {
                var15_20 = throwable;
                throw throwable;
            }
            finally {
                if (ds2 != null) {
                    if (var15_20 != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable throwable) {
                            var15_20.addSuppressed(throwable);
                        }
                    } else {
                        ds2.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return standardSetIds;
    }

    public Set<Long> getGroupStandardByOrgs(String entityNumber, List<Long> createOrgs, boolean isAddEnable) {
        HashSet<Long> standardSetIds = new HashSet<Long>();
        try {
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
            if (ctrlview == null) {
                return standardSetIds;
            }
            ORM ormOv = ORM.create();
            QFilter f1 = new QFilter("view.id", "=", ctrlview.getPkValue());
            QFilter f2 = new QFilter("org", "in", createOrgs);
            HashSet<String> orglongnumberSets = new HashSet<String>();
            try (DataSet ds = ormOv.queryDataSet(MasterDataStandardService.class.getName(), "bos_org_structure", "longnumber", new QFilter[]{f1, f2});){
                for (Row row : ds) {
                    if (row.getString("longnumber") == null) continue;
                    orglongnumberSets.add(row.getString("longnumber"));
                }
            }
            ArrayList orglongnumberList = new ArrayList(orglongnumberSets);
            String orgLongNumber = "";
            if (orglongnumberList.size() > 1) {
                for (int i = 1; i < orglongnumberList.size(); ++i) {
                    orgLongNumber = i == 1 ? MasterDataStandardService.getInterSeciton((String)orglongnumberList.get(i - 1), (String)orglongnumberList.get(i)) : MasterDataStandardService.getInterSeciton(orgLongNumber, (String)orglongnumberList.get(i));
                }
            } else if (orglongnumberList.size() == 1) {
                orgLongNumber = (String)orglongnumberList.get(0);
            } else {
                return standardSetIds;
            }
            String[] orgnumbers = orgLongNumber.split("!");
            HashSet<String> orgnumberSets = new HashSet<String>();
            orgnumberSets.addAll(new HashSet<String>(Arrays.asList(orgnumbers)));
            QFilter f = new QFilter("number", "in", orgnumberSets);
            f2 = new QFilter("enable", "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{f, f2};
            HashSet<Long> orgIdSets = new HashSet<Long>();
            try (DataSet ds = ormOv.queryDataSet(MasterDataStandardService.class.getName(), "bos_org", "id", qFilters);){
                for (Row row : ds) {
                    if (row.getLong("id") == null) continue;
                    orgIdSets.add(row.getLong("id"));
                }
            }
            f = new QFilter("createorg", "in", orgIdSets);
            qFilters = isAddEnable ? new QFilter[]{f, f2} : new QFilter[]{f};
            ds = ormOv.queryDataSet(MasterDataStandardService.class.getName(), entityNumber + ENTITY_GROUPSTANDARD, "id", qFilters);
            var18_25 = null;
            try {
                for (Row row : ds) {
                    if (row.get("id") == null) continue;
                    standardSetIds.add(Long.parseLong(row.get("id").toString()));
                }
            }
            catch (Throwable throwable) {
                var18_25 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var18_25 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var18_25.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return standardSetIds;
    }

    public QFilter getGroupByOrgs(String entityNumber, List<Long> creates, Long standardId, boolean isAddEnable) {
        QFilter qFilter = null;
        try {
            HashSet<Long> createOrgs = new HashSet<Long>(creates);
            Set<Long> useOrgIds = MasterDataStandardService.getGroupOrgId(entityNumber, createOrgs);
            qFilter = new QFilter("createorg", "in", useOrgIds);
            if (StringUtils.isBlank((Object)standardId)) {
                Set<Long> standardIds = this.getGroupStandardByOrgs(entityNumber, creates, isAddEnable);
                QFilter f1 = new QFilter("standard", "in", standardIds);
                qFilter.and(f1);
            } else {
                QFilter f1 = new QFilter("standard", "=", (Object)standardId);
                qFilter.and(f1);
            }
            QFilter f2 = new QFilter("enable", "=", (Object)"1");
            if (isAddEnable) {
                qFilter.and(f2);
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return qFilter;
    }

    public static Set<Long> getGroupOrgId(String entity, Set<Long> useOrgs) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet<String> longnumberSet = new HashSet<String>();
        ORM ormOv = ORM.create();
        DataSet ds = ormOv.queryDataSet(MasterDataStandardService.class.getName(), "bos_org_structure", "longnumber", new QFilter[]{new QFilter("org", "in", useOrgs), new QFilter("view.id", "=", (Object)ctrlview.getLong("id"))});
        Object object = null;
        try {
            for (Row row : ds) {
                if (row.getString("longnumber") == null) continue;
                longnumberSet.add(row.getString("longnumber"));
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<String> numberSets = new HashSet<String>();
        for (String longnumber : longnumberSet) {
            String[] numbers = longnumber.split("!");
            numberSets.addAll(new HashSet<String>(Arrays.asList(numbers)));
        }
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds2 = ormOv.queryDataSet(MasterDataStandardService.class.getName(), "bos_org", "id", new QFilter[]{new QFilter("number", "in", numberSets)});){
            for (Row row : ds2) {
                if (row.getLong("id") == null) continue;
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    public static String getInterSeciton(String max, String min) {
        String[] minarray;
        StringBuilder sb = new StringBuilder();
        String[] maxarray = max.split("!");
        if (maxarray.length < (minarray = min.split("!")).length) {
            String s = max;
            max = min;
            min = s;
        }
        minarray = min.split("!");
        maxarray = max.split("!");
        for (int i = 0; i < minarray.length; ++i) {
            if (!maxarray[i].equals(minarray[i])) continue;
            sb.append(maxarray[i]).append("!");
        }
        return sb.toString();
    }

    public ApiResult updateGroupStandard(DynamicObject[] datas, Long groupId, Long groupStrandId) {
        if (datas == null || datas.length == 0) {
            return ApiResult.success((Object)datas);
        }
        QFilter f1 = new QFilter("standard", "=", (Object)groupStrandId);
        String entityName = "";
        String entity = datas[0].getDataEntityType().getName();
        ArrayList<Long> dataIds = new ArrayList<Long>(datas.length);
        for (DynamicObject data : datas) {
            Long dataId = data.getLong("id");
            dataIds.add(dataId);
        }
        logger.info("\u4f20\u5165\u5206\u7c7b\u6807\u51c6\u4e3a:" + groupStrandId + ";\u5206\u7c7b\u4e3a: " + groupId + ";\u4e3b\u6570\u636e\u7c7b\u578b\u4e3a: " + entity + ";\u4e3b\u6570\u636e\u4e3a: " + dataIds);
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)groupId, (String)(entity + "group"), (String)"id,createorg");
        Long groupOrgId = this.getDataByType(group.get("createorg"));
        QFilter f2 = null;
        String defGroupStandard = "";
        StringBuilder selectfield = new StringBuilder("id").append(',').append("standard").append(',').append("group");
        if (entity.equals("bd_customer")) {
            f2 = new QFilter("customer", "in", dataIds);
            selectfield.append(',').append("customer").append(',').append("createorg");
            entityName = "customer";
            defGroupStandard = "712984405228187648";
        } else if (entity.equals("bd_supplier")) {
            f2 = new QFilter("supplier", "in", dataIds);
            selectfield.append(',').append("supplier").append(',').append("createorg");
            entityName = "supplier";
            defGroupStandard = "716529547008326656";
        } else if (entity.equals("bd_material")) {
            f2 = new QFilter("material", "in", dataIds);
            selectfield.append(',').append("material").append(',').append("createorg");
            entityName = "material";
            defGroupStandard = "730148448254487552";
        } else {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u4e3b\u6570\u636e\u3002", (String)"MasterDataStandardService_1", (String)"bd-master-mservice", (Object[])new Object[0]), (String)"0001");
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"MasterDataStandardService.updateGroupStandard");){
            if (defGroupStandard.equals(groupStrandId.toString())) {
                DynamicObject[] basedatas;
                for (DynamicObject entitydata : basedatas = BusinessDataServiceHelper.load((String)entity, (String)"id,group", (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)})) {
                    entitydata.set("group", (Object)groupId);
                }
                SaveServiceHelper.update((DynamicObject[])basedatas);
            }
            QFilter[] qFilters = new QFilter[]{f1, f2};
            DynamicObject[] details = BusinessDataServiceHelper.load((String)(entity + ENTITY_GROUPDETAIL), (String)selectfield.toString(), (QFilter[])qFilters);
            ArrayList<DynamicObject> standards = new ArrayList<DynamicObject>(details.length);
            for (DynamicObject data : details) {
                data.set("group", (Object)groupId);
                data.set("createorg", (Object)groupOrgId);
                standards.add(data);
                Long entityId = data.getDynamicObject(entityName).getLong("id");
                if (!dataIds.contains(entityId)) continue;
                dataIds.remove(entityId);
            }
            for (Long dataId : dataIds) {
                DynamicObject entityGroupDetail = BusinessDataServiceHelper.newDynamicObject((String)(entity + ENTITY_GROUPDETAIL));
                entityGroupDetail.set("standard", (Object)groupStrandId);
                entityGroupDetail.set("group", (Object)groupId);
                entityGroupDetail.set(entityName, (Object)dataId);
                entityGroupDetail.set("createorg", (Object)groupOrgId);
                standards.add(entityGroupDetail);
            }
            SaveServiceHelper.save((DynamicObject[])standards.toArray(new DynamicObject[0]));
            ApiResult apiResult = ApiResult.success((Object)datas);
            return apiResult;
        }
        catch (Throwable e) {
            logger.error(e);
            tx.markRollback();
            ApiResult apiResult = ApiResult.ex((Throwable)e);
            return apiResult;
        }
    }

    public Map<Long, Set<Long>> checkAvailableMasterData(String entity, Map<Long, Set<Long>> orgMasterData) {
        HashMap<Long, Set<Long>> orgEffectMasterData = new HashMap<Long, Set<Long>>(orgMasterData.size());
        String datafield = "";
        if (entity.equals("bd_customer")) {
            datafield = "customer";
            entity = "bd_customer";
        } else if (entity.equals("bd_supplier")) {
            datafield = "supplier";
            entity = "bd_supplier";
        } else if (entity.equals("bd_material")) {
            datafield = "material";
            entity = "bd_material";
        }
        HashSet<Long> allDataIds = new HashSet<Long>();
        for (Set<Long> dataIds : orgMasterData.values()) {
            allDataIds.addAll(dataIds);
        }
        QFilter qf = new QFilter(datafield, "in", allDataIds);
        String selectfield = datafield + "," + "createorg";
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)(entity + ENTITY_GROUPDETAIL), (String)selectfield, (QFilter[])new QFilter[]{qf});
        HashMap<Long, HashSet<Long>> queryMasterData = new HashMap<Long, HashSet<Long>>(loadFromCache.size());
        for (DynamicObject dynamicObject : loadFromCache.values()) {
            Long dataId = this.getDataByType(dynamicObject.get(datafield));
            Long createOrg = this.getDataByType(dynamicObject.get("createorg"));
            HashSet<Long> queryDataIds = (HashSet<Long>)queryMasterData.get(createOrg);
            if (queryDataIds == null) {
                queryDataIds = new HashSet<Long>();
            }
            queryDataIds.add(dataId);
            queryMasterData.put(createOrg, queryDataIds);
        }
        for (Map.Entry entry : orgMasterData.entrySet()) {
            Long orgId = (Long)entry.getKey();
            HashSet<Long> useOrgs = new HashSet<Long>();
            useOrgs.add(orgId);
            Set<Long> groupOrgIds = MasterDataStandardService.getGroupOrgId(entity, useOrgs);
            Set dataIds = (Set)entry.getValue();
            HashSet orgsQueryDataIds = new HashSet();
            for (Long groupOrgId : groupOrgIds) {
                Set queryDataIds = (Set)queryMasterData.get(groupOrgId);
                if (queryDataIds == null) continue;
                orgsQueryDataIds.addAll(queryDataIds);
            }
            if (dataIds == null || orgsQueryDataIds == null) continue;
            dataIds.retainAll(orgsQueryDataIds);
            orgEffectMasterData.put(orgId, dataIds);
        }
        return orgEffectMasterData;
    }

    public List<Long> queryGroupsByGroupId(String entity, Long standardId, Long id, Set<Long> useOrgs) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (id == null) {
            return list;
        }
        Long dataId = Long.valueOf(id.toString());
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"longnumber,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataId)});
        list.add(dataId);
        if (group == null) {
            return list;
        }
        String longNumberDlm = ".";
        MainEntityType dataEntityType = (MainEntityType)group.getDataEntityType();
        DynamicProperty property = dataEntityType.getProperty("parent");
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        String longnumber = group.getString("longnumber");
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + longNumberDlm + "%"));
        QFilter f2 = new QFilter("standard", "=", (Object)Long.valueOf(standardId.toString()));
        QFilter f3 = new QFilter("createorg", "in", useOrgs);
        QFilter[] qFilters = new QFilter[]{f1, f2, f3};
        ORM ormOv = ORM.create();
        try (DataSet ds = ormOv.queryDataSet(MasterDataStandardService.class.getName(), entity, "id", qFilters);){
            for (Row row : ds) {
                if (row.getLong("id") == null) continue;
                list.add(row.getLong("id"));
            }
        }
        return list;
    }

    public Long getDataByType(Object object) {
        Long dataId = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject createorg = (DynamicObject)object;
            dataId = (Long)createorg.getPkValue();
        } else if (object instanceof Long) {
            dataId = (Long)object;
        }
        return dataId;
    }
}

