/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.helper.BillopcontrolHelper;
import kd.bd.master.mservice.api.IOpMasterManagementService;
import kd.bd.master.vo.BillOpCondition;
import kd.bd.master.vo.BillOpStatusVo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OpMasterManagementService
implements IOpMasterManagementService {
    private static final Log log = LogFactory.getLog(OpMasterManagementService.class);
    private BillopcontrolHelper billopcontrolHelper = new BillopcontrolHelper();

    public void checkData(List<Object> datas, String op) {
        String entityName;
        DynamicObject dynamicObject;
        if (datas != null && datas.size() > 0 && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_billopcontrol", (QFilter[])new QFilter[]{new QFilter("object", "=", (Object)(entityName = ((DynamicObject)datas.get(0)).getDataEntityType().getName())), new QFilter("enable", "=", (Object)"1")})) != null) {
            log.info("bd_billopcontrol data is not null.");
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection sortColl = this.sortList(collection);
            ArrayList<BillOpCondition> billOpConditions = new ArrayList<BillOpCondition>(sortColl.size());
            BillOpCondition conditionVo = null;
            ArrayList<BillOpStatusVo> billOpStatusVos = new ArrayList<BillOpStatusVo>(sortColl.size());
            BillOpStatusVo opStatusVo = null;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sortColl.size(); ++i) {
                if (!op.equals(((DynamicObject)sortColl.get(i)).getString("billoperation"))) continue;
                sb.append(((DynamicObject)sortColl.get(i)).getString("matachfiled")).append(',');
                String entityNumber = ((DynamicObject)sortColl.get(i)).getDynamicObject("basedatatype").getString("number");
                String matachfiled = ((DynamicObject)sortColl.get(i)).getString("matachfiled");
                String operation = ((DynamicObject)sortColl.get(i)).getString("billoperation");
                int priority = ((DynamicObject)sortColl.get(i)).getInt("priority");
                log.info("entityNumber:" + entityNumber);
                if ("bd_supplier".equals(entityNumber)) {
                    opStatusVo = new BillOpStatusVo(matachfiled, operation, priority, ((DynamicObject)sortColl.get(i)).getDynamicObjectCollection("supwhitelist"));
                } else if ("bd_customer".equals(entityNumber)) {
                    opStatusVo = new BillOpStatusVo(matachfiled, operation, priority, ((DynamicObject)sortColl.get(i)).getDynamicObjectCollection("cuswhitelist"));
                }
                billOpStatusVos.add(opStatusVo);
                String condition = ((DynamicObject)sortColl.get(i)).getString("conditionjson_tag");
                if (!StringUtils.isNotEmpty((CharSequence)condition)) continue;
                conditionVo = new BillOpCondition(matachfiled, operation, priority, condition);
                billOpConditions.add(conditionVo);
            }
            ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(datas.size());
            for (Object obj : datas) {
                DynamicObject dyn = (DynamicObject)obj;
                dyns.add(dyn);
            }
            if (billOpStatusVos.size() > 0) {
                Collections.sort(billOpStatusVos);
                Collections.sort(billOpConditions);
                this.checkBlackList(op, entityName, billOpConditions, billOpStatusVos, dyns);
            }
        }
    }

    private void checkBlackList(String op, String entityName, List<BillOpCondition> billOpConditions, List<BillOpStatusVo> billOpStatusVos, List<DynamicObject> dyns) {
        ArrayList<Long> statusPks = null;
        for (DynamicObject dyn : dyns) {
            for (BillOpStatusVo opStatusVo : billOpStatusVos) {
                DynamicObjectCollection realStatus = opStatusVo.getStatusCollection();
                if (realStatus != null && realStatus.size() > 0) {
                    statusPks = new ArrayList<Long>(realStatus.size());
                    for (DynamicObject st : realStatus) {
                        log.info("fbasedataid_id" + st.getLong("fbasedataid_id"));
                        statusPks.add(st.getLong("fbasedataid_id"));
                    }
                }
                String matachfiled = opStatusVo.getMatachfiled();
                int count = this.characterCount(matachfiled, '.');
                if (matachfiled.contains(".") && count == 1) {
                    log.info(matachfiled + ":" + count);
                    DynamicObjectCollection collection = dyn.getDynamicObjectCollection(matachfiled.substring(0, matachfiled.indexOf(".")));
                    for (DynamicObject ob : collection) {
                        DynamicObject dy = (DynamicObject)ob.get(matachfiled.substring(matachfiled.indexOf(".") + 1, matachfiled.length()));
                        if (dy != null) {
                            this.checkDataStatus(op, entityName, billOpConditions, statusPks, dyn, opStatusVo, dy);
                            continue;
                        }
                        log.info("collection get data is null");
                    }
                    continue;
                }
                if (matachfiled.contains(".") && count == 2) {
                    log.info(matachfiled + ":" + count);
                    String[] splitKey = matachfiled.split("\\.");
                    if (splitKey == null || splitKey.length != 3) continue;
                    DynamicObjectCollection collection = dyn.getDynamicObjectCollection(splitKey[0]);
                    for (DynamicObject ob : collection) {
                        DynamicObjectCollection subCollection = ob.getDynamicObjectCollection(splitKey[1]);
                        if (subCollection == null || subCollection.size() <= 0) continue;
                        for (DynamicObject subDyn : subCollection) {
                            DynamicObject dy = (DynamicObject)subDyn.get(splitKey[2]);
                            if (dy != null) {
                                this.checkDataStatus(op, entityName, billOpConditions, statusPks, dyn, opStatusVo, dy);
                                continue;
                            }
                            log.info("subcollection get data is null");
                        }
                    }
                    continue;
                }
                log.info(matachfiled);
                DynamicObject dy = (DynamicObject)dyn.get(matachfiled);
                if (dy != null) {
                    this.checkDataStatus(op, entityName, billOpConditions, statusPks, dyn, opStatusVo, dy);
                    continue;
                }
                log.info("dyn.get(arr[0]) is null");
            }
        }
    }

    private void checkDataStatus(String op, String entityName, List<BillOpCondition> billOpConditions, List<Long> statusPks, DynamicObject dyn, BillOpStatusVo opStatusVo, DynamicObject dy) {
        if (dyn != null) {
            DynamicObject customer;
            Long statusId = 0L;
            String statusName = "";
            String dataName = "";
            log.info("checkDataStatus entityName:" + dy.getDataEntityType().getName());
            if ("bd_supplier".equals(dy.getDataEntityType().getName())) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)dy.getPkValue(), (String)"bd_supplier", (String)"supplier_status,name");
                if (supplier != null && supplier.getDynamicObject("supplier_status") != null) {
                    statusId = supplier.getDynamicObject("supplier_status").getLong("id");
                    log.info("supplier status:" + statusId);
                    statusName = supplier.getDynamicObject("supplier_status").getLocaleString("name").getLocaleValue();
                    dataName = supplier.getLocaleString("name").getLocaleValue();
                }
            } else if ("bd_customer".equals(dy.getDataEntityType().getName()) && (customer = BusinessDataServiceHelper.loadSingle((Object)dy.getPkValue(), (String)"bd_customer", (String)"customerstatus,name")) != null && customer.getDynamicObject("customerstatus") != null) {
                statusId = customer.getDynamicObject("customerstatus").getLong("id");
                log.info("customer status:" + statusId);
                statusName = customer.getDynamicObject("customerstatus").getLocaleString("name").getLocaleValue();
                dataName = customer.getLocaleString("name").getLocaleValue();
            }
            if (statusPks.contains(statusId)) {
                log.info("statusPks is contains statusId.");
                this.checkCondition(op, entityName, billOpConditions, dyn, opStatusVo, dy, statusName, dataName);
            }
        } else {
            log.error("checkDataStatus dyn is null.");
        }
    }

    private void checkCondition(String op, String entityName, List<BillOpCondition> billOpConditions, DynamicObject dyn, BillOpStatusVo opStatusVo, DynamicObject dy, String statusName, String dataName) {
        String localeId = RequestContext.get().getLang().name();
        if (billOpConditions != null && billOpConditions.size() > 0) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            HashMap<String, BillOpCondition> matachfiledMap = new HashMap<String, BillOpCondition>(billOpConditions.size());
            for (BillOpCondition opCondition : billOpConditions) {
                matachfiledMap.put(opCondition.getMatachfiled() + '-' + opCondition.getOperation() + '-' + opCondition.getPriority(), opCondition);
            }
            String key = opStatusVo.getMatachfiled() + '-' + opStatusVo.getOperation() + '-' + opStatusVo.getPriority();
            if (matachfiledMap.containsKey(key)) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)((BillOpCondition)matachfiledMap.get(key)).getConditionjsonTag(), CRCondition.class);
                FilterBuilder fb = new FilterBuilder(entityType, condition.getFilterCondition());
                String[] script = fb.buildFilterScript();
                BOSExpression expr = new BOSExpression(script[0]);
                boolean exec = true;
                Set vars = expr.getVars();
                if (!vars.isEmpty()) {
                    Map param = this.billopcontrolHelper.buildMatchParam(dyn, vars);
                    exec = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), (Map)param, null);
                }
                if (exec) {
                    log.info("exec condition true.");
                    this.doException(op, entityName, dy, localeId, statusName, dataName);
                }
            } else {
                log.info("throw exception.");
                this.doException(op, entityName, dy, localeId, statusName, dataName);
            }
        } else {
            log.info("throw exception.");
            this.doException(op, entityName, dy, localeId, statusName, dataName);
        }
    }

    private void doException(String op, String entityName, DynamicObject dy, String localeId, String statusName, String dataName) {
        log.info("throw exception in.");
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u201c%4$s\u201d\u7684\u72b6\u6001\u4e3a%2$s\uff0c\u4e0d\u5141\u8bb8%3$s\uff1b\u5982\u9700\u653e\u5f00\uff0c\u8bf7\u8054\u7cfb%1$s\u7684\u6570\u636e\u7ba1\u7406\u4eba\u5458\u5728\u5355\u636e\u64cd\u4f5c\u7ba1\u63a7\u4e2d\u914d\u7f6e\u3002", (String)"OpMasterManagementService_0", (String)"bd-master-mservice", (Object[])new Object[0]), dy.getDataEntityType().getDisplayName().getLocaleValue(), statusName, this.billopcontrolHelper.getOperateName(entityName, op, localeId), dataName));
    }

    private DynamicObjectCollection sortList(DynamicObjectCollection collection) {
        collection.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getInt("priority") - o2.getInt("priority");
            }
        });
        return collection;
    }

    private int characterCount(String str, char sub) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != sub) continue;
            ++count;
        }
        return count;
    }
}

