/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class UpgradeByCrossDatabaseService {
    private static final Log logger = LogFactory.getLog(UpgradeByCrossDatabaseService.class);
    private String tableStr = null;
    private String srcDBRoutKey = null;
    private String tarDBRoutKey = null;
    private String colunmFileds = null;

    private void updateTarDatabase(final String tableStr, String srcDBRoutKey, final String tarDBRoutKey, final String colunmFileds, boolean isBydiff) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tableStr) || StringUtils.isEmpty((CharSequence)srcDBRoutKey) || StringUtils.isEmpty((CharSequence)tarDBRoutKey) || StringUtils.isEmpty((CharSequence)colunmFileds)) {
            logger.info("\u8de8\u5e93\u8fc1\u79fb\u53c2\u6570\u9519\u8bef:" + tableStr + srcDBRoutKey + tarDBRoutKey + colunmFileds);
            return;
        }
        StringBuilder selectStrBf = new StringBuilder("select ").append(colunmFileds).append(" from ").append(tableStr);
        if (isBydiff) {
            String qFilterId = "FID";
            if (colunmFileds.contains("FPKID")) {
                qFilterId = "FPKID";
            }
            final String finalQFilterId = qFilterId;
            DB.query((DBRoute)DBRoute.of((String)srcDBRoutKey), (String)selectStrBf.toString(), (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        UpgradeByCrossDatabaseService.this.insertDataByDiff(tarDBRoutKey, tableStr, colunmFileds, resultSet, finalQFilterId);
                    }
                    return null;
                }
            });
        } else {
            if (!this.isNeedMove(tarDBRoutKey, tableStr, null)) {
                logger.info("\u76ee\u8868\u5e93\u5df2\u5b58\u5728\u8be5\u6570\u636e\u65e0\u9700\u8fc1\u79fb:" + tableStr + srcDBRoutKey + tarDBRoutKey + colunmFileds);
                return;
            }
            DB.query((DBRoute)DBRoute.of((String)srcDBRoutKey), (String)selectStrBf.toString(), (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        UpgradeByCrossDatabaseService.this.insertData(tarDBRoutKey, tableStr, colunmFileds, resultSet);
                    }
                    return null;
                }
            });
        }
    }

    private void insertData(String tarDBRoutKey, String tableStr, String colunmFileds, ResultSet resultSet) throws SQLException {
        String[] filed = colunmFileds.split(",");
        Object[] params = new Object[filed.length];
        StringBuilder insertStr = new StringBuilder("insert into ").append(tableStr).append(" (").append(colunmFileds).append(")  VALUES (");
        for (int i = 0; i < filed.length; ++i) {
            if (i > 0) {
                insertStr.append(",");
            }
            insertStr.append("?");
            params[i] = resultSet.getObject(filed[i].trim());
        }
        insertStr.append(")");
        DB.execute((DBRoute)DBRoute.of((String)tarDBRoutKey), (String)insertStr.toString(), (Object[])params);
    }

    private void insertDataByDiff(String tarDBRoutKey, String tableStr, String colunmFileds, ResultSet resultSet, String qFilterColunm) throws SQLException {
        StringBuilder selectStrBf = new StringBuilder("select ").append(colunmFileds).append(" from ").append(tableStr).append(" where ").append(qFilterColunm).append("=?");
        DataSet dataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)tarDBRoutKey), (String)selectStrBf.toString(), (Object[])new Object[]{resultSet.getObject(qFilterColunm)});
        if (dataSet.isEmpty()) {
            this.insertData(tarDBRoutKey, tableStr, colunmFileds, resultSet);
        }
    }

    public abstract void excute();

    protected void moveAllTableData() throws Exception {
        this.updateTarDatabase(this.tableStr, this.srcDBRoutKey, this.tarDBRoutKey, this.colunmFileds, false);
    }

    protected void moveDiffTableData() throws Exception {
        this.updateTarDatabase(this.tableStr, this.srcDBRoutKey, this.tarDBRoutKey, this.colunmFileds, true);
    }

    private boolean isNeedMove(String tarDBRoutKey, String tableStr, String filterStr) {
        StringBuilder selectStrBf = new StringBuilder("select 1 from ").append(tableStr);
        if (filterStr != null) {
            selectStrBf.append(filterStr);
        }
        DataSet dataSet = DB.queryDataSet((String)"upgradeData", (DBRoute)DBRoute.of((String)tarDBRoutKey), (String)selectStrBf.toString());
        return dataSet.isEmpty();
    }

    public String getTableStr() {
        return this.tableStr;
    }

    public void setTableStr(String tableStr) {
        this.tableStr = tableStr;
    }

    public String getSrcDBRoutKey() {
        return this.srcDBRoutKey;
    }

    public void setSrcDBRoutKey(String srcDBRoutKey) {
        this.srcDBRoutKey = srcDBRoutKey;
    }

    public String getTarDBRoutKey() {
        return this.tarDBRoutKey;
    }

    public void setTarDBRoutKey(String tarDBRoutKey) {
        this.tarDBRoutKey = tarDBRoutKey;
    }

    public String getColunmFileds() {
        return this.colunmFileds;
    }

    public void setColunmFileds(String colunmFileds) {
        this.colunmFileds = colunmFileds;
    }
}

