/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.bizrule.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.instance.AppGroup;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;

public class BizRuleConfigTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log LOG = LogFactory.getLog(BizRuleConfigTreeListPlugin.class);
    private static final String APP_PREFIX = "app_";
    private static final String CLOUD_PREFIX = "cloud_";
    private static final String TYPE = "type";
    private List<AppInfo> grayAppInfoList = null;

    public void initialize() {
        super.initialize();
        this.setTreeBarVisible(false);
        ((ListView)this.getView()).setNeedRefreshTree(true);
    }

    public void initializeTree(EventObject e) {
        this.initTree();
        this.setTreeBarVisible(false);
    }

    private TreeNode initTree() {
        List<TreeNode> cloudNodes = this.getCloudNodes();
        TreeNode root = new TreeNode();
        root.setId("root");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BizRuleConfigTreeListPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        return root;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter filter = this.getFilter(nodeId);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String currentNodeId = e.getNodeId().toString();
        TreeNode root = this.initTree();
        this.getTreeListView().getTreeView().addNode(root);
        TreeNode treeNode = root.getTreeNode(currentNodeId);
        if (treeNode == null) {
            return;
        }
        e.setChildNodes(treeNode.getChildren());
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains(CLOUD_PREFIX) || currentNodeId.contains(APP_PREFIX) || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam("groupNumber", (Object)currentNodeId);
    }

    private List<TreeNode> getCloudNodes() {
        HashSet<String> bizAppIds = new HashSet<String>();
        HashMap<String, List> bizappMap = new HashMap<String, List>();
        Set<String> entityNumberset = this.getEntityNumbers();
        HashSet<String> bizCloudIds = new HashSet<String>();
        for (String entityNumber : entityNumberset) {
            try {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                String appNumber = dataEntityType.getAppId();
                AppInfo appInfo = EntityMetadataCache.getProvider().getAppInfo(appNumber);
                String appId = appInfo.getId();
                bizAppIds.add(appId);
                bizCloudIds.add(appInfo.getCloudId());
                HashMap<String, String> entityDataMap = new HashMap<String, String>();
                entityDataMap.put("name", dataEntityType.getDisplayName().getLocaleValue());
                entityDataMap.put("number", entityNumber);
                List configTreeList = bizappMap.getOrDefault(appId, new ArrayList());
                configTreeList.add(entityDataMap);
                bizappMap.put(appId, configTreeList);
            }
            catch (Exception e) {
                LOG.error("EntityMetadataCache.getDataEntityType.entityNumber={} error", (Object)entityNumber, (Object)e);
            }
        }
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])bizCloudIds.toArray(new String[0]), (String[])bizAppIds.toArray(new String[0]), null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String cloudId = appInfo.getCloudId();
                String appId = appInfo.getId();
                TreeNode cloudNode = root.getTreeNode(cloudId, 5);
                TreeNode appNode = root.getTreeNode(appId, 5);
                if (cloudNode == null || appNode != null) continue;
                ArrayList<TreeNode> appTreeNodes = cloudNode.getChildren();
                if (appTreeNodes == null) {
                    appTreeNodes = new ArrayList<TreeNode>(10);
                    cloudNode.setChildren(appTreeNodes);
                }
                appTreeNodes.add(new TreeNode(cloudId, appId, appInfo.getName().toString()));
            }
        }
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>();
        HashMap<String, String> appNumIndex = new HashMap<String, String>();
        this.getOriginExtendAppRelMap(originExtendAppRelMap, appNumIndex);
        Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
        LOG.info("Cloud is diabled : {}, Appid is diabled : {}, needAdminAppRange : {}, rangeApp size : {}", new Object[]{disabledCloudIds, disabledAppIds, adminAppResult.needAdminAppRange(), adminAppResult.getAppIds() == null ? "null" : Integer.valueOf(adminAppResult.getAppIds().size())});
        if (LOG.isDebugEnabled()) {
            LOG.debug("rangeAppIds:{}", (Object)(adminAppResult.getAppIds() == null ? "null" : String.join((CharSequence)",", adminAppResult.getAppIds())));
        }
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            HashMap<String, String> cloudData = new HashMap<String, String>();
            cloudData.put(TYPE, "cloud");
            String cloudId = cloud.getId();
            String cloudNodeId = CLOUD_PREFIX + cloudId;
            cloud.setId(cloudNodeId);
            cloud.setData(cloudData);
            List apps = cloud.getChildren();
            if (apps == null || disabledCloudIds.contains(cloudId)) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                boolean adminNotCharge;
                TreeNode app = (TreeNode)appIterator.next();
                HashMap<String, String> appData = new HashMap<String, String>();
                appData.put(TYPE, "app");
                String appId = app.getId();
                String appNodeId = APP_PREFIX + appId;
                boolean bl = adminNotCharge = adminAppResult.needAdminAppRange() && (adminAppResult.getAppIds() == null || !adminAppResult.getAppIds().contains(appId));
                if (disabledAppIds.contains(appId) || adminNotCharge) {
                    appIterator.remove();
                    continue;
                }
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData(appData);
                app.setChildren(this.buildBizEntityNode(app, (List)bizappMap.get(appId)));
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private Set<String> getEntityNumbers() {
        HashSet<String> entityIds = new HashSet<String>();
        String entityNumber = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String sql = "";
        if ("gbs_bizrule".equals(entityNumber)) {
            sql = "select distinct fentity from t_gbs_bizrule";
        } else if ("gbs_bizrulelibrary".equals(entityNumber)) {
            sql = "select distinct fentity from t_gbs_bizrulelibrary";
        } else {
            return entityIds;
        }
        return (Set)DB.query((DBRoute)new DBRoute("sys"), (String)sql, rs -> {
            while (rs.next()) {
                String number = rs.getString("fentity");
                entityIds.add(number);
            }
            return entityIds;
        });
    }

    private List<TreeNode> buildBizEntityNode(TreeNode app, List<Map<String, String>> entityDyList) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(entityDyList.size());
        entityDyList.forEach(entityMap -> {
            TreeNode treeNode = new TreeNode(app.getId(), (String)entityMap.get("number"), (String)entityMap.get("name"));
            HashMap<String, String> bizenityData = new HashMap<String, String>();
            bizenityData.put(TYPE, "bizenity");
            treeNode.setData(bizenityData);
            nodes.add(treeNode);
        });
        return nodes;
    }

    private List<AppInfo> getGrayAppInfos() {
        if (this.grayAppInfoList != null) {
            return this.grayAppInfoList;
        }
        this.grayAppInfoList = new ArrayList<AppInfo>(10);
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        if (AppGroup.isGrayUpgrade()) {
            List appInfoStrList = metadataService.loadGrayAppInfoList();
            for (String infoStr : appInfoStrList) {
                if (StringUtils.isBlank((CharSequence)infoStr)) continue;
                AppInfo appInfo = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
                this.grayAppInfoList.add(appInfo);
            }
        }
        return this.grayAppInfoList;
    }

    private Map<String, String> getOriginExtendAppRelMap(Map<String, String> originExtendAppRelMap, Map<String, String> appNumIndex) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allApps) {
            String type = app.getString(TYPE);
            String number = app.getString("number");
            String appId = app.getString("id");
            String nodeId = APP_PREFIX + appId;
            if ("0".equals(type)) {
                originExtendAppRelMap.put(nodeId, nodeId);
                appNumIndex.put(number, appId);
                continue;
            }
            String masterId = app.getString("masterid");
            String masterNodeId = APP_PREFIX + masterId;
            originExtendAppRelMap.put(nodeId, masterNodeId);
            appNumIndex.put(number, masterId);
        }
        if (AppGroup.isGrayUpgrade()) {
            List<AppInfo> appInfoList = this.getGrayAppInfos();
            for (AppInfo appInfo : appInfoList) {
                String nodeId = APP_PREFIX + appInfo.getId();
                originExtendAppRelMap.put(nodeId, nodeId);
                appNumIndex.put(appInfo.getAppId(), appInfo.getId());
            }
        }
        return originExtendAppRelMap;
    }

    private QFilter getFilter(String nodeId) {
        if (this.isTopNode(nodeId)) {
            return null;
        }
        if (nodeId.contains(CLOUD_PREFIX)) {
            return new QFilter("entity.bizappid.bizcloud.id", "=", (Object)nodeId.substring(nodeId.indexOf("_") + 1));
        }
        if (nodeId.contains(APP_PREFIX)) {
            return new QFilter("entity.bizappid.id", "=", (Object)nodeId.substring(nodeId.indexOf("_") + 1));
        }
        return new QFilter("entity.number", "=", (Object)nodeId);
    }

    private boolean isTopNode(String currNodeId) {
        String rootId = this.getTreeModel().getRoot().getId();
        return StringUtils.equals((CharSequence)rootId, (CharSequence)currNodeId);
    }

    private void setTreeBarVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null && result.isSuccess() && "delete".equals(operateKey)) {
            ITreeListView treeListView = ((ListView)this.getView()).getTreeListView();
            TreeNode root = treeListView.getTreeModel().getRoot();
            treeListView.getTreeModel().refreshNode((Object)root.getId());
            treeListView.refreshTreeNode(root.getId());
        }
    }
}

