/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.bizrule.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BizRuleLibraryEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Map<String, Set<String>> LEVEL_MAP = new HashMap<String, Set<String>>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entityEdit = (BasedataEdit)this.getView().getControl("entity");
        entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String entityNumber = dataEntity.getString("entity.number");
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return;
        }
        this.checkRefByEntity(entityNumber);
        ComboEdit keyFieldEdit = (ComboEdit)this.getControl("fieldshow");
        keyFieldEdit.setComboItems(this.initComboFieldVal(entityNumber, this.getModel().getDataEntity().getString("validatetype")));
        this.getModel().setValue("fieldshow", this.getModel().getValue("field"));
        String validateType = (String)this.getModel().getValue("validatetype");
        this.setMustInputOfField(validateType, keyFieldEdit);
        this.setShowFieldNoChanged("fieldshow");
    }

    private void checkRefByEntity(String entityNumber) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return;
        }
        Object iscopy = customParams.get("iscopy");
        Boolean isCopyFrom = Boolean.FALSE;
        if (Objects.nonNull(iscopy)) {
            isCopyFrom = (Boolean)iscopy;
        }
        if (QueryServiceHelper.exists((String)"gbs_bizrule", (QFilter[])new QFilter[]{new QFilter("entity.number", "=", (Object)entityNumber)}) && !isCopyFrom.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entity"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"entity") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"validatetype")) {
            this.initFieldVal();
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"level0")) {
            this.getModel().setValue("level", this.getModel().getValue("level0"));
        } else if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"level1")) {
            this.getModel().setValue("level", this.getModel().getValue("level1"));
        }
    }

    private void initFieldVal() {
        if (this.getModel().getDataEntity() == null) {
            return;
        }
        String validateType = (String)this.getModel().getValue("validatetype");
        ComboEdit keyFieldEdit = (ComboEdit)this.getControl("fieldshow");
        this.setMustInputOfField(validateType, keyFieldEdit);
        this.getModel().setValue("fieldshow", null);
        DynamicObject obj = (DynamicObject)this.getModel().getValue("entity");
        if (obj == null) {
            return;
        }
        keyFieldEdit.setComboItems(this.initComboFieldVal(obj.getString("number"), validateType));
    }

    private List<ComboItem> initComboFieldVal(String entityNumber, String validateType) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        if (StringUtils.isEmpty((CharSequence)validateType)) {
            return comboItemList;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = mainEntityType.getAllFields();
        this.addCombo(allFields, comboItemList, validateType);
        return comboItemList;
    }

    private void addCombo(Map<String, IDataEntityProperty> allFields, List<ComboItem> comboItemList, String validateType) {
        if (allFields == null) {
            return;
        }
        allFields.forEach((num, pro) -> {
            if ("1".equals(validateType) && !(pro instanceof TextProp)) {
                return;
            }
            if ("0".equals(validateType) && (pro instanceof FieldProp && ((FieldProp)pro).isMustInput() || pro instanceof BasedataProp && ((BasedataProp)pro).isMustInput())) {
                return;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(new StringBuffer(pro.getDisplayName() != null ? pro.getDisplayName().getLocaleValue() : "").append("(").append(pro.getName()).append(")").toString()));
            comboItem.setValue(num);
            comboItemList.add(comboItem);
        });
    }

    private void setMustInputOfField(String validateType, ComboEdit keyFieldEdit) {
        if ("0".equals(validateType) || "1".equals(validateType)) {
            if ("0".equals(validateType)) {
                this.setLevelField("level0");
            } else {
                this.setLevelField("level1");
            }
            keyFieldEdit.setMustInput(true);
        } else {
            keyFieldEdit.setMustInput(false);
        }
    }

    private void setLevelField(String levelField) {
        ComboEdit levelEdit = (ComboEdit)this.getControl(levelField);
        levelEdit.setMustInput(true);
        if (this.getModel().getValue("level") != null && LEVEL_MAP.containsKey(levelField) && LEVEL_MAP.get(levelField).contains(this.getModel().getValue("level"))) {
            this.getModel().setValue(levelField, this.getModel().getValue("level"));
        } else {
            this.getModel().setValue(levelField, null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setShowFieldNoChanged("field", "level1", "level0");
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView) {
            ITreeListView treeListView = ((ListView)parentView).getTreeListView();
            TreeNode root = treeListView.getTreeModel().getRoot();
            treeListView.getTreeModel().refreshNode((Object)root.getId());
            treeListView.refreshTreeNode(root.getId());
        }
    }

    private void setShowFieldNoChanged(String ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        DataEntityState entityState = this.getModel().getDataEntity().getDataEntityState();
        DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
        Arrays.stream(fields).forEach(field -> entityState.setBizChanged(((IDataEntityProperty)props.get(field)).getOrdinal(), Boolean.FALSE.booleanValue()));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("entity".equals(key)) {
            DataSet dataSet = DB.queryDataSet((String)"InterQueryMeta", (DBRoute)DBRoute.of((String)"sys.meta"), (String)"select fnumber from t_meta_entitydesign where fmasterid != ' '");
            ArrayList<String> numberList = new ArrayList<String>(10);
            while (dataSet.hasNext()) {
                numberList.add(dataSet.next().getString("fnumber"));
            }
            if (numberList.size() > 0) {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("number", "not in", numberList));
            }
        }
    }

    static {
        HashSet<String> mustInputSet = new HashSet<String>(16);
        mustInputSet.add("0");
        mustInputSet.add("2");
        HashSet<String> formatSet = new HashSet<String>(16);
        formatSet.add("0");
        formatSet.add("1");
        formatSet.add("2");
        LEVEL_MAP.put("level0", mustInputSet);
        LEVEL_MAP.put("level1", formatSet);
    }
}

