/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.common.pagemodel;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;

public class ClassTreeSearchParam {
    public static final String CACHE_KEY_SEARCH_NODES = "_searchNodes";
    public static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText";
    public static final String CACHE_KEY_OLD_VIEW_SCHEMA = "_oldSearchViewSchema";
    public static final String CACHE_KEY_PARENTID = "_parentIdCacheKey";
    public static final String CACHE_KEY_RESULT_TOTAL = "_resultTotalCacheKey";
    private String searchText;
    private IFormView formView;
    private TreeView treeView;
    private String rootNodeCacheKey;
    private long standardId;
    private boolean clickNode;
    private IPageCache pageCache;

    public ClassTreeSearchParam(String searchText, IFormView formView, TreeView treeView, String rootNodeCacheKey, long standardId) {
        this.searchText = searchText;
        this.formView = formView;
        this.treeView = treeView;
        this.rootNodeCacheKey = rootNodeCacheKey;
        this.pageCache = formView.getPageCache();
        this.standardId = standardId;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public void setTreeView(TreeView treeView) {
        this.treeView = treeView;
    }

    public String getRootNodeCacheKey() {
        return this.rootNodeCacheKey;
    }

    public void setRootNodeCacheKey(String rootNodeCacheKey) {
        this.rootNodeCacheKey = rootNodeCacheKey;
    }

    public TreeNode getRootNode() {
        if (StringUtils.isBlank((CharSequence)this.rootNodeCacheKey)) {
            return null;
        }
        String rootNodeCache = this.getPageCache().get(this.rootNodeCacheKey);
        if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
        }
        return null;
    }

    public long getStandardId() {
        return this.standardId;
    }

    public void setStandardId(long standardId) {
        this.standardId = standardId;
    }

    public boolean isClickNode() {
        return this.clickNode;
    }

    public void setClickNode(boolean clickNode) {
        this.clickNode = clickNode;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }
}

