/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import kd.bd.master.helper.BatchUpdFieldHelper;
import kd.bd.master.helper.GroupstandardQueryHelper;
import kd.bd.master.helper.MaterialUnitQueryHelper;
import kd.bd.master.list.MasterDataListBaseFormPlugin;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialDataListPlugin
extends MasterDataListBaseFormPlugin {
    private static final Log log = LogFactory.getLog(MaterialDataListPlugin.class);
    private MaterialUnitQueryHelper materialUnitQueryHelper = new MaterialUnitQueryHelper();
    private GroupstandardQueryHelper groupstandardQueryHelper = new GroupstandardQueryHelper();
    public static final String BTN_BATCHMATERIAL = "btn_batchmaterial";
    public static final String OP_BATCHMATERIAL = "batchmaterial";

    @Override
    protected String getType() {
        return "bd_material";
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("buildbizinfo".equals(operateKey)) {
            String bizOrg = this.getPageCache().get("createOrg");
            operate.getOption().setVariableValue("createOrg", bizOrg);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "btn_batchgroup": {
                this.addGroup(rows, entity);
                break;
            }
        }
    }

    private void batchMaterial() {
        ListShowParameter lsp = FormShowParameterUtil.getListShowParameter((String)"bd_applicationmaterials", (String)"bos_list", (ShowType)ShowType.MainNewTabPage, (String)"_toolbar_");
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void addGroup(ListSelectedRowCollection rows, String entity) {
        if (rows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MaterialDataListPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        HashSet<Long> ids = new HashSet<Long>();
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        Map dataFromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet<Long> createorgs = new HashSet<Long>(dataFromCache.size());
        for (DynamicObject data : dataFromCache.values()) {
            Long createorgId = GroupStandardUtils.getDataByType((Object)data.get("createorg"));
            createorgs.add(createorgId);
        }
        if (createorgs.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\u3002", (String)"MaterialDataListPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        String useOrg = this.getPageCache().get("createOrg");
        String appNumber = this.getView().getFormShowParameter().getAppId();
        if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)Long.parseLong(useOrg), (String)appNumber, (String)"bd_material", (String)"4715a0df000000ac") == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"BASEDATA-E-034051", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put("entity", entity);
        params.put("dataIds", ids);
        params.put("createOrg", useOrg);
        params.put("standard", this.getModel().getValue("cmbstandardlst"));
        this.showDynamicForm("bd_grouptree", params, null, ShowType.Modal);
    }

    private void showDynamicForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(showType);
        fsp.setFormId(formId);
        fsp.setCaption(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"MaterialDataListPlugin_5", (String)"bd-master-formplugin", (Object[])new Object[0]));
        if (params != null) {
            fsp.setCustomParams(params);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackId = closedCallBackEvent.getActionId();
        if ("permChangeCallBack".equals(callBackId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        boolean hasUnitKey;
        super.afterQueryOfExport(e);
        DynamicObject[] queryValues = e.getQueryValues();
        ArrayList<DynamicObject> materials = new ArrayList<DynamicObject>(queryValues.length);
        DynamicObjectType materialType = null;
        HashSet<Long> materialIds = new HashSet<Long>(queryValues.length);
        DynamicObjectType groupstandardType = null;
        DynamicObjectType measureunitType = null;
        for (DynamicObject row : queryValues) {
            materialIds.add(row.getLong("id"));
            if (materialType == null) {
                materialType = row.getDynamicObjectType();
            }
            if (groupstandardType == null && materialType.getProperty("entry_groupstandard") != null) {
                DynamicObjectCollection dynamicObjectCollection = row.getDynamicObjectCollection("entry_groupstandard");
                groupstandardType = dynamicObjectCollection.getDynamicObjectType();
            }
            if (measureunitType != null || materialType.getProperty("entryentity") == null) continue;
            DynamicObjectCollection measureunitCollections = row.getDynamicObjectCollection("entryentity");
            measureunitType = measureunitCollections.getDynamicObjectType();
        }
        boolean hasGroupKey = materialType != null && materialType.getProperties().containsKey((Object)"entry_groupstandard");
        boolean bl = hasUnitKey = materialType != null && materialType.getProperties().containsKey((Object)"entryentity");
        if (materialType == null || !hasGroupKey && !hasUnitKey) {
            return;
        }
        if (hasGroupKey) {
            this.groupstandardQueryHelper.getGroupStand("bd_material", queryValues, materialType, groupstandardType, materialIds);
        }
        if (hasUnitKey) {
            this.materialUnitQueryHelper.getMaterialUnit("bd_material", queryValues, materialType, measureunitType, materialIds);
        }
        for (DynamicObject dynamicObject : queryValues) {
            this.groupstandardQueryHelper.setExportGroupStand(materialType, dynamicObject);
            this.materialUnitQueryHelper.setExportMaterialUnit(materialType, measureunitType, dynamicObject);
            if (materialType != null && materialType.getProperty("configproperties") != null && "1".equals(dynamicObject.getString("configproperties"))) {
                dynamicObject.set("configproperties", (Object)" ");
            }
            materials.add(dynamicObject);
        }
        e.setQueryValues(materials.toArray(new DynamicObject[0]));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate oper = (FormOperate)afterDoOperationEventArgs.getSource();
        ListSelectedRowCollection rows = oper.getListSelectedData();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        if (afterDoOperationEventArgs.getOperateKey().equals("batchupdate") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            try (TraceSpan span = Tracer.create((String)"MaterialDataListPlugin", (String)"afterDoOperation:BatchUpdFieldHelper.showBatchUpdForm");){
                log.info("open BatchUpdForm, entity number: " + entity + ", selected record num: " + rows.size());
                BatchUpdFieldHelper.showBatchUpdForm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (String)entity, (ListSelectedRowCollection)rows);
            }
        } else if (afterDoOperationEventArgs.getOperateKey().equals(OP_BATCHMATERIAL) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.batchMaterial();
        }
    }
}

