/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.helper.BatchUpdFieldHelper;
import kd.bd.master.helper.BizpartnerHelper;
import kd.bd.master.helper.GroupstandardQueryHelper;
import kd.bd.master.list.MasterDataListBaseFormPlugin;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.sdk.annotation.SdkDeprecated;
import kd.sdk.bd.basedata.service.SuppChangeBizpartnerService;

@SdkDeprecated
public class SupplierDataListPlugin
extends MasterDataListBaseFormPlugin
implements SuppChangeBizpartnerService {
    private static final Log log = LogFactory.getLog(SupplierDataListPlugin.class);
    private static final String IMPORTDATAGROUP = "importdatagroup";
    private GroupstandardQueryHelper groupstandardQueryHelper = new GroupstandardQueryHelper();
    private BizpartnerHelper bizpartnerHelper = new BizpartnerHelper();
    private static final String SYS_BASEDATA_UPDATEBIZPARTNRT_CHECK = "SYS_BASEDATA_UPDATEBIZPARTNRT_CHECK";

    @Override
    protected String getType() {
        return "bd_supplier";
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        String entity = "bd_supplier";
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "btn_batchgroup": {
                this.addGroup(rows, entity);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate oper = (FormOperate)afterDoOperationEventArgs.getSource();
        ListSelectedRowCollection rows = oper.getListSelectedData();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        if ("changebizpartner".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            log.info("open changeBizPartner, selected record num: " + rows.size());
            this.changeBizPartner(rows);
        } else if (afterDoOperationEventArgs.getOperateKey().equals("batchupdate") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            try (TraceSpan span = Tracer.create((String)"SupplierDataListPlugin", (String)"afterDoOperation:BatchUpdFieldHelper.showBatchUpdForm");){
                log.info("open BatchUpdForm, entity number: " + entity + ", selected record num: " + rows.size());
                BatchUpdFieldHelper.showBatchUpdForm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (String)entity, (ListSelectedRowCollection)rows);
            }
        } else if (afterDoOperationEventArgs.getOperateKey().equals(IMPORTDATAGROUP) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.showGroup();
        }
    }

    private void showGroup() {
        FormShowParameter paramGroups = new FormShowParameter();
        paramGroups.getOpenStyle().setShowType(ShowType.Modal);
        paramGroups.setFormId("bos_importstart");
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("BillFormId", "bd_suppliergroup");
        paramGroups.setCustomParams(customParam);
        this.getView().showForm(paramGroups);
    }

    private void addGroup(ListSelectedRowCollection rows, String entity) {
        if (rows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SupplierDataListPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        Map dataFromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet<Long> createorgs = new HashSet<Long>(dataFromCache.size());
        for (DynamicObject data : dataFromCache.values()) {
            Long createorgId = GroupStandardUtils.getDataByType((Object)data.get("createorg"));
            createorgs.add(createorgId);
        }
        if (createorgs.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\u3002", (String)"SupplierDataListPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        String appNumber = this.getView().getFormShowParameter().getAppId();
        if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)Long.parseLong(this.getPageCache().get("createOrg")), (String)appNumber, (String)"bd_supplier", (String)"4715a0df000000ac") == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"BASEDATA-E-243838", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entity", entity);
        params.put("dataIds", ids);
        params.put("createOrg", this.getPageCache().get("createOrg"));
        params.put("standard", this.getModel().getValue("cmbstandardlst"));
        this.getView().showForm(FormShowParameterUtil.getDynamicForm((String)"bd_grouptree", params, null, (ShowType)ShowType.Modal, (String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5206\u7c7b", (String)"SupplierDataListPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0])));
    }

    private void changeBizPartner(ListSelectedRowCollection rows) {
        if (rows.size() <= 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        Map dataFromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashSet<Long> createorgs = new HashSet<Long>(dataFromCache.size());
        for (DynamicObject data : dataFromCache.values()) {
            Long createorgId = GroupStandardUtils.getDataByType((Object)data.get("createorg"));
            createorgs.add(createorgId);
        }
        if (createorgs.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\u3002", (String)"SupplierDataListPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        String useOrg = this.getPageCache().get("createOrg");
        if (!createorgs.contains(Long.valueOf(useOrg))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u548c\u4e1a\u52a1\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\u3002", (String)"SupplierDataListPlugin_4", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showForm((FormShowParameter)FormShowParameterUtil.getListShowParameterCcb((String)"bd_bizpartner", (String)"bos_listf7", (ShowType)ShowType.Modal, (String)"_toolbar_", (CloseCallBack)new CloseCallBack((IFormPlugin)this, "bd_bizpartner")));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("bd_bizpartner".equals(closedCallBackEvent.getActionId())) {
            BillList billList;
            ListSelectedRowCollection rows;
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (listSelectedRowCollection == null) {
                return;
            }
            ListSelectedRow id = listSelectedRowCollection.get(0);
            if (id != null && !id.getPrimaryKeyValue().equals(0L) && (rows = (billList = (BillList)this.getView().getControl("billlistap")).getSelectedRows()).size() > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(rows.size());
                for (ListSelectedRow row : rows) {
                    ids.add(Long.valueOf(row.toString()));
                }
                DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (suppliers != null && suppliers.length > 0) {
                    HashMap<Long, Long> map = new HashMap<Long, Long>(suppliers.length);
                    for (DynamicObject sup : suppliers) {
                        DynamicObject bizpartner = sup.getDynamicObject("bizpartner");
                        if (bizpartner != null) {
                            map.put(sup.getLong("id"), bizpartner.getLong("id"));
                            continue;
                        }
                        map.put(sup.getLong("id"), 0L);
                    }
                    PluginProxy pluginProxy = PluginProxy.create(null, SuppChangeBizpartnerService.class, (String)SYS_BASEDATA_UPDATEBIZPARTNRT_CHECK);
                    List list = pluginProxy.getPlugins();
                    Set changeSuppliers = null;
                    changeSuppliers = list == null || list.size() == 0 ? this.checkSrmDataReference(map) : ((SuppChangeBizpartnerService)list.get(0)).checkSrmDataReference(map);
                    if (changeSuppliers == null || changeSuppliers.size() == 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5168\u90e8\u5546\u52a1\u4f19\u4f34\u4fee\u6539\u5931\u8d25\uff0c\u539f\u5546\u52a1\u4f19\u4f34\u88ab\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u5f15\u7528\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b\u8bf7\u8054\u7cfbIT\u8fd0\u7ef4\u4eba\u5458\u4f7f\u7528\u5de5\u5177\u4fee\u590d\u6570\u636e\u540e\u518d\u4fee\u6539\uff1b\u5de5\u5177\u8def\u5f84\uff1a\u5f00\u53d1\u670d\u52a1\u4e91>\u5f00\u53d1\u5e73\u53f0>\u4f9b\u5e94\u5546\u534f\u540c\u4e91>\u57fa\u7840\u8d44\u6599>\u4fee\u590d\u5de5\u5177>\u5546\u52a1\u4f19\u4f34\u68c0\u67e5\u53ca\u4fee\u590d\u3002", (String)"SupplierDataListPlugin_7", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    try {
                        this.bizpartnerHelper.updateSupplierBizPartner(changeSuppliers.stream().collect(Collectors.toList()), Long.valueOf(id.toString()));
                        if (rows.size() != changeSuppliers.size()) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u52a1\u4f19\u4f34\u4fee\u6539\u5931\u8d25\uff0c\u539f\u5546\u52a1\u4f19\u4f34\u88ab\u4f9b\u5e94\u5546\u534f\u540c\u4e91\u5f15\u7528\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b\u8bf7\u8054\u7cfbIT\u8fd0\u7ef4\u4eba\u5458\u4f7f\u7528\u5de5\u5177\u4fee\u590d\u6570\u636e\u540e\u518d\u4fee\u6539\uff1b\u5de5\u5177\u8def\u5f84\uff1a\u5f00\u53d1\u670d\u52a1\u4e91>\u5f00\u53d1\u5e73\u53f0>\u4f9b\u5e94\u5546\u534f\u540c\u4e91>\u57fa\u7840\u8d44\u6599>\u4fee\u590d\u5de5\u5177>\u5546\u52a1\u4f19\u4f34\u68c0\u67e5\u53ca\u4fee\u590d\u3002", (String)"SupplierDataListPlugin_8", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fee\u6539\u5546\u52a1\u4f19\u4f34\u6210\u529f\u3002", (String)"SupplierDataListPlugin_6", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        this.getView().showErrorNotification(e.getMessage());
                    }
                }
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryValues = e.getQueryValues();
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(queryValues.length);
        HashSet<Long> ids = new HashSet<Long>(queryValues.length);
        DynamicObjectType dynamicObjectType = null;
        DynamicObjectType groupstandardType = null;
        for (DynamicObject row : queryValues) {
            ids.add(row.getLong("id"));
            if (dynamicObjectType == null) {
                dynamicObjectType = row.getDynamicObjectType();
            }
            if (groupstandardType != null || dynamicObjectType.getProperty("entry_groupstandard") == null) continue;
            groupstandardType = row.getDynamicObjectCollection("entry_groupstandard").getDynamicObjectType();
        }
        if (dynamicObjectType == null || !dynamicObjectType.getProperties().containsKey((Object)"entry_groupstandard")) {
            return;
        }
        this.groupstandardQueryHelper.getGroupStand("bd_supplier", queryValues, dynamicObjectType, groupstandardType, ids);
        for (DynamicObject supplier : queryValues) {
            this.groupstandardQueryHelper.setExportGroupStand(dynamicObjectType, supplier);
            datas.add(supplier);
        }
        e.setQueryValues(datas.toArray(new DynamicObject[0]));
    }
}

