/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.business.pojo.LotCodeRuleEntryInfo;
import kd.bd.sbd.business.pojo.LotCodeRuleInfo;
import kd.bd.sbd.enums.LotCodeFormatEnum;
import kd.bd.sbd.enums.LotCodeItemTypeEnum;
import kd.bd.sbd.enums.UseModeEnum;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.entity.BasedataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class TrackNumberProcessor {
    private static final Log log = LogFactory.getLog(TrackNumberProcessor.class);
    private static final String BILLS = "bills";
    private static final String BILL_NUMBER = "billNumber";
    private static final String BILL_TYPE = "billType";
    private static final String ENTITYNAME = "entityName";
    private static final String ENTRYNAME = "entryName";
    private static final String RULE = "rule";
    private static final String COL_MATERIAL = "materialColName";
    private static final String COL_SEQ = "seqColName";
    private static final String COL_TRACKNUMBER = "tracknumberColName";
    private static final String COL_REQUIRETYPE = "requiretypeColName";
    private String entryEntityKey = "";
    private String materialKey = "";
    public static final String ASSIGN_ENTITY = "bd_manustrassign";

    public Map<String, Object> autoGenerateTrackNumber(Map params) throws KDException {
        HashMap<String, Object> returnSN = new HashMap<String, Object>();
        if (params == null || params.get(ENTITYNAME) == null || params.get(ENTRYNAME) == null || params.get(COL_TRACKNUMBER) == null || params.get(COL_MATERIAL) == null || params.get(BILLS) == null) {
            return null;
        }
        String entryName = params.get(ENTRYNAME).toString();
        boolean isEntry = StringUtils.isNotEmpty((String)entryName);
        String seqColName = params.get(COL_SEQ).toString();
        String materialColName = params.get(COL_MATERIAL).toString();
        String[] materialCols = materialColName.split("\\.");
        String tracknumberColName = params.get(COL_TRACKNUMBER).toString();
        String[] tracknumberCols = tracknumberColName.split("\\.");
        String requiretypeColName = params.get(COL_REQUIRETYPE).toString();
        String[] requiretypeCols = requiretypeColName.split("\\.");
        String billNumber = params.get(BILL_NUMBER).toString();
        DynamicObject billType = (DynamicObject)params.get(BILL_TYPE);
        DynamicObject[] objects = (DynamicObject[])params.get(BILLS);
        DynamicObject rule = (DynamicObject)params.get(RULE);
        if (rule == null) {
            rule = this.getRule();
        }
        if (rule == null) {
            return null;
        }
        HashSet<String> setTrackNumbers = new HashSet<String>(16);
        HashSet<String> setOrderTrackNumbers = new HashSet<String>(16);
        DynamicObject dataEntity = null;
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        for (DynamicObject object : objects) {
            ArrayList<DynamicObject> updateTrackNumbers;
            ArrayList<DynamicObject> updateTN;
            ArrayList<DynamicObject> addTN;
            DynamicObject master;
            block29: {
                DynamicObject entry;
                Map results;
                Long requiretypeId;
                HashMap<Object, DynamicObject> mapByNumber;
                HashMap<Object, DynamicObject> mapByEntryId;
                DynamicObjectCollection billEntry;
                block28: {
                    Iterator track;
                    block30: {
                        setTrackNumbers.clear();
                        setOrderTrackNumbers.clear();
                        param.clear();
                        dataEntity = object;
                        billEntry = isEntry ? dataEntity.getDynamicObjectCollection(entryName) : null;
                        QFilter[] filters = new QFilter[]{new QFilter("sourcebillid", "=", (Object)dataEntity.getPkValue().toString())};
                        DynamicObject[] trackNumbers = BusinessDataServiceHelper.load((String)"bd_tracknumber", (String)"id,number,name,createorg,sourcebilltype,sourcebillid,sourcebillno,sourcebillentryid,sourcebillentryseq,trackstatus,enable", (QFilter[])filters);
                        mapByEntryId = new HashMap<Object, DynamicObject>(trackNumbers.length);
                        mapByNumber = new HashMap<Object, DynamicObject>(trackNumbers.length);
                        if (trackNumbers.length > 0) {
                            for (DynamicObject dynamicObject : trackNumbers) {
                                mapByEntryId.put(dynamicObject.get("sourcebillentryid"), dynamicObject);
                                mapByNumber.put(dynamicObject.get("number"), dynamicObject);
                                setTrackNumbers.add(dynamicObject.get("sourcebillentryid").toString());
                            }
                        }
                        if (isEntry && (billEntry == null || billEntry.isEmpty())) {
                            this.deleteTrackNumber(new ArrayList<String>(setTrackNumbers));
                            continue;
                        }
                        master = materialCols.length == 1 ? this.getMaterialBaseInfo(dataEntity.getDynamicObject(materialCols[0])) : null;
                        requiretypeId = requiretypeCols.length == 1 ? this.getDataId(dataEntity.get(requiretypeCols[0])) : 0L;
                        HashSet<Long> requiretypeIds = new HashSet<Long>(16);
                        if (!isEntry && requiretypeId > 0L) {
                            requiretypeIds.add(requiretypeId);
                        } else {
                            if (!isEntry) continue;
                            for (DynamicObject entry2 : billEntry) {
                                if (entry2.getPkValue() == null) continue;
                                if (requiretypeCols.length > 1) {
                                    requiretypeId = this.getDataId(entry2.get(requiretypeCols[1]));
                                }
                                if (requiretypeId == 0L) continue;
                                requiretypeIds.add(requiretypeId);
                            }
                        }
                        QFilter qFilter = new QFilter("id", "in", requiretypeIds);
                        results = BusinessDataServiceHelper.loadFromCache((String)"bd_requiretype", (String)"traceway", (QFilter[])new QFilter[]{qFilter});
                        Iterator iterator = results.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry3 = iterator.next();
                            DynamicObject value = (DynamicObject)entry3.getValue();
                            if (requiretypeId == 0L) continue;
                            if (value.get("traceway") == null || ((DynamicObjectCollection)value.get("traceway")).size() < 1) {
                                iterator.remove();
                                continue;
                            }
                            DynamicObjectCollection traceways = (DynamicObjectCollection)value.get("traceway");
                            boolean isMTO = false;
                            for (DynamicObject traceway : traceways) {
                                if (!traceway.get("fbasedataid.number").equals("GZ001")) continue;
                                isMTO = true;
                                break;
                            }
                            if (isMTO) continue;
                            iterator.remove();
                        }
                        addTN = new ArrayList<DynamicObject>(16);
                        updateTN = new ArrayList<DynamicObject>(16);
                        updateTrackNumbers = new ArrayList<DynamicObject>(16);
                        entry = null;
                        if (isEntry) break block28;
                        if (results.get(requiretypeId) == null) break block29;
                        track = dataEntity.getDynamicObject(tracknumberCols[0]);
                        setOrderTrackNumbers.add(dataEntity.getPkValue().toString());
                        if (mapByEntryId.get(dataEntity.getPkValue().toString()) != null || track != null) break block30;
                        addTN.add(entry);
                        break block29;
                    }
                    if (track == null || mapByNumber.get(track.get("number")) == null) break block29;
                    DynamicObject tn = (DynamicObject)mapByNumber.get(track.get("number"));
                    tn.set("sourcebillid", dataEntity.getPkValue());
                    tn.set("sourcebillno", dataEntity.get(billNumber));
                    tn.set("sourcebillentryseq", (Object)0);
                    tn.set("sourcebillentryid", dataEntity.getPkValue());
                    updateTrackNumbers.add(tn);
                    updateTN.add(entry);
                    break block29;
                }
                for (DynamicObject dynamicObject : billEntry) {
                    entry = dynamicObject;
                    if (entry.getPkValue() == null) continue;
                    if (requiretypeCols.length > 1) {
                        requiretypeId = this.getDataId(entry.get(requiretypeCols[1]));
                    }
                    if (requiretypeId == 0L || results.get(requiretypeId) == null) continue;
                    setOrderTrackNumbers.add(entry.getPkValue().toString());
                    DynamicObject track = entry.getDynamicObject(tracknumberCols[1]);
                    if (mapByEntryId.get(entry.getPkValue().toString()) == null && track == null) {
                        addTN.add(entry);
                        continue;
                    }
                    if (track == null || mapByNumber.get(track.get("number")) == null) continue;
                    DynamicObject tn = (DynamicObject)mapByNumber.get(track.get("number"));
                    tn.set("sourcebillid", dataEntity.getPkValue());
                    tn.set("sourcebillno", dataEntity.get(billNumber));
                    tn.set("sourcebillentryseq", entry.get(seqColName));
                    tn.set("sourcebillentryid", (Object)entry.getPkValue().toString());
                    updateTrackNumbers.add(tn);
                    updateTN.add(entry);
                }
            }
            HashMap<String, DynamicObject> trackNumber2trackObj = new HashMap<String, DynamicObject>(16);
            if (updateTrackNumbers.size() > 0) {
                HashMap<String, Object> updateParam = new HashMap<String, Object>(4);
                updateParam.put("snrule", rule);
                updateParam.put("material", master);
                updateParam.put("size", updateTN.size());
                updateParam.put(ENTRYNAME, entryName);
                updateParam.put(COL_MATERIAL, materialColName);
                long startTime = System.currentTimeMillis();
                List<String> sns = this.getSns(dataEntity, updateTN, updateParam);
                if (sns != null && !sns.isEmpty()) {
                    HashSet<Object> pks = new HashSet<Object>(updateTrackNumbers.size());
                    long endTime = System.currentTimeMillis();
                    log.info("TrackNumberProcessor-autoGenerateTrackNumber-getSns : " + (endTime - startTime));
                    for (int i = 0; i < sns.size(); ++i) {
                        DynamicObject upTrackNumber;
                        String number = sns.get(i);
                        if (!number.equals((upTrackNumber = (DynamicObject)updateTrackNumbers.get(i)).getString("number"))) {
                            upTrackNumber.set("number", (Object)number);
                            upTrackNumber.set("name", (Object)number);
                        }
                        pks.add(upTrackNumber.getPkValue());
                    }
                    this.findExistTrackNumber(sns, pks, trackNumber2trackObj);
                }
                DynamicObject[] objs = new DynamicObject[updateTrackNumbers.size()];
                SaveServiceHelper.update((DynamicObject[])updateTrackNumbers.toArray(objs));
                for (int k = 0; k < updateTN.size(); ++k) {
                    DynamicObject updateEntry = (DynamicObject)updateTN.get(k);
                    DynamicObject upTrackNumber = (DynamicObject)updateTrackNumbers.get(k);
                    DynamicObject obj = (DynamicObject)trackNumber2trackObj.get(upTrackNumber.getString("number"));
                    if (obj != null && !obj.getPkValue().equals(upTrackNumber.getPkValue())) {
                        String pk = updateEntry == null ? dataEntity.getPkValue().toString() : updateEntry.getPkValue().toString();
                        setOrderTrackNumbers.remove(pk);
                        returnSN.put(pk, obj);
                        continue;
                    }
                    if (obj != null) continue;
                    trackNumber2trackObj.put(upTrackNumber.getString("number"), upTrackNumber);
                }
            }
            if (addTN.size() > 0) {
                param.put("snrule", rule);
                param.put("material", master);
                param.put("size", addTN.size());
                param.put(ENTRYNAME, entryName);
                param.put(COL_MATERIAL, materialColName);
                long startTime = System.currentTimeMillis();
                List<String> sns = this.getSns(dataEntity, addTN, param);
                if (sns != null && sns.size() > 0) {
                    long endTime = System.currentTimeMillis();
                    log.info("TrackNumberProcessor-autoGenerateTrackNumber-getSns : " + (endTime - startTime));
                    this.findExistTrackNumber(sns, new HashSet<Object>(0), trackNumber2trackObj);
                    ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(sns.size());
                    long[] ids = this.getIds(sns.size());
                    DynamicObject rootorg = BusinessDataServiceHelper.loadSingleFromCache((Object)OrgUnitServiceHelper.getRootOrgId(), (String)"bos_org", (String)"id");
                    for (int k = 0; k < addTN.size(); ++k) {
                        DynamicObject addEntry = (DynamicObject)addTN.get(k);
                        DynamicObject obj = (DynamicObject)trackNumber2trackObj.get(sns.get(k));
                        if (obj == null) {
                            obj = BusinessDataServiceHelper.newDynamicObject((String)"bd_tracknumber");
                            obj.set("id", (Object)ids[k]);
                            obj.set("number", (Object)sns.get(k));
                            obj.set("name", (Object)sns.get(k));
                            obj.set("createorg", (Object)rootorg);
                            obj.set("org", (Object)rootorg);
                            obj.set("useorg", (Object)rootorg);
                            obj.set("sourcebilltype", (Object)billType);
                            obj.set("sourcebillid", dataEntity.getPkValue());
                            obj.set("sourcebillno", dataEntity.get(billNumber));
                            obj.set("sourcebillentryid", addEntry == null ? dataEntity.getPkValue() : addEntry.getPkValue());
                            obj.set("sourcebillentryseq", addEntry == null ? Integer.valueOf(0) : addEntry.get(seqColName));
                            Object orderId = addEntry == null ? dataEntity.getPkValue() : addEntry.getPkValue();
                            obj.set("trackstatus", (Object)Character.valueOf('0'));
                            obj.set("enable", (Object)Character.valueOf('1'));
                            obj.set("masterid", (Object)ids[k]);
                            obj.set("status", (Object)Character.valueOf('C'));
                            objList.add(obj);
                            trackNumber2trackObj.put(sns.get(k), obj);
                        }
                        returnSN.put(addEntry == null ? dataEntity.getPkValue().toString() : addEntry.getPkValue().toString(), obj);
                    }
                    SaveServiceHelper.save((DynamicObject[])objList.toArray(new DynamicObject[0]));
                } else {
                    log.info("TrackNumberProcessor-sns is null");
                }
            }
            setTrackNumbers.removeAll(setOrderTrackNumbers);
            if (setTrackNumbers.size() <= 0) continue;
            returnSN.put("DELTRACKNUMBER", setTrackNumbers);
        }
        return returnSN;
    }

    private void findExistTrackNumber(List<String> sns, Set<Object> pks, Map<String, DynamicObject> trackNumber2trackObj) {
        HashSet<String> nums = new HashSet<String>(sns.size());
        for (String num : sns) {
            if (trackNumber2trackObj.containsKey(num)) continue;
            nums.add(num);
        }
        if (!nums.isEmpty()) {
            QFilter qFilter = new QFilter("number", "in", nums);
            if (!pks.isEmpty()) {
                qFilter.and("id", "not in", pks);
            }
            Map tracks = BusinessDataServiceHelper.loadFromCache((String)"bd_tracknumber", (String)"id,number,name,createorg,sourcebilltype,sourcebillid,sourcebillno,sourcebillentryid,sourcebillentryseq,trackstatus,enable", (QFilter[])new QFilter[]{qFilter});
            for (Map.Entry entry : tracks.entrySet()) {
                trackNumber2trackObj.put(((DynamicObject)entry.getValue()).getString("number"), (DynamicObject)entry.getValue());
            }
        }
    }

    private DynamicObject getMaterialBaseInfo(DynamicObject master) {
        if (master.get("masterid") instanceof DynamicObject) {
            master = master.getDynamicObject("masterid");
        }
        return master;
    }

    public void updateTrackNumber(Map<String, Map<String, Object>> trackNumbers) throws KDException {
        if (trackNumbers == null || trackNumbers.size() < 1) {
            return;
        }
        ArrayList<String> entryIds = new ArrayList<String>(trackNumbers.size());
        for (Map.Entry<String, Map<String, Object>> entry : trackNumbers.entrySet()) {
            entryIds.add(entry.getKey());
        }
        QFilter[] filters = new QFilter[]{new QFilter("sourcebillentryid", "in", entryIds)};
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bd_tracknumber", (String)"id,number,createorg,sourcebilltype,sourcebillno,sourcebillentryid,sourcebillentryseq,trackstatus,enable", (QFilter[])filters);
        ArrayList<DynamicObject> tns = new ArrayList<DynamicObject>(16);
        Map<Object, Object> tnInfo = new HashMap();
        for (DynamicObject obj : objects) {
            tnInfo = trackNumbers.get(obj.getString("sourcebillentryid"));
            if (tnInfo == null || tnInfo.get("tnnumber").equals(obj.getString("number")) && tnInfo.get("sourcebillentryreq").equals(obj.getString("sourcebillentryseq"))) continue;
            obj.set("number", tnInfo.get("tnnumber"));
            obj.set("sourcebillentryseq", tnInfo.get("sourcebillentryreq"));
            tns.add(obj);
        }
        DynamicObject[] objs = new DynamicObject[tns.size()];
        SaveServiceHelper.update((DynamicObject[])tns.toArray(objs));
    }

    public String deleteTrackNumber(List<String> sourceBillEntryId) throws KDException {
        Map refrenceResult;
        if (sourceBillEntryId == null || sourceBillEntryId.size() < 1) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("sourcebillentryid", "in", sourceBillEntryId)};
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bd_tracknumber", (String)"id,number,createorg,sourcebilltype,sourcebillid,sourcebillno,sourcebillentryid,sourcebillentryseq,trackstatus,enable", (QFilter[])filters);
        if (objects == null || objects.length == 0) {
            return null;
        }
        ArrayList<Object> toDelPks = new ArrayList<Object>(objects.length);
        HashMap<Object, DynamicObject> mapTN = new HashMap<Object, DynamicObject>(objects.length);
        for (DynamicObject obj : objects) {
            toDelPks.add(obj.getPkValue());
            mapTN.put(obj.getPkValue(), obj);
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        ArrayList refTrackNums = new ArrayList(16);
        if (objects != null && toDelPks != null && objects[0] != null && toDelPks.size() > 0 && (refrenceResult = checker.checkRef((BasedataEntityType)objects[0].getDataEntityType(), toDelPks.toArray())).size() > 0) {
            Iterator iterator = refrenceResult.keySet().iterator();
            while (iterator.hasNext()) {
                refTrackNums.add(iterator.next());
            }
        }
        toDelPks.removeAll(refTrackNums);
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_tracknumber"), (Object[])toDelPks.toArray());
        if (refTrackNums.size() > 0) {
            ArrayList<DynamicObject> updateTrackNumbers = new ArrayList<DynamicObject>(refTrackNums.size());
            for (int i = 0; i < refTrackNums.size(); ++i) {
                DynamicObject tn = (DynamicObject)mapTN.get(refTrackNums.get(i));
                tn.set("trackstatus", (Object)Character.valueOf('1'));
                updateTrackNumbers.add(tn);
            }
            if (updateTrackNumbers.size() > 0) {
                DynamicObject[] objs = new DynamicObject[updateTrackNumbers.size()];
                SaveServiceHelper.update((DynamicObject[])updateTrackNumbers.toArray(objs));
            }
        }
        return null;
    }

    private List<String> getSns(DynamicObject dataEntity, List<DynamicObject> updateEntrys, Map<String, Object> param) {
        ArrayList<String> listSns = new ArrayList(16);
        try {
            listSns = this.getSnCodeNum(dataEntity, updateEntrys, param);
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7\u7f16\u7801\u751f\u6210\u6709\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u8ddf\u8e2a\u53f7\u7f16\u7801\u89c4\u5219\u3002", (String)"TrackNumberProcessor_1", (String)"bd-sbd-business", (Object[])new Object[0]), (Throwable)e);
            return listSns;
        }
        return listSns;
    }

    private long[] getIds(int size) {
        return DB.genLongIds((String)"t_bd_tracknumber", (int)size);
    }

    public List<String> getSnCodeNum(DynamicObject dataEntity, List<DynamicObject> updateEntrys, Map<String, Object> returnParam) {
        DynamicObject snRule = (DynamicObject)returnParam.get("snrule");
        DynamicObject material = (DynamicObject)returnParam.get("material");
        String materialColName = returnParam.get(COL_MATERIAL).toString();
        String[] materialCols = materialColName.split("\\.");
        int size = (Integer)returnParam.get("size");
        DynamicObject codeRule = BusinessDataServiceHelper.loadSingle((Object)snRule.getPkValue(), (String)"bd_lotcoderule");
        HashMap<String, DynamicObject> ruleEntryMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection lotCodeRuleEntry = codeRule.getDynamicObjectCollection("entryentity");
        ArrayList<Object> lotItemIds = new ArrayList<Object>();
        for (DynamicObject row : lotCodeRuleEntry) {
            lotItemIds.add(row.get("lotprop.id"));
            ruleEntryMap.put(row.getString("lotprop.id"), row);
        }
        ArrayList<String> snNums = new ArrayList<String>(size);
        for (DynamicObject entry : updateEntrys) {
            if (entry != null && materialCols.length > 1) {
                material = this.getMaterialBaseInfo(entry.getDynamicObject(materialCols[1]));
            }
            LotCodeRuleInfo codeInfo = this.buildCodeInfo(entry == null ? 1 : entry.getInt("seq"), lotItemIds, ruleEntryMap, dataEntity, null, material, codeRule);
            codeInfo.setRuleId(codeRule.get("id"));
            codeInfo.setMatNumOnly(codeRule.getBoolean("matnumonly"));
            codeInfo.setMaterialId(material.get("id"));
            HashMap<Integer, LotCodeRuleInfo> codeRuleMap = new HashMap<Integer, LotCodeRuleInfo>();
            codeRuleMap.put(0, codeInfo);
            HashMap propSeqMap = new HashMap();
            if (!codeInfo.isRight()) {
                throw new KDBizException(codeInfo.getMsg());
            }
            ArrayList<Integer> seqs = new ArrayList<Integer>(1);
            seqs.add(0);
            propSeqMap.put(codeRule.getString("id"), seqs);
            Integer serialNum = 0;
            if (codeInfo.isHaveSerial()) {
                DLock lock = DLock.create((String)"bd/sbd/sncoderule");
                Object object = null;
                try {
                    lock.lock();
                    try {
                        serialNum = this.setMaxSerialNum(codeRuleMap, (List)propSeqMap.values().iterator().next());
                    }
                    catch (Exception ex) {
                        throw new KDBizException(ex.getMessage());
                    }
                }
                catch (Throwable ex) {
                    object = ex;
                    throw ex;
                }
                finally {
                    if (lock != null) {
                        if (object != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable ex) {
                                ((Throwable)object).addSuppressed(ex);
                            }
                        } else {
                            lock.close();
                        }
                    }
                }
            }
            StringBuilder numsb = new StringBuilder();
            numsb.setLength(0);
            for (LotCodeRuleEntryInfo row : codeInfo.getEntry()) {
                if (StringUtils.isEmpty((String)row.getPropValue())) continue;
                if (numsb.length() > 0) {
                    numsb.append(row.getSplitsign());
                }
                if (row.getPropType() == LotCodeItemTypeEnum.SEQ) {
                    numsb.append(entry == null ? Integer.valueOf(1) : entry.get("seq"));
                    continue;
                }
                if (row.getPropType() == LotCodeItemTypeEnum.SERIALNUM) {
                    serialNum = serialNum + codeInfo.getStep();
                    String seNum = serialNum.toString();
                    int max = codeInfo.getLenth() - seNum.length();
                    for (int j = 0; j < max; ++j) {
                        numsb.append('0');
                    }
                    numsb.append(seNum);
                    continue;
                }
                numsb.append(row.getPropValue());
            }
            snNums.add(numsb.toString());
        }
        return snNums;
    }

    private LotCodeRuleInfo buildCodeInfo(int seq, List<Object> lotItemIds, Map<String, DynamicObject> ruleEntryMap, DynamicObject dataEntity, DynamicObjectCollection entrys, DynamicObject material, DynamicObject lotCodeRule) {
        LotCodeRuleInfo codeInfo = new LotCodeRuleInfo();
        String entityType = dataEntity.getDataEntityType().getName();
        Map<Object, DynamicObject> items = this.getLotCodeItems(lotItemIds.toArray());
        block8: for (Object id : lotItemIds) {
            DynamicObject item = items.get(id);
            String type = item.getString("type");
            Object pvalue = "";
            String endValue = "";
            DynamicObject ruleRow = ruleEntryMap.get(id.toString());
            LotCodeItemTypeEnum iEnum = LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)type);
            switch (iEnum) {
                case TXT: 
                case DATE: {
                    DynamicObjectCollection itemEntry = item.getDynamicObjectCollection("entryentity");
                    for (DynamicObject irow : itemEntry) {
                        if (!irow.getString("appbill.id").equals(entityType)) continue;
                        String prop = irow.getString("billfieldid");
                        try {
                            pvalue = this.getLotPropValue(dataEntity, entrys, seq, prop, irow);
                        }
                        catch (KDBizException e) {
                            codeInfo.setRight(false);
                            codeInfo.appendMsg(e.getMessage());
                        }
                        break;
                    }
                    if (pvalue == null || StringUtils.isEmpty((String)pvalue.toString().trim())) {
                        if (item.getBoolean("isnullgenlot")) {
                            endValue = "";
                            break;
                        }
                        codeInfo.setRight(false);
                        codeInfo.appendMsg(ResManager.loadKDString((String)"\u7269\u6599\u201c{0}\u201d\u7684\u4f9b\u5e94\u94fe\u7f16\u7801\u89c4\u5219\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u201c{1}\u201d\u5c5e\u6027\u3002", (String)"LotCodeRuleProcessor_1", (String)"bd-sbd-business", (Object[])new Object[]{this.getMatName(material), item.getString("name")}));
                        continue block8;
                    }
                    if (iEnum == LotCodeItemTypeEnum.DATE) {
                        String format = ruleEntryMap.get(id.toString()).getString("format");
                        SimpleDateFormat sdf = new SimpleDateFormat(format);
                        endValue = sdf.format(pvalue);
                        break;
                    }
                    endValue = this.delUseMode(pvalue.toString(), ruleRow);
                    break;
                }
                case SEQ: {
                    endValue = this.delUseMode(String.valueOf(seq), ruleRow);
                    break;
                }
                case SERIALNUM: {
                    codeInfo.setHaveSerial(true);
                    codeInfo.setSettingValue(ruleRow.getString("settingvalue"));
                    codeInfo.setLenth(ruleRow.getInt("length"));
                    codeInfo.setStep(ruleRow.getInt("step"));
                }
                case CONST: {
                    endValue = ruleRow.getString("settingvalue");
                }
            }
            endValue = this.delString2LowUp(endValue, iEnum, ruleRow.getString("formatvalue"));
            LotCodeRuleEntryInfo entryInfo = new LotCodeRuleEntryInfo(seq, ruleRow.getString("entrysplitsign"), iEnum, endValue, ruleRow.getBoolean("isnumaccord"));
            codeInfo.getEntry().add(entryInfo);
            codeInfo.setSeq(seq);
        }
        if (codeInfo.isRight()) {
            StringBuilder sb = new StringBuilder();
            for (LotCodeRuleEntryInfo entry : codeInfo.getEntry()) {
                if (!entry.isNumAccord()) continue;
                sb.append(entry.getPropValue());
            }
            codeInfo.setPropCol(sb.toString());
        }
        return codeInfo;
    }

    private Integer setMaxSerialNum(Map<Integer, LotCodeRuleInfo> lotCodeRuleMap, List<Integer> seqs) {
        LotCodeRuleInfo info = lotCodeRuleMap.get(seqs.get(0));
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("lotcoderule", "=", info.getRuleId()));
        if (info.isMatNumOnly()) {
            qfilters.add(new QFilter("material", "=", info.getMaterialId()));
        }
        if (StringUtils.isNotEmpty((String)info.getPropCol())) {
            qfilters.add(new QFilter("accordprop", "=", (Object)info.getPropCol()));
        }
        DynamicObject maxSerialEntity = BusinessDataServiceHelper.loadSingle((String)"bd_lotcoderule_maxserial", (String)"id,maxserial", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        Integer serialNum = 0;
        if (maxSerialEntity == null) {
            maxSerialEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_lotcoderule_maxserial"));
            serialNum = Integer.parseInt(info.getSettingValue()) - info.getStep();
            maxSerialEntity.set("lotcoderule", info.getRuleId());
            maxSerialEntity.set("material", info.getMaterialId());
            maxSerialEntity.set("accordprop", (Object)info.getPropCol());
        } else {
            serialNum = maxSerialEntity.getInt("maxserial");
        }
        int maxSerialNum = serialNum + info.getStep() * seqs.size();
        maxSerialEntity.set("maxserial", (Object)maxSerialNum);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{maxSerialEntity});
        return serialNum;
    }

    private Map<Object, DynamicObject> getLotCodeItems(Object[] ids) {
        return BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bd_lotcodeitem");
    }

    private Object getLotPropValue(DynamicObject dataEntity, DynamicObjectCollection entrys, int seq, String prop, DynamicObject irow) {
        String key = irow.getString("entryentityid");
        if (StringUtils.isNotEmpty((String)key)) {
            if (key.equals(this.entryEntityKey)) {
                String[] props;
                if (prop.indexOf(".") > 0 && prop.indexOf(this.materialKey) == 0 && (props = prop.split("\\.")).length == 2) {
                    prop = props[0] + ".masterid." + props[1];
                }
                if (dataEntity.getDataEntityType().getProperties().get((Object)key) != null) {
                    entrys = dataEntity.getDynamicObjectCollection(key);
                }
                try {
                    return ((DynamicObject)entrys.get(seq - 1)).get(prop);
                }
                catch (Exception var9) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u53f7\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6279\u53f7\u5c5e\u6027%1$s\u5b57\u6bb5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"TrackNumberProcessor_5", (String)"bd-sbd-business", (Object[])new Object[0]), prop));
                }
            }
            if (dataEntity.getDataEntityType().getProperties().get((Object)key) != null) {
                entrys = dataEntity.getDynamicObjectCollection(key);
            }
            DynamicObjectCollection entry = entrys;
            if (entrys.size() > 0) {
                try {
                    return ((DynamicObject)entry.get(seq - 1)).get(prop);
                }
                catch (Exception var10) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u53f7\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6279\u53f7\u5c5e\u6027%1$s\u5b57\u6bb5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"TrackNumberProcessor_5", (String)"bd-sbd-business", (Object[])new Object[0]), prop));
                }
            }
            return "";
        }
        try {
            return dataEntity.get(prop);
        }
        catch (Exception var11) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6279\u53f7\u5c5e\u6027\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6279\u53f7\u5c5e\u6027%1$s\u5b57\u6bb5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"TrackNumberProcessor_5", (String)"bd-sbd-business", (Object[])new Object[0]), prop));
        }
    }

    public Long getDataId(Object object) {
        Long dataid = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject data = (DynamicObject)object;
            dataid = data.getLong("id");
        } else if (object instanceof Long) {
            dataid = (Long)object;
        }
        return dataid;
    }

    private String getMatName(DynamicObject material) {
        return material.getDynamicObjectType().getName().equals("bd_materialinventoryinfo") ? material.getString("masterid.name") : material.getString("name");
    }

    private String delUseMode(String value, DynamicObject ruleRow) {
        String result = "";
        int ruleLength = ruleRow.getInt("length");
        switch (UseModeEnum.getUseModeEnumEnumByValue((String)ruleRow.getString("attusingmode"))) {
            case CUT: {
                if (value.length() == ruleLength) {
                    return value;
                }
                if (value.length() > ruleRow.getInt("length")) {
                    if (ruleRow.getBoolean("cutstyle")) {
                        result = value.substring(0, ruleLength);
                        break;
                    }
                    result = value.substring(value.length() - ruleLength, value.length());
                    break;
                }
                StringBuilder endString = new StringBuilder();
                String settingvalue = ruleRow.getString("addchar");
                for (int i = 0; i < ruleLength - value.length(); ++i) {
                    endString.append(settingvalue);
                }
                if (ruleRow.getBoolean("addstyle")) {
                    StringBuilder re = new StringBuilder();
                    result = re.append(value).append((CharSequence)endString).toString();
                    break;
                }
                StringBuilder re = new StringBuilder();
                result = re.append((CharSequence)endString).append(value).toString();
                break;
            }
            case TOTAL: {
                result = value;
            }
        }
        return result;
    }

    private String delString2LowUp(String endValue, LotCodeItemTypeEnum iEnum, String formatvalue) {
        if (StringUtils.isNotEmpty((String)formatvalue)) {
            block0 : switch (iEnum) {
                case DATE: {
                    break;
                }
                default: {
                    LotCodeFormatEnum key = LotCodeFormatEnum.getLotCodeFormatEnumByValue((String)formatvalue);
                    if (key == null) break;
                    switch (key) {
                        default: {
                            break block0;
                        }
                        case LOW: {
                            endValue = endValue.toLowerCase();
                            break block0;
                        }
                        case UP: 
                    }
                    endValue = endValue.toUpperCase();
                }
            }
        }
        return endValue;
    }

    private DynamicObject getRule() {
        QFilter qFilter3;
        DynamicObject rule = null;
        QFilter qFilter2 = new QFilter("useintracknumber", "=", (Object)Character.valueOf('1'));
        Map mapRule = BusinessDataServiceHelper.loadFromCache((String)"bd_lotcoderule", (QFilter[])new QFilter[]{qFilter2, qFilter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (mapRule == null || mapRule.size() < 1) {
            return null;
        }
        for (Object value : mapRule.values()) {
            rule = (DynamicObject)value;
        }
        return rule;
    }
}

