/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.element;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bd.macc.common.helper.SubElementHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SubElementEditPlugin
extends AbstractFormPlugin {
    public static final String ENTITY_CAD_PURPRICES = "cad_purprices";
    public static final String ENTITY_CAD_STDRATESETTING = "cad_stdratesetting";
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Save save;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save && "save".equals((save = (Save)e.getSource()).getOperateKey())) {
            Long subId;
            QFilter idQF;
            QFilter numberQF;
            DynamicObjectCollection data;
            String number = (String)this.getModel().getValue("number");
            if (!StringUtils.isEmpty((CharSequence)number)) {
                number = number.trim();
            }
            if ((data = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{numberQF = new QFilter("number", "=", (Object)number), idQF = new QFilter("id", "!=", (Object)((subId = (Long)this.getModel().getValue("id")) != null ? subId : -1L))})) != null && !data.isEmpty()) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u53f7\u201d\u5df2\u5b58\u5728\u3002", (String)"SubElementEditPlugin_0", (String)"bd-macc-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isDefault = (Boolean)this.getModel().getValue("defaultvalue");
            Boolean syncFlag = (Boolean)this.getModel().getValue("syncflag");
            String enable = (String)this.getModel().getValue("enable");
            if (!(syncFlag.booleanValue() && enable.equals("1") || !isDefault.booleanValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\uff0c\u9700\u540c\u65f6\u6ee1\u8db3\uff1a\u201c\u4f7f\u7528\u72b6\u6001\u4e3a\u53ef\u7528\uff0c\u52fe\u9009\u4e86\u540c\u6b65\u5b58\u8d27\u4f59\u989d\u8868\u201d\uff0c\u624d\u5141\u8bb8\u52fe\u9009\u9ed8\u8ba4\u503c\u3002", (String)"SubElementEditPlugin_9", (String)"bd-macc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String type = (String)this.getModel().getValue("type");
            QFilter typeFilter = new QFilter("type", "=", (Object)type);
            QFilter defFilter = new QFilter("defaultvalue", "=", (Object)true);
            Boolean isDbHashOtherDef = QueryServiceHelper.exists((String)"cad_subelement", (QFilter[])new QFilter[]{typeFilter, defFilter});
            if (!isDefault.booleanValue() && !isDbHashOtherDef.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u6210\u672c\u8981\u7d20\u4e0b\uff0c\u5fc5\u987b\u6709\u4e00\u4e2a\u9ed8\u8ba4\u7684\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"SubElementEditPlugin_7", (String)"bd-macc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private String getTypeName(String type) {
        String name = "";
        switch (type) {
            case "001": {
                name = ResManager.loadKDString((String)"\u7269\u6599", (String)"SubElementEditPlugin_2", (String)"bd-macc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "002": {
                name = ResManager.loadKDString((String)"\u7269\u6599\u8d39\u7528", (String)"SubElementEditPlugin_3", (String)"bd-macc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "003": {
                name = ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528", (String)"SubElementEditPlugin_4", (String)"bd-macc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "004": {
                name = ResManager.loadKDString((String)"\u8d44\u6e90", (String)"SubElementEditPlugin_5", (String)"bd-macc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "005": {
                name = ResManager.loadKDString((String)"\u5916\u534f\u52a0\u5de5\u8d39", (String)"SubElementEditPlugin_6", (String)"bd-macc-formplugin", (Object[])new Object[0]);
            }
        }
        return name;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if ("type".equals(proName) || "costbehavior".equals(proName) || "defaultvalue".equals(proName) || "supmaterielcount".equals(proName) || "syncflag".equals(proName)) {
            this.getPageCache().put("isDataChange", "true");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey())) {
            String isDataChange;
            Object type;
            DynamicObjectCollection doc;
            List subIds = e.getOperationResult().getSuccessPkIds();
            if (Utils.isListEmpty((List)subIds)) {
                return;
            }
            Object pkVal = subIds.get(0);
            DynamicObject subEle = this.updateStatusToAudit(pkVal);
            if (subEle.getBoolean("defaultvalue")) {
                this.updateDefault(pkVal);
            }
            if ((doc = QueryServiceHelper.query((String)"cad_elementdetail", (String)"id", (QFilter[])new QFilter[]{new QFilter("subelement", "=", pkVal)})) == null || doc.isEmpty()) {
                this.saveElementDetailInfo((Long)pkVal);
            }
            if ((type = this.getModel().getValue("type")) != null && MATCOST.equals(type) && (isDataChange = this.getPageCache().get("isDataChange")) != null && "true".equals(isDataChange)) {
                this.updateStdSet(ENTITY_CAD_STDRATESETTING);
                this.updateStdSet(ENTITY_CAD_PURPRICES);
                this.updateRate();
            }
        }
    }

    private void updateDefault(Object pkVal) {
        Long tempSubId = (Long)pkVal;
        DynamicObjectCollection data = this.getSubElementByType();
        for (DynamicObject subIdObj : data) {
            Long subId = subIdObj.getLong("id");
            DynamicObject subEle = BusinessDataServiceHelper.loadSingle((Object)subId, (String)"cad_subelement");
            if (!subEle.getBoolean("defaultvalue") || tempSubId.equals(subEle.getLong("id"))) continue;
            subEle.set("defaultvalue", (Object)"0");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{subEle});
        }
    }

    private DynamicObjectCollection getSubelemetByEleId() {
        Long elementId = this.getElementId();
        QFilter qf1 = new QFilter("element", "=", (Object)elementId);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{qf1});
        return data;
    }

    private DynamicObjectCollection getSubElementByType() {
        String elementType = this.getElementType();
        QFilter qf1 = new QFilter("type", "=", (Object)elementType);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qf1});
        return data;
    }

    private DynamicObject updateStatusToAudit(Object pkVal) {
        DynamicObject subEle = BusinessDataServiceHelper.loadSingle((Object)pkVal, (String)"cad_subelement");
        if (!"C".equals(subEle.getString("status"))) {
            OperationServiceHelper.executeOperate((String)"submit", (String)"cad_subelement", (Object[])new Object[]{pkVal}, (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"audit", (String)"cad_subelement", (Object[])new Object[]{pkVal}, (OperateOption)OperateOption.create());
        }
        return subEle;
    }

    public void afterBindData(EventObject e) {
        String costbehavior;
        super.afterBindData(e);
        Long subId = (Long)this.getModel().getValue("id");
        if (subId == null || subId == 0L) {
            String type = this.getElementType();
            this.getModel().setValue("type", (Object)type);
            Boolean syncFlag = SubElementHelper.syncFlag();
            Boolean isCalByCostElement = SubElementHelper.isCalByCostElement();
            this.getModel().setValue("syncflag", (Object)(syncFlag == false || isCalByCostElement == false ? 1 : 0));
        }
        this.getModel().setDataChanged(false);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String type = (String)fsp.getCustomParam("type");
        if (!MATCOST.equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supmaterielcount"});
        }
        if ((costbehavior = (String)this.getModel().getValue("costbehavior")) != null) {
            return;
        }
        if ("003".equals(type)) {
            costbehavior = "B";
            this.getModel().setValue("costbehavior", (Object)costbehavior);
        } else {
            costbehavior = "A";
            this.getModel().setValue("costbehavior", (Object)costbehavior);
        }
    }

    private void saveElementDetailInfo(Long subId) {
        Long elementId = this.getElementId();
        if (elementId < 1L) {
            return;
        }
        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"cad_elementdetail");
        detail.set("element", (Object)elementId);
        detail.set("elementtype", (Object)this.getElementTypeId());
        detail.set("subelement", (Object)subId);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_elementdetail");
        SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{detail});
    }

    private Long getElementId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long eleId = (Long)fsp.getCustomParam("element");
        if (eleId == null) {
            return 0L;
        }
        return eleId;
    }

    private Long getElementTypeId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long elementtype = (Long)fsp.getCustomParam("elementtype");
        return elementtype;
    }

    private String getElementType() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String type = (String)fsp.getCustomParam("type");
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = "";
        }
        return type;
    }

    private void updateStdSet(String entityName) {
        Long subElementId = (Long)this.getModel().getValue("id");
        if (subElementId == 0L) {
            return;
        }
        QFilter filter = new QFilter("costtype.type", "=", (Object)"1");
        filter.and("entryentity.subelement", "=", (Object)subElementId);
        DynamicObjectCollection dy = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter});
        if (dy.isEmpty()) {
            return;
        }
        HashSet ids = new HashSet();
        dy.forEach(p -> ids.add(p.getLong("id")));
        DynamicObject[] newDy = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Boolean supmaterielcount = (Boolean)this.getModel().getValue("supmaterielcount");
        for (DynamicObject data : newDy) {
            DynamicObjectCollection entry = data.getDynamicObjectCollection("entryentity");
            boolean isRemoveEntry = false;
            for (int i = 0; i < entry.size(); ++i) {
                if ((!ENTITY_CAD_PURPRICES.equals(entityName) || !MATCOST.equals(((DynamicObject)entry.get(i)).getString("subelement.type")) || !subElementId.equals(((DynamicObject)entry.get(i)).getLong("subelement.id")) || supmaterielcount.booleanValue()) && (!ENTITY_CAD_STDRATESETTING.equals(entityName) || supmaterielcount.booleanValue())) continue;
                entry.remove(i);
                isRemoveEntry = true;
                break;
            }
            if (!isRemoveEntry || !ENTITY_CAD_PURPRICES.equals(entityName)) continue;
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < entry.size(); ++i) {
                amount = amount.add(((DynamicObject)entry.get(i)).getBigDecimal("price"));
            }
            data.set("amount", (Object)amount);
        }
        SaveServiceHelper.save((DynamicObject[])newDy);
    }

    private void updateRate() {
        Long subElementId = (Long)this.getModel().getValue("id");
        if (subElementId == 0L) {
            return;
        }
        QFilter filter = new QFilter("costtype.type", "=", (Object)"1");
        filter.and("entryentity.subelement", "=", (Object)subElementId);
        DynamicObjectCollection purPrice = QueryServiceHelper.query((String)ENTITY_CAD_PURPRICES, (String)"id", (QFilter[])new QFilter[]{filter});
        if (purPrice.isEmpty()) {
            return;
        }
        HashSet ids = new HashSet();
        purPrice.forEach(p -> ids.add(p.getLong("id")));
        DynamicObject[] newPurPrice = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_CAD_PURPRICES));
        HashMap<Long, BigDecimal> idAndSum = new HashMap<Long, BigDecimal>(16);
        HashSet<Long> costTypeId = new HashSet<Long>(16);
        for (DynamicObject pur : newPurPrice) {
            DynamicObjectCollection entry = pur.getDynamicObjectCollection("entryentity");
            BigDecimal sum = BigDecimal.ZERO;
            for (DynamicObject en : entry) {
                if (!MATTYPE.equals(en.getString("subelement.type"))) continue;
                sum = sum.add(en.getBigDecimal("price"));
            }
            idAndSum.put(pur.getLong("id"), sum);
            costTypeId.add(pur.getLong("CostType.id"));
        }
        DynamicObjectCollection rateSet = SubElementEditPlugin.getRateInfo(costTypeId.toArray(new Long[0]));
        for (DynamicObject pur : newPurPrice) {
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal sum = (BigDecimal)idAndSum.get(pur.getLong("id"));
            Long costType = pur.getLong("costtype.id");
            DynamicObjectCollection entry = pur.getDynamicObjectCollection("entryentity");
            for (DynamicObject en : entry) {
                if (MATCOST.equals(en.getString("subelement.type"))) {
                    Boolean supmaterielcount = (Boolean)this.getModel().getValue("supmaterielcount");
                    Long subElement = en.getLong("subelement.id");
                    BigDecimal rate = SubElementEditPlugin.getCurRate(rateSet, costType, subElement);
                    if (supmaterielcount.booleanValue() && !BigDecimal.ZERO.equals(rate)) {
                        rate = rate == null ? BigDecimal.ZERO : rate;
                        en.set("price", (Object)sum.multiply(rate).divide(new BigDecimal(100)));
                        en.set("rate", (Object)rate);
                    } else {
                        en.set("price", (Object)0);
                        en.set("rate", (Object)0);
                    }
                }
                amount = amount.add(en.getBigDecimal("price"));
            }
            pur.set("amount", (Object)amount);
        }
        SaveServiceHelper.save((DynamicObject[])newPurPrice);
    }

    private static DynamicObjectCollection getRateInfo(Long[] costTypeId) {
        QFilter qfCostType = new QFilter("costtype", "in", (Object)costTypeId);
        return QueryServiceHelper.query((String)ENTITY_CAD_STDRATESETTING, (String)"costtype,entryentity.subelement,entryentity.stdrate", (QFilter[])new QFilter[]{qfCostType});
    }

    private static BigDecimal getCurRate(DynamicObjectCollection rateInfo, Long costType, Long subElement) {
        for (DynamicObject rate : rateInfo) {
            if (!costType.equals(rate.getLong("costtype")) || !subElement.equals(rate.getLong("entryentity.subelement"))) continue;
            return rate.getBigDecimal("entryentity.stdrate");
        }
        return BigDecimal.ZERO;
    }
}

