/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.util.StringUtils;

public class ScheduleConfigHelper {
    private static final String SELECT_FIELDS = "canclose,exetype,interface,selbill.number, schschedule.id, schschedule.status, selbillfilter_tag";
    private static final String EXPORT_FIELDS = "FID,FNUMBER,FNAME,FSELBILLID,FSELBILLFILTER,FSELBILLFILTER_TAG,FSCHSCHEDULEID,FEXETYPE,FINTERFACE,FSTATUS,FENABLE,FCANCLOSE,FMASTERID,FMODIFIERID,FMODIFYTIME,FCREATORID,FCREATETIME";
    public static final String EXPORT_LANG_FIELDS = "FPKID,FID,FLOCALEID,FNAME";
    private static final Log logger = LogFactory.getLog(ScheduleConfigHelper.class);

    public static boolean doExecute(QFilter qFilter, boolean throwException) throws KDException {
        DynamicObjectCollection schedualConfigs = QueryServiceHelper.query((String)"bd_scheduleconfig", (String)SELECT_FIELDS, (QFilter[])qFilter.toArray());
        ArrayList<String> disableScheduleIds = new ArrayList<String>(8);
        ArrayList<String> enableScheduleIds = new ArrayList<String>(8);
        for (DynamicObject config : schedualConfigs) {
            String status;
            boolean isEnable;
            String scheduleId = config.getString("schschedule.id");
            if (StringUtils.isEmpty((String)scheduleId) || (isEnable = "1".equals(status = config.getString("schschedule.status"))) && !config.getBoolean("canclose")) continue;
            boolean exists = false;
            try {
                exists = ScheduleConfigHelper.isExists(config);
            }
            catch (Exception e) {
                logger.error(String.format("check isExists error, scheduleId: %s", scheduleId), (Throwable)e);
                if (!throwException) continue;
                throw e;
            }
            if (exists && !isEnable) {
                enableScheduleIds.add(scheduleId);
                continue;
            }
            if (exists || !isEnable) continue;
            disableScheduleIds.add(scheduleId);
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        for (String scheduleId : disableScheduleIds) {
            try {
                scheduleManager.disableSchedule(scheduleId);
            }
            catch (Exception e) {
                logger.error("disableSchedule error, scheduleId: {}, error: {}", (Object)scheduleId, (Object)e.getMessage());
                if (!throwException) continue;
                throw e;
            }
        }
        for (String scheduleId : enableScheduleIds) {
            try {
                scheduleManager.enableSchedule(scheduleId);
            }
            catch (Exception e) {
                logger.error("enableSchedule error, scheduleId: {}, error: {}", (Object)scheduleId, (Object)e.getMessage());
                if (!throwException) continue;
                throw e;
            }
        }
        return !enableScheduleIds.isEmpty() || !disableScheduleIds.isEmpty();
    }

    private static boolean isExists(DynamicObject config) {
        String exeType;
        switch (exeType = config.getString("exetype")) {
            case "bill": {
                String entityNumber = config.getString("selbill.number");
                if (StringUtils.isEmpty((String)entityNumber)) {
                    throw new KDBizException("selbill is empty");
                }
                QFilter filter = ScheduleConfigHelper.getFilterGridFilter(config.getString("selbillfilter_tag"), entityNumber);
                return QueryServiceHelper.exists((String)entityNumber, (QFilter[])(filter != null ? filter.toArray() : null));
            }
            case "interface": {
                String intface = config.getString("interface");
                if (StringUtils.isEmpty((String)intface)) {
                    throw new KDBizException("interface is empty");
                }
                String[] splits = intface.split("\\.");
                Object result = DispatchServiceHelper.invokeBizService((String)splits[0], (String)splits[1], (String)splits[2], (String)splits[3], (Object[])new Object[0]);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new KDBizException("unsupport interface: " + intface + ", not return bool");
            }
        }
        throw new KDBizException("unsupport exetype: " + exeType);
    }

    private static QFilter getFilterGridFilter(String filterTag, String entityName) {
        if (StringUtils.isBlank((String)filterTag)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), filterCondition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    public static String exportKsql(Object[] selectIds) {
        StringBuilder builder = new StringBuilder();
        String ids = Arrays.stream(selectIds).map(Object::toString).collect(Collectors.joining("','"));
        String where = "FID in ('" + ids + "')";
        builder.append(ScheduleConfigHelper.exportKsql("T_BD_SCHEDULECONFIG", EXPORT_FIELDS, where)).append("\n");
        builder.append(ScheduleConfigHelper.exportKsql("T_BD_SCHEDULECONFIG_L", EXPORT_LANG_FIELDS, where));
        return builder.toString();
    }

    private static String exportKsql(String tableName, String fields, String where) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.base, tableName, fields, where, null, null);
        return (String)map.get("sql");
    }
}

