/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.mservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.mservice.api.RequireTypeService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class RequireTypeServiceImpl
implements RequireTypeService {
    public static final String BD_MANUSTRCONFIG = "bd_manustrconfig";
    public static final String BD_MANUSTRATEGYGROUP = "bd_manustrategygroup";

    public Map<String, Long> getRequireType(Map<Long, Set<Long>> orgmaterials, String billType) {
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (orgmaterials == null || orgmaterials.isEmpty() || billType.isEmpty()) {
            return result;
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter billentityqf = new QFilter("entryentity.billentity", "=", (Object)billType);
        QFilter aloneDemandtypeFilter = null;
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)BD_MANUSTRCONFIG, (String)"entryentity.alonedemandtype", (QFilter[])new QFilter[]{statusFilter, enableFilter, billentityqf}, null);){
            for (Row row : queryDataSet) {
                String aloneDemandtype = row.getString("entryentity.alonedemandtype");
                if (aloneDemandtype == null) continue;
                if ("C".equals(aloneDemandtype)) {
                    aloneDemandtypeFilter = new QFilter("entryentity.manustrategy.requiretype.projectreq", "=", (Object)"1");
                    continue;
                }
                if (!"A".equals(aloneDemandtype) && !"B".equals(aloneDemandtype)) continue;
                aloneDemandtypeFilter = new QFilter("entryentity.manustrategy.requiretype.projectreq", "=", (Object)"0");
            }
        }
        for (Map.Entry<Long, Set<Long>> orgmaterial : orgmaterials.entrySet()) {
            Serializable manustrategygroupId;
            Long orgId = orgmaterial.getKey();
            Set<Long> materialIds = orgmaterial.getValue();
            QFilter idFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
            QFilter materialFilter = new QFilter("masterid.id", "in", materialIds);
            HashMap<Long, Long> materialmanustrategygroupMap = new HashMap<Long, Long>(16);
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialinventoryinfo", (String)"id,masterid,createorg,manustrategygroup", (QFilter[])new QFilter[]{idFilter, materialFilter, statusFilter, enableFilter}, null);){
                for (Row materialInvInfo : queryDataSet) {
                    Long masterid = materialInvInfo.getLong("masterid");
                    manustrategygroupId = materialInvInfo.getLong("manustrategygroup");
                    if (materialmanustrategygroupMap.get(masterid) == null) {
                        materialmanustrategygroupMap.put(masterid, (Long)manustrategygroupId);
                    }
                    if (!orgId.equals(materialInvInfo.getLong("createorg"))) continue;
                    materialmanustrategygroupMap.put(masterid, (Long)manustrategygroupId);
                }
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            Map requireTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_requiretype", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            qFilters.add(new QFilter("id", "in", materialmanustrategygroupMap.values()));
            qFilters.add(new QFilter("entryentity.manustrategy.status", "=", (Object)"C"));
            qFilters.add(new QFilter("entryentity.manustrategy.enable", "=", (Object)"1"));
            if (aloneDemandtypeFilter != null) {
                qFilters.add(aloneDemandtypeFilter);
            }
            HashMap<Long, Long> requireMap = new HashMap<Long, Long>(16);
            HashMap<Long, Integer> lastPriorityMap = new HashMap<Long, Integer>(16);
            DataSet manustrategyDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)BD_MANUSTRATEGYGROUP, (String)"id,entryentity.manustrategy.requiretype,entryentity.priority", (QFilter[])qFilters.toArray(new QFilter[0]), null);
            manustrategygroupId = null;
            try {
                for (Row data : manustrategyDataSet) {
                    Integer lastPriority;
                    Long manustrategygroupId2 = data.getLong("id");
                    int priority = data.getInteger("entryentity.priority");
                    if (priority < (lastPriority = lastPriorityMap.getOrDefault(manustrategygroupId2, 0))) continue;
                    requireMap.put(manustrategygroupId2, data.getLong("entryentity.manustrategy.requiretype"));
                    lastPriorityMap.put(manustrategygroupId2, priority);
                }
            }
            catch (Throwable throwable) {
                manustrategygroupId = throwable;
                throw throwable;
            }
            finally {
                if (manustrategyDataSet != null) {
                    if (manustrategygroupId != null) {
                        try {
                            manustrategyDataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)manustrategygroupId).addSuppressed(throwable);
                        }
                    } else {
                        manustrategyDataSet.close();
                    }
                }
            }
            for (Long materialId : materialIds) {
                Long manustrategygroupId3 = materialmanustrategygroupMap.getOrDefault(materialId, 0L);
                Long requireId = requireMap.getOrDefault(manustrategygroupId3, 0L);
                String key = orgId + "" + materialId;
                if (!requireTypes.containsKey(requireId)) {
                    result.put(key, 0L);
                    continue;
                }
                result.put(key, requireId);
            }
        }
        return result;
    }
}

