/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.TaskFlowHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.threads.ThreadPools;

public class TaskInterceptPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TaskInterceptPlugin.class);
    private static final String SELECTPROPS = "id,number,name,exceptionreceiver,bizentity,beginoperate,bizfilterconfig_tag,isrevoperate,isbackgroundstart,queryderiction,taskentry,taskentry.mainentity,executor,taskentry,taskentry.operatekey,taskentry.operatename,taskentry.isacrossbill,taskentry.mserviceconfig_tag,orgentry.org,taskentry.iscycle";
    private static final String showDetail = "isbackgroundstart";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        logger.info("\u4efb\u52a1\u7f16\u6392\u6355\u6349\u5230\u64cd\u4f5c\uff1a" + operate.getOperateKey());
        this.beforeStartTaskFlow(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && EmptyUtil.isNoEmpty(args.getOperationResult().getSuccessPkIds())) {
            this.afterStartTaskFlow(args);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void beforeStartTaskFlow(BeforeDoOperationEventArgs args) {
        try {
            String entityNumber = this.getView() instanceof IListView ? this.getDataEntityName() : this.getModel().getDataEntityType().getName();
            Map<Object, DynamicObject> taskFlows = this.checkPositiveAndReverse((EventObject)args, entityNumber);
            if (taskFlows == null || taskFlows.isEmpty()) {
                return;
            }
            ArrayList<Long> selectIds = new ArrayList<Long>(10);
            if (this.getView() instanceof IListView) {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                selectIds.addAll(selectedRows.stream().map(r -> (Long)r.getPrimaryKeyValue()).collect(Collectors.toList()));
            } else {
                Long id = (Long)this.getModel().getValue("id");
                if (EmptyUtil.isNoEmpty(id)) {
                    selectIds.add(id);
                }
            }
            if (EmptyUtil.isNoEmpty(selectIds)) {
                Map<Object, Set<Long>> taskExecuteIds = this.groupBillIdByTaskFlow(taskFlows, entityNumber, selectIds);
                for (Map.Entry<Object, Set<Long>> taskExecuteId : taskExecuteIds.entrySet()) {
                    args.setCancel(true);
                    this.startTaskFlow(taskFlows.get(taskExecuteId.getKey()), new ArrayList<Long>((Collection)taskExecuteId.getValue()));
                }
            }
        }
        catch (Exception e) {
            logger.info("\u64cd\u4f5c\u524d\u5f00\u542f\u4efb\u52a1\u6d41\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private Map<Object, DynamicObject> checkPositiveAndReverse(EventObject args, String entityNumber) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        QFilter filter = new QFilter("beginoperate", "=", (Object)operate.getOperateKey());
        filter.and("bizentity", "=", (Object)entityNumber);
        filter.and("enable", "=", (Object)"1");
        if (args instanceof AfterDoOperationEventArgs) {
            filter.and("isrevoperate", "=", (Object)"0");
            return BusinessDataServiceHelper.loadFromCache((String)"fcs_taskflow", (String)SELECTPROPS, (QFilter[])filter.toArray());
        }
        filter.and("isrevoperate", "=", (Object)"1");
        return BusinessDataServiceHelper.loadFromCache((String)"fcs_taskflow", (String)SELECTPROPS, (QFilter[])filter.toArray());
    }

    private void afterStartTaskFlow(AfterDoOperationEventArgs args) {
        try {
            String entityNumber = this.getView() instanceof IListView ? this.getDataEntityName() : this.getModel().getDataEntityType().getName();
            Map<Object, DynamicObject> taskFlows = this.checkPositiveAndReverse((EventObject)args, entityNumber);
            if (taskFlows == null || taskFlows.isEmpty()) {
                return;
            }
            List<Long> selectIds = args.getOperationResult().getSuccessPkIds().stream().map(s -> Long.valueOf(s.toString())).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(selectIds)) {
                Map<Object, Set<Long>> taskExecuteIds = this.groupBillIdByTaskFlow(taskFlows, entityNumber, selectIds);
                for (Map.Entry<Object, Set<Long>> taskExecuteId : taskExecuteIds.entrySet()) {
                    args.getOperationResult().setShowMessage(false);
                    this.startTaskFlow(taskFlows.get(taskExecuteId.getKey()), new ArrayList<Long>((Collection)taskExecuteId.getValue()));
                }
            }
        }
        catch (Exception e) {
            logger.info("\u64cd\u4f5c\u540e\u5f00\u542f\u4efb\u52a1\u6d41\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void startTaskFlow(DynamicObject taskFlow, List<Long> ids) {
        boolean isShowDetail = taskFlow.getBoolean(showDetail);
        this.startTaskFlow(taskFlow, ids, isShowDetail);
    }

    private void startTaskFlow(DynamicObject taskFlow, List<Long> ids, boolean isShowDetail) {
        logger.info("\u542f\u52a8\u4efb\u52a1\u7f16\u6392\u65b9\u6848\uff1a" + taskFlow.getString("number") + "\u7684id\uff1a" + ids.toString());
        JobFormInfo jobFormInfo = this.buildJobFormInfo(taskFlow, ids);
        if (jobFormInfo == null) {
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
        if (isShowDetail) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.RobotAutoFloat);
            param.setHasRight(true);
            param.setFormId("fcs_taskexecute_progress");
            param.getCustomParams().put("taskflow", DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{taskFlow}, (DynamicObjectType)taskFlow.getDynamicObjectType()));
            param.getCustomParams().put("ids", ids);
            param.getCustomParams().put("taskflow_taskid", taskId);
            this.getView().showForm(param);
        }
    }

    private JobFormInfo buildJobFormInfo(DynamicObject taskFlow, List<Long> ids) {
        String taskJson = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{taskFlow}, (DynamicObjectType)taskFlow.getDynamicObjectType());
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u6392\u65b9\u6848%s", (String)"TaskFlowHelper_0", (String)"bos-ext-tmc", (Object[])new Object[]{taskFlow.getString("number")}));
        jobInfo.setJobType(JobType.REALTIME);
        DynamicObject user = taskFlow.getDynamicObject("executor");
        long userId = EmptyUtil.isNoEmpty(user) ? user.getLong("id") : RequestContext.get().getCurrUserId();
        jobInfo.setRunByUserId(userId);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.bos.ext.tmc.task.TaskExecuteImpl");
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("taskflow", taskJson);
        params.put("ids", ids);
        params.put("view", this.getView().getPageId());
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        CloseCallBack closeCallBack = new CloseCallBack("kd.bos.ext.tmc.task.TaskExecuteCallBack", "background_actionid");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.bos.ext.tmc.task.TaskProgressClick");
        return jobFormInfo;
    }

    private Map<Object, Set<Long>> groupBillIdByTaskFlow(Map<Object, DynamicObject> taskFlows, String entityNumber, List<Long> selectIds) {
        HashMap<Object, Set<Long>> taskExecuteIds = new HashMap<Object, Set<Long>>(taskFlows.size());
        for (Map.Entry<Object, DynamicObject> taskFlow : taskFlows.entrySet()) {
            Set<Long> fitBillIds = TaskFlowHelper.getFitBillIds(taskFlow.getValue(), entityNumber, selectIds);
            selectIds.removeAll(fitBillIds);
            if (!EmptyUtil.isNoEmpty(fitBillIds)) continue;
            taskExecuteIds.put(taskFlow.getKey(), fitBillIds);
        }
        return taskExecuteIds;
    }

    private String getDataEntityName() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getEntityType().getName();
    }
}

