/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.commitToBe;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.commitToBe.ICommitToBeService;
import kd.bos.ext.tmc.utils.commitToBe.enums.BillStatusEnum;
import kd.bos.ext.tmc.utils.commitToBe.enums.EBResultStatusCode;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.commitToBe.helper.ParameterHelper;
import kd.bos.form.ClientCallback;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.IFormView;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.operate.SignOperateCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractCommitToBeService
implements ICommitToBeService,
SignCallbackLisenter {
    private static Log logger = LogFactory.getLog(AbstractCommitToBeService.class);
    protected List<Pair<Long, Long>> successPairs;
    protected List<DynamicObject> payBillList;
    protected IFormView view;
    protected Map<String, List<Long>> bankOpCol = new HashMap<String, List<Long>>();
    protected Map<Long, Long> payBillToBankBillMap = new LinkedHashMap<Long, Long>();
    protected List<Long> commitBeBankBillCol = new ArrayList<Long>();

    @Override
    public void init(List<Pair<Long, Long>> successPairs, IFormView view) {
        this.successPairs = successPairs;
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)this.getBillEntity(), (String)this.selectField(), (QFilter[])new QFilter[]{new QFilter("id", "in", successPairs.stream().map(Pair::getLeft).collect(Collectors.toList()))});
        this.payBillList = Arrays.asList(payBills);
        this.view = view;
    }

    @Override
    public void executeOperate(OperationResult opResult) {
        logger.info("\u63d0\u4ea4\u94f6\u4f01\u5f00\u59cb\uff1a" + System.currentTimeMillis());
        this.successPairs.forEach(o -> this.payBillToBankBillMap.put((Long)o.getKey(), (Long)o.getValue()));
        this.splitBankBill();
        this.sign(opResult);
    }

    public void splitBankBill() {
        Map<Object, List<DynamicObject>> payBillGroupByOrg = this.payBillList.stream().collect(Collectors.groupingBy(o -> o.getDynamicObject(this.getOrgProp()).getPkValue()));
        ArrayList submitPayBillList = new ArrayList();
        ArrayList auditPayBillList = new ArrayList();
        ArrayList needCommitBeIdList = new ArrayList();
        for (Map.Entry<Object, List<DynamicObject>> entry : payBillGroupByOrg.entrySet()) {
            Object orgId = entry.getKey();
            boolean isBankBillAudit = ParameterHelper.getParameterBoolean((Long)orgId, "bei002");
            boolean isNeedCommitBe = ParameterHelper.isBizBillCommitBe((Long)orgId);
            if (isNeedCommitBe) {
                auditPayBillList.addAll(entry.getValue().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                needCommitBeIdList.addAll(entry.getValue().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                continue;
            }
            if (isBankBillAudit) {
                submitPayBillList.addAll(entry.getValue().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
                continue;
            }
            auditPayBillList.addAll(entry.getValue().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        ArrayList<Long> submitList = new ArrayList<Long>();
        if (submitPayBillList.size() > 0) {
            this.bankOpCol.put("submit", submitList);
        }
        ArrayList<Long> auditList = new ArrayList<Long>();
        if (auditPayBillList.size() > 0) {
            this.bankOpCol.put("audit", auditList);
        }
        for (Map.Entry<Long, Long> one : this.payBillToBankBillMap.entrySet()) {
            if (submitPayBillList.contains(one.getKey())) {
                submitList.add(one.getValue());
            }
            if (auditPayBillList.contains(one.getKey())) {
                auditList.add(one.getValue());
            }
            if (!needCommitBeIdList.contains(one.getKey())) continue;
            this.commitBeBankBillCol.add(one.getValue());
        }
    }

    public void sign(OperationResult commitToBeOpResult) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("srcEntityNumber", this.getBillEntity());
        ArrayList<Pair> opResultList = new ArrayList<Pair>();
        Boolean allDone = Boolean.TRUE;
        ArrayList<Object> opSuccessIds = new ArrayList<Object>();
        String errorMsg = "";
        for (Map.Entry<String, List<Long>> entry : this.bankOpCol.entrySet()) {
            OperationResult signResult = OperationServiceHelper.executeOperate((String)entry.getKey(), (String)this.getBankBillEntity(), (Object[])entry.getValue().toArray(), (OperateOption)operateOption);
            boolean isSuccess = signResult.isSuccess();
            opSuccessIds.addAll(signResult.getSuccessPkIds());
            logger.info("\u7b7e\u540d\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString((Object)signResult));
            if (!isSuccess && signResult.isNeedSign()) {
                opResultList.add(Pair.of((Object)entry.getKey(), (Object)signResult));
                allDone = Boolean.FALSE;
                continue;
            }
            if (isSuccess) continue;
            errorMsg = errorMsg + AbstractCommitToBeService.decodeErrorMsg(signResult);
            logger.info("\u63d0\u4ea4\u94f6\u4f01\u7b7e\u540d\u5931\u8d25\uff1a" + errorMsg);
        }
        if (EmptyUtil.isNoEmpty(errorMsg)) {
            this.signErrRollBack(opSuccessIds, this.payBillToBankBillMap, this.bankOpCol);
            logger.info("\u63d0\u4ea4\u94f6\u4f01\u7ed3\u675f\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)System.currentTimeMillis(), (Object)errorMsg);
            throw new KDBizException(errorMsg);
        }
        if (!allDone.booleanValue()) {
            commitToBeOpResult.setShowMessage(false);
            HashMap allClearText = new HashMap();
            for (Pair opResult : opResultList) {
                OperationResult operationResult = (OperationResult)opResult.getRight();
                Map clearTexts = (Map)SerializationUtils.fromJsonString((String)operationResult.getClearText(), Map.class);
                allClearText.putAll(clearTexts);
            }
            OperationResult operationResult = (OperationResult)((Pair)opResultList.get(0)).getRight();
            operationResult.setClearText(SerializationUtils.toJsonString(allClearText));
            operateOption.setVariableValue("committobeopresult", SerializationUtils.toJsonString((Object)commitToBeOpResult));
            operateOption.setVariableValue("bankopcol", SerializationUtils.toJsonString(this.bankOpCol));
            operateOption.setVariableValue("opsuccessids", SerializationUtils.toJsonString(opSuccessIds));
            operateOption.setVariableValue("commitbebankbillids", SerializationUtils.toJsonString(this.commitBeBankBillCol));
            operateOption.setVariableValue("paybilltobankbillmap", SerializationUtils.toJsonString(this.payBillToBankBillMap));
            operateOption.setVariableValue("paybilllist", DynamicObjectSerializeUtil.serialize((Object[])this.payBillList.toArray(), (DynamicObjectType)this.payBillList.get(0).getDynamicObjectType()));
            SignOperateCallback signOperate = new SignOperateCallback(this.view, (SignCallbackLisenter)this, operateOption, ClientCallback.SignClientType.Secondry, "secondSign");
            OperationResult ops = signOperate.sign(operationResult);
            if (!ops.isSuccess() && ops.isShowMessage()) {
                logger.info("\u63d0\u4ea4\u94f6\u4f01\u7ed3\u675f\uff1a secondSign fail ");
                this.signErrRollBack(opSuccessIds, this.payBillToBankBillMap, this.bankOpCol);
                if (EmptyUtil.isNoEmpty(ops.getMessage())) {
                    throw new KDBizException(ops.getMessage());
                }
            }
        } else {
            this.doCommitBe(commitToBeOpResult, false, opSuccessIds);
        }
    }

    public void signCallback(SignCallbackEvent evt) {
        ClientMethodResult ret = evt.getResult();
        OperationResult commitToBeOpResult = (OperationResult)JSON.parseObject((String)((String)evt.getOption().get("committobeopresult")), (TypeReference)new TypeReference<OperationResult>(){}, (Feature[])new Feature[0]);
        Map bankOpCol = (Map)JSON.parseObject((String)((String)evt.getOption().get("bankopcol")), (TypeReference)new TypeReference<Map<String, List<Long>>>(){}, (Feature[])new Feature[0]);
        Map clearText = (Map)SerializationUtils.fromJsonString((String)evt.getClearText(), Map.class);
        List opSuccessIds = (List)SerializationUtils.fromJsonString((String)((String)evt.getOption().get("opsuccessids")), List.class);
        List commitbeBankbillIds = (List)JSON.parseObject((String)((String)evt.getOption().get("commitbebankbillids")), (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
        Map payBillToBankBillMap = (Map)JSON.parseObject((String)((String)evt.getOption().get("paybilltobankbillmap")), (TypeReference)new TypeReference<Map<Long, Long>>(){}, (Feature[])new Feature[0]);
        Object[] tempA = DynamicObjectSerializeUtil.deserialize((String)((String)evt.getOption().get("paybilllist")), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getBillEntity()));
        this.payBillList = Arrays.stream(tempA).map(o -> (DynamicObject)o).collect(Collectors.toList());
        this.payBillToBankBillMap = payBillToBankBillMap;
        this.commitBeBankBillCol = commitbeBankbillIds;
        this.view = evt.getView();
        if (ret.getSuccess().booleanValue()) {
            String errorMsg = "";
            for (Map.Entry one : bankOpCol.entrySet()) {
                List list = (List)one.getValue();
                HashMap signResult = new HashMap();
                HashMap clearResult = new HashMap();
                for (Map.Entry oneSignData : ret.getResult().entrySet()) {
                    String bankBillId = (String)oneSignData.getKey();
                    Long temp = Long.valueOf(bankBillId);
                    if (!list.contains(temp)) continue;
                    signResult.put(bankBillId, oneSignData.getValue());
                    clearResult.put(bankBillId, clearText.get(bankBillId));
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("srcEntityNumber", this.getBillEntity());
                operateOption.setVariableValue("ishasright", "true");
                operateOption.setVariableValue("signCallbackFlag", "true");
                operateOption.setVariableValue("signFirstSave", "false");
                operateOption.setVariableValue("signResult", SerializationUtils.toJsonString(signResult));
                operateOption.setVariableValue("clearResult", SerializationUtils.toJsonString(clearResult));
                operateOption.setVariableValue("isCheckPassCA", "true");
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)((String)one.getKey()), (String)this.getBankBillEntity(), (Object[])list.toArray(), (OperateOption)operateOption);
                boolean isSuccess = operationResult.isSuccess();
                if (isSuccess) {
                    opSuccessIds.addAll(operationResult.getSuccessPkIds());
                    continue;
                }
                errorMsg = errorMsg + AbstractCommitToBeService.decodeErrorMsg(operationResult);
                logger.info("\u63d0\u4ea4\u94f6\u4f01\u7b7e\u540d\u5931\u8d25" + SerializationUtils.toJsonString((Object)operationResult));
            }
            if (EmptyUtil.isNoEmpty(errorMsg)) {
                this.signErrRollBack(opSuccessIds, payBillToBankBillMap, bankOpCol);
                evt.getView().showErrorNotification(errorMsg);
                logger.info("\u63d0\u4ea4\u94f6\u4f01\u7ed3\u675f\uff1a" + System.currentTimeMillis());
                return;
            }
            this.doCommitBe(commitToBeOpResult, true, opSuccessIds);
        } else {
            logger.info("\u63d0\u4ea4\u94f6\u4f01\u7b7e\u540d\u56de\u8c03\uff1a\u7b7e\u540d\u5931\u8d25\u56de\u6eda");
            this.signErrRollBack(opSuccessIds, payBillToBankBillMap, bankOpCol);
        }
    }

    protected void doCommitBe(OperationResult commitToBeResult, Boolean isSignCallBack, List<Object> opSuccessIds) {
        this.doSignSuccess(opSuccessIds);
        Object[] realCommit = this.commitBeBankBillCol.stream().filter(opSuccessIds::contains).toArray();
        if (realCommit.length > 0) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            operateOption.setVariableValue("isBizPay", "true");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"commitbe", (String)this.getBankBillEntity(), (Object[])realCommit, (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                HashMap bankBillIdsToBillIds = new HashMap();
                this.payBillToBankBillMap.entrySet().stream().forEach(o -> {
                    Long cfr_ignored_0 = (Long)bankBillIdsToBillIds.put(o.getValue(), o.getKey());
                });
                List successPair = operationResult.getSuccessPkIds().stream().map(o -> {
                    JSONObject result = new JSONObject();
                    result.put("payBillId", bankBillIdsToBillIds.get(o));
                    result.put("bankBillId", o);
                    return result;
                }).collect(Collectors.toList());
                commitToBeResult.setSuccessPkIds(successPair);
                List allErrorInfo = operationResult.getAllErrorInfo();
                ValidateResultCollection validateResult = operationResult.getValidateResult();
                if (EmptyUtil.isNoEmpty(validateResult.getValidateErrors())) {
                    validateResult.getValidateErrors().forEach(v -> commitToBeResult.getValidateResult().getValidateErrors().add(v));
                }
                if (EmptyUtil.isNoEmpty(allErrorInfo)) {
                    ArrayList<Pair<Long, String>> rollbackResultList = new ArrayList<Pair<Long, String>>();
                    for (OperateErrorInfo errorInfo : allErrorInfo) {
                        if (!errorInfo.getErrorCode().equals(EBResultStatusCode.ROLLBACK.name())) continue;
                        rollbackResultList.add((Pair<Long, String>)Pair.of(bankBillIdsToBillIds.get((Long)errorInfo.getPkValue()), (Object)errorInfo.getMessage()));
                    }
                    this.rollback(rollbackResultList);
                    ValidateResult vr = new ValidateResult();
                    allErrorInfo.forEach(o -> o.setPkValue(bankBillIdsToBillIds.get(o.getPkValue())));
                    vr.setAllErrorInfo(allErrorInfo);
                    commitToBeResult.getValidateResult().getValidateErrors().add(vr);
                }
                if (isSignCallBack.booleanValue() && this.view != null) {
                    commitToBeResult.setShowMessage(true);
                    this.view.showOperationResult(commitToBeResult);
                }
            } else if (isSignCallBack.booleanValue()) {
                commitToBeResult.setShowMessage(true);
            }
        } else if (isSignCallBack.booleanValue() && this.view != null) {
            commitToBeResult.setShowMessage(true);
            this.view.showOperationResult(commitToBeResult);
        }
        logger.info("\u63d0\u4ea4\u94f6\u4f01\u64cd\u4f5c\u7ed3\u675f\uff1a" + System.currentTimeMillis());
    }

    public void signErrRollBack(List<Object> successBankIds, Map<Long, Long> payBillToBankBillMap, Map<String, List<Long>> bankOpCol) {
        logger.info("signErrRollBack successBankIds:" + successBankIds.size());
        logger.info("signErrRollBack payBillToBankBillMap:" + payBillToBankBillMap.size());
        ArrayList<Pair<Long, String>> pairs = new ArrayList<Pair<Long, String>>();
        ArrayList<Long> bankBillIds = new ArrayList<Long>();
        for (Map.Entry<Long, Long> entry : payBillToBankBillMap.entrySet()) {
            if (successBankIds.contains(entry.getValue())) continue;
            pairs.add(Pair.of((Object)entry.getKey(), null));
            bankBillIds.add(entry.getValue());
        }
        logger.info("signErrRollBack bankBillIds:" + bankBillIds.size());
        if (bankBillIds.size() > 0) {
            logger.info(" signErrRollBack rollbackPayBill:" + pairs.size());
            this.rollback(pairs);
            for (Map.Entry<Object, Object> entry : bankOpCol.entrySet()) {
                QFilter filter_status = ((String)entry.getKey()).equals("submit") ? new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()) : new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
                Set rollbackBankBillIds = ((List)entry.getValue()).stream().filter(o -> !successBankIds.contains(o)).collect(Collectors.toSet());
                int count = DeleteServiceHelper.delete((String)this.getBankBillEntity(), (QFilter[])new QFilter[]{new QFilter("id", "in", rollbackBankBillIds), filter_status});
                if (count != rollbackBankBillIds.size()) {
                    logger.info(" signErrRollBack rollbackBankBill fail");
                    continue;
                }
                logger.info(" signErrRollBack rollbackBankBill success");
            }
        }
    }

    public static String decodeErrorMsg(OperationResult operationResult) {
        String errMsg;
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            errMsg = AbstractCommitToBeService.decodeMultiErrorMsg(operationResult);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            errMsg = errorInfo.getMessage();
        } else {
            errMsg = operationResult.getMessage();
        }
        return errMsg;
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder buf = new StringBuilder();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append('\n');
        }
        return buf.toString();
    }

    protected abstract void doSignSuccess(List<Object> var1);

    protected abstract void rollback(List<Pair<Long, String>> var1);

    protected abstract String getOrgProp();

    protected abstract String getEntityTable();

    protected abstract String getBillEntity();

    protected abstract String getBankBillEntity();

    protected abstract String selectField();
}

