/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.commitToBe.ctbservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.tmc.utils.commitToBe.AbstractCommitToBeService;
import kd.bos.ext.tmc.utils.commitToBe.enums.BillStatusEnum;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AgentPayBillCTBService
extends AbstractCommitToBeService {
    @Override
    protected String getOrgProp() {
        return "org";
    }

    @Override
    protected String getEntityTable() {
        return "T_CAS_AgentPayBill";
    }

    @Override
    protected String getBillEntity() {
        return "cas_agentpaybill";
    }

    @Override
    protected String getBankBillEntity() {
        return "bei_bankagentpay";
    }

    @Override
    protected String selectField() {
        return "org,iscommitbe,commitbetime,bankagentpaystatus,billstatus,cashier";
    }

    @Override
    protected void doSignSuccess(List<Object> successIdList) {
    }

    @Override
    protected void rollback(List<Pair<Long, String>> rollbackPayBillIdList) {
        ArrayList<DynamicObject> rollbackPayBillList = new ArrayList<DynamicObject>(rollbackPayBillIdList.size());
        for (Pair<Long, String> result : rollbackPayBillIdList) {
            DynamicObject payBill = this.payBillList.stream().filter(o -> o.getPkValue().equals(result.getLeft())).findFirst().orElse(null);
            if (payBill == null) continue;
            payBill.set("iscommitbe", (Object)"0");
            payBill.set("commitbetime", null);
            payBill.set("bankagentpaystatus", null);
            payBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            payBill.set("cashier", null);
            rollbackPayBillList.add(payBill);
        }
        if (rollbackPayBillList.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                try {
                    SaveServiceHelper.update((DynamicObject[])rollbackPayBillList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw e;
                }
            }
        }
    }
}

